/* Generated by GOB (v2.0.11) on Sat Apr 16 19:56:21 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-engine.gob"

/***************************************************************************
                         lum-engine.gob  -  Lumiere Engine 
                             -------------------
    begin                : Tue dec 2 02:08:47 BST 2003
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.20 $
 * $Date: 2005/04/13 01:26:42 $
 *
 */

#line 35 "lum-engine.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-engine.h"

#include "lum-engine-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 71 "lum-engine.gob"

/* Drag'n Drop target table for the video window */
static const GtkTargetEntry target_table [] =
{
	{ "STRING",        0, TARGET_STRING },
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
	{ "text/plain;charset=UTF-8",    0, TARGET_STRING_UTF8 },
	{ "GTK_TREE_MODEL_ROW", GTK_TARGET_SAME_WIDGET, 0 }
};

#include "lum-cd-selection.h"
#include <libgnomeui/libgnomeui.h>

/* debug printout macros */	
#ifndef NDEBUG
#define __d	g_message(__GOB_FUNCTION__);
#define __ds(s)	g_message(__GOB_FUNCTION__ s);
#else
#define __d
#define __ds(s)
#endif

#line 80 "lum-engine.c"
static const GEnumValue _lum_engine_target_values[] = {
	{ TARGET_STRING, (char *)"TARGET_STRING", (char *)"string" },
	{ TARGET_URL, (char *)"TARGET_URL", (char *)"url" },
	{ TARGET_STRING_UTF8, (char *)"TARGET_STRING_UTF8", (char *)"string-utf8" },
	{ 0, NULL, NULL }
};

GType
lum_engine_target_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumEngineTarget", _lum_engine_target_values);
	return type;
}

static const GEnumValue _lum_engine_prev_values[] = {
	{ PREV_NONE, (char *)"PREV_NONE", (char *)"none" },
	{ PREV_VIDEO, (char *)"PREV_VIDEO", (char *)"video" },
	{ PREV_VFX, (char *)"PREV_VFX", (char *)"vfx" },
	{ PREV_AUDIO, (char *)"PREV_AUDIO", (char *)"audio" },
	{ 0, NULL, NULL }
};

GType
lum_engine_prev_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumEnginePrev", _lum_engine_prev_values);
	return type;
}

static const GEnumValue _lum_engine_event_values[] = {
	{ LUM_EVENT_STATUS_CHANGED, (char *)"LUM_EVENT_STATUS_CHANGED", (char *)"status-changed" },
	{ LUM_EVENT_PLAY_NOW, (char *)"LUM_EVENT_PLAY_NOW", (char *)"play-now" },
	{ LUM_EVENT_PLAYLIST_END, (char *)"LUM_EVENT_PLAYLIST_END", (char *)"playlist-end" },
	{ LUM_EVENT_NEW_ENGINE, (char *)"LUM_EVENT_NEW_ENGINE", (char *)"new-engine" },
	{ LUM_EVENT_CLOSE_ENGINE, (char *)"LUM_EVENT_CLOSE_ENGINE", (char *)"close-engine" },
	{ 0, NULL, NULL }
};

GType
lum_engine_event_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumEngineEvent", _lum_engine_event_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_ENGINE(x)
#define SELF_CONST(x) LUM_ENGINE_CONST(x)
#define IS_SELF(x) LUM_IS_ENGINE(x)
#define TYPE_SELF LUM_TYPE_ENGINE
#define SELF_CLASS(x) LUM_ENGINE_CLASS(x)

#define SELF_GET_CLASS(x) LUM_ENGINE_GET_CLASS(x)

/* self typedefs */
typedef LumEngine Self;
typedef LumEngineClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lum_engine_class_init (LumEngineClass * c) G_GNUC_UNUSED;
static void lum_engine_init (LumEngine * self) G_GNUC_UNUSED;
static void ___2_lum_engine_dispose (GObject * object) G_GNUC_UNUSED;
static void ___3_lum_engine_finalize (GObject * object) G_GNUC_UNUSED;
static gpointer lum_engine_populate_playlist (gpointer data) G_GNUC_UNUSED;
static GList * lum_engine_check_dir (const gchar * uri) G_GNUC_UNUSED;
static gboolean lum_engine_autostart (gpointer data) G_GNUC_UNUSED;
static gboolean lum_engine_video_window_delete_cb (GtkWidget * widget, GdkEvent * event, gpointer user_data) G_GNUC_UNUSED;
static void lum_engine_playback_finished_cb (LumPlayer * player, gpointer data) G_GNUC_UNUSED;
static void lum_engine_player_notify_cb (LumPlayer * player, GParamSpec * spec, Self * self) G_GNUC_UNUSED;
static void lum_engine_volume_changed_cb (LumPlayer * player, double volume, Self * self) G_GNUC_UNUSED;
static void lum_engine_vfx_activate_cb (GtkCheckMenuItem * button, Self * self) G_GNUC_UNUSED;
static void lum_engine_visible_cb (GtkAction * action, gpointer data) G_GNUC_UNUSED;
static void lum_engine_player_drag_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, Self * self) G_GNUC_UNUSED;
static gboolean lum_engine_key_press_cb (GtkWidget * widget, GdkEventKey * event, Self * self) G_GNUC_UNUSED;
static char * lum_engine_lookup_icon (LumPlayerInfo * info, gpointer data) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_REPEAT,
	PROP_PLAYLIST_VISIBLE,
	PROP_VIDWIN_VISIBLE,
	PROP_SKIN_VISIBLE
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_skin lum_engine_get_skin
#define self_load_uri lum_engine_load_uri
#define self_enqueue lum_engine_enqueue
#define self_iconify lum_engine_iconify
#define self_set_volume lum_engine_set_volume
#define self_dec_vol lum_engine_dec_vol
#define self_inc_vol lum_engine_inc_vol
#define self_mute lum_engine_mute
#define self_show_info lum_engine_show_info
#define self_do_popup lum_engine_do_popup
#define self_switch_timer_mode lum_engine_switch_timer_mode
#define self_can_seek lum_engine_can_seek
#define self_fwd10 lum_engine_fwd10
#define self_back10 lum_engine_back10
#define self_close lum_engine_close
#define self_prev lum_engine_prev
#define self_next lum_engine_next
#define self_play lum_engine_play
#define self_pause lum_engine_pause
#define self_stop lum_engine_stop
#define self_get_shuffle lum_engine_get_shuffle
#define self_set_shuffle lum_engine_set_shuffle
#define self_get_list lum_engine_get_list
#define self_play_now lum_engine_play_now
#define self_set_position lum_engine_set_position
#define self_show_fileselector lum_engine_show_fileselector
#define self_show_directoryselector lum_engine_show_directoryselector
#define self_open_dvd lum_engine_open_dvd
#define self_open_cdda lum_engine_open_cdda
#define self_drag_received lum_engine_drag_received
#define self_populate_playlist lum_engine_populate_playlist
#define self_check_dir lum_engine_check_dir
#define self_autostart lum_engine_autostart
#define self_opendir_activate_cb lum_engine_opendir_activate_cb
#define self_video_window_delete_cb lum_engine_video_window_delete_cb
#define self_playlist_delete_cb lum_engine_playlist_delete_cb
#define self_playback_finished_cb lum_engine_playback_finished_cb
#define self_player_notify_cb lum_engine_player_notify_cb
#define self_volume_changed_cb lum_engine_volume_changed_cb
#define self_vfx_activate_cb lum_engine_vfx_activate_cb
#define self_visible_cb lum_engine_visible_cb
#define self_player_drag_received_cb lum_engine_player_drag_received_cb
#define self_key_press_cb lum_engine_key_press_cb
#define self_lookup_icon lum_engine_lookup_icon
GType
lum_engine_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumEngineClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_engine_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumEngine),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_engine_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumEngine", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumEngine *)g_object_new(lum_engine_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumEngine * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumEngine *
GET_NEW_VARG (const char *first, ...)
{
	LumEngine *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumEngine *)g_object_new_valist (lum_engine_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Engine::dispose"
	LumEngine *self G_GNUC_UNUSED = LUM_ENGINE (obj_self);
#line 350 "lum-engine.gob"
	___2_lum_engine_dispose(obj_self);
#line 271 "lum-engine.c"
#line 133 "lum-engine.gob"
	if(self->repeat_action) { g_object_unref ((gpointer) self->repeat_action); self->repeat_action = NULL; }
#line 274 "lum-engine.c"
#line 150 "lum-engine.gob"
	if(self->playlist_visible_action) { g_object_unref ((gpointer) self->playlist_visible_action); self->playlist_visible_action = NULL; }
#line 277 "lum-engine.c"
#line 169 "lum-engine.gob"
	if(self->vidwin_visible_action) { g_object_unref ((gpointer) self->vidwin_visible_action); self->vidwin_visible_action = NULL; }
#line 280 "lum-engine.c"
#line 187 "lum-engine.gob"
	if(self->skin_visible_action) { g_object_unref ((gpointer) self->skin_visible_action); self->skin_visible_action = NULL; }
#line 283 "lum-engine.c"
#line 201 "lum-engine.gob"
	if(self->_priv->changer) { g_object_unref ((gpointer) self->_priv->changer); self->_priv->changer = NULL; }
#line 286 "lum-engine.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Engine::finalize"
	LumEngine *self G_GNUC_UNUSED = LUM_ENGINE (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 375 "lum-engine.gob"
	___3_lum_engine_finalize(obj_self);
#line 299 "lum-engine.c"
#line 203 "lum-engine.gob"
	if(self->_priv->current_folder) { g_free ((gpointer) self->_priv->current_folder); self->_priv->current_folder = NULL; }
#line 302 "lum-engine.c"
}
#undef __GOB_FUNCTION__

static void 
lum_engine_class_init (LumEngineClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Engine::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LumEnginePrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 350 "lum-engine.gob"
	g_object_class->dispose = ___dispose;
#line 375 "lum-engine.gob"
	g_object_class->finalize = ___finalize;
#line 320 "lum-engine.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("repeat" /* name */,
		 "repeat" /* nick */,
		 "repeat" /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_REPEAT,
		param_spec);
	param_spec = g_param_spec_boolean
		("playlist_visible" /* name */,
		 "playlist visible" /* nick */,
		 "playlist visible" /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PLAYLIST_VISIBLE,
		param_spec);
	param_spec = g_param_spec_boolean
		("vidwin_visible" /* name */,
		 "vidwin visible" /* nick */,
		 "vidwin visible" /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_VIDWIN_VISIBLE,
		param_spec);
	param_spec = g_param_spec_boolean
		("skin_visible" /* name */,
		 "skin visible" /* nick */,
		 "skin visible" /* blurb */,
		 TRUE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SKIN_VISIBLE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 212 "lum-engine.gob"
static void 
lum_engine_init (LumEngine * self G_GNUC_UNUSED)
#line 368 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,LumEnginePrivate);
#line 129 "lum-engine.gob"
	self->repeat_action = 
		lum_toggle_action_new("repeat", _("Repeat"), 
				_("Restart when we reach the end of the playlist"),
				NULL);
#line 377 "lum-engine.c"
#line 145 "lum-engine.gob"
	self->playlist_visible_action = 
		lum_toggle_action_new("playlist_visible",
				_("Show Playlist"), 
				_("Show / Hide the playlist window"),
				NULL);;
#line 384 "lum-engine.c"
#line 164 "lum-engine.gob"
	self->vidwin_visible_action = 
		lum_toggle_action_new("vidwin_visible",
				_("Show Video Window"), 
				_("Show / Hide the video window"),
				NULL);;
#line 391 "lum-engine.c"
#line 182 "lum-engine.gob"
	self->skin_visible_action = 
		lum_toggle_action_new("skin_visible",
				_("Show Skin"), 
				_("Show / Hide the Skin"),
				NULL);;
#line 398 "lum-engine.c"
#line 192 "lum-engine.gob"
	self->_priv->skin = lum_skin_new(self);
#line 401 "lum-engine.c"
#line 193 "lum-engine.gob"
	self->_priv->playlist = lum_playlist_new(self);
#line 404 "lum-engine.c"
#line 195 "lum-engine.gob"
	self->_priv->video_window = GTK_WINDOW(gtk_window_new(GTK_WINDOW_TOPLEVEL));
#line 407 "lum-engine.c"
#line 195 "lum-engine.gob"
	self->_priv->popup_menu = NULL;
#line 410 "lum-engine.c"
#line 195 "lum-engine.gob"
	self->_priv->player = NULL;
#line 413 "lum-engine.c"
#line 195 "lum-engine.gob"
	self->_priv->player_type = PLAYER_XINE;
#line 416 "lum-engine.c"
#line 195 "lum-engine.gob"
	self->_priv->prev = PREV_NONE;
#line 419 "lum-engine.c"
#line 201 "lum-engine.gob"
	self->_priv->changer = g_object_new(LUM_TYPE_CHANGER, NULL);
#line 422 "lum-engine.c"
#line 201 "lum-engine.gob"
	self->_priv->autostart_id = FALSE;
#line 425 "lum-engine.c"
#line 201 "lum-engine.gob"
	self->_priv->current_folder = NULL;
#line 428 "lum-engine.c"
#line 201 "lum-engine.gob"
	self->_priv->dialog = NULL;
#line 431 "lum-engine.c"
 {
#line 212 "lum-engine.gob"

		/* TODO allow type changes when other backends are ready */
		__d;
		selfp->player_type = lum_shell_get_config(lum_shell)->backend;
		selfp->player = lum_player_factory(selfp->player_type,
					lum_shell_get_config(lum_shell));
		g_object_set(G_OBJECT(selfp->player), "GtkXine::show_vfx", FALSE,
				"LumPlayer::repeat", FALSE,
				"LumPlayer::can_hide_bars", FALSE,
				"LumPlayer::can_fullscreen", FALSE, NULL);

		gtk_container_add(GTK_CONTAINER(selfp->video_window),
				GTK_WIDGET(selfp->player));
		g_object_set(G_OBJECT(selfp->video_window),
				"GtkWindow::window_position", GTK_WIN_POS_CENTER, NULL);
		g_object_set(G_OBJECT(selfp->playlist),
				"GtkWindow::window_position", GTK_WIN_POS_MOUSE, NULL);
		gtk_widget_show(GTK_WIDGET(selfp->player));
		gtk_widget_show(GTK_WIDGET(selfp->video_window));
		gtk_widget_hide(GTK_WIDGET(selfp->video_window));
		gtk_window_set_resizable(selfp->video_window, FALSE);
		gtk_drag_dest_set(GTK_WIDGET(selfp->video_window),
				GTK_DEST_DEFAULT_ALL, target_table,
				G_N_ELEMENTS (target_table),
			       	GDK_ACTION_COPY | GDK_ACTION_MOVE);
		g_signal_connect(G_OBJECT(selfp->video_window), "drag-data-received",
				G_CALLBACK(self_player_drag_received_cb), self);
		g_signal_connect(G_OBJECT(selfp->video_window), "delete-event",
				G_CALLBACK(self_video_window_delete_cb), self);
		g_signal_connect(G_OBJECT(selfp->video_window), "key-press-event",
				G_CALLBACK(self_key_press_cb), self);
		gtk_widget_show(GTK_WIDGET(selfp->skin));
		g_signal_connect(G_OBJECT(selfp->skin), "key-press-event",
				G_CALLBACK(self_key_press_cb), self);
		gtk_widget_show_all(GTK_WIDGET(selfp->playlist));
		gtk_window_resize(GTK_WINDOW(selfp->playlist), 200, 300);
		gtk_widget_hide(GTK_WIDGET(selfp->playlist));
		g_signal_connect(G_OBJECT(selfp->playlist), "delete-event",
				G_CALLBACK(self_playlist_delete_cb), self);
		g_signal_connect(G_OBJECT(selfp->playlist), "key-press-event",
				G_CALLBACK(self_key_press_cb), self);
		/* Popup menu */
		GladeXML *xml;
		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"engine_menu", GETTEXT_PACKAGE);
		if(xml == NULL)
			lum_shell_glade_not_found();
			
		selfp->popup_menu = glade_xml_get_widget(xml, "engine_menu_menu");
		gtk_action_connect_proxy(lum_shell->prefs, glade_xml_get_widget(xml, "prefs"));
		gtk_action_connect_proxy(lum_shell->help, glade_xml_get_widget(xml, "help"));
		gtk_action_connect_proxy(lum_shell->about, glade_xml_get_widget(xml, "about"));
		gtk_action_connect_proxy(lum_shell->quit, glade_xml_get_widget(xml, "quit"));
		gtk_action_connect_proxy(GTK_ACTION(self->playlist_visible_action), glade_xml_get_widget(xml, "playlist_visible"));
		gtk_action_connect_proxy(GTK_ACTION(self->vidwin_visible_action), glade_xml_get_widget(xml, "video_visible"));
		
		
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "properties"),
	 			"activate",
				G_CALLBACK(self_show_info), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "open"),
 				"activate",
				G_CALLBACK(self_show_fileselector), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "open_dvd"),
 				"activate",
				G_CALLBACK(self_open_dvd), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "open_audio_cd"),
 				"activate",
				G_CALLBACK(self_open_cdda), self);
		g_signal_connect_swapped(glade_xml_get_widget(xml, "new_engine"),
			    "activate", G_CALLBACK(lum_shell_new_engine), lum_shell);
		g_signal_connect(glade_xml_get_widget(xml, "vfx"),
			    "activate", G_CALLBACK(self_vfx_activate_cb), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "controls"),
 				"activate",
				G_CALLBACK(lum_player_show_runtime),
				selfp->player);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "window_close"),
			    "activate", G_CALLBACK(self_close), self);

		g_object_unref(G_OBJECT(xml));

		/* video window popup menu */
		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"player_menu", GETTEXT_PACKAGE);
		if(xml == NULL)
			lum_shell_glade_not_found();

		lum_player_set_popup_menu(selfp->player,
				GTK_MENU(glade_xml_get_widget(xml, "player_menu_menu")));
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "play_pause"),
			    "activate", G_CALLBACK(self_pause), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "stop"),
			    "activate", G_CALLBACK(self_stop), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "next"),
			    "activate", G_CALLBACK(self_next), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "previous"),
			    "activate", G_CALLBACK(self_prev), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "properties"),
 				"activate",
				G_CALLBACK(self_show_info), self);
		g_object_unref(G_OBJECT(xml));

		if(lum_shell_get_config(lum_shell)->autostart)
			selfp->autostart_id = g_timeout_add(500, self_autostart, self);
		g_signal_connect(G_OBJECT(selfp->player),"playbackfinished",
				G_CALLBACK(self_playback_finished_cb), self);
		g_signal_connect(G_OBJECT(selfp->player),"notify",
				G_CALLBACK(self_player_notify_cb), self);
		g_signal_connect(G_OBJECT(selfp->player),"volume_changed",
				G_CALLBACK(self_volume_changed_cb), self);

		g_signal_connect(G_OBJECT(self->playlist_visible_action),
				"activate",
				G_CALLBACK(self_visible_cb), selfp->playlist);
		g_signal_connect(G_OBJECT(self->vidwin_visible_action),
				"activate",
				G_CALLBACK(self_visible_cb), selfp->video_window);
		g_signal_connect(G_OBJECT(self->skin_visible_action),
				"activate",
				G_CALLBACK(self_visible_cb), selfp->skin);
	
#line 567 "lum-engine.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Lum:Engine::set_property"
{
	LumEngine *self G_GNUC_UNUSED;

	self = LUM_ENGINE (object);

	switch (property_id) {
	case PROP_REPEAT:
		{
#line 122 "lum-engine.gob"
 gtk_toggle_action_set_active(
				 GTK_TOGGLE_ACTION(self->repeat_action),
				 g_value_get_boolean(VAL));
		 
#line 591 "lum-engine.c"
		}
		break;
	case PROP_PLAYLIST_VISIBLE:
		{
#line 139 "lum-engine.gob"
 gtk_toggle_action_set_active(
				 GTK_TOGGLE_ACTION(self->playlist_visible_action),
				 g_value_get_boolean(VAL));
		 
#line 601 "lum-engine.c"
		}
		break;
	case PROP_VIDWIN_VISIBLE:
		{
#line 156 "lum-engine.gob"
gtk_toggle_action_set_active(
				 GTK_TOGGLE_ACTION(self->vidwin_visible_action),
				 g_value_get_boolean(VAL));
		 
#line 611 "lum-engine.c"
		}
		break;
	case PROP_SKIN_VISIBLE:
		{
#line 175 "lum-engine.gob"
gtk_toggle_action_set_active(
				 GTK_TOGGLE_ACTION(self->skin_visible_action),
				  g_value_get_boolean(VAL));
		 
#line 621 "lum-engine.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Lum:Engine::get_property"
{
	LumEngine *self G_GNUC_UNUSED;

	self = LUM_ENGINE (object);

	switch (property_id) {
	case PROP_REPEAT:
		{
#line 126 "lum-engine.gob"
g_value_set_boolean(VAL,
				 gtk_toggle_action_get_active(
				 	GTK_TOGGLE_ACTION(self->repeat_action)));
#line 654 "lum-engine.c"
		}
		break;
	case PROP_PLAYLIST_VISIBLE:
		{
#line 143 "lum-engine.gob"
g_value_set_boolean(VAL, gtk_toggle_action_get_active(
		 	GTK_TOGGLE_ACTION(self->playlist_visible_action)));
#line 662 "lum-engine.c"
		}
		break;
	case PROP_VIDWIN_VISIBLE:
		{
#line 160 "lum-engine.gob"
g_value_set_boolean(VAL,
			 gtk_toggle_action_get_active(
		 		 GTK_TOGGLE_ACTION(self->vidwin_visible_action)));
		 
#line 672 "lum-engine.c"
		}
		break;
	case PROP_SKIN_VISIBLE:
		{
#line 179 "lum-engine.gob"
g_value_set_boolean(VAL,
			 gtk_toggle_action_get_active(
				 GTK_TOGGLE_ACTION(self->skin_visible_action)));
#line 681 "lum-engine.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 350 "lum-engine.gob"
static void 
___2_lum_engine_dispose (GObject * object G_GNUC_UNUSED)
#line 701 "lum-engine.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Engine::dispose"
{
#line 350 "lum-engine.gob"
	
		__d;
		Self *self = SELF(object);
		if(selfp->autostart_id){
			g_source_remove(selfp->autostart_id);
			selfp->autostart_id = FALSE;
		}
		lum_player_stop(selfp->player);

		if(selfp->skin)
			gtk_widget_hide(GTK_WIDGET(selfp->skin));

		if(selfp->playlist)
			gtk_widget_hide(GTK_WIDGET(selfp->playlist));
		if(selfp->video_window)
			gtk_widget_hide(GTK_WIDGET(selfp->video_window));
		if(selfp->popup_menu)
			gtk_widget_hide(GTK_WIDGET(selfp->popup_menu));
		g_object_ref(lum_shell);
		lum_shell_set_tip(lum_shell, NULL);
		g_object_unref(lum_shell);

		PARENT_HANDLER(object);
	}}
#line 733 "lum-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 375 "lum-engine.gob"
static void 
___3_lum_engine_finalize (GObject * object G_GNUC_UNUSED)
#line 740 "lum-engine.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Engine::finalize"
{
#line 375 "lum-engine.gob"
	
		__d;
		Self *self = SELF(object);
		if(selfp->skin){
			gtk_widget_destroy(GTK_WIDGET(selfp->skin));
			selfp->skin = NULL;
		}
		if(selfp->playlist){
			gtk_widget_destroy(GTK_WIDGET(selfp->playlist));
			selfp->playlist = NULL;
		}
		if(selfp->video_window){
			gtk_widget_destroy(GTK_WIDGET(selfp->video_window));
			selfp->video_window = NULL;
		}
		if(selfp->popup_menu){
			gtk_widget_destroy(GTK_WIDGET(selfp->popup_menu));
			selfp->popup_menu = NULL;
		}
		if(selfp->dialog) {
			gtk_widget_destroy(selfp->dialog);
			selfp->dialog = NULL;
		}
		PARENT_HANDLER(object);
	}}
#line 773 "lum-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

/**
 * lum_engine_get_skin:
 *
 * Returns: the skin
 **/
#line 406 "lum-engine.gob"
GtkWindow * 
lum_engine_get_skin (LumEngine * self)
#line 785 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::get_skin"
#line 406 "lum-engine.gob"
	g_return_val_if_fail (self != NULL, (GtkWindow * )0);
#line 406 "lum-engine.gob"
	g_return_val_if_fail (LUM_IS_ENGINE (self), (GtkWindow * )0);
#line 792 "lum-engine.c"
{
#line 407 "lum-engine.gob"
		return GTK_WINDOW(selfp->skin); }}
#line 796 "lum-engine.c"
#undef __GOB_FUNCTION__

/**
 * lum_engine_load_uri:
 * @uri: a uri
 * clear the playlist and load this uri
 **/
#line 414 "lum-engine.gob"
void 
lum_engine_load_uri (LumEngine * self, const gchar * uri)
#line 807 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::load_uri"
#line 414 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 414 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 414 "lum-engine.gob"
	g_return_if_fail (uri != NULL);
#line 816 "lum-engine.c"
{
#line 414 "lum-engine.gob"
	
		lum_playlist_clear(selfp->playlist);
		self_enqueue(self, uri);
		if(lum_shell_get_config(lum_shell)->autostart)
			if(selfp->autostart_id)
				g_source_remove(selfp->autostart_id);
			selfp->autostart_id = g_timeout_add(500, self_autostart, self);
	}}
#line 827 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 428 "lum-engine.gob"
void 
lum_engine_enqueue (LumEngine * self, const gchar * uri)
#line 833 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::enqueue"
#line 428 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 428 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 428 "lum-engine.gob"
	g_return_if_fail (uri != NULL);
#line 842 "lum-engine.c"
{
#line 428 "lum-engine.gob"
	
		GList *tmp;
		LumPlayerInfo *info = NULL;

		if((tmp = self_check_dir(uri))){
			GList *list;
			for(list = tmp; list != NULL; list = list->next){
				if((info = lum_player_info_factory(
						(gchar*)list->data, NULL))){
					lum_player_info_connect__lookup_icon(
						info, self_lookup_icon, self);
					lum_playlist_add(selfp->playlist,
							(gchar*)list->data, info);
				}
				g_free(list->data);
			}
			g_list_free(tmp);
		} else {
			if((info = lum_player_info_factory(uri, NULL))){
				lum_player_info_connect__lookup_icon(
						info, self_lookup_icon, self);
				lum_playlist_add(selfp->playlist, uri, info);
			}
		}
	}}
#line 870 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 457 "lum-engine.gob"
void 
lum_engine_iconify (LumEngine * self)
#line 876 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::iconify"
#line 457 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 457 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 883 "lum-engine.c"
{
#line 457 "lum-engine.gob"
	
		if(gdk_window_get_state(GTK_WIDGET(selfp->skin)->window)
					== GDK_WINDOW_STATE_ICONIFIED ){
			gtk_window_present(GTK_WINDOW(selfp->skin));
			gtk_window_deiconify(GTK_WINDOW(selfp->skin));
			if((gdk_window_get_state(GTK_WIDGET(selfp->video_window)->window)
				== GDK_WINDOW_STATE_ICONIFIED) &&
				gtk_toggle_action_get_active(
		 		 GTK_TOGGLE_ACTION(self->vidwin_visible_action))){
				gtk_window_present(selfp->video_window);
				gtk_window_deiconify(selfp->video_window);
			}
			if((gdk_window_get_state(GTK_WIDGET(selfp->playlist)->window)
						== GDK_WINDOW_STATE_ICONIFIED) &&
				gtk_toggle_action_get_active(
		 		 GTK_TOGGLE_ACTION(self->playlist_visible_action))){
				gtk_window_present(GTK_WINDOW(selfp->playlist));
				gtk_window_deiconify(GTK_WINDOW(selfp->playlist));
			}
		} else {
			gtk_window_iconify(GTK_WINDOW(selfp->skin));
			gtk_window_iconify(selfp->video_window);
			gtk_window_iconify(GTK_WINDOW(selfp->playlist));
		}
	}}
#line 911 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 484 "lum-engine.gob"
void 
lum_engine_set_volume (LumEngine * self, gdouble volume)
#line 917 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::set_volume"
#line 484 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 484 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 924 "lum-engine.c"
{
#line 484 "lum-engine.gob"
	
		if(volume > 100)
			volume = 100;
		else if(volume < 0)
			volume = 0;
		lum_player_set_volume(selfp->player, volume);
	}}
#line 934 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 492 "lum-engine.gob"
void 
lum_engine_dec_vol (LumEngine * self)
#line 940 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::dec_vol"
#line 492 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 492 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 947 "lum-engine.c"
{
#line 493 "lum-engine.gob"
		self_set_volume(self, lum_player_get_volume(selfp->player) - 10); }}
#line 951 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 495 "lum-engine.gob"
void 
lum_engine_inc_vol (LumEngine * self)
#line 957 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::inc_vol"
#line 495 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 495 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 964 "lum-engine.c"
{
#line 496 "lum-engine.gob"
		self_set_volume(self, lum_player_get_volume(selfp->player) + 10); }}
#line 968 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 498 "lum-engine.gob"
void 
lum_engine_mute (LumEngine * self)
#line 974 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::mute"
#line 498 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 498 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 981 "lum-engine.c"
{
#line 498 "lum-engine.gob"
	
		gboolean tmp;
		g_object_get(G_OBJECT(selfp->player), "LumPlayer::mute",
				&tmp, NULL);
		g_object_set(G_OBJECT(selfp->player), "LumPlayer::mute", !tmp, NULL);
	}}
#line 990 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 505 "lum-engine.gob"
void 
lum_engine_show_info (LumEngine * self)
#line 996 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::show_info"
#line 505 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 505 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1003 "lum-engine.c"
{
#line 505 "lum-engine.gob"
	
		lum_player_show_props_window(
				lum_playlist_get_active_info(selfp->playlist));
	}}
#line 1010 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 513 "lum-engine.gob"
void 
lum_engine_do_popup (LumEngine * self, GdkEventButton * event)
#line 1016 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::do_popup"
#line 513 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 513 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1023 "lum-engine.c"
{
#line 513 "lum-engine.gob"
	
		if(event)
			gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, event->button, event->time);
		else
			gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, 0, gtk_get_current_event_time());
	}}
#line 1036 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 525 "lum-engine.gob"
void 
lum_engine_switch_timer_mode (LumEngine * self)
#line 1042 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::switch_timer_mode"
#line 525 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 525 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1049 "lum-engine.c"
}
#undef __GOB_FUNCTION__

#line 527 "lum-engine.gob"
gboolean 
lum_engine_can_seek (LumEngine * self)
#line 1056 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::can_seek"
#line 527 "lum-engine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 527 "lum-engine.gob"
	g_return_val_if_fail (LUM_IS_ENGINE (self), (gboolean )0);
#line 1063 "lum-engine.c"
{
#line 528 "lum-engine.gob"
		return lum_player_get_is_seekable(selfp->player); }}
#line 1067 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 531 "lum-engine.gob"
void 
lum_engine_fwd10 (LumEngine * self)
#line 1073 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::fwd10"
#line 531 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 531 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1080 "lum-engine.c"
}
#undef __GOB_FUNCTION__

#line 534 "lum-engine.gob"
void 
lum_engine_back10 (LumEngine * self)
#line 1087 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::back10"
#line 534 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 534 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1094 "lum-engine.c"
}
#undef __GOB_FUNCTION__

#line 541 "lum-engine.gob"
void 
lum_engine_close (LumEngine * self)
#line 1101 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::close"
#line 541 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 541 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1108 "lum-engine.c"
{
#line 542 "lum-engine.gob"
		g_object_unref(G_OBJECT(self)); }}
#line 1112 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 547 "lum-engine.gob"
void 
lum_engine_prev (LumEngine * self)
#line 1118 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::prev"
#line 547 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 547 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1125 "lum-engine.c"
{
#line 547 "lum-engine.gob"
	
		if(lum_playlist_has_prev(selfp->playlist))
			lum_playlist_prev(selfp->playlist);
		else {
			lum_playlist_prev(selfp->playlist);
			self_play(self);
		}
	}}
#line 1136 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 559 "lum-engine.gob"
void 
lum_engine_next (LumEngine * self)
#line 1142 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::next"
#line 559 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 559 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1149 "lum-engine.c"
{
#line 559 "lum-engine.gob"
	
		bool has_next = false;
		has_next = lum_player_next(selfp->player);

		if(!has_next){
			if(lum_playlist_has_next(selfp->playlist))
				lum_playlist_next(selfp->playlist);
			else {
				lum_playlist_next(selfp->playlist);
				self_play(self);
			}
		}
	}}
#line 1165 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 577 "lum-engine.gob"
void 
lum_engine_play (LumEngine * self)
#line 1171 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::play"
#line 577 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 577 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1178 "lum-engine.c"
{
#line 577 "lum-engine.gob"
	
		self_play_now(self,lum_playlist_get_active_info(selfp->playlist),
				lum_playlist_get_active_uri(selfp->playlist));
	}}
#line 1185 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 586 "lum-engine.gob"
void 
lum_engine_pause (LumEngine * self)
#line 1191 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::pause"
#line 586 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 586 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1198 "lum-engine.c"
{
#line 586 "lum-engine.gob"
	
		LumPlayerStatus status = lum_player_get_status(selfp->player);
		if(status == PLAYER_PLAYING ||
				status == PLAYER_PAUSED){
			lum_player_play_pause(selfp->player);	
		}
		else if(status == PLAYER_STOPPED){
			self_play_now(self,lum_playlist_get_active_info(selfp->playlist),
				lum_playlist_get_active_uri(selfp->playlist));
		}
	}}
#line 1212 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 598 "lum-engine.gob"
void 
lum_engine_stop (LumEngine const * self)
#line 1218 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::stop"
#line 598 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 598 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1225 "lum-engine.c"
{
#line 599 "lum-engine.gob"
		lum_player_stop(selfp->player); }}
#line 1229 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 602 "lum-engine.gob"
gboolean 
lum_engine_get_shuffle (LumEngine const * self)
#line 1235 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::get_shuffle"
#line 602 "lum-engine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 602 "lum-engine.gob"
	g_return_val_if_fail (LUM_IS_ENGINE (self), (gboolean )0);
#line 1242 "lum-engine.c"
{
#line 603 "lum-engine.gob"
		return FALSE; }}
#line 1246 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 606 "lum-engine.gob"
void 
lum_engine_set_shuffle (LumEngine const * self, gboolean shuffle)
#line 1252 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::set_shuffle"
#line 606 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 606 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1259 "lum-engine.c"
}
#undef __GOB_FUNCTION__

#line 611 "lum-engine.gob"
GList * 
lum_engine_get_list (LumEngine * self)
#line 1266 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::get_list"
#line 611 "lum-engine.gob"
	g_return_val_if_fail (self != NULL, (GList * )0);
#line 611 "lum-engine.gob"
	g_return_val_if_fail (LUM_IS_ENGINE (self), (GList * )0);
#line 1273 "lum-engine.c"
{
#line 612 "lum-engine.gob"
		return lum_playlist_get_list(selfp->playlist); }}
#line 1277 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 619 "lum-engine.gob"
void 
lum_engine_play_now (LumEngine * self, LumPlayerInfo * info, const gchar * uri)
#line 1283 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::play_now"
#line 619 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 619 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 619 "lum-engine.gob"
	g_return_if_fail (info != NULL);
#line 619 "lum-engine.gob"
	g_return_if_fail (LUM_IS_PLAYER_INFO (info));
#line 619 "lum-engine.gob"
	g_return_if_fail (uri != NULL);
#line 1296 "lum-engine.c"
{
#line 620 "lum-engine.gob"
	
		__d;
		lum_player_open_file(selfp->player, uri, info);
		lum_skin_handle_event(selfp->skin, LUM_EVENT_PLAY_NOW, (gpointer) info);
		lum_changer_action(selfp->changer, LUM_EVENT_PLAY_NOW, (gpointer) info);
//		lum_shell_handle_event(lum_shell, LUM_EVENT_PLAY_NOW, (gpointer) info);
		/* #TODO
		gtk_xine_set_reparent(GTK_XINE(selfp->player),
				GTK_WIDGET(selfp->skin)->window);
		g_object_set(G_OBJECT(selfp->player), 
				"GtkXine::show_vfx_embed", TRUE, NULL, NULL);
		*/
			
		gboolean vfx = FALSE;
		g_object_get(G_OBJECT(selfp->player), "GtkXine::show_vfx", &vfx, NULL, NULL);
		if(info->has_video){
			g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", TRUE, NULL);
			if(selfp->prev == PREV_NONE || selfp->prev == PREV_AUDIO){
				gtk_window_set_resizable(selfp->video_window, TRUE);
				gtk_window_resize(selfp->video_window, info->video_width,
						info->video_height + 65);
			}
			g_object_set(G_OBJECT(self), "LumEngine::vidwin_visible",
						TRUE, NULL);
			selfp->prev = PREV_VIDEO;
		} else if(vfx){
			g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", TRUE, NULL);
			if(selfp->prev == PREV_NONE || selfp->prev == PREV_AUDIO){
				gtk_window_set_resizable(selfp->video_window, TRUE);
				gtk_window_resize(selfp->video_window, 320, 300);
			}
			g_object_set(G_OBJECT(self), "LumEngine::vidwin_visible",
						TRUE, NULL);
			selfp->prev = PREV_VFX;
		} else {
			gtk_window_resize(selfp->video_window, 368, 85);
			gtk_window_set_resizable(selfp->video_window, FALSE);
			g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", FALSE, NULL);
			g_object_set(G_OBJECT(self), "LumEngine::vidwin_visible",
						FALSE, NULL);
			selfp->prev = PREV_AUDIO;
		}	
		lum_player_play_pause(selfp->player);
	}}
#line 1346 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 671 "lum-engine.gob"
void 
lum_engine_set_position (LumEngine * self, gdouble position)
#line 1352 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::set_position"
#line 671 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 671 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1359 "lum-engine.c"
{
#line 671 "lum-engine.gob"
	
		if(lum_player_get_status(selfp->player) != PLAYER_STOPPED)
			lum_player_set_position(selfp->player, position);
	}}
#line 1366 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 679 "lum-engine.gob"
void 
lum_engine_show_fileselector (LumEngine * self)
#line 1372 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::show_fileselector"
#line 679 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 679 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1379 "lum-engine.c"
{
#line 679 "lum-engine.gob"
	
		GSList *uris;
		GList *mime_types;
		if(selfp->dialog == NULL){
			GtkFileFilter *filter = gtk_file_filter_new ();
			GtkFileFilter *global_filter = gtk_file_filter_new ();
			gtk_file_filter_set_name(filter, _("Supported files"));	
			gtk_file_filter_set_name(global_filter, _("All files"));
			gtk_file_filter_add_pattern (global_filter, "*");
			mime_types = gnome_vfs_application_registry_get_mime_types(
					"lumiere");
			for(; mime_types; mime_types = mime_types->next)
				gtk_file_filter_add_mime_type(filter, mime_types->data);
			selfp->dialog = gtk_file_chooser_dialog_new (_("Open Files"),
				      NULL,
				      GTK_FILE_CHOOSER_ACTION_OPEN,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);
			gtk_file_chooser_set_select_multiple(
					GTK_FILE_CHOOSER(selfp->dialog), TRUE);
			gtk_file_chooser_set_local_only(GTK_FILE_CHOOSER(selfp->dialog),
					FALSE);
			gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(selfp->dialog),
					filter);
			gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(selfp->dialog),
					global_filter);
		}
		
		lum_skin_set_info_text_temp(selfp->skin, _("Open Files"));

		if(selfp->current_folder)
			gtk_file_chooser_set_current_folder_uri(
					GTK_FILE_CHOOSER(selfp->dialog),
					selfp->current_folder);
		
		if(gtk_dialog_run(GTK_DIALOG(selfp->dialog)) == GTK_RESPONSE_ACCEPT){
			uris = gtk_file_chooser_get_uris(
					GTK_FILE_CHOOSER (selfp->dialog));
			if(uris != NULL){
				for(; uris != NULL; uris = uris->next){
					self_enqueue(self, uris->data);
					g_free(uris->data);
				}
				g_slist_free(uris);
			}
			if(selfp->current_folder)
				g_free(selfp->current_folder);
			selfp->current_folder = 
				gtk_file_chooser_get_current_folder_uri(
						GTK_FILE_CHOOSER(selfp->dialog));
		}
		gtk_widget_destroy(selfp->dialog);
		selfp->dialog = NULL;
	}}
#line 1437 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 735 "lum-engine.gob"
void 
lum_engine_show_directoryselector (LumEngine * self)
#line 1443 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::show_directoryselector"
#line 735 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 735 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1450 "lum-engine.c"
{
#line 735 "lum-engine.gob"
	
		GSList *uris;
		if(selfp->dialog == NULL){
			selfp->dialog = gtk_file_chooser_dialog_new (_("Open Directories"),
				      NULL,
				      GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);
			gtk_file_chooser_set_select_multiple(
					GTK_FILE_CHOOSER(selfp->dialog), TRUE);
			gtk_file_chooser_set_local_only(GTK_FILE_CHOOSER(selfp->dialog),
					FALSE);
		}
		
		lum_skin_set_info_text_temp(selfp->skin, _("Open Directories"));

		if(selfp->current_folder)
			gtk_file_chooser_set_current_folder_uri(
					GTK_FILE_CHOOSER(selfp->dialog),
					selfp->current_folder);
		
		if(gtk_dialog_run(GTK_DIALOG(selfp->dialog)) == GTK_RESPONSE_ACCEPT){
			uris = gtk_file_chooser_get_uris(
					GTK_FILE_CHOOSER (selfp->dialog));
			if(uris != NULL){
				for(; uris != NULL; uris = uris->next){
					printf("uri = %s\n",(char *)uris->data);
					self_enqueue(self, uris->data);
					g_free(uris->data);
				}
				g_slist_free(uris);
			} else
				printf("uris from directory chooser == NULL\n");
			if(selfp->current_folder)
				g_free(selfp->current_folder);
			selfp->current_folder = 
				gtk_file_chooser_get_current_folder_uri(
						GTK_FILE_CHOOSER(selfp->dialog));
		}
		gtk_widget_destroy(selfp->dialog);
		selfp->dialog = NULL;
	}}
#line 1496 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 782 "lum-engine.gob"
void 
lum_engine_open_dvd (LumEngine * self)
#line 1502 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::open_dvd"
#line 782 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 782 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1509 "lum-engine.c"
{
#line 782 "lum-engine.gob"
	
		char **list;
		int i, num = 0;

		lum_skin_set_info_text_temp(selfp->skin, _("Open DVD"));
		list = lum_player_get_dvd_list(selfp->player, &num);
		if(num == 0){
			GtkWidget *dialog = gtk_message_dialog_new (NULL,
					GTK_DIALOG_MODAL,
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK,
					_("Failed to load DVD."));
			LumCdSelection *cd_select = g_object_new(
					LUM_TYPE_CD_SELECTION, NULL);
			const char *drive = lum_cd_selection_get_device_name(
					LUM_CD_SELECTION(cd_select),
					lum_shell_get_config(lum_shell)->dvd_dev);
			char * text = g_strdup_printf (
					_("Lumiere could not open a DVD from device: %s"),
					drive);
			
			gtk_message_dialog_format_secondary_text (
				GTK_MESSAGE_DIALOG(dialog), "%s\n\n%s", text,
				_("Make sure there is a DVD in the drive. "
				"Or check the drive settings in lumiere preferences. "
				" Or even check that you have libdvdcss installed "
				"in order to read encrypted DVDs."));
			g_signal_connect_swapped(dialog, "response", 
				G_CALLBACK (gtk_widget_destroy), dialog);
			gtk_widget_show_all(dialog);
			g_free (text);
			gtk_dialog_run (GTK_DIALOG (dialog));
			gtk_widget_destroy(dialog);
			g_object_unref(cd_select);
		} else {
			for(i = 0; i < num; i++){
				self_enqueue(self, list[i]);
				free(list[i]);
			}
		}
	}}
#line 1553 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 824 "lum-engine.gob"
void 
lum_engine_open_cdda (LumEngine * self)
#line 1559 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::open_cdda"
#line 824 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 824 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1566 "lum-engine.c"
{
#line 824 "lum-engine.gob"
	
		char **list;
		int i, num = 0;

		lum_skin_set_info_text_temp(selfp->skin, _("Open Audio CD"));
		list = lum_player_get_cdda_list(selfp->player, &num);
		if(num == 0){
			GtkWidget *dialog = gtk_message_dialog_new (NULL,
					GTK_DIALOG_MODAL,
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK,
					_("Failed to load audio CD."));
			LumCdSelection *cd_select = g_object_new(
					LUM_TYPE_CD_SELECTION, NULL);
			const char *drive = lum_cd_selection_get_device_name(
					LUM_CD_SELECTION(cd_select),
					lum_shell_get_config(lum_shell)->dvd_dev);
			char * text = g_strdup_printf (
					_("Lumiere could not open an audio CD from device: %s"),
					drive);
			gtk_message_dialog_format_secondary_text (
				GTK_MESSAGE_DIALOG(dialog), "%s\n\n%s", text,
   					_("Make sure there is an audio CD in the drive. "));
			g_free (text);
			gtk_dialog_run (GTK_DIALOG (dialog));
			gtk_widget_destroy(dialog);
			g_object_unref(cd_select);
		} else {
			for(i = 0; i < num; i++){
				self_enqueue(self, list[i]);
				free(list[i]);
			}
		}
	}}
#line 1603 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 859 "lum-engine.gob"
void 
lum_engine_drag_received (LumEngine * self, GdkDragContext * context, GtkSelectionData * data, guint time)
#line 1609 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::drag_received"
#line 859 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 859 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1616 "lum-engine.c"
{
#line 860 "lum-engine.gob"
	
		GList *list, *p, *file_list;

		list = gnome_vfs_uri_list_parse (data->data);

		if (list == NULL) {
			gtk_drag_finish (context, FALSE, FALSE, time);
			return;
		}

		p = list;
		file_list = NULL;

		for(; p != NULL; p = p->next){
			file_list = g_list_prepend (file_list,
					gnome_vfs_uri_to_string
					((const GnomeVFSURI*)(p->data), 0));
		}

		gnome_vfs_uri_list_free (list);
		file_list = g_list_reverse (file_list);

		if (file_list == NULL){
			gtk_drag_finish (context, FALSE, FALSE, time);
			return;
		}
		
		struct thread_data *my_data;
		my_data = g_malloc(sizeof(struct thread_data));
		my_data->engine = self;
		my_data->list = file_list;
		g_thread_create(self_populate_playlist, (gpointer) my_data,
						FALSE, NULL);
#if 0
		for (p = file_list; p != NULL; p = p->next){
			char *filename;

			if (p->data == NULL)
				continue;

			filename = gnome_vfs_get_local_path_from_uri(p->data);
			if (filename == NULL)
				filename = g_strdup (p->data);

			if (filename != NULL &&
				(g_file_test (filename, G_FILE_TEST_IS_REGULAR
					| G_FILE_TEST_EXISTS)
					 || strstr (filename, "://") != NULL))
				lum_engine_enqueue(engine, filename);
			g_free (p->data);
		}
		g_list_free (file_list);
#endif
		gtk_drag_finish (context, TRUE, FALSE, time);
		gtk_widget_queue_draw(GTK_WIDGET(selfp->playlist));		
	}}
#line 1675 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 917 "lum-engine.gob"
static gpointer 
lum_engine_populate_playlist (gpointer data)
#line 1681 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::populate_playlist"
{
#line 917 "lum-engine.gob"
	
		struct thread_data *my_data = (struct thread_data *) data;
		GList *p = NULL;
		for (p = my_data->list; p != NULL; p = p->next){
			char *filename;

			if (p->data == NULL)
				continue;

			filename = gnome_vfs_get_local_path_from_uri(p->data);
			if (filename == NULL)
				filename = g_strdup (p->data);

			if (filename != NULL &&
				(g_file_test (filename, G_FILE_TEST_IS_REGULAR
					| G_FILE_TEST_EXISTS)
					 || strstr (filename, "://") != NULL))
				self_enqueue(my_data->engine, filename);
			g_free (p->data);
		}
		g_list_free (my_data->list);
		g_free(my_data);
		return NULL;
	}}
#line 1710 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 946 "lum-engine.gob"
static GList * 
lum_engine_check_dir (const gchar * uri)
#line 1716 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::check_dir"
#line 946 "lum-engine.gob"
	g_return_val_if_fail (uri != NULL, (GList * )NULL);
#line 1721 "lum-engine.c"
{
#line 946 "lum-engine.gob"
	
		DIR *dir = NULL;
	 	struct dirent *dirent = NULL;
	 	struct stat statbuf;
		char *temp = NULL;
	 	GList *list = NULL;
		GnomeVFSURI *vfs_uri = gnome_vfs_uri_new(uri);
		if(!vfs_uri){
			printf("vfs_uri == NULL\n");
			return NULL;
		}
		if(gnome_vfs_uri_is_local(vfs_uri)){
			char *path;
			if(g_ascii_strncasecmp ("file:", uri, 5) == 0)
				path = g_strdup(uri+5);
			else
				path = g_strdup(uri);
			__ds("opening directory localy");
			if (stat(path, &statbuf) < 0)
				return NULL;
			if (!S_ISDIR(statbuf.st_mode))
				return NULL;
			if (path[strlen(path) - 1] != '/')
				temp = g_strconcat(path, "/", NULL);
			else
				temp = g_strdup(path);
			if ((dir = opendir(path)) == NULL) {
				g_free(temp);
				return NULL;
			}
			while ((dirent = readdir(dir)) != NULL) {
				char *filename;
				if (dirent->d_name[0] == '.')
					continue;
				filename = g_strconcat(temp, dirent->d_name, NULL);
				
				if (stat(filename, &statbuf) < 0) {
					g_free(filename);
					continue;
				}
				
				if (S_ISDIR(statbuf.st_mode)) {
					GList *sub;
					sub = self_check_dir(filename);
					g_free(filename);
					list = g_list_concat(list, sub);
				} else { 
					list = g_list_append(list, filename);
				}
				
			}
			closedir(dir);
			g_free(temp);
			return list;
		} else {
			GnomeVFSFileInfo info;
			gnome_vfs_file_info_ref(&info); 

			if(gnome_vfs_get_file_info_uri(vfs_uri,
                                     &info, 0) != GNOME_VFS_OK)
				return NULL;
			if(info.type != GNOME_VFS_FILE_TYPE_DIRECTORY)
				return NULL;
			GnomeVFSDirectoryHandle *handle = NULL;
			if(gnome_vfs_directory_open_from_uri(&handle,
   						vfs_uri, 0) != GNOME_VFS_OK)
				return NULL;
			printf(__FILE__ ": info name: %s\n", info.name);
			while(gnome_vfs_directory_read_next(handle, &info) == GNOME_VFS_OK) {
				GString *string = NULL;
				if (g_ascii_strncasecmp (".", info.name, 2) == 0 ||
					g_ascii_strncasecmp ("..", info.name, 3) == 0)
					continue;
			    	string = g_string_new(uri);
				string = g_string_append(string, "/");
				string = g_string_append(string, info.name);
				if(info.type == GNOME_VFS_FILE_TYPE_DIRECTORY){
					GList *sub;
					sub = self_check_dir(string->str);
					list = g_list_concat(list,sub);
				} else
					list = g_list_append(list, g_strdup(string->str));
				g_string_free(string, TRUE);
			}
			gnome_vfs_directory_close(handle);
			gnome_vfs_uri_unref(vfs_uri);
			return list;
		}			
	}}
#line 1813 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1036 "lum-engine.gob"
static gboolean 
lum_engine_autostart (gpointer data)
#line 1819 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::autostart"
{
#line 1036 "lum-engine.gob"
	
		Self *self = SELF(data);
		if(lum_playlist_get_active_info(selfp->playlist)){
			self_play(self);
			selfp->autostart_id = FALSE;
			return FALSE;
		}
		return TRUE;
	}}
#line 1833 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1050 "lum-engine.gob"
void 
lum_engine_opendir_activate_cb (GtkMenuItem * button, LumEngine * self)
#line 1839 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::opendir_activate_cb"
#line 1050 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 1050 "lum-engine.gob"
	g_return_if_fail (LUM_IS_ENGINE (self));
#line 1846 "lum-engine.c"
{
#line 1051 "lum-engine.gob"
		self_show_directoryselector(self);	}}
#line 1850 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1054 "lum-engine.gob"
static gboolean 
lum_engine_video_window_delete_cb (GtkWidget * widget, GdkEvent * event, gpointer user_data)
#line 1856 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::video_window_delete_cb"
{
#line 1055 "lum-engine.gob"
	
		Self *self = SELF(user_data);
		g_object_set(G_OBJECT(self), "LumEngine::vidwin_visible",
						FALSE, NULL);
		return TRUE;
	}}
#line 1867 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1062 "lum-engine.gob"
gboolean 
lum_engine_playlist_delete_cb (GtkWidget * widget, GdkEvent * event, gpointer user_data)
#line 1873 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::playlist_delete_cb"
{
#line 1063 "lum-engine.gob"
	
		Self *self = SELF(user_data);
		g_object_set(G_OBJECT(self),"LumEngine::playlist_visible", FALSE, NULL);
		return TRUE;
	}}
#line 1883 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1074 "lum-engine.gob"
static void 
lum_engine_playback_finished_cb (LumPlayer * player, gpointer data)
#line 1889 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::playback_finished_cb"
{
#line 1074 "lum-engine.gob"
	
		Self *self = SELF(data);
		if(lum_playlist_has_next(selfp->playlist))
			lum_playlist_next(selfp->playlist);
		else if(gtk_toggle_action_get_active(
					GTK_TOGGLE_ACTION(self->repeat_action))){
			lum_playlist_next(selfp->playlist);
			self_play(self);
		}
		else {
			lum_player_stop(player);
			lum_playlist_set_at_start(selfp->playlist);
		}
	}}
#line 1908 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1091 "lum-engine.gob"
static void 
lum_engine_player_notify_cb (LumPlayer * player, GParamSpec * spec, Self * self)
#line 1914 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::player_notify_cb"
#line 1091 "lum-engine.gob"
	g_return_if_fail (player != NULL);
#line 1091 "lum-engine.gob"
	g_return_if_fail (LUM_IS_PLAYER (player));
#line 1091 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 1091 "lum-engine.gob"
	g_return_if_fail (IS_SELF (self));
#line 1925 "lum-engine.c"
{
#line 1093 "lum-engine.gob"
	
		__d;
		LumPlayerStatus status = lum_player_get_status(player);
		if(!strncmp("status", spec->name, 6)){
			switch(status){
				case PLAYER_PAUSED: break;
				case PLAYER_PLAYING: break;
				case PLAYER_NONE:
				case PLAYER_STOPPED:
					lum_shell_set_tip(lum_shell, NULL);
					if(GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->video_window)))
						self_video_window_delete_cb(
							GTK_WIDGET(selfp->video_window), NULL, self);
					break;
				default: break;
			}
			lum_skin_handle_event(selfp->skin,
					LUM_EVENT_STATUS_CHANGED,
					GINT_TO_POINTER(status));
			lum_changer_action(selfp->changer,
					LUM_EVENT_STATUS_CHANGED,
					GINT_TO_POINTER(status));
			printf(__GOB_FUNCTION__" status changed: %d.\n", status);
		} else if(!strncmp("time", spec->name, 4)){
			if(status == PLAYER_STOPPED)
				return;
			if(lum_player_get_is_seekable(player)){
				int time = lum_player_get_time(player);
				int min = time / 60000;
				int secs = (time / 1000) - (min * 60);
				lum_skin_set_time(selfp->skin, min, secs);
			} else
				lum_skin_set_time(selfp->skin, 0, 0);
		} else if(!strncmp("position", spec->name, 8)){
			if(status == PLAYER_STOPPED)
				return;
			if(lum_player_get_is_seekable(player))
				lum_skin_set_position(selfp->skin,
						lum_player_get_position(player));
			else
				lum_skin_set_position(selfp->skin, -1);
		}
	}}
#line 1971 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1140 "lum-engine.gob"
static void 
lum_engine_volume_changed_cb (LumPlayer * player, double volume, Self * self)
#line 1977 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::volume_changed_cb"
{
#line 1141 "lum-engine.gob"
		lum_skin_set_volume(selfp->skin, volume); }}
#line 1983 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1145 "lum-engine.gob"
static void 
lum_engine_vfx_activate_cb (GtkCheckMenuItem * button, Self * self)
#line 1989 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::vfx_activate_cb"
{
#line 1145 "lum-engine.gob"
	
		gboolean active = gtk_check_menu_item_get_active(button);
		LumPlayerStatus status = lum_player_get_status(selfp->player);
//		if(GTK_IS_XINE(selfp->player)){
			g_object_set(G_OBJECT(selfp->player),"GtkXine::show_vfx",
					active, NULL);
			if(active){
				if(selfp->prev == PREV_VIDEO)
					return;
				else {
					gtk_window_set_resizable(selfp->video_window, TRUE);
					gtk_window_resize(selfp->video_window, 300, 300);
				}
				if(!GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->video_window))){
					if(status != PLAYER_STOPPED){
						g_object_set(G_OBJECT(self),
								"LumEngine::vidwin_visible",
								TRUE, NULL);
						selfp->prev = PREV_VFX;
					}
				}
				g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", TRUE, NULL);
			} else if(selfp->prev == PREV_NONE || selfp->prev == PREV_VFX
					|| selfp->prev == PREV_AUDIO){
				gtk_window_resize(selfp->video_window, 368, 65);
				gtk_window_set_resizable(selfp->video_window, FALSE);
				g_object_set(G_OBJECT(selfp->player), 
						"LumPlayer::can_fullscreen", FALSE, NULL);
				g_object_set(G_OBJECT(self), "LumEngine::vidwin_visible",
						FALSE, NULL);
				selfp->prev = PREV_AUDIO;
			}
//		}
	}}
#line 2029 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1183 "lum-engine.gob"
static void 
lum_engine_visible_cb (GtkAction * action, gpointer data)
#line 2035 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::visible_cb"
{
#line 1183 "lum-engine.gob"
	
		GtkWidget *widget = GTK_WIDGET(data);
		GtkToggleAction *toggle_action = GTK_TOGGLE_ACTION(action);

		if(gtk_toggle_action_get_active(toggle_action))
			gtk_widget_show(widget);
		else
			gtk_widget_hide(widget);
	}}
#line 2049 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1196 "lum-engine.gob"
static void 
lum_engine_player_drag_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, Self * self)
#line 2055 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::player_drag_received_cb"
#line 1196 "lum-engine.gob"
	g_return_if_fail (self != NULL);
#line 1196 "lum-engine.gob"
	g_return_if_fail (IS_SELF (self));
#line 2062 "lum-engine.c"
{
#line 1198 "lum-engine.gob"
	
		self_drag_received(self, context, data, time);
	}}
#line 2068 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1202 "lum-engine.gob"
static gboolean 
lum_engine_key_press_cb (GtkWidget * widget, GdkEventKey * event, Self * self)
#line 2074 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::key_press_cb"
#line 1202 "lum-engine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 1202 "lum-engine.gob"
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
#line 2081 "lum-engine.c"
{
#line 1203 "lum-engine.gob"
	

		switch (event->keyval) {
			case GDK_E:
			case GDK_e:
				if (event->state & GDK_CONTROL_MASK)
					gnome_url_show("mailto:your_recipient", NULL);
				else return FALSE;
				break;
			case GDK_N:
			case GDK_n:
				if (event->state & GDK_CONTROL_MASK)
					lum_shell_new_engine(lum_shell);
				else return FALSE;
				break;
			case GDK_O:
			case GDK_o:
				if (event->state & GDK_CONTROL_MASK)
					self_show_fileselector(self);
				else return FALSE;
				break;
			case XF86XK_AudioPlay:
			case XF86XK_AudioPause:
			case GDK_p:
			case GDK_P:
				self_pause(self);
				break;
			case GDK_q:
			case GDK_Q:
				if(event->state & GDK_CONTROL_MASK)
					gtk_action_activate(lum_shell->quit);
				else return FALSE;
				break;
			case GDK_R:
			case GDK_r:
				if(event->state & GDK_CONTROL_MASK)
					self_set_position(self, 0);
				else return FALSE;
				break;
			case GDK_W:
			case GDK_w:
				if (event->state & GDK_CONTROL_MASK)
					self_close(self);
				else return FALSE;
				break;
			case XF86XK_AudioPrev:
			case GDK_Left:
			case GDK_KP_Left:
				if(event->state & GDK_MOD1_MASK)
					self_prev(self);
				else return FALSE;
				break;
			case XF86XK_AudioNext:
			case GDK_KP_Right:
			case GDK_Right:
				if(event->state & GDK_MOD1_MASK)
					self_next(self);
				else return FALSE;
				break;
			case GDK_plus:
			case GDK_KP_Add:
				self_inc_vol(self);
				break;
			case GDK_minus:
			case GDK_KP_Subtract:
				self_dec_vol(self);
				break;
			case GDK_KP_Home:
			case GDK_Home:
				if(event->state & GDK_MOD1_MASK){
//					self_stop(self);
					lum_playlist_set_at_start(selfp->playlist);
					self_play(self);
				}
				else return FALSE;
				break;	
			case GDK_F1:
				gtk_action_activate(lum_shell->help);
				break;
			default:
				return FALSE;
		}
		return TRUE;
	}}
#line 2168 "lum-engine.c"
#undef __GOB_FUNCTION__

#line 1288 "lum-engine.gob"
static char * 
lum_engine_lookup_icon (LumPlayerInfo * info, gpointer data)
#line 2174 "lum-engine.c"
{
#define __GOB_FUNCTION__ "Lum:Engine::lookup_icon"
#line 1288 "lum-engine.gob"
	g_return_val_if_fail (info != NULL, (char * )0);
#line 1288 "lum-engine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER_INFO (info), (char * )0);
#line 1288 "lum-engine.gob"
	g_return_val_if_fail (data != NULL, (char * )0);
#line 2183 "lum-engine.c"
{
#line 1289 "lum-engine.gob"
	
		char *mime_type = gnome_vfs_get_mime_type(info->uri);
		if(!mime_type)
			return NULL;
		return gnome_icon_lookup(
			LUM_PLAYER_INFO_GET_CLASS(info)->icon_theme,
			NULL, info->uri,
			NULL, NULL, mime_type,
			GNOME_ICON_LOOKUP_FLAGS_NONE, NULL);
	}}
#line 2196 "lum-engine.c"
#undef __GOB_FUNCTION__
