/* Generated by GOB (v2.0.11) on Sat Apr 16 22:40:52 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-playlist.gob"

/***************************************************************************
                   lum-playlist.gob  -  Lumiere Playlist Window 
                             -------------------
    copyright            : (C) 2003,2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * CVS block: cvs hosted at nongnu.org
 *
 * $Author: stephanek $
 * $Revision: 1.13 $
 * $Date: 2005/04/13 01:26:42 $
 *
 */

#line 35 "lum-playlist.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-playlist.h"

#include "lum-playlist-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 35 "lum-playlist.gob"


static const GtkTargetEntry target_table [] =
{
	{ "STRING",        0, TARGET_STRING },
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
	{ "text/plain;charset=UTF-8",    0, TARGET_STRING_UTF8 },
};

enum
{
	TARGET_GTK_TREE_MODEL_ROW
};
static GtkTargetEntry tree_view_row_targets[] = {
	{ "GTK_TREE_MODEL_ROW", GTK_TARGET_SAME_APP, TARGET_GTK_TREE_MODEL_ROW }
};


#line 76 "lum-playlist.c"

#line 71 "lum-playlist.gob"

static gboolean gtk_tree_model_iter_previous (GtkTreeModel *tree_model, GtkTreeIter *iter)
{
	GtkTreePath *path;
	gboolean ret;

	path = gtk_tree_model_get_path (tree_model, iter);
	ret = gtk_tree_path_prev (path);
	if (ret == TRUE)
		gtk_tree_model_get_iter (tree_model, iter, path);

	gtk_tree_path_free (path);
	return ret;
}


#line 95 "lum-playlist.c"
static const GEnumValue _lum_playlist_column_values[] = {
	{ COL_DISPLAY_URI, (char *)"COL_DISPLAY_URI", (char *)"display-uri" },
	{ COL_ACTUAL_URI, (char *)"COL_ACTUAL_URI", (char *)"actual-uri" },
	{ COL_INFO, (char *)"COL_INFO", (char *)"info" },
	{ COL_NR, (char *)"COL_NR", (char *)"nr" },
	{ 0, NULL, NULL }
};

GType
lum_playlist_column_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumPlaylistColumn", _lum_playlist_column_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_PLAYLIST(x)
#define SELF_CONST(x) LUM_PLAYLIST_CONST(x)
#define IS_SELF(x) LUM_IS_PLAYLIST(x)
#define TYPE_SELF LUM_TYPE_PLAYLIST
#define SELF_CLASS(x) LUM_PLAYLIST_CLASS(x)

#define SELF_GET_CLASS(x) LUM_PLAYLIST_GET_CLASS(x)

/* self typedefs */
typedef LumPlaylist Self;
typedef LumPlaylistClass SelfClass;

/* here are local prototypes */
static void lum_playlist_class_init (LumPlaylistClass * c) G_GNUC_UNUSED;
static void lum_playlist_init (LumPlaylist * self) G_GNUC_UNUSED;
static void ___3_lum_playlist_dispose (GObject * object) G_GNUC_UNUSED;
static void ___4_lum_playlist_finalize (GObject * object) G_GNUC_UNUSED;
static gboolean ___5_lum_playlist_button_release_event (GtkWidget * widget, GdkEventButton * event) G_GNUC_UNUSED;
static gboolean ___6_lum_playlist_popup_menu (GtkWidget * widget) G_GNUC_UNUSED;
static gboolean ___7_lum_playlist_key_release_event (GtkWidget * widget, GdkEventKey * event) G_GNUC_UNUSED;
static void ___8_lum_playlist_drag_data_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time) G_GNUC_UNUSED;
static gboolean lum_playlist_update_current (LumPlaylist * self) G_GNUC_UNUSED;
static void lum_playlist_set_at_end (LumPlaylist * self) G_GNUC_UNUSED;
static void lum_playlist_delete (LumPlaylist * self, gboolean crop) G_GNUC_UNUSED;
static gint lum_playlist_compare_func (GtkTreeModel * model, GtkTreeIter * iter_a, GtkTreeIter * iter_b, gpointer data) G_GNUC_UNUSED;
static gboolean lum_playlist_crop (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void lum_playlist_selection_changed_cb (GtkTreeSelection * selection, Self * self) G_GNUC_UNUSED;
static void lum_playlist_activate_cb (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, Self * self) G_GNUC_UNUSED;
static void lum_playlist_delete_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_crop_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_clear_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_sort_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_properties_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_delete_clicked_cb (GtkButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_playlist_add_clicked_cb (GtkButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_playlist_close_clicked_cb (GtkButton * button, gpointer data) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkWindowClass *parent_class = NULL;

/* Short form macros */
#define self_new lum_playlist_new
#define self_add_list lum_playlist_add_list
#define self_add lum_playlist_add
#define self_get_active_info lum_playlist_get_active_info
#define self_get_active_uri lum_playlist_get_active_uri
#define self_get_length lum_playlist_get_length
#define self_get_list lum_playlist_get_list
#define self_clear lum_playlist_clear
#define self_has_next lum_playlist_has_next
#define self_next lum_playlist_next
#define self_has_prev lum_playlist_has_prev
#define self_prev lum_playlist_prev
#define self_update_current lum_playlist_update_current
#define self_set_at_start lum_playlist_set_at_start
#define self_set_at_end lum_playlist_set_at_end
#define self_delete lum_playlist_delete
#define self_compare_func lum_playlist_compare_func
#define self_crop lum_playlist_crop
#define self_selection_changed_cb lum_playlist_selection_changed_cb
#define self_activate_cb lum_playlist_activate_cb
#define self_delete_cb lum_playlist_delete_cb
#define self_crop_cb lum_playlist_crop_cb
#define self_clear_cb lum_playlist_clear_cb
#define self_sort_cb lum_playlist_sort_cb
#define self_properties_cb lum_playlist_properties_cb
#define self_delete_clicked_cb lum_playlist_delete_clicked_cb
#define self_add_clicked_cb lum_playlist_add_clicked_cb
#define self_close_clicked_cb lum_playlist_close_clicked_cb
GType
lum_playlist_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumPlaylistClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_playlist_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumPlaylist),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_playlist_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_WINDOW, "LumPlaylist", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumPlaylist *)g_object_new(lum_playlist_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumPlaylist * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumPlaylist *
GET_NEW_VARG (const char *first, ...)
{
	LumPlaylist *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumPlaylist *)g_object_new_valist (lum_playlist_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::dispose"
	LumPlaylist *self G_GNUC_UNUSED = LUM_PLAYLIST (obj_self);
#line 222 "lum-playlist.gob"
	___3_lum_playlist_dispose(obj_self);
#line 233 "lum-playlist.c"
#line 102 "lum-playlist.gob"
	if(self->_priv->store) { g_object_unref ((gpointer) self->_priv->store); self->_priv->store = NULL; }
#line 236 "lum-playlist.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::finalize"
	LumPlaylist *self G_GNUC_UNUSED = LUM_PLAYLIST (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 229 "lum-playlist.gob"
	___4_lum_playlist_finalize(obj_self);
#line 249 "lum-playlist.c"
#line 113 "lum-playlist.gob"
	if(self->_priv->active_uri) { g_free ((gpointer) self->_priv->active_uri); self->_priv->active_uri = NULL; }
#line 252 "lum-playlist.c"
}
#undef __GOB_FUNCTION__

static void 
lum_playlist_class_init (LumPlaylistClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Playlist::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	g_type_class_add_private(c,sizeof(LumPlaylistPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_WINDOW);

#line 222 "lum-playlist.gob"
	g_object_class->dispose = ___dispose;
#line 229 "lum-playlist.gob"
	g_object_class->finalize = ___finalize;
#line 254 "lum-playlist.gob"
	gtk_widget_class->button_release_event = ___5_lum_playlist_button_release_event;
#line 266 "lum-playlist.gob"
	gtk_widget_class->popup_menu = ___6_lum_playlist_popup_menu;
#line 274 "lum-playlist.gob"
	gtk_widget_class->key_release_event = ___7_lum_playlist_key_release_event;
#line 287 "lum-playlist.gob"
	gtk_widget_class->drag_data_received = ___8_lum_playlist_drag_data_received;
#line 279 "lum-playlist.c"
}
#undef __GOB_FUNCTION__
#line 117 "lum-playlist.gob"
static void 
lum_playlist_init (LumPlaylist * self G_GNUC_UNUSED)
#line 285 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,LumPlaylistPrivate);
#line 71 "lum-playlist.gob"
	self->_priv->menu = NULL;
#line 291 "lum-playlist.c"
#line 100 "lum-playlist.gob"
	self->_priv->store = lum_playlist_store_new(COL_NR, G_TYPE_STRING, G_TYPE_STRING, 
				LUM_TYPE_PLAYER_INFO);
#line 295 "lum-playlist.c"
#line 104 "lum-playlist.gob"
	self->_priv->view = GTK_TREE_VIEW(
			gtk_tree_view_new_with_model(GTK_TREE_MODEL(selfp->store)));;
#line 299 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->renderer = gtk_cell_renderer_text_new();
#line 302 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->column = NULL;
#line 305 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->path = NULL;
#line 308 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->selected_uris = NULL;
#line 311 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->active_info = NULL;
#line 314 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->active_uri = NULL;
#line 317 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->manual = TRUE;
#line 320 "lum-playlist.c"
#line 107 "lum-playlist.gob"
	self->_priv->engine = NULL;
#line 323 "lum-playlist.c"
 {
#line 117 "lum-playlist.gob"

		gtk_widget_add_events(GTK_WIDGET(self), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
		
		GtkTreeSelection *select;

		g_object_set (G_OBJECT (selfp->renderer),
			"editable", FALSE, NULL);
		selfp->column = gtk_tree_view_column_new_with_attributes(_("Media:"),
						selfp->renderer,
						"text", COL_DISPLAY_URI, NULL);
		gtk_tree_view_append_column(selfp->view, selfp->column);
		gtk_tree_view_set_headers_visible(selfp->view, FALSE);
		select = gtk_tree_view_get_selection(selfp->view);
		gtk_tree_selection_set_mode(select, GTK_SELECTION_MULTIPLE);
		g_signal_connect_after(G_OBJECT(selfp->view), "row_activated",
				G_CALLBACK(self_activate_cb), self);

		/* TODO implement all drag_received and drag_sent */
		/* THIS IS BROKEN FOR NOW IN LIBEGG */
//		egg_tree_multi_drag_add_drag_support (GTK_TREE_VIEW (selfp->view));
		gtk_tree_view_enable_model_drag_source (selfp->view, GDK_BUTTON1_MASK,
					tree_view_row_targets,
					G_N_ELEMENTS (tree_view_row_targets),
					GDK_ACTION_MOVE);
		gtk_tree_view_enable_model_drag_dest (selfp->view,
				tree_view_row_targets,
				G_N_ELEMENTS (tree_view_row_targets),
				GDK_ACTION_MOVE);

		gtk_drag_dest_set(GTK_WIDGET(self), GTK_DEST_DEFAULT_ALL,
			target_table, G_N_ELEMENTS (target_table), GDK_ACTION_COPY | GDK_ACTION_MOVE);
	
#line 358 "lum-playlist.c"
 }
}
#undef __GOB_FUNCTION__



#line 150 "lum-playlist.gob"
LumPlaylist * 
lum_playlist_new (LumEngine * engine)
#line 368 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::new"
#line 150 "lum-playlist.gob"
	g_return_val_if_fail (engine != NULL, (LumPlaylist * )NULL);
#line 150 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_ENGINE (engine), (LumPlaylist * )NULL);
#line 375 "lum-playlist.c"
{
#line 151 "lum-playlist.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": init\n");
#endif
		gchararray title = g_strdup_printf("%s -- Lumiere ", _("Playlist"));
		Self *self = GET_NEW_VARG("GtkWindow::type",
				GTK_WINDOW_TOPLEVEL, "GtkWindow::title", title,
				NULL, NULL);
		g_free(title);
		selfp->engine = engine;

		GladeXML *xml;
		GtkWidget *widget;

		xml = glade_xml_new(
				DATADIR"/lumiere/lumiere.glade",
				"playlist_box", GETTEXT_PACKAGE);
		if(xml == NULL)
			lum_shell_glade_not_found();

		widget = glade_xml_get_widget(xml, "scroll");
		gtk_container_add(GTK_CONTAINER(widget), GTK_WIDGET(selfp->view));
		widget = glade_xml_get_widget(xml, "playlist_box");
		glade_xml_signal_connect_data(xml, "add_clicked_cb",
				G_CALLBACK(self_add_clicked_cb), self);
		glade_xml_signal_connect_data(xml, "delete_clicked",
				G_CALLBACK(self_delete_clicked_cb), self);
		glade_xml_signal_connect_data(xml, "close_clicked",
				G_CALLBACK(self_close_clicked_cb), self);
		g_object_unref(G_OBJECT(xml));
		gtk_container_add(GTK_CONTAINER(self), GTK_WIDGET(widget));

		xml = glade_xml_new(
				DATADIR"/lumiere/lumiere.glade",
				"playlist_menu", GETTEXT_PACKAGE);
		if(xml == NULL)
			lum_shell_glade_not_found();
		
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "add"),
			    "activate",
			    G_CALLBACK(lum_engine_show_fileselector),
			    selfp->engine);
		g_signal_connect(glade_xml_get_widget(xml, "remove"),
			    "activate", G_CALLBACK(self_delete_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "crop"),
			    "activate", G_CALLBACK(self_crop_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "clear"),
			    "activate", G_CALLBACK(self_clear_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "sort"),
			    "activate", G_CALLBACK(self_sort_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "properties"),
			    "activate", G_CALLBACK(self_properties_cb), self);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "dvd"),
			    "activate",
			    G_CALLBACK(lum_engine_open_dvd),
			    selfp->engine);
		g_signal_connect_swapped(
				glade_xml_get_widget(xml, "audio_cd"),
			    "activate",
			    G_CALLBACK(lum_engine_open_cdda),
			    selfp->engine);
		selfp->menu = GTK_MENU(glade_xml_get_widget(xml, "playlist_menu_menu"));
		g_object_unref(xml);
#ifndef NDEBUG
		printf(__FILE__ ": inited\n");
#endif	
		return self;
	}}
#line 448 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 222 "lum-playlist.gob"
static void 
___3_lum_playlist_dispose (GObject * object G_GNUC_UNUSED)
#line 454 "lum-playlist.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Playlist::dispose"
{
#line 222 "lum-playlist.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": dispose\n");
#endif	
		PARENT_HANDLER(object);
	}}
#line 468 "lum-playlist.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 229 "lum-playlist.gob"
static void 
___4_lum_playlist_finalize (GObject * object G_GNUC_UNUSED)
#line 475 "lum-playlist.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Playlist::finalize"
{
#line 229 "lum-playlist.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": finalize\n");
#endif	
		Self *self = SELF(object);
		if(selfp->selected_uris){
			GList *list = selfp->selected_uris;
		   	for(; list != NULL; list = list->next)
		   		g_free(list->data);
			g_list_free(selfp->selected_uris);
		}
		if(selfp->menu){
			gtk_widget_destroy(GTK_WIDGET(selfp->menu));
			selfp->menu = NULL;
		}
		if(selfp->path){
			gtk_tree_path_free(selfp->path);
			selfp->path = NULL;
		}
		PARENT_HANDLER(object);
#ifndef NDEBUG
		printf(__FILE__ ": finalized\n");
#endif	
	}}
#line 507 "lum-playlist.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 254 "lum-playlist.gob"
static gboolean 
___5_lum_playlist_button_release_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventButton * event)
#line 514 "lum-playlist.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->button_release_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->button_release_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Playlist::button_release_event"
{
#line 255 "lum-playlist.gob"
	
		Self *self = SELF(widget);

		if(event->button == 3) {
			gtk_menu_popup(selfp->menu, NULL, NULL, NULL, self,
					event->button, event->time);
			return TRUE;
		}
		return PARENT_HANDLER(widget, event);
	}}
#line 533 "lum-playlist.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 266 "lum-playlist.gob"
static gboolean 
___6_lum_playlist_popup_menu (GtkWidget * widget G_GNUC_UNUSED)
#line 540 "lum-playlist.c"
#define PARENT_HANDLER(___widget) \
	((GTK_WIDGET_CLASS(parent_class)->popup_menu)? \
		(* GTK_WIDGET_CLASS(parent_class)->popup_menu)(___widget): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Playlist::popup_menu"
{
#line 266 "lum-playlist.gob"
	
		Self *self = SELF(widget);

		gtk_menu_popup(selfp->menu, NULL, NULL, NULL, self,
					0, gtk_get_current_event_time());
		return TRUE;
	}}
#line 556 "lum-playlist.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 274 "lum-playlist.gob"
static gboolean 
___7_lum_playlist_key_release_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventKey * event)
#line 563 "lum-playlist.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->key_release_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->key_release_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Playlist::key_release_event"
{
#line 275 "lum-playlist.gob"
	
		Self *self = SELF(widget);
		switch (event->keyval) {
			case GDK_Delete:
				self_delete(self, FALSE);
				break;
			default:
				return PARENT_HANDLER(widget, event);
		}
		return TRUE;
	}}
#line 583 "lum-playlist.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 287 "lum-playlist.gob"
static void 
___8_lum_playlist_drag_data_received (GtkWidget * widget G_GNUC_UNUSED, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time)
#line 590 "lum-playlist.c"
#define PARENT_HANDLER(___widget,___context,___x,___y,___data,___info,___time) \
	{ if(GTK_WIDGET_CLASS(parent_class)->drag_data_received) \
		(* GTK_WIDGET_CLASS(parent_class)->drag_data_received)(___widget,___context,___x,___y,___data,___info,___time); }
{
#define __GOB_FUNCTION__ "Lum:Playlist::drag_data_received"
{
#line 289 "lum-playlist.gob"
	
		Self *self = SELF(widget);
		lum_engine_drag_received(selfp->engine, context, data, time);
	}}
#line 602 "lum-playlist.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 295 "lum-playlist.gob"
void 
lum_playlist_add_list (LumPlaylist * self, GList * uris, GList * infos)
#line 609 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::add_list"
#line 295 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 295 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 616 "lum-playlist.c"
{
#line 295 "lum-playlist.gob"
	
		for(; uris != NULL && infos != NULL;
				uris = uris->next, infos = infos->next)
			self_add(self, (gchar *) uris->data,
					LUM_PLAYER_INFO(infos->data));
	}}
#line 625 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 302 "lum-playlist.gob"
void 
lum_playlist_add (LumPlaylist * self, const gchar * uri, LumPlayerInfo * info)
#line 631 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::add"
#line 302 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 302 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 302 "lum-playlist.gob"
	g_return_if_fail (uri != NULL);
#line 302 "lum-playlist.gob"
	g_return_if_fail (info != NULL);
#line 302 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYER_INFO (info));
#line 644 "lum-playlist.c"
{
#line 303 "lum-playlist.gob"
	
		GtkTreeIter iter;
		gchar *display_uri = NULL;
		gchar *unescaped = NULL;
		gchar *s1, *s2;

		if(info->artist && info->title && (s1 = lum_util_convert(info->artist))
				&& (s2 = lum_util_convert(info->title))){
			display_uri = g_strdup_printf("%s - %s", s1, s2);
		} else{
			unescaped = gnome_vfs_unescape_string_for_display(
						g_path_get_basename (uri));
			display_uri = 	g_filename_to_utf8 (unescaped,
					-1, NULL, NULL, NULL);
			if (display_uri == NULL)
				display_uri = g_locale_to_utf8 (unescaped,
						-1, NULL, NULL, NULL);
			if (display_uri == NULL)
				display_uri = lum_util_convert(unescaped);
			g_free (unescaped);
		}
		gtk_list_store_append(GTK_LIST_STORE(selfp->store), &iter);
		gtk_list_store_set(GTK_LIST_STORE(selfp->store), &iter,
					COL_ACTUAL_URI, g_strdup(uri),
					COL_DISPLAY_URI, display_uri,
					COL_INFO, info,
					-1);
		g_object_unref(info);
	}}
#line 676 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 333 "lum-playlist.gob"
LumPlayerInfo * 
lum_playlist_get_active_info (LumPlaylist * self)
#line 682 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_active_info"
#line 333 "lum-playlist.gob"
	g_return_val_if_fail (self != NULL, (LumPlayerInfo * )0);
#line 333 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (LumPlayerInfo * )0);
#line 689 "lum-playlist.c"
{
#line 333 "lum-playlist.gob"
	
		GtkTreeIter iter;
		if(!selfp->active_info && gtk_tree_model_get_iter_first(
							GTK_TREE_MODEL(selfp->store), &iter)){
			gpointer *tmp;
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_INFO, &tmp, -1);
			
			selfp->active_info = LUM_PLAYER_INFO(tmp);
		}
		return selfp->active_info;

	}}
#line 705 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 346 "lum-playlist.gob"
gchar * 
lum_playlist_get_active_uri (LumPlaylist * self)
#line 711 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_active_uri"
#line 346 "lum-playlist.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 346 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gchar * )0);
#line 718 "lum-playlist.c"
{
#line 346 "lum-playlist.gob"
	
		GtkTreeIter iter;
		if(!selfp->active_uri && gtk_tree_model_get_iter_first(
							GTK_TREE_MODEL(selfp->store), &iter)){
			gchar *tmp;
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_ACTUAL_URI, &tmp, -1);
			
			selfp->active_uri = g_strdup(tmp);
		}
		return selfp->active_uri;
	}}
#line 733 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 359 "lum-playlist.gob"
gint 
lum_playlist_get_length (LumPlaylist * self)
#line 739 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_length"
#line 359 "lum-playlist.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 359 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gint )0);
#line 746 "lum-playlist.c"
{
#line 359 "lum-playlist.gob"
	
		return gtk_tree_model_iter_n_children(
				GTK_TREE_MODEL(selfp->store), NULL);
	}}
#line 753 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 364 "lum-playlist.gob"
GList * 
lum_playlist_get_list (LumPlaylist * self)
#line 759 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_list"
#line 364 "lum-playlist.gob"
	g_return_val_if_fail (self != NULL, (GList * )0);
#line 364 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (GList * )0);
#line 766 "lum-playlist.c"
{
#line 364 "lum-playlist.gob"
	
		GList *list = NULL;
		GtkTreeIter  iter;
	 	gboolean     valid;
		gchar *tmp;

		/* Get first row in list store */
	 	valid = gtk_tree_model_get_iter_first(
				GTK_TREE_MODEL(selfp->store), &iter);
	 	while (valid) {
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_ACTUAL_URI, &tmp, -1);
	   		list = g_list_append(list, g_strdup(tmp));
	       /* Make iter point to the next row in the list store */
	   		valid = gtk_tree_model_iter_next(
					GTK_TREE_MODEL(selfp->store), &iter);
	 	}
		return list;
	}}
#line 788 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 384 "lum-playlist.gob"
void 
lum_playlist_clear (LumPlaylist * self)
#line 794 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::clear"
#line 384 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 384 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 801 "lum-playlist.c"
{
#line 384 "lum-playlist.gob"
	
		gtk_list_store_clear(GTK_LIST_STORE(selfp->store));
		selfp->active_uri = NULL;
	}}
#line 808 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 389 "lum-playlist.gob"
gboolean 
lum_playlist_has_next (LumPlaylist * self)
#line 814 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::has_next"
#line 389 "lum-playlist.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 389 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gboolean )0);
#line 821 "lum-playlist.c"
{
#line 389 "lum-playlist.gob"
	
		GtkTreeIter iter;

		if (self_update_current(self) == FALSE)
			return FALSE;

		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);

		return gtk_tree_model_iter_next(GTK_TREE_MODEL(selfp->store),
				&iter);
	}}
#line 836 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 403 "lum-playlist.gob"
void 
lum_playlist_next (LumPlaylist * self)
#line 842 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::next"
#line 403 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 403 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 849 "lum-playlist.c"
{
#line 403 "lum-playlist.gob"
	
		GtkTreeIter iter;

		if (self_has_next(self) == FALSE) {
			self_set_at_start(self);
			return;
		}

		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);

		gtk_tree_model_iter_next(GTK_TREE_MODEL(selfp->store), &iter);
		if(selfp->path)
			gtk_tree_path_free (selfp->path);
		selfp->path = gtk_tree_model_get_path(
				GTK_TREE_MODEL(selfp->store), &iter);
		selfp->manual = FALSE;
		gtk_tree_view_row_activated(selfp->view,
				selfp->path,
				selfp->column);
		selfp->manual = TRUE;
	}}
#line 874 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 426 "lum-playlist.gob"
gboolean 
lum_playlist_has_prev (LumPlaylist * self)
#line 880 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::has_prev"
#line 426 "lum-playlist.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 426 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gboolean )0);
#line 887 "lum-playlist.c"
{
#line 426 "lum-playlist.gob"
	
		GtkTreeIter iter;

		if(self_update_current(self) == FALSE)
			return FALSE;
		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);

		return gtk_tree_model_iter_previous(
				GTK_TREE_MODEL(selfp->store), &iter);
	}}
#line 901 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 438 "lum-playlist.gob"
void 
lum_playlist_prev (LumPlaylist * self)
#line 907 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::prev"
#line 438 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 438 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 914 "lum-playlist.c"
{
#line 438 "lum-playlist.gob"
	
		GtkTreeIter iter;
		char *path;

		if (self_has_prev(self) == FALSE)
			return;

		path = gtk_tree_path_to_string(selfp->path);
		if (strcmp (path, "0") == 0){
			self_set_at_end(self);
			g_free (path);
			return;
		}

		g_free (path);

		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);
		gtk_tree_model_iter_previous(GTK_TREE_MODEL(selfp->store), &iter);
		gtk_tree_path_free (selfp->path);
		selfp->path = gtk_tree_model_get_path(
				GTK_TREE_MODEL(selfp->store), &iter);
		selfp->manual = FALSE;
		gtk_tree_view_row_activated(selfp->view,
				selfp->path,
				selfp->column);
		selfp->manual = TRUE;
	}}
#line 945 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 467 "lum-playlist.gob"
static gboolean 
lum_playlist_update_current (LumPlaylist * self)
#line 951 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::update_current"
#line 467 "lum-playlist.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 467 "lum-playlist.gob"
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gboolean )0);
#line 958 "lum-playlist.c"
{
#line 467 "lum-playlist.gob"
	
		if (selfp->path != NULL)
			return TRUE;

		if (self_get_length(self) != 0)
			selfp->path = gtk_tree_path_new_from_indices(0, -1);
		else
			return FALSE;

		return TRUE;
	}}
#line 972 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 479 "lum-playlist.gob"
void 
lum_playlist_set_at_start (LumPlaylist * self)
#line 978 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::set_at_start"
#line 479 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 479 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 985 "lum-playlist.c"
{
#line 479 "lum-playlist.gob"
	
		GtkTreeIter iter;
		LumPlayerInfo *info;
		gchar *tmp;

		if (selfp->path != NULL){
			gtk_tree_path_free (selfp->path);
			selfp->path = NULL;
		}
		gtk_tree_model_get_iter_first(
				GTK_TREE_MODEL(selfp->store), &iter);
		gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
				&iter, COL_ACTUAL_URI, &tmp, COL_INFO, &info, -1);
		selfp->path = gtk_tree_model_get_path(GTK_TREE_MODEL(selfp->store),
				&iter);
		if(selfp->active_uri)
			g_free(selfp->active_uri);
		selfp->active_uri = g_strdup(tmp);
		selfp->active_info = LUM_PLAYER_INFO(info);
		gtk_tree_view_set_cursor(selfp->view, selfp->path, NULL, FALSE);
		gtk_tree_view_scroll_to_cell(selfp->view, selfp->path, NULL,
				FALSE, 0, 0);
	}}
#line 1011 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 503 "lum-playlist.gob"
static void 
lum_playlist_set_at_end (LumPlaylist * self)
#line 1017 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::set_at_end"
#line 503 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 503 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 1024 "lum-playlist.c"
{
#line 503 "lum-playlist.gob"
	
		int index;
		GtkTreeIter iter;
		LumPlayerInfo *info;
		gchar *tmp;

		if (selfp->path != NULL){
			gtk_tree_path_free (selfp->path);
			selfp->path = NULL;
		}

		if (self_get_length(self)){
			index = self_get_length(self) - 1;
			selfp->path = gtk_tree_path_new_from_indices(index, -1);
			gtk_tree_model_get_iter(
				GTK_TREE_MODEL(selfp->store), &iter, selfp->path);
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
				&iter, COL_ACTUAL_URI, &tmp, COL_INFO, &info, -1);
			if(selfp->active_uri)
				g_free(selfp->active_uri);
			selfp->active_uri = g_strdup(tmp);
			selfp->active_info = LUM_PLAYER_INFO(info);
			gtk_tree_view_set_cursor(selfp->view, selfp->path, NULL, FALSE);
			gtk_tree_view_scroll_to_cell(selfp->view, selfp->path, NULL,
				FALSE, 0, 0);

		}
	}}
#line 1055 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 532 "lum-playlist.gob"
static void 
lum_playlist_delete (LumPlaylist * self, gboolean crop)
#line 1061 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::delete"
#line 532 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 532 "lum-playlist.gob"
	g_return_if_fail (LUM_IS_PLAYLIST (self));
#line 1068 "lum-playlist.c"
{
#line 532 "lum-playlist.gob"
	
		GtkTreeSelection *selection;
		GtkTreeRowReference *ref;
		gboolean is_selected = FALSE;
		int next_pos;

		selection = gtk_tree_view_get_selection(selfp->view);
		if (selection == NULL)
			return;
		if(!crop)
			self_selection_changed_cb(selection, self);

		if(selfp->path != NULL){
			int *indices;

			ref = gtk_tree_row_reference_new (
					GTK_TREE_MODEL(selfp->store), selfp->path);
			is_selected = gtk_tree_selection_path_is_selected(selection,
					selfp->path);
			if(crop)
				is_selected = !is_selected;

			indices = gtk_tree_path_get_indices(selfp->path);
			next_pos = indices[0];

			gtk_tree_path_free (selfp->path);
		} else {
			ref = NULL;
			next_pos = -1;
		}
		if(crop){
			g_list_foreach(selfp->selected_uris,
					(GFunc)gtk_tree_row_reference_free, NULL);
			g_list_free(selfp->selected_uris);
			gtk_tree_model_foreach(GTK_TREE_MODEL(selfp->store),
					self_crop, self);
		}
		
		while (selfp->selected_uris != NULL){
			GtkTreePath *path;
			GtkTreeIter iter;
#ifndef NDEBUG
			printf(__FILE__ ": deleting...\n");
#endif

			path = gtk_tree_row_reference_get_path
				((GtkTreeRowReference *)(selfp->selected_uris->data));
			gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
					&iter, path);
			gtk_tree_path_free (path);
			gtk_list_store_remove(GTK_LIST_STORE(selfp->store), &iter);

			gtk_tree_row_reference_free(
					(GtkTreeRowReference *)(selfp->selected_uris->data));
			selfp->selected_uris = selfp->selected_uris->next;
		}
		g_list_free(selfp->selected_uris);
		selfp->selected_uris = NULL;

		if (is_selected == TRUE){
			if(self_has_next(self))
				self_next(self);
			else
				lum_engine_stop(selfp->engine);
			/* The current item was removed from the playlist */
			if (next_pos != -1){
				char *str;
				GtkTreeIter iter;
				GtkTreePath *cur;

				str = g_strdup_printf ("%d", next_pos);
				cur = gtk_tree_path_new_from_string (str);

				if (gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
							&iter, cur) == FALSE){
					selfp->path = NULL;
					gtk_tree_path_free (cur);
				} else {
					selfp->path = cur;
				}
			} else {
				selfp->path = NULL;
			}

		} else {
			if (ref != NULL) {
			/* The path to the current item changed */
				selfp->path =
					gtk_tree_row_reference_get_path(ref);
				gtk_tree_row_reference_free (ref);
			}
		}
	}}
#line 1164 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 626 "lum-playlist.gob"
static gint 
lum_playlist_compare_func (GtkTreeModel * model, GtkTreeIter * iter_a, GtkTreeIter * iter_b, gpointer data)
#line 1170 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::compare_func"
{
#line 627 "lum-playlist.gob"
	
		gchar *a, *b;
		gtk_tree_model_get(model, iter_a, COL_ACTUAL_URI, &a, -1);
		gtk_tree_model_get(model, iter_b, COL_ACTUAL_URI, &b, -1);
		return g_ascii_strcasecmp(a, b);
	}}
#line 1181 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 634 "lum-playlist.gob"
static gboolean 
lum_playlist_crop (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 1187 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::crop"
{
#line 635 "lum-playlist.gob"
	
		Self *self = SELF(data);
		GtkTreeSelection *selection;
		GtkTreeRowReference *ref;
		selection = gtk_tree_view_get_selection(selfp->view);
		if(!gtk_tree_selection_path_is_selected(selection, path)){
#ifndef NDEBUG
			printf(__FILE__ ": appending selected...\n");
#endif
			ref = gtk_tree_row_reference_new(model, path);
			selfp->selected_uris = g_list_append(
					selfp->selected_uris, (gpointer) ref);
		}
		return FALSE;
	}}
#line 1207 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 654 "lum-playlist.gob"
static void 
lum_playlist_selection_changed_cb (GtkTreeSelection * selection, Self * self)
#line 1213 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::selection_changed_cb"
#line 654 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 654 "lum-playlist.gob"
	g_return_if_fail (IS_SELF (self));
#line 1220 "lum-playlist.c"
{
#line 654 "lum-playlist.gob"
	
		GtkTreeModel *model;
		GList *list;
		GtkTreeRowReference *ref;

		if ((list = gtk_tree_selection_get_selected_rows (
						selection, &model))) {
			g_list_foreach(selfp->selected_uris,
					(GFunc) gtk_tree_row_reference_free, NULL);
			g_list_free(selfp->selected_uris);
			for(; list != NULL; list = list->next){
#ifndef NDEBUG
				printf(__FILE__ ": appending selected...\n");
#endif

				ref = gtk_tree_row_reference_new(model,
						(GtkTreePath *) list->data);
				selfp->selected_uris = g_list_append(
						selfp->selected_uris, (gpointer) ref);
			}
		}
	}}
#line 1245 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 677 "lum-playlist.gob"
static void 
lum_playlist_activate_cb (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, Self * self)
#line 1251 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::activate_cb"
#line 677 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 677 "lum-playlist.gob"
	g_return_if_fail (IS_SELF (self));
#line 1258 "lum-playlist.c"
{
#line 678 "lum-playlist.gob"
	
		gchar *tmp = NULL;
		gpointer *info = NULL;
		GtkTreeIter iter;
		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store), &iter, path);
		gtk_tree_model_get(GTK_TREE_MODEL(selfp->store), &iter, COL_ACTUAL_URI, &tmp, COL_INFO, &info, -1);
		if(selfp->active_uri)
			g_free(selfp->active_uri);
		selfp->active_uri = g_strdup(tmp);
		selfp->active_info = LUM_PLAYER_INFO(info);
		if(selfp->manual){
			if(selfp->path)
				gtk_tree_path_free(selfp->path);
			selfp->path = gtk_tree_model_get_path(
					GTK_TREE_MODEL(selfp->store), &iter);
		}
		gtk_tree_view_set_cursor(selfp->view, selfp->path, NULL, FALSE);
		gtk_tree_view_scroll_to_cell(selfp->view, selfp->path, NULL,
				FALSE, 0, 0);
		lum_engine_play_now(selfp->engine, selfp->active_info, selfp->active_uri);
	}}
#line 1282 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 700 "lum-playlist.gob"
static void 
lum_playlist_delete_cb (GtkMenuItem * menuitem, Self * self)
#line 1288 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::delete_cb"
#line 700 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 700 "lum-playlist.gob"
	g_return_if_fail (IS_SELF (self));
#line 1295 "lum-playlist.c"
{
#line 700 "lum-playlist.gob"
	
		self_delete(self, FALSE);
	}}
#line 1301 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 704 "lum-playlist.gob"
static void 
lum_playlist_crop_cb (GtkMenuItem * menuitem, Self * self)
#line 1307 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::crop_cb"
#line 704 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 704 "lum-playlist.gob"
	g_return_if_fail (IS_SELF (self));
#line 1314 "lum-playlist.c"
{
#line 704 "lum-playlist.gob"
	
		self_delete(self, TRUE);
	}}
#line 1320 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 708 "lum-playlist.gob"
static void 
lum_playlist_clear_cb (GtkMenuItem * menuitem, Self * self)
#line 1326 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::clear_cb"
#line 708 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 708 "lum-playlist.gob"
	g_return_if_fail (IS_SELF (self));
#line 1333 "lum-playlist.c"
{
#line 708 "lum-playlist.gob"
	
		self_clear(self);
	}}
#line 1339 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 712 "lum-playlist.gob"
static void 
lum_playlist_sort_cb (GtkMenuItem * menuitem, Self * self)
#line 1345 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::sort_cb"
#line 712 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 712 "lum-playlist.gob"
	g_return_if_fail (IS_SELF (self));
#line 1352 "lum-playlist.c"
{
#line 712 "lum-playlist.gob"
	
/*TODO
 		gtk_tree_sortable_set_sort_func (GTK_TREE_SORTABLE(selfp->store),
				COL_ACTUAL_URI, self_compare_func, self, NULL);
		gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(selfp->store),
				COL_ACTUAL_URI ,GTK_SORT_ASCENDING);
		gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(selfp->store),
						NULL, NULL, NULL);
		gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(selfp->store),
				GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,
				GTK_SORT_ASCENDING);
		gtk_tree_sortable_sort_column_changed(GTK_TREE_SORTABLE(selfp->store));
		gtk_tree_view_set_reorderable(selfp->view, TRUE);
*/
	}}
#line 1370 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 728 "lum-playlist.gob"
static void 
lum_playlist_properties_cb (GtkMenuItem * menuitem, Self * self)
#line 1376 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::properties_cb"
#line 728 "lum-playlist.gob"
	g_return_if_fail (self != NULL);
#line 728 "lum-playlist.gob"
	g_return_if_fail (IS_SELF (self));
#line 1383 "lum-playlist.c"
{
#line 728 "lum-playlist.gob"
	
		GtkTreeSelection *sel;
		LumPlayerInfo *info;
		GList *l;
		GtkTreeIter iter;
		sel = gtk_tree_view_get_selection(selfp->view);
		if(!sel) return;

		l = gtk_tree_selection_get_selected_rows(sel, NULL);
		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
					&iter, (GtkTreePath *) l->data);
		gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_INFO, &info, -1);
		lum_player_show_props_window(info);
		g_list_foreach (l, (GFunc)gtk_tree_path_free, NULL);
		g_list_free (l);
	}}
#line 1403 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 746 "lum-playlist.gob"
static void 
lum_playlist_delete_clicked_cb (GtkButton * button, gpointer data)
#line 1409 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::delete_clicked_cb"
{
#line 746 "lum-playlist.gob"
	
		Self *self = SELF(data);
		self_delete(self, FALSE);
	}}
#line 1418 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 751 "lum-playlist.gob"
static void 
lum_playlist_add_clicked_cb (GtkButton * button, gpointer data)
#line 1424 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::add_clicked_cb"
{
#line 751 "lum-playlist.gob"
	
		Self *self = SELF(data);
		lum_engine_show_fileselector(selfp->engine);
	}}
#line 1433 "lum-playlist.c"
#undef __GOB_FUNCTION__

#line 756 "lum-playlist.gob"
static void 
lum_playlist_close_clicked_cb (GtkButton * button, gpointer data)
#line 1439 "lum-playlist.c"
{
#define __GOB_FUNCTION__ "Lum:Playlist::close_clicked_cb"
{
#line 756 "lum-playlist.gob"
	
		Self *self = SELF(data);
		lum_engine_playlist_delete_cb(NULL, NULL, selfp->engine);
	}}
#line 1448 "lum-playlist.c"
#undef __GOB_FUNCTION__
