/***************************************************************************
                          lum-prefs.c  -  Lumiere Preferences Window
                             -------------------
    begin                : jeu jan 16 02:08:47 BST 2002
    copyright            : (C) 2003 by Stphane Konstantaropoulos
    email                : ssk01@aber.ac.uk | stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.7 $
 * $Date: 2005/04/13 01:26:42 $
 *
 */

#include <config.h>
#include "lum-prefs.h"
#include "lum-cd-selection.h"

/* no way porting to gtk-2.4 as I have a deprecated widget
 * that comes from glade, need to upgrade glade first to
 * fix the .glade file
 */
#ifdef GTK_DISABLE_DEPRECATED
#undef GTK_DISABLE_DEPRECATED
#include <gtk/gtkoptionmenu.h>
#endif

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <libgnomeui/libgnomeui.h>
#include <gconf/gconf-client.h>
#include <bonobo/bonobo-i18n.h>

#define GCONF_LUM_PLAYER_DIR "/apps/lumiere"
#define GCONF_LUM_PLAYER_XV "/apps/lumiere/player/xv"
#define GCONF_LUM_PLAYER_SLANG "/apps/lumiere/player/slang"
#define GCONF_LUM_PLAYER_ALANG "/apps/lumiere/player/alang"
#define GCONF_LUM_PLAYER_DVDDEV "/apps/lumiere/player/dvd_dev"
#define GCONF_LUM_PLAYER_STOPSSAVER "/apps/lumiere/player/stop_ssaver"
#define GCONF_LUM_PLAYER_BE "/apps/lumiere/player/backend"
#define GCONF_LUM_PLAYER_TRAY "/apps/lumiere/shell/show-tray-icon"
#define GCONF_LUM_PLAYER_SERVER "/apps/lumiere/shell/server-mode"

#define BE_KEY "ao_key"

/*
 * check toggle
 * Valid with all buttons, cool
 */
static void check_toggle_cb (GtkWidget *widget, gpointer data)
{
	char *key = NULL;

	key = g_object_get_data (G_OBJECT (widget), "GCONF_KEY");
	if (key == NULL) return;

	gconf_client_set_bool (GCONF_CLIENT (data),
			       key,
			       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)),
			       NULL);
}

/*
 * Text changed
 * Valid with all entries!
 */
static void text_changed_cb(GtkWidget *widget, gpointer data)
{
	char *key = NULL;

	key = g_object_get_data (G_OBJECT (widget), "GCONF_KEY");
	if (key == NULL) return;

	gconf_client_set_string (GCONF_CLIENT (data),
			       key,
			       g_strdup(gtk_entry_get_text(GTK_ENTRY (widget))),
			       NULL);
}

static void device_changed_cb(LumCdSelection *widget, const char *device, gpointer data)
{
	gconf_client_set_string (GCONF_CLIENT (data), 
			GCONF_LUM_PLAYER_DVDDEV, device, NULL);
}

/*
 * menu item activated
 * Valid with all entries!
 */
static void submenu_activate_cb(GtkWidget *widget, gpointer data)
{
	char *key;
	char *string;
	GladeXML *xml;

	key = g_object_get_data (G_OBJECT (widget), "GCONF_KEY");
	xml = g_object_get_data (G_OBJECT (widget), "xml");
	
	if (key == NULL) return;
	string = g_object_get_data (G_OBJECT (widget), BE_KEY);

	gconf_client_set_string (GCONF_CLIENT (data),
			       key,
			       g_strdup(string),
			       NULL);
}

static gboolean key_press_cb (
		GtkWidget *dialog, GdkEventKey *event, gpointer user_data)
{
	if (event->keyval == GDK_Escape) {
		gtk_widget_destroy (dialog);
		return TRUE;
	}
	else {
		return FALSE;
	}
}

static gboolean destroy_cb(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	g_object_unref(data);
	return FALSE;
}

static void sound_ref_clicked(GtkButton *button, gpointer unused)
{
	GtkWidget *parent;
	GtkWidget *dialog;
	GError 	  *err = NULL;

	if (g_spawn_command_line_async(PREFIX"/bin/gnome-sound-properties", &err))
		return;

	parent = gtk_widget_get_toplevel(GTK_WIDGET(button));
	dialog = gtk_message_dialog_new (GTK_WINDOW(parent),
				GTK_DIALOG_MODAL,
				GTK_MESSAGE_ERROR,
				GTK_BUTTONS_OK,
				_("Cannot start sound "
				  "configuration program: %s"),
				err->message);
	g_clear_error (&err);

	gtk_dialog_run (GTK_DIALOG(dialog));
	gtk_widget_destroy (dialog);
}

void lum_prefs_show (void)
{
	GtkWidget *dlg;
	GladeXML *xml;
	GtkWidget *widget;
	GtkWidget *menu;
	char *dvd_dev;
	GConfClient *client = gconf_client_get_default();
	xml = glade_xml_new (DATADIR"/lumiere/lumiere.glade",
				"prefs_window",GETTEXT_PACKAGE);
	g_assert(xml != NULL);

	dlg = glade_xml_get_widget(xml, "prefs_window");
	g_signal_connect(G_OBJECT(dlg), "key-press-event",
			G_CALLBACK(key_press_cb), NULL);
	g_signal_connect(G_OBJECT(dlg), "destroy-event",
			G_CALLBACK(destroy_cb), client);
	widget = glade_xml_get_widget (xml, "close_button");
	g_signal_connect_swapped (G_OBJECT (widget), "clicked", 
				  G_CALLBACK (gtk_widget_destroy), dlg);
	glade_xml_signal_connect(xml, "sound_ref_clicked",
				G_CALLBACK(sound_ref_clicked));
	widget = glade_xml_get_widget(xml, "tray_button");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (widget), 
		gconf_client_get_bool (client, GCONF_LUM_PLAYER_TRAY, NULL));
	g_object_set_data (G_OBJECT (widget), "GCONF_KEY", GCONF_LUM_PLAYER_TRAY);
	g_signal_connect (G_OBJECT (widget), "toggled",
			G_CALLBACK (check_toggle_cb), client);

	widget = glade_xml_get_widget(xml, "server_button");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), 
		gconf_client_get_bool (client, GCONF_LUM_PLAYER_SERVER, NULL));
	g_object_set_data (G_OBJECT (widget), "GCONF_KEY", GCONF_LUM_PLAYER_SERVER);
	g_signal_connect (G_OBJECT (widget), "toggled", 
			  G_CALLBACK (check_toggle_cb), client);

	widget = glade_xml_get_widget(xml, "ssaver_button");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), 
		gconf_client_get_bool (client, GCONF_LUM_PLAYER_STOPSSAVER, NULL));
	g_object_set_data (G_OBJECT (widget),
			"GCONF_KEY", GCONF_LUM_PLAYER_STOPSSAVER);
	g_signal_connect (G_OBJECT (widget), "toggled", 
			  G_CALLBACK (check_toggle_cb), client);
	widget = glade_xml_get_widget(xml, "xv_button");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), 
		gconf_client_get_bool (client, GCONF_LUM_PLAYER_XV, NULL));
	g_object_set_data (G_OBJECT (widget), "GCONF_KEY", GCONF_LUM_PLAYER_XV);
	g_signal_connect (G_OBJECT (widget), "toggled", 
			  G_CALLBACK (check_toggle_cb), client);

	GtkWidget *cd_select;
	widget = glade_xml_get_widget(xml, "dvd_box");
	cd_select = g_object_new(LUM_TYPE_CD_SELECTION, NULL);
	g_signal_connect (G_OBJECT (cd_select), 
			  "device_changed", 
			  G_CALLBACK (device_changed_cb), 
			  client);

	gtk_widget_show(cd_select);
	gtk_box_pack_start(GTK_BOX(widget), cd_select, TRUE, TRUE, 2);
	
	dvd_dev = gconf_client_get_string(client, GCONF_LUM_PLAYER_DVDDEV, NULL);
	lum_cd_selection_set_device(LUM_CD_SELECTION(cd_select), dvd_dev);
	g_free(dvd_dev);

	widget = glade_xml_get_widget(xml, "alang_entry");
	gtk_entry_set_text(GTK_ENTRY(widget), gconf_client_get_string(
					client, GCONF_LUM_PLAYER_ALANG, NULL));
	g_object_set_data (G_OBJECT (widget),
			"GCONF_KEY", GCONF_LUM_PLAYER_ALANG);
	g_signal_connect (G_OBJECT (widget), "changed", 
			  G_CALLBACK (text_changed_cb), client);
	widget = glade_xml_get_widget(xml, "slang_entry");
	gtk_entry_set_text(GTK_ENTRY(widget), gconf_client_get_string(
					client, GCONF_LUM_PLAYER_SLANG, NULL));
	g_object_set_data (G_OBJECT (widget),
			"GCONF_KEY", GCONF_LUM_PLAYER_SLANG);
	g_signal_connect (G_OBJECT (widget), "changed", 
			  G_CALLBACK (text_changed_cb), client);

	menu = glade_xml_get_widget(xml, "be_optionmenu");
	widget = glade_xml_get_widget(xml, "mplayer");
	if(g_ascii_strcasecmp("mplayer", gconf_client_get_string(
					client, GCONF_LUM_PLAYER_BE, NULL)) == 0)
		gtk_option_menu_set_history(GTK_OPTION_MENU(menu), 0);

	g_object_set_data (G_OBJECT (widget), BE_KEY, "mplayer");
	g_object_set_data (G_OBJECT (widget), "GCONF_KEY", GCONF_LUM_PLAYER_BE);
	g_object_set_data (G_OBJECT (widget),"xml", xml);
	g_signal_connect (G_OBJECT (widget), "activate", 
			  G_CALLBACK (submenu_activate_cb), client);
	widget = glade_xml_get_widget(xml, "xine");
	if(g_ascii_strcasecmp("xine", gconf_client_get_string(
					client, GCONF_LUM_PLAYER_BE, NULL)) == 0)
		gtk_option_menu_set_history(GTK_OPTION_MENU(menu), 1);
	g_object_set_data (G_OBJECT (widget), BE_KEY, "xine");
	g_object_set_data (G_OBJECT (widget), "GCONF_KEY", GCONF_LUM_PLAYER_BE);
	g_object_set_data (G_OBJECT (widget),"xml", xml);
	g_signal_connect (G_OBJECT (widget), "activate", 
			  G_CALLBACK (submenu_activate_cb), client);
	widget = glade_xml_get_widget(xml, "glplay");
	if(g_ascii_strcasecmp("glplay", gconf_client_get_string(
					client, GCONF_LUM_PLAYER_BE, NULL)) == 0)
		gtk_option_menu_set_history(GTK_OPTION_MENU(menu), 2);
	g_object_set_data (G_OBJECT (widget), BE_KEY, "glplay");
	g_object_set_data (G_OBJECT (widget), "GCONF_KEY", GCONF_LUM_PLAYER_BE);
	g_object_set_data (G_OBJECT (widget),"xml", xml);
	g_signal_connect (G_OBJECT (widget), "activate", 
			  G_CALLBACK (submenu_activate_cb), client);

}
