/* Generated by GOB (v2.0.11) on Sat Apr 16 19:56:21 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-session.gob"

/***************************************************************************
                   lum-session.gob  -  Lumiere Session Handling 
                             -------------------
    begin                : Tue nov 4 22:08:47 CET 2003
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.9 $
 * $Date: 2005/01/16 01:41:24 $
 *
 */

#line 35 "lum-session.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "lum-session.h"

#include "lum-session-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 32 "lum-session.gob"

#include <config.h>

#include "lum-shell.h"
#include "lum-util.h"
#include "lum-skin.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <string.h>
#include <stdbool.h>
#include <glib/gthread.h>
#include <libgnomeui/libgnomeui.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xmlmemory.h>

#define SESSION_CRASHED "type:session_crashed"
#define SESSION_SAVED "type:session_saved"
#define SESSION_GNOME "type:session_gnome"
#define LUM_DIR ".lumiere/"

extern LumShell *lum_shell; /* unique LumShell, in lum-shell.gob */

struct local_data {
	LumEngine *engine;
	int idx;
	char *filename;
};

#line 86 "lum-session.c"
static const GEnumValue _lum_sessionresumetype_values[] = {
	{ SESSION_OK, (char *)"SESSION_OK", (char *)"ok" },
	{ SESSION_RESUMED, (char *)"SESSION_RESUMED", (char *)"resumed" },
	{ SESSION_ABORT, (char *)"SESSION_ABORT", (char *)"abort" },
	{ 0, NULL, NULL }
};

GType
lum_sessionresumetype_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumSessionResumeType", _lum_sessionresumetype_values);
	return type;
}

static const GEnumValue _lum_sessionrestoretype_values[] = {
	{ SESSION_RESTORE, (char *)"SESSION_RESTORE", (char *)"restore" },
	{ SESSION_DISCARD, (char *)"SESSION_DISCARD", (char *)"discard" },
	{ 0, NULL, NULL }
};

GType
lum_sessionrestoretype_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumSessionRestoreType", _lum_sessionrestoretype_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_SESSION(x)
#define SELF_CONST(x) LUM_SESSION_CONST(x)
#define IS_SELF(x) LUM_IS_SESSION(x)
#define TYPE_SELF LUM_TYPE_SESSION
#define SELF_CLASS(x) LUM_SESSION_CLASS(x)

#define SELF_GET_CLASS(x) LUM_SESSION_GET_CLASS(x)

/* self typedefs */
typedef LumSession Self;
typedef LumSessionClass SelfClass;

/* here are local prototypes */
static void lum_session_class_init (LumSessionClass * c) G_GNUC_UNUSED;
static void lum_session_init (LumSession * self) G_GNUC_UNUSED;
static void ___2_lum_session_finalize (GObject * object) G_GNUC_UNUSED;
static gchar * lum_session_get_filename (const char * type) G_GNUC_UNUSED;
static void lum_session_delete (LumSession * self, const char * filename) G_GNUC_UNUSED;
static gpointer lum_session_parse_xml (gpointer data) G_GNUC_UNUSED;
static bool lum_session_save_yourself_cb (GnomeClient * client, gint phase, GnomeSaveStyle save_style, bool shutdown, GnomeInteractStyle interact_style, bool fast, Self * self) G_GNUC_UNUSED;
static void lum_session_die_cb (GnomeClient * client, Self * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_load lum_session_load
#define self_autoresume lum_session_autoresume
#define self_close lum_session_close
#define self_save lum_session_save
#define self_get_filename lum_session_get_filename
#define self_delete lum_session_delete
#define self_parse_xml lum_session_parse_xml
#define self_save_yourself_cb lum_session_save_yourself_cb
#define self_die_cb lum_session_die_cb
GType
lum_session_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumSessionClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_session_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumSession),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_session_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumSession", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumSession *)g_object_new(lum_session_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumSession * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumSession *
GET_NEW_VARG (const char *first, ...)
{
	LumSession *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumSession *)g_object_new_valist (lum_session_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Session::finalize"
	LumSession *self G_GNUC_UNUSED = LUM_SESSION (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 104 "lum-session.gob"
	___2_lum_session_finalize(obj_self);
#line 205 "lum-session.c"
}
#undef __GOB_FUNCTION__

static void 
lum_session_class_init (LumSessionClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Session::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LumSessionPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 104 "lum-session.gob"
	g_object_class->finalize = ___finalize;
#line 221 "lum-session.c"
}
#undef __GOB_FUNCTION__
#line 81 "lum-session.gob"
static void 
lum_session_init (LumSession * self G_GNUC_UNUSED)
#line 227 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,LumSessionPrivate);
#line 32 "lum-session.gob"
	self->_priv->session_saved = false;
#line 233 "lum-session.c"
#line 32 "lum-session.gob"
	self->_priv->dont_remove_crashed = true;
#line 236 "lum-session.c"
 {
#line 81 "lum-session.gob"

		GnomeClient *client;
		char *dir;
	 	struct stat statbuf;

		client = gnome_master_client ();
	
		g_signal_connect (G_OBJECT (client), "save_yourself",
				G_CALLBACK (self_save_yourself_cb), self);
	
		g_signal_connect (G_OBJECT (client), "die",
				G_CALLBACK (self_die_cb), self);
		
		dir = g_build_filename (g_get_home_dir(), LUM_DIR, NULL);
		if (stat(dir, &statbuf) < 0)
			if (mkdir(dir, 488) != 0)
				g_error ("Couldn't mkdir ./lumiere");
		g_free(dir);
	
#line 258 "lum-session.c"
 }
}
#undef __GOB_FUNCTION__



#line 104 "lum-session.gob"
static void 
___2_lum_session_finalize (GObject * object G_GNUC_UNUSED)
#line 268 "lum-session.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Session::finalize"
#line 104 "lum-session.gob"
	g_return_if_fail (object != NULL);
#line 104 "lum-session.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 278 "lum-session.c"
{
#line 104 "lum-session.gob"
	
		Self *self = SELF(object);
#ifndef NDEBUG
		printf(__FILE__ ": finalize\n");
#endif
		if (!selfp->dont_remove_crashed)
			self_delete(self, SESSION_CRASHED);

		if (!selfp->session_saved)
			self_delete(self, SESSION_SAVED);

		PARENT_HANDLER(object);
	}}
#line 294 "lum-session.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 121 "lum-session.gob"
void 
lum_session_load (LumSession * self, const char * filename)
#line 301 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::load"
#line 121 "lum-session.gob"
	g_return_if_fail (self != NULL);
#line 121 "lum-session.gob"
	g_return_if_fail (LUM_IS_SESSION (self));
#line 121 "lum-session.gob"
	g_return_if_fail (filename != NULL);
#line 310 "lum-session.c"
{
#line 121 "lum-session.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": load\n");
#endif
		xmlDocPtr doc;
		xmlNodePtr child;
		char *save_to;
		int idx = 0;
	
		save_to = self_get_filename (filename);
		doc = xmlParseFile (save_to);
		if(!doc){
			g_free (save_to);
			return;
		}

		child = xmlDocGetRootElement (doc);
		if(!child){
			g_free (save_to);
			xmlFreeDoc(doc);
			return ;
		}

		child = child->children;
	
		for( ; child != NULL; child = child->next, ++idx) {
			if (strcmp (child->name, "engine") == 0) {
				LumEngine *engine;
				gint x = 0, y = 0;
				bool boolean;

				x = lum_util_xmlGetIntProp (child, "x");
				y = lum_util_xmlGetIntProp (child, "y");
				boolean = lum_util_xmlGetIntProp (child, "shaded");
				engine = lum_shell_new_engine(lum_shell);
				gtk_window_move (lum_engine_get_skin(engine), x, y);
				lum_skin_set_shaded(LUM_SKIN(lum_engine_get_skin(engine)),
						boolean);
				boolean = lum_util_xmlGetIntProp (child, "always_on_top");
				lum_skin_set_always_on_top(
						LUM_SKIN(lum_engine_get_skin(engine)),
						boolean);
				if(child->children){
					struct local_data *my_data = g_malloc0(
							sizeof(struct local_data));
					my_data->filename = g_strdup(filename);
					my_data->idx = idx;
					my_data->engine = g_object_ref(engine);
					g_thread_create(self_parse_xml, (gpointer) my_data,
							false, NULL);
				}
			}
		}
		xmlFreeDoc(doc);
	}}
#line 368 "lum-session.c"
#undef __GOB_FUNCTION__

#line 182 "lum-session.gob"
LumSessionResumeType 
lum_session_autoresume (LumSession * self)
#line 374 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::autoresume"
#line 182 "lum-session.gob"
	g_return_val_if_fail (self != NULL, (LumSessionResumeType )0);
#line 182 "lum-session.gob"
	g_return_val_if_fail (LUM_IS_SESSION (self), (LumSessionResumeType )0);
#line 381 "lum-session.c"
{
#line 182 "lum-session.gob"
	
		char *saved_session;
		bool loaded = false;

		saved_session = self_get_filename(SESSION_CRASHED);

		if (g_file_test (saved_session, G_FILE_TEST_EXISTS))
			loaded = true;

		g_free (saved_session);

		saved_session = self_get_filename (SESSION_SAVED);

		if (g_file_test (saved_session, G_FILE_TEST_EXISTS) && !loaded)
		/*TODO add this to the config
		 * && eel_gconf_get_boolean (CONF_GENERAL_ALWAYS_SAVE_SESSION))
		 */
			self_load (self, saved_session);

		g_free (saved_session);

		return (lum_shell_get_engines(lum_shell) != NULL) ? SESSION_RESUMED : SESSION_OK;
	}}
#line 407 "lum-session.c"
#undef __GOB_FUNCTION__

#line 213 "lum-session.gob"
void 
lum_session_close (LumSession * self)
#line 413 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::close"
#line 213 "lum-session.gob"
	g_return_if_fail (self != NULL);
#line 213 "lum-session.gob"
	g_return_if_fail (LUM_IS_SESSION (self));
#line 420 "lum-session.c"
{
#line 213 "lum-session.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": close\n");
#endif
		if(!selfp->session_saved)
			self_save (self, SESSION_SAVED);
		selfp->session_saved = true;
	}}
#line 431 "lum-session.c"
#undef __GOB_FUNCTION__

#line 227 "lum-session.gob"
void 
lum_session_save (LumSession * self, const char * filename)
#line 437 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::save"
#line 227 "lum-session.gob"
	g_return_if_fail (self != NULL);
#line 227 "lum-session.gob"
	g_return_if_fail (LUM_IS_SESSION (self));
#line 227 "lum-session.gob"
	g_return_if_fail (filename != NULL);
#line 446 "lum-session.c"
{
#line 227 "lum-session.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": save\n");
#endif
		GList *e;
		xmlNodePtr root_node, engine_node;
		xmlDocPtr doc;
		gchar buffer[32];
		char *save_to;

		save_to = self_get_filename (filename);
		doc = xmlNewDoc ("1.0");

		root_node = xmlNewDocNode (doc, NULL, "session", NULL);
		xmlDocSetRootElement (doc, root_node);

		for (e = lum_shell_get_engines(lum_shell); e != NULL; e = e->next) {
#ifndef NDEBUG
			printf(__FILE__ ": doing engine save\n");
#endif
			GList *uris, *l;
			int x = 0, y = 0;
			bool shaded;
			LumEngine *engine = LUM_ENGINE(e->data);

			uris = lum_engine_get_list (engine);
			engine_node = xmlNewDocNode (doc, NULL, "engine", NULL);

			gtk_window_get_position (lum_engine_get_skin(engine), &x, &y);

			snprintf(buffer, 32, "%d", x);
			xmlSetProp (engine_node, "x", buffer);
			snprintf(buffer, 32, "%d", y);
			xmlSetProp (engine_node, "y", buffer);
			shaded  = lum_skin_get_shaded(
					LUM_SKIN(lum_engine_get_skin(engine)));
			snprintf(buffer, 32, "%d", shaded);
			xmlSetProp (engine_node, "shaded", buffer);
			shaded  = lum_skin_get_always_on_top(
						LUM_SKIN(lum_engine_get_skin(engine)));
			snprintf(buffer, 32, "%d", shaded);
			xmlSetProp (engine_node, "always_on_top", buffer);

			for (l = uris; l != NULL; l = l->next) {
	   			gchar *uri = (gchar *) l->data;
				xmlNodePtr playlist_node;
				playlist_node = xmlNewDocNode (doc, NULL, "playlist", NULL);
				xmlSetProp (playlist_node, "uri", g_strdup(uri));
				xmlAddChild (engine_node, playlist_node);
			}
			/*TODO shall we free this? */
			//if(uris)
			//	for (l = uris; l != NULL; l = l->next)
			//		if(l->data) g_free(l->data);
			//	g_list_free (uris);
			xmlAddChild (root_node, engine_node);
		}

  		xmlSaveFile(save_to, doc);
  		xmlFreeDoc(doc);
		g_free(save_to);
	}}
#line 511 "lum-session.c"
#undef __GOB_FUNCTION__

#line 293 "lum-session.gob"
static gchar * 
lum_session_get_filename (const char * type)
#line 517 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::get_filename"
#line 293 "lum-session.gob"
	g_return_val_if_fail (type != NULL, (gchar * )NULL);
#line 522 "lum-session.c"
{
#line 293 "lum-session.gob"
	
		char *save_to;

		if (strcmp (type, SESSION_SAVED) == 0){
			save_to = g_build_filename (g_get_home_dir (), LUM_DIR,
					    "session_saved.xml", NULL);
		} else if (strcmp (type, SESSION_CRASHED) == 0) {
			save_to = g_build_filename (g_get_home_dir (), LUM_DIR,
					    "session_crashed.xml", NULL);
		} else if (strcmp (type, SESSION_GNOME) == 0) {
			char *tmp;
		
			save_to = g_build_filename (g_get_home_dir (), LUM_DIR,
					    "session_gnome-XXXXXX", NULL);
			tmp = lum_util_general_tmp_filename (save_to, "xml");
			g_free (save_to);
			save_to = tmp;
		} else {
			save_to = g_strdup (type);
		}
#ifndef NDEBUG
		printf(__FILE__ ": filename: %s\n", save_to);
#endif
		return save_to;
	}}
#line 550 "lum-session.c"
#undef __GOB_FUNCTION__

#line 322 "lum-session.gob"
static void 
lum_session_delete (LumSession * self, const char * filename)
#line 556 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::delete"
#line 322 "lum-session.gob"
	g_return_if_fail (self != NULL);
#line 322 "lum-session.gob"
	g_return_if_fail (LUM_IS_SESSION (self));
#line 563 "lum-session.c"
{
#line 322 "lum-session.gob"
	
		char *save_to;
		save_to = self_get_filename (filename);
		gnome_vfs_unlink (save_to);
		g_free (save_to);
	}}
#line 572 "lum-session.c"
#undef __GOB_FUNCTION__

#line 333 "lum-session.gob"
static gpointer 
lum_session_parse_xml (gpointer data)
#line 578 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::parse_xml"
{
#line 333 "lum-session.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": enter parse thread\n");
#endif
		struct local_data *my_data = (struct local_data *) data;
		char *filename = my_data->filename;
		LumEngine *engine = my_data->engine;
		xmlDocPtr doc;
		xmlNodePtr child;
		char *save_to;
		int i = 0;
	
		save_to = self_get_filename(filename);
		doc = xmlParseFile (save_to);
		if(!doc){
			g_free (save_to);
			g_free(my_data);
			return NULL;
		}

		child = xmlDocGetRootElement (doc);
		if(!child){
			g_free (save_to);
			g_free(my_data);
			xmlFreeDoc(doc);
			return NULL;
		}

		child = child->children;
	
		for( ; child != NULL; child = child->next, ++i) {
			if(i != my_data->idx)
				continue;
			if (strcmp (child->name, "engine") == 0) {
				xmlNodePtr child2;
				child2 = child->children;
				for( ; child2 != NULL; child2 = child2->next) {
					if (strcmp (child2->name, "playlist") == 0) {
						char *uri;
						uri = xmlGetProp (child2, "uri");
						lum_engine_enqueue(engine, g_strdup(uri));
						xmlFree (uri);
					}
				}

			}
		}
		xmlFreeDoc(doc);
		g_object_unref(engine);
		g_free(filename);
		g_free (save_to);
		g_free(my_data);
#ifndef NDEBUG
		printf(__FILE__ ": exit parse thread\n");
#endif
		return NULL;
	}}
#line 640 "lum-session.c"
#undef __GOB_FUNCTION__

#line 397 "lum-session.gob"
static bool 
lum_session_save_yourself_cb (GnomeClient * client, gint phase, GnomeSaveStyle save_style, bool shutdown, GnomeInteractStyle interact_style, bool fast, Self * self)
#line 646 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::save_yourself_cb"
#line 397 "lum-session.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 397 "lum-session.gob"
	g_return_val_if_fail (IS_SELF (self), (bool )0);
#line 653 "lum-session.c"
{
#line 400 "lum-session.gob"
	
		char *argv[] = { "lumiere", "--load-session", NULL, NULL };
		char *discard_argv[] = { "rm", "-r", NULL };
	
		argv[2] = self_get_filename (SESSION_GNOME);
		if(lum_shell_get_server_mode(lum_shell)){
			argv[3] = "-s";
			gnome_client_set_restart_command (client, 4, argv);
		} else
			gnome_client_set_restart_command (client, 3, argv);
     
		discard_argv[2] = argv[2];
		gnome_client_set_discard_command(client, 3, discard_argv);
			
		self_save (self, argv[2]);
		g_free (argv[2]);
		return true;
	}}
#line 674 "lum-session.c"
#undef __GOB_FUNCTION__

#line 423 "lum-session.gob"
static void 
lum_session_die_cb (GnomeClient * client, Self * self)
#line 680 "lum-session.c"
{
#define __GOB_FUNCTION__ "Lum:Session::die_cb"
#line 423 "lum-session.gob"
	g_return_if_fail (self != NULL);
#line 423 "lum-session.gob"
	g_return_if_fail (IS_SELF (self));
#line 687 "lum-session.c"
{
#line 423 "lum-session.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": die_cb\n");
#endif
		LumShell *shell;
		shell =  g_object_ref (lum_shell);
		if(shell){
			self_close (self);
			lum_shell_set_server_mode (lum_shell, false);
			g_object_unref (lum_shell);
		}
	}}
#line 702 "lum-session.c"
#undef __GOB_FUNCTION__
