/* Generated by GOB (v2.0.11) on Sat Apr 16 19:56:21 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-shell.gob"

/***************************************************************************
                        lum-shell.gob  -  Lumiere Main Class 
                             -------------------
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.16 $
 * $Date: 2005/04/13 01:26:42 $
 *
 */

#line 34 "lum-shell.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "lum-shell.h"

#include "lum-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 41 "lum-shell.gob"

#include <config.h>

#include "lum-control.h"
#include "lum-util.h"
#include "lum-context.h"
#include "lum-prefs.h"
#include "lum-automation.h"
#include "lum-player-info-server.h"

#include <glade/glade.h>
#include <glib/gutils.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-application-registry.h>
#include <libgnomeui/gnome-about.h>
#include <libgnomeui/gnome-stock-icons.h>
#include <libgnome/gnome-help.h>
#include <gdk/gdkx.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <string.h>
#include <xine.h>

extern LumShell *lum_shell;

#line 80 "lum-shell.c"

#line 68 "lum-shell.gob"

/* drag'n drop target table, basically anything can be dragged */
static const GtkTargetEntry target_table [] =
{
	{ "STRING",        0, TARGET_STRING },
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
};


#line 93 "lum-shell.c"
static const GEnumValue _lum_shell_xf86audio_values[] = {
	{ XF86AUDIO_PLAY, (char *)"XF86AUDIO_PLAY", (char *)"play" },
	{ XF86AUDIO_PAUSE, (char *)"XF86AUDIO_PAUSE", (char *)"pause" },
	{ XF86AUDIO_STOP, (char *)"XF86AUDIO_STOP", (char *)"stop" },
	{ XF86AUDIO_NEXT, (char *)"XF86AUDIO_NEXT", (char *)"next" },
	{ XF86AUDIO_PREV, (char *)"XF86AUDIO_PREV", (char *)"prev" },
	{ XF86AUDIO_RAISEVOLUME, (char *)"XF86AUDIO_RAISEVOLUME", (char *)"raisevolume" },
	{ XF86AUDIO_LOWERVOLUME, (char *)"XF86AUDIO_LOWERVOLUME", (char *)"lowervolume" },
	{ XF86AUDIO_MUTE, (char *)"XF86AUDIO_MUTE", (char *)"mute" },
	{ XF86AUDIO_MEDIA, (char *)"XF86AUDIO_MEDIA", (char *)"media" },
	{ XF86AUDIO_MAX, (char *)"XF86AUDIO_MAX", (char *)"max" },
	{ 0, NULL, NULL }
};

GType
lum_shell_xf86audio_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumShellXF86Audio", _lum_shell_xf86audio_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_SHELL(x)
#define SELF_CONST(x) LUM_SHELL_CONST(x)
#define IS_SELF(x) LUM_IS_SHELL(x)
#define TYPE_SELF LUM_TYPE_SHELL
#define SELF_CLASS(x) LUM_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) LUM_SHELL_GET_CLASS(x)

/* self typedefs */
typedef LumShell Self;
typedef LumShellClass SelfClass;

/* here are local prototypes */
static void lum_shell_class_init (LumShellClass * class) G_GNUC_UNUSED;
static void lum_shell_init (LumShell * self) G_GNUC_UNUSED;
static void ___4_lum_shell_dispose (GObject * object) G_GNUC_UNUSED;
static void ___5_lum_shell_finalize (GObject * object) G_GNUC_UNUSED;
static void lum_shell_add_engine (LumShell * self, LumEngine * engine) G_GNUC_UNUSED;
static void lum_shell_remove_engine (LumShell * self, LumEngine * engine) G_GNUC_UNUSED;
static GdkFilterReturn lum_shell_xf86audio_filter (GdkXEvent * xevent, GdkEvent * event, gpointer data) G_GNUC_UNUSED;
static KeyCode lum_shell_grab_key (char * keystring) G_GNUC_UNUSED;
static void lum_shell_grab_keys (LumShell * self) G_GNUC_UNUSED;
static void lum_shell_ungrab_key (KeyCode code) G_GNUC_UNUSED;
static void lum_shell_ungrab_keys (LumShell * self) G_GNUC_UNUSED;
static void lum_shell_init_tray (LumShell * self) G_GNUC_UNUSED;
static bool lum_shell_tray_destroyed (GtkWidget * widget, GdkEvent * event, Self * self) G_GNUC_UNUSED;
static void lum_shell_prefs_activate_cb (GtkAction * action, gpointer data) G_GNUC_UNUSED;
static void lum_shell_about_activate_cb (GtkAction * action, gpointer data) G_GNUC_UNUSED;
static void lum_shell_help_activate_cb (GtkAction * action, gpointer data) G_GNUC_UNUSED;
static void lum_shell_quit (LumShell * self) G_GNUC_UNUSED;
static void lum_shell_close_engine_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_open_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_opendir_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_audio_cd_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_dvd_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_play_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_stop_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_next_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_shell_prev_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static bool lum_shell_tray_icon_release_cb (GtkWidget * widget, GdkEventButton * event, Self * self) G_GNUC_UNUSED;
static bool lum_shell_tray_icon_press_cb (GtkWidget * widget, GdkEventButton * event, Self * self) G_GNUC_UNUSED;
static void lum_shell_drag_data_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, gpointer user_data) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_new lum_shell_new
#define self_new_engine lum_shell_new_engine
#define self_get_active_engine lum_shell_get_active_engine
#define self_set_active_engine lum_shell_set_active_engine
#define self_get_session lum_shell_get_session
#define self_get_config lum_shell_get_config
#define self_get_server_mode lum_shell_get_server_mode
#define self_set_server_mode lum_shell_set_server_mode
#define self_add_engine lum_shell_add_engine
#define self_remove_engine lum_shell_remove_engine
#define self_get_engines lum_shell_get_engines
#define self_get_tray_icon lum_shell_get_tray_icon
#define self_set_tray_icon lum_shell_set_tray_icon
#define self_show_prefs lum_shell_show_prefs
#define self_show_about lum_shell_show_about
#define self_glade_not_found lum_shell_glade_not_found
#define self_set_tip lum_shell_set_tip
#define self_xf86audio_filter lum_shell_xf86audio_filter
#define self_grab_key lum_shell_grab_key
#define self_grab_keys lum_shell_grab_keys
#define self_ungrab_key lum_shell_ungrab_key
#define self_ungrab_keys lum_shell_ungrab_keys
#define self_init_tray lum_shell_init_tray
#define self_tray_destroyed lum_shell_tray_destroyed
#define self_prefs_activate_cb lum_shell_prefs_activate_cb
#define self_about_activate_cb lum_shell_about_activate_cb
#define self_help_activate_cb lum_shell_help_activate_cb
#define self_quit lum_shell_quit
#define self_close_engine_activate_cb lum_shell_close_engine_activate_cb
#define self_open_activate_cb lum_shell_open_activate_cb
#define self_opendir_activate_cb lum_shell_opendir_activate_cb
#define self_audio_cd_activate_cb lum_shell_audio_cd_activate_cb
#define self_dvd_activate_cb lum_shell_dvd_activate_cb
#define self_play_activate_cb lum_shell_play_activate_cb
#define self_stop_activate_cb lum_shell_stop_activate_cb
#define self_next_activate_cb lum_shell_next_activate_cb
#define self_prev_activate_cb lum_shell_prev_activate_cb
#define self_tray_icon_release_cb lum_shell_tray_icon_release_cb
#define self_tray_icon_press_cb lum_shell_tray_icon_press_cb
#define self_drag_data_received_cb lum_shell_drag_data_received_cb
GType
lum_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumShell *)g_object_new(lum_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumShell *
GET_NEW_VARG (const char *first, ...)
{
	LumShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumShell *)g_object_new_valist (lum_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Shell::dispose"
	LumShell *self G_GNUC_UNUSED = LUM_SHELL (obj_self);
#line 246 "lum-shell.gob"
	___4_lum_shell_dispose(obj_self);
#line 255 "lum-shell.c"
#line 95 "lum-shell.gob"
	if(self->_priv->session) { g_object_unref ((gpointer) self->_priv->session); self->_priv->session = NULL; }
#line 258 "lum-shell.c"
#line 96 "lum-shell.gob"
	if(self->_priv->config) { g_object_unref ((gpointer) self->_priv->config); self->_priv->config = NULL; }
#line 261 "lum-shell.c"
#line 118 "lum-shell.gob"
	if(self->_priv->automation_factory) { bonobo_object_unref ((gpointer) self->_priv->automation_factory); self->_priv->automation_factory = NULL; }
#line 264 "lum-shell.c"
#line 121 "lum-shell.gob"
	if(self->_priv->control_factory) { bonobo_object_unref ((gpointer) self->_priv->control_factory); self->_priv->control_factory = NULL; }
#line 267 "lum-shell.c"
#line 124 "lum-shell.gob"
	if(self->_priv->context_factory) { bonobo_object_unref ((gpointer) self->_priv->context_factory); self->_priv->context_factory = NULL; }
#line 270 "lum-shell.c"
#line 127 "lum-shell.gob"
	if(self->_priv->info_factory) { bonobo_object_unref ((gpointer) self->_priv->info_factory); self->_priv->info_factory = NULL; }
#line 273 "lum-shell.c"
#line 137 "lum-shell.gob"
	if(self->quit) { g_object_unref ((gpointer) self->quit); self->quit = NULL; }
#line 276 "lum-shell.c"
#line 142 "lum-shell.gob"
	if(self->prefs) { g_object_unref ((gpointer) self->prefs); self->prefs = NULL; }
#line 279 "lum-shell.c"
#line 147 "lum-shell.gob"
	if(self->about) { g_object_unref ((gpointer) self->about); self->about = NULL; }
#line 282 "lum-shell.c"
#line 152 "lum-shell.gob"
	if(self->help) { g_object_unref ((gpointer) self->help); self->help = NULL; }
#line 285 "lum-shell.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Shell::finalize"
	LumShell *self G_GNUC_UNUSED = LUM_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 259 "lum-shell.gob"
	___5_lum_shell_finalize(obj_self);
#line 298 "lum-shell.c"
#line 98 "lum-shell.gob"
	if(self->_priv->engines) { g_list_free ((gpointer) self->_priv->engines); self->_priv->engines = NULL; }
#line 301 "lum-shell.c"
#line 103 "lum-shell.gob"
	if(self->_priv->tray_icon) { gtk_widget_destroy ((gpointer) self->_priv->tray_icon); self->_priv->tray_icon = NULL; }
#line 304 "lum-shell.c"
#line 106 "lum-shell.gob"
	if(self->_priv->tray_icon_tooltip) { gtk_object_destroy ((gpointer) self->_priv->tray_icon_tooltip); self->_priv->tray_icon_tooltip = NULL; }
#line 307 "lum-shell.c"
#line 108 "lum-shell.gob"
	if(self->_priv->popup_menu) { gtk_widget_destroy ((gpointer) self->_priv->popup_menu); self->_priv->popup_menu = NULL; }
#line 310 "lum-shell.c"
}
#undef __GOB_FUNCTION__

#line 159 "lum-shell.gob"
static void 
lum_shell_class_init (LumShellClass * class G_GNUC_UNUSED)
#line 317 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(LumShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 246 "lum-shell.gob"
	g_object_class->dispose = ___dispose;
#line 259 "lum-shell.gob"
	g_object_class->finalize = ___finalize;
#line 330 "lum-shell.c"
 {
#line 159 "lum-shell.gob"

		 if(!gnome_vfs_application_registry_exists("lumiere")){
		 	gnome_vfs_application_registry_set_value("lumiere", "command",
					PREFIX"bin/lumiere");
			gnome_vfs_application_registry_set_value("lumiere", "name",
					"Lumiere");
			gnome_vfs_application_registry_set_bool_value("lumiere",
					"can_open_multiple_files", true);
			gnome_vfs_application_registry_set_bool_value("lumiere",
					"requires_terminal", false);
			gnome_vfs_application_registry_set_bool_value("lumiere",
					"expects_uris", true);
			gnome_vfs_application_registry_set_value("lumiere",
					"supported_uri_schemes",
					"file,http,ssh,rtsp,mms,rtp,pnm,mmsh,dvd,vcd,cdda");
			gnome_vfs_application_registry_set_bool_value("lumiere",
					"all_gnome_vfs_schemes_supported", true);
			gnome_vfs_application_registry_set_bool_value("lumiere",
					"startup_notify", true);
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"audio/*");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"application/ogg");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"application/x-ogg");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"application/vnd.rn-realmedia");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"application/x-quicktimeplayer");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"application/vnd.ms-asf");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"application/x-mplayer2");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"video/*");
			gnome_vfs_application_registry_add_mime_type("lumiere",
					"x-directory/normal");
			gnome_vfs_application_registry_sync();
		 }
	
#line 373 "lum-shell.c"
 }
}
#undef __GOB_FUNCTION__
#line 207 "lum-shell.gob"
static void 
lum_shell_init (LumShell * self G_GNUC_UNUSED)
#line 380 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,LumShellPrivate);
#line 95 "lum-shell.gob"
	self->_priv->session = g_object_new(LUM_TYPE_SESSION, NULL);;
#line 386 "lum-shell.c"
#line 96 "lum-shell.gob"
	self->_priv->config = g_object_new(LUM_TYPE_CONFIG_GCONF, NULL);;
#line 389 "lum-shell.c"
#line 96 "lum-shell.gob"
	self->_priv->engines = NULL;
#line 392 "lum-shell.c"
#line 96 "lum-shell.gob"
	self->_priv->active_engine = NULL;
#line 395 "lum-shell.c"
#line 96 "lum-shell.gob"
	self->_priv->tray_icon = NULL;
#line 398 "lum-shell.c"
#line 105 "lum-shell.gob"
	self->_priv->tray_icon_tooltip = gtk_tooltips_new ();
#line 401 "lum-shell.c"
#line 105 "lum-shell.gob"
	self->_priv->popup_menu = NULL;
#line 404 "lum-shell.c"
#line 117 "lum-shell.gob"
	self->_priv->automation_factory = lum_automation_factory_new();;
#line 407 "lum-shell.c"
#line 120 "lum-shell.gob"
	self->_priv->control_factory = lum_control_factory_new();;
#line 410 "lum-shell.c"
#line 123 "lum-shell.gob"
	self->_priv->context_factory = lum_context_factory_new();;
#line 413 "lum-shell.c"
#line 126 "lum-shell.gob"
	self->_priv->info_factory = lum_player_info_server_factory_new();;
#line 416 "lum-shell.c"
#line 126 "lum-shell.gob"
	self->_priv->server_mode = false;
#line 419 "lum-shell.c"
#line 133 "lum-shell.gob"
	self->quit = gtk_action_new("lum_shell_quit",
			_("Quit"), _("Close all windows and exit"),
			GTK_STOCK_QUIT);
			;
#line 425 "lum-shell.c"
#line 138 "lum-shell.gob"
	self->prefs = gtk_action_new("lum_shell_prefs",
			_("Preferences"), _("Show Preferences Window"),
			GTK_STOCK_PREFERENCES);
			;
#line 431 "lum-shell.c"
#line 143 "lum-shell.gob"
	self->about = gtk_action_new("lum_shell_about",
			_("About"), _("Show About Window"),
			GNOME_STOCK_ABOUT);
			;
#line 437 "lum-shell.c"
#line 148 "lum-shell.gob"
	self->help = gtk_action_new("lum_shell_help",
			_("Help"), _("Show Help"),
			GTK_STOCK_HELP);
			;
#line 443 "lum-shell.c"
 {
#line 207 "lum-shell.gob"

		self_grab_keys(self);
		self_set_server_mode(self, selfp->config->server_mode);
		
		if(!selfp->automation_factory || !selfp->control_factory ||
			    	!selfp->context_factory || !selfp->info_factory) {
			GtkWidget *dialog = gtk_message_dialog_new (NULL,
					GTK_DIALOG_MODAL,
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK,
					_("Lumiere failed to start."));
			char * text = g_strdup_printf (
					_("Bonobo couldn't locate the file %s or %s or %s."),
					"<tt>\"GNOME_Lum_Automation.server\"</tt>",
					"<tt>\"GNOME_Lum_Control.server\"</tt>",
					"<tt>\"GNOME_Lum_Contextmenu.server\"</tt>");
			gtk_message_dialog_format_secondary_text(
					GTK_MESSAGE_DIALOG(dialog), "%s\n\n%s", text,
    					_("Usually this is an indication of an incomplete installation. "
					"See the INSTALL document for more details."));
			g_free (text);
			gtk_dialog_run (GTK_DIALOG (dialog));
			exit (EXIT_FAILURE);
		}
		self_set_tray_icon(self, selfp->config->tray_icon);
		g_signal_connect_swapped(G_OBJECT(self->quit), "activate",
					G_CALLBACK(self_quit), self);
		g_signal_connect(G_OBJECT(self->prefs), "activate",
					G_CALLBACK(self_prefs_activate_cb), self);
		g_signal_connect(G_OBJECT(self->about), "activate",
					G_CALLBACK(self_about_activate_cb), self);
		g_signal_connect(G_OBJECT(self->help), "activate",
					G_CALLBACK(self_help_activate_cb), self);
	
#line 480 "lum-shell.c"
 }
}
#undef __GOB_FUNCTION__



#line 242 "lum-shell.gob"
LumShell * 
lum_shell_new (void)
#line 490 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::new"
{
#line 242 "lum-shell.gob"
	
		return GET_NEW;
	}}
#line 498 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 246 "lum-shell.gob"
static void 
___4_lum_shell_dispose (GObject * object G_GNUC_UNUSED)
#line 504 "lum-shell.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Shell::dispose"
#line 246 "lum-shell.gob"
	g_return_if_fail (object != NULL);
#line 512 "lum-shell.c"
{
#line 246 "lum-shell.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": dispose\n");
#endif
		Self *self = SELF(object);

		GList *list = selfp->engines;

		for( ; list != NULL; list = list->next)
			g_object_unref(G_OBJECT(list->data));
		PARENT_HANDLER(object);
	}}
#line 527 "lum-shell.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 259 "lum-shell.gob"
static void 
___5_lum_shell_finalize (GObject * object G_GNUC_UNUSED)
#line 534 "lum-shell.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Shell::finalize"
#line 259 "lum-shell.gob"
	g_return_if_fail (object != NULL);
#line 542 "lum-shell.c"
{
#line 259 "lum-shell.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": finalize\n");
#endif
		Self *self = SELF(object);
		self_ungrab_keys(self);
		PARENT_HANDLER(object);
#ifndef NDEBUG
		printf(__FILE__ ": finalized\n");
#endif
		bonobo_main_quit ();
	}}
#line 557 "lum-shell.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 274 "lum-shell.gob"
LumEngine * 
lum_shell_new_engine (LumShell * self)
#line 564 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::new_engine"
#line 274 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (LumEngine * )0);
#line 274 "lum-shell.gob"
	g_return_val_if_fail (LUM_IS_SHELL (self), (LumEngine * )0);
#line 571 "lum-shell.c"
{
#line 274 "lum-shell.gob"
	
		LumEngine *engine = g_object_new(LUM_TYPE_ENGINE, NULL);
		self_add_engine(self, engine);
		return engine;
	}}
#line 579 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 283 "lum-shell.gob"
LumEngine * 
lum_shell_get_active_engine (LumShell * self)
#line 585 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::get_active_engine"
#line 283 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (LumEngine * )0);
#line 283 "lum-shell.gob"
	g_return_val_if_fail (LUM_IS_SHELL (self), (LumEngine * )0);
#line 592 "lum-shell.c"
{
#line 283 "lum-shell.gob"
	
		GList *engines;

		engines = selfp->engines;

		if (engines && !g_list_find(engines, selfp->active_engine))
			selfp->active_engine = LUM_ENGINE(engines->data);
		else if(engines == NULL)
			selfp->active_engine = NULL;
		return selfp->active_engine;
	}}
#line 606 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 295 "lum-shell.gob"
void 
lum_shell_set_active_engine (LumShell * self, LumEngine * engine)
#line 612 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::set_active_engine"
#line 295 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 295 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 295 "lum-shell.gob"
	g_return_if_fail (engine != NULL);
#line 295 "lum-shell.gob"
	g_return_if_fail (LUM_IS_ENGINE (engine));
#line 623 "lum-shell.c"
{
#line 296 "lum-shell.gob"
		selfp->active_engine = engine; }}
#line 627 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 301 "lum-shell.gob"
LumSession * 
lum_shell_get_session (LumShell * self)
#line 633 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::get_session"
#line 301 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (LumSession * )0);
#line 301 "lum-shell.gob"
	g_return_val_if_fail (LUM_IS_SHELL (self), (LumSession * )0);
#line 640 "lum-shell.c"
{
#line 301 "lum-shell.gob"
	
		if(!selfp->session)
			selfp->session = g_object_new(LUM_TYPE_SESSION, NULL);
		return selfp->session;
	}}
#line 648 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 310 "lum-shell.gob"
LumConfig * 
lum_shell_get_config (LumShell * self)
#line 654 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::get_config"
#line 310 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (LumConfig * )0);
#line 310 "lum-shell.gob"
	g_return_val_if_fail (LUM_IS_SHELL (self), (LumConfig * )0);
#line 661 "lum-shell.c"
{
#line 310 "lum-shell.gob"
	
		if(!selfp->config)
			selfp->config = g_object_new(LUM_TYPE_CONFIG_GCONF, NULL);
		return selfp->config;
	}}
#line 669 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 316 "lum-shell.gob"
bool 
lum_shell_get_server_mode (LumShell * self)
#line 675 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::get_server_mode"
#line 316 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 316 "lum-shell.gob"
	g_return_val_if_fail (LUM_IS_SHELL (self), (bool )0);
#line 682 "lum-shell.c"
{
#line 316 "lum-shell.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": get server mode = %s\n",
				selfp->server_mode ? "true" : "false");
#endif
		return selfp->server_mode;
	}}
#line 692 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 324 "lum-shell.gob"
void 
lum_shell_set_server_mode (LumShell * self, bool mode)
#line 698 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::set_server_mode"
#line 324 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 324 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 705 "lum-shell.c"
{
#line 324 "lum-shell.gob"
	
		if(mode == selfp->server_mode)
			return;
		selfp->server_mode = mode;
		
		if (mode)
			g_object_ref (G_OBJECT(self));

		else if (!mode)
			g_object_unref (G_OBJECT(self));
#ifndef NDEBUG
		printf(__FILE__": set server mode = %s\n",
				mode ? "true" : "false");
#endif
	}}
#line 723 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 343 "lum-shell.gob"
static void 
lum_shell_add_engine (LumShell * self, LumEngine * engine)
#line 729 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::add_engine"
#line 343 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 343 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 343 "lum-shell.gob"
	g_return_if_fail (engine != NULL);
#line 343 "lum-shell.gob"
	g_return_if_fail (LUM_IS_ENGINE (engine));
#line 740 "lum-shell.c"
{
#line 343 "lum-shell.gob"
	
		g_object_ref(self);
		selfp->engines = g_list_append(selfp->engines, engine);
		self_set_active_engine(self, engine);
		g_object_weak_ref(G_OBJECT(engine), (GWeakNotify) self_remove_engine, self);
	}}
#line 749 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 354 "lum-shell.gob"
static void 
lum_shell_remove_engine (LumShell * self, LumEngine * engine)
#line 755 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::remove_engine"
#line 354 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 354 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 762 "lum-shell.c"
{
#line 354 "lum-shell.gob"
	
//		if(g_list_length(selfp->engines) == 2){
//			lum_session_save(selfp->session, "type:session_saved");
//		}
		selfp->engines = g_list_remove (selfp->engines, engine);
		g_object_unref(self);
	}}
#line 772 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 366 "lum-shell.gob"
GList * 
lum_shell_get_engines (LumShell * self)
#line 778 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::get_engines"
#line 366 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (GList * )0);
#line 366 "lum-shell.gob"
	g_return_val_if_fail (LUM_IS_SHELL (self), (GList * )0);
#line 785 "lum-shell.c"
{
#line 367 "lum-shell.gob"
		return selfp->engines; }}
#line 789 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 370 "lum-shell.gob"
bool 
lum_shell_get_tray_icon (LumShell * self)
#line 795 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::get_tray_icon"
#line 370 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 370 "lum-shell.gob"
	g_return_val_if_fail (LUM_IS_SHELL (self), (bool )0);
#line 802 "lum-shell.c"
{
#line 370 "lum-shell.gob"
	
	#warning fix this get_tray_icon()
		return true;
	}}
#line 809 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 375 "lum-shell.gob"
void 
lum_shell_set_tray_icon (LumShell * self, bool mode)
#line 815 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::set_tray_icon"
#line 375 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 375 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 822 "lum-shell.c"
{
#line 375 "lum-shell.gob"
	
		if(mode && selfp->tray_icon)
			return;
		else if(!mode && !selfp->tray_icon)
			return;
		
		if (mode && !selfp->tray_icon)
			self_init_tray(self);

		else if (!mode && selfp->tray_icon){
			gtk_widget_destroy(GTK_WIDGET(selfp->tray_icon));
			selfp->tray_icon = NULL;
		}
	}}
#line 839 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 390 "lum-shell.gob"
void 
lum_shell_show_prefs (LumShell * self)
#line 845 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::show_prefs"
#line 390 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 390 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 852 "lum-shell.c"
{
#line 391 "lum-shell.gob"
		lum_prefs_show(); }}
#line 856 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 396 "lum-shell.gob"
void 
lum_shell_show_about (LumShell * self)
#line 862 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::show_about"
#line 396 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 396 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 869 "lum-shell.c"
{
#line 396 "lum-shell.gob"
	
		static GtkWidget *about;
		static const char *authors[] = {
			NULL,
			NULL
		};
		
		const char *translator_credits;

		if (!about) {
			GdkPixbuf *pixbuf;
			pixbuf = gdk_pixbuf_new_from_file(
					DATADIR"/lumiere/lumiere-logo.png",
					NULL); 
			authors[0] = _("Stephane Konstantaropoulos"),

			translator_credits = _("Translator Credits");
			
			about = gnome_about_new (
					"Lumiere",
					VERSION,
					_("Copyright (C) 2004 Stephane Konstantaropoulos"),
					_("A media player for GNOME 2"),
					authors,
					NULL, /* char **documenters */
					translator_credits,
					pixbuf);
			g_signal_connect (about, "destroy",
					G_CALLBACK (gtk_widget_destroyed),
					&about);
		}
		gtk_widget_show_now(about);
		g_assert (GTK_WIDGET_REALIZED(about));
		gdk_window_show (about->window);
		gtk_widget_grab_focus(about);
	}}
#line 908 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 433 "lum-shell.gob"
void 
lum_shell_glade_not_found (void)
#line 914 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::glade_not_found"
{
#line 433 "lum-shell.gob"
	
		GtkWidget *dialog;
		dialog = gtk_message_dialog_new (NULL,
				GTK_DIALOG_MODAL, 
				GTK_MESSAGE_ERROR,
				GTK_BUTTONS_OK,
				_("Lumiere cannot find %s."),
				DATADIR"/lumiere/lumiere.glade");
		gtk_message_dialog_format_secondary_text(
				GTK_MESSAGE_DIALOG(dialog),
				"Make sure lumiere was completely installed,"
				" or run the install again.\n\n"
				"Aborting...");
		g_signal_connect (G_OBJECT (dialog), "response",
			  G_CALLBACK (gtk_widget_destroy), NULL);
		gtk_widget_show (dialog);
		exit(EXIT_FAILURE);
	}}
#line 937 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 455 "lum-shell.gob"
void 
lum_shell_set_tip (LumShell * self, const char * tip)
#line 943 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::set_tip"
#line 455 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 455 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 950 "lum-shell.c"
{
#line 455 "lum-shell.gob"
	
		if(selfp->tray_icon){
			gtk_tooltips_set_tip (selfp->tray_icon_tooltip,
				GTK_WIDGET (selfp->tray_icon),
				tip ? tip : _("Lumiere Server Active"), NULL);
		}
	}}
#line 960 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 471 "lum-shell.gob"
static GdkFilterReturn 
lum_shell_xf86audio_filter (GdkXEvent * xevent, GdkEvent * event, gpointer data)
#line 966 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::xf86audio_filter"
{
#line 472 "lum-shell.gob"
	
		Self *self = lum_shell;
		LumEngine *engine = NULL;
		XEvent *xev = (XEvent *)xevent;
		XKeyEvent *keyevent = (XKeyEvent *)xevent;
		KeyCode *k = (KeyCode *)data;
		gint i;
	
		if (xev->type != KeyRelease)
			return GDK_FILTER_CONTINUE;

		for (i=0; i<XF86AUDIO_MAX; i++) {
			if (k[i] == keyevent->keycode)
				break;
		}
		if (i == XF86AUDIO_MAX) {
			g_warning("Received KeyRelease event for unrequested keycode %d", keyevent->keycode);
			return GDK_FILTER_CONTINUE;
		}
		engine = self_get_active_engine(self);

		if(!engine){
			if(i == XF86AUDIO_MEDIA)
				lum_engine_show_fileselector(g_object_new(LUM_TYPE_ENGINE, NULL));
			return GDK_FILTER_CONTINUE;
		}
	
		switch (i) {
		case XF86AUDIO_PLAY:
			lum_engine_play(engine);
			break;
		case XF86AUDIO_STOP:
			lum_engine_stop(engine);
			break;
		case XF86AUDIO_PREV:
			lum_engine_prev(engine);
			break;
		case XF86AUDIO_NEXT:
			lum_engine_next(engine);
			break;
		case XF86AUDIO_PAUSE:
			lum_engine_pause(engine);
			break;
		case XF86AUDIO_RAISEVOLUME:
			lum_engine_inc_vol(engine);
			break;
		case XF86AUDIO_LOWERVOLUME:
			lum_engine_dec_vol(engine);
			break;
		case XF86AUDIO_MUTE:
			lum_engine_mute(engine);
			break;
		case XF86AUDIO_MEDIA:
			lum_engine_show_fileselector(engine);
			break;
		default: return GDK_FILTER_CONTINUE;
		}
		return GDK_FILTER_REMOVE;
	}}
#line 1030 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 532 "lum-shell.gob"
static KeyCode 
lum_shell_grab_key (char * keystring)
#line 1036 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::grab_key"
{
#line 532 "lum-shell.gob"
	
		KeySym sym;
		KeyCode code;

		sym = XStringToKeysym(keystring);
		if (sym == NoSymbol)
			return 0;
		if ((code = XKeysymToKeycode(GDK_DISPLAY(), sym)) == 0)
			return 0;

		gdk_error_trap_push();
		XGrabKey(GDK_DISPLAY(), code,
				AnyModifier, GDK_ROOT_WINDOW(),
				1, GrabModeAsync, GrabModeAsync);
		gdk_flush();
		if (gdk_error_trap_pop()) {
			g_warning("Couldn't grab %s: another client may already have done so",
				keystring);
			return 0;
		}
		return code;
	}}
#line 1063 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 555 "lum-shell.gob"
static void 
lum_shell_grab_keys (LumShell * self)
#line 1069 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::grab_keys"
#line 555 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 555 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 1076 "lum-shell.c"
{
#line 555 "lum-shell.gob"
	
		KeyCode code;
	
		if ((code = self_grab_key("XF86AudioNext")) != 0)
			selfp->map[XF86AUDIO_NEXT] = code;
		if ((code = self_grab_key("XF86AudioPrev")) != 0)
			selfp->map[XF86AUDIO_PREV] = code;
		if ((code = self_grab_key("XF86AudioPlay")) != 0)
			selfp->map[XF86AUDIO_PLAY] = code;
		if ((code = self_grab_key("XF86AudioStop")) != 0)
			selfp->map[XF86AUDIO_STOP] = code;
		if ((code = self_grab_key("XF86AudioPause")) != 0)
			selfp->map[XF86AUDIO_PAUSE] = code;
		if ((code = self_grab_key("XF86AudioRaiseVolume")) != 0)
			selfp->map[XF86AUDIO_RAISEVOLUME] = code;
		if ((code = self_grab_key("XF86AudioLowerVolume")) != 0)
			selfp->map[XF86AUDIO_LOWERVOLUME] = code;
		if ((code = self_grab_key("XF86AudioMute")) != 0)
			selfp->map[XF86AUDIO_MUTE] = code;
		if ((code = self_grab_key("XF86AudioMedia")) != 0)
			selfp->map[XF86AUDIO_MEDIA] = code;

		gdk_window_add_filter(gdk_get_default_root_window (),
				self_xf86audio_filter, selfp->map);
	}}
#line 1104 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 581 "lum-shell.gob"
static void 
lum_shell_ungrab_key (KeyCode code)
#line 1110 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::ungrab_key"
{
#line 581 "lum-shell.gob"
	
		XUngrabKey(GDK_DISPLAY(), code,
			AnyModifier, GDK_ROOT_WINDOW());
	}}
#line 1119 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 586 "lum-shell.gob"
static void 
lum_shell_ungrab_keys (LumShell * self)
#line 1125 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::ungrab_keys"
#line 586 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 586 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 1132 "lum-shell.c"
{
#line 586 "lum-shell.gob"
	
		int i;

		for (i = 0; i < XF86AUDIO_MAX; i++) {
			if (selfp->map[i] != 0)
				self_ungrab_key(selfp->map[i]);
		}
		gdk_window_remove_filter(gdk_get_default_root_window (),
				self_xf86audio_filter, selfp->map);
	}}
#line 1145 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 600 "lum-shell.gob"
static void 
lum_shell_init_tray (LumShell * self)
#line 1151 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::init_tray"
#line 600 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 600 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 1158 "lum-shell.c"
{
#line 600 "lum-shell.gob"
	
		GtkWidget *image, *evbox;
		GladeXML *xml;
			
		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"tray_menu", GETTEXT_PACKAGE);
		if(xml == NULL){
			self_glade_not_found();
		}

		selfp->tray_icon = egg_tray_icon_new("Lumiere");
		image = gtk_image_new_from_file (
				DATADIR"/lumiere/lumiere-tray-16.png");
		gtk_tooltips_set_tip (selfp->tray_icon_tooltip,
			GTK_WIDGET (selfp->tray_icon),
			_("Lumiere Server Active"), NULL);
	
		selfp->popup_menu = glade_xml_get_widget(xml, "tray_menu_menu");

		gtk_action_connect_proxy(self->prefs, glade_xml_get_widget(xml, "prefs"));
		gtk_action_connect_proxy(self->about, glade_xml_get_widget(xml, "about"));
		gtk_action_connect_proxy(self->quit, glade_xml_get_widget(xml, "quit"));
		gtk_action_connect_proxy(self->help, glade_xml_get_widget(xml, "help"));
		
		g_signal_connect_swapped(glade_xml_get_widget(xml, "new_engine"),
			    "activate", G_CALLBACK(self_new_engine), self);
		g_signal_connect(selfp->close_engine_item = glade_xml_get_widget(
					xml, "close_engine"),
			    "activate", G_CALLBACK(self_close_engine_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "open"),
			    "activate", G_CALLBACK(self_open_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "opendir"),
			    "activate", G_CALLBACK(self_opendir_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "audio_cd"),
			    "activate", G_CALLBACK(self_audio_cd_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "dvd"),
			    "activate", G_CALLBACK(self_dvd_activate_cb), self);
		g_signal_connect(selfp->play_item = glade_xml_get_widget(xml, "play"),
			    "activate", G_CALLBACK(self_play_activate_cb), self);
		g_signal_connect(selfp->stop_item = glade_xml_get_widget(xml, "stop"),
			    "activate", G_CALLBACK(self_stop_activate_cb), self);
		g_signal_connect(selfp->next_item = glade_xml_get_widget(xml, "next"),
			    "activate", G_CALLBACK(self_next_activate_cb), self);
		g_signal_connect(selfp->prev_item = glade_xml_get_widget(xml, "prev"),
			    "activate", G_CALLBACK(self_prev_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "help"),
			    "activate", G_CALLBACK(self_help_activate_cb), self);
		g_object_unref(G_OBJECT(xml));

		evbox = gtk_event_box_new ();
		g_signal_connect (G_OBJECT (evbox), "button_press_event",
			G_CALLBACK (self_tray_icon_press_cb), (gpointer) self);
		g_signal_connect (G_OBJECT (evbox), "button_release_event",
			G_CALLBACK (self_tray_icon_release_cb), (gpointer) self);
		gtk_container_add (GTK_CONTAINER (evbox), image);
		gtk_container_add (GTK_CONTAINER (selfp->tray_icon), evbox);
		gtk_widget_show_all (GTK_WIDGET(selfp->tray_icon));
		g_signal_connect (G_OBJECT (selfp->tray_icon), "destroy-event",
			G_CALLBACK (self_tray_destroyed), self);

		g_signal_connect(G_OBJECT(selfp->tray_icon), "drag-data-received",
				G_CALLBACK(self_drag_data_received_cb), self);
		gtk_drag_dest_set(GTK_WIDGET(selfp->tray_icon),
				GTK_DEST_DEFAULT_ALL,
				target_table, G_N_ELEMENTS (target_table),
				GDK_ACTION_COPY);
	}}
#line 1228 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 668 "lum-shell.gob"
static bool 
lum_shell_tray_destroyed (GtkWidget * widget, GdkEvent * event, Self * self)
#line 1234 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::tray_destroyed"
#line 668 "lum-shell.gob"
	g_return_val_if_fail (!(self) || IS_SELF (self), (bool )0);
#line 1239 "lum-shell.c"
{
#line 668 "lum-shell.gob"
	
		if(selfp->config->tray_icon){
			g_object_unref(widget);
			gtk_widget_destroy(selfp->popup_menu);
			g_idle_add((GSourceFunc) self_init_tray, self);
		}
		return true;
	}}
#line 1250 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 680 "lum-shell.gob"
static void 
lum_shell_prefs_activate_cb (GtkAction * action, gpointer data)
#line 1256 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::prefs_activate_cb"
{
#line 680 "lum-shell.gob"
	
		Self *self = SELF(data);
		self_show_prefs(self);
	}}
#line 1265 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 685 "lum-shell.gob"
static void 
lum_shell_about_activate_cb (GtkAction * action, gpointer data)
#line 1271 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::about_activate_cb"
{
#line 685 "lum-shell.gob"
	
		Self *self = SELF(data);
		self_show_about(self);
	}}
#line 1280 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 694 "lum-shell.gob"
static void 
lum_shell_help_activate_cb (GtkAction * action, gpointer data)
#line 1286 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::help_activate_cb"
{
#line 694 "lum-shell.gob"
	
		GError *error = NULL;
		GtkWidget *dialog;

		gnome_help_display ("lumiere.xml", NULL, &error);
		if (error) {
			dialog = gtk_message_dialog_new (NULL,
					GTK_DIALOG_MODAL, 
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK,
					_("Cannot display help."));
			gtk_message_dialog_format_secondary_text(
					GTK_MESSAGE_DIALOG(dialog),
					error->message);
			g_signal_connect (G_OBJECT (dialog), "response",
				  G_CALLBACK (gtk_widget_destroy), NULL);
			gtk_widget_show (dialog);
			g_error_free (error);
		}
	}}
#line 1311 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 718 "lum-shell.gob"
static void 
lum_shell_quit (LumShell * self)
#line 1317 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::quit"
#line 718 "lum-shell.gob"
	g_return_if_fail (self != NULL);
#line 718 "lum-shell.gob"
	g_return_if_fail (LUM_IS_SHELL (self));
#line 1324 "lum-shell.c"
{
#line 718 "lum-shell.gob"
	
 		LumSession *session = self_get_session(self);
		lum_session_close(session);
		GList *l, *engines;
		engines = g_list_copy (selfp->engines);
		for (l = engines; l != NULL; l = l->next) {
			g_object_unref(G_OBJECT(l->data));
		}
		g_list_free(engines);
		if(selfp->server_mode)
			self_set_server_mode(self, false);
	}}
#line 1339 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 732 "lum-shell.gob"
static void 
lum_shell_close_engine_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1345 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::close_engine_activate_cb"
{
#line 732 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_close(engine);
	}}
#line 1356 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 739 "lum-shell.gob"
static void 
lum_shell_open_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1362 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::open_activate_cb"
{
#line 739 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = g_object_new(LUM_TYPE_ENGINE, NULL);
		lum_engine_show_fileselector(engine);
	}}
#line 1374 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 747 "lum-shell.gob"
static void 
lum_shell_opendir_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1380 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::opendir_activate_cb"
{
#line 747 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = g_object_new(LUM_TYPE_ENGINE, NULL);
		lum_engine_show_directoryselector(engine);
	}}
#line 1392 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 755 "lum-shell.gob"
static void 
lum_shell_audio_cd_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1398 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::audio_cd_activate_cb"
{
#line 755 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = g_object_new(LUM_TYPE_ENGINE, NULL);
		lum_engine_open_cdda(engine);
	}}
#line 1410 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 763 "lum-shell.gob"
static void 
lum_shell_dvd_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1416 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::dvd_activate_cb"
{
#line 763 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = g_object_new(LUM_TYPE_ENGINE, NULL);
		lum_engine_open_dvd(engine);
	}}
#line 1428 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 771 "lum-shell.gob"
static void 
lum_shell_play_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1434 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::play_activate_cb"
{
#line 771 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_pause(engine);
	}}
#line 1445 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 777 "lum-shell.gob"
static void 
lum_shell_stop_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1451 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::stop_activate_cb"
{
#line 777 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_stop(engine);
	}}
#line 1462 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 784 "lum-shell.gob"
static void 
lum_shell_next_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1468 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::next_activate_cb"
{
#line 784 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_next(engine);
	}}
#line 1479 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 790 "lum-shell.gob"
static void 
lum_shell_prev_activate_cb (GtkMenuItem * menuitem, gpointer data)
#line 1485 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::prev_activate_cb"
{
#line 790 "lum-shell.gob"
	
		Self *self = SELF(data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine != NULL)
			lum_engine_prev(engine);
	}}
#line 1496 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 800 "lum-shell.gob"
static bool 
lum_shell_tray_icon_release_cb (GtkWidget * widget, GdkEventButton * event, Self * self)
#line 1502 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::tray_icon_release_cb"
#line 800 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 800 "lum-shell.gob"
	g_return_val_if_fail (IS_SELF (self), (bool )0);
#line 1509 "lum-shell.c"
{
#line 801 "lum-shell.gob"
	
		if (event->button == 3){
			gtk_menu_popdown (GTK_MENU(selfp->popup_menu));
			return false;
		} else if (event->button == 1){
			GList *list = selfp->engines;
			for(; list; list = list->next)
				lum_engine_iconify(LUM_ENGINE(list->data));
			return false;
		}

		return true;
	}}
#line 1525 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 815 "lum-shell.gob"
static bool 
lum_shell_tray_icon_press_cb (GtkWidget * widget, GdkEventButton * event, Self * self)
#line 1531 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::tray_icon_press_cb"
#line 815 "lum-shell.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 815 "lum-shell.gob"
	g_return_val_if_fail (IS_SELF (self), (bool )0);
#line 1538 "lum-shell.c"
{
#line 816 "lum-shell.gob"
	
		if (event->button == 3){
			LumEngine *engine = self_get_active_engine(self);
			GList *list = NULL;
			if(!engine || !(list = lum_engine_get_list(engine))){
				gtk_widget_hide(selfp->play_item);
				gtk_widget_hide(selfp->stop_item);
				gtk_widget_hide(selfp->next_item);
				gtk_widget_hide(selfp->prev_item);
				if(!engine)
					gtk_widget_hide(selfp->close_engine_item);
				else
					gtk_widget_show(selfp->close_engine_item);
			} else {
				gtk_widget_show(selfp->close_engine_item);
				gtk_widget_show(selfp->play_item);
				gtk_widget_show(selfp->stop_item);
				if(!list || g_list_length(list) < 2){
					gtk_widget_hide(selfp->next_item);
					gtk_widget_hide(selfp->prev_item);
				} else {
					gtk_widget_show(selfp->next_item);
					gtk_widget_show(selfp->prev_item);
				}
			}
			gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, event->button, event->time);
			return true;
		}
		if (event->button == 2){
			lum_engine_pause(self_get_active_engine(self));
			return true;
		}
		return false;
	}}
#line 1577 "lum-shell.c"
#undef __GOB_FUNCTION__

#line 856 "lum-shell.gob"
static void 
lum_shell_drag_data_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, gpointer user_data)
#line 1583 "lum-shell.c"
{
#define __GOB_FUNCTION__ "Lum:Shell::drag_data_received_cb"
{
#line 859 "lum-shell.gob"
	
		Self *self = SELF(user_data);
		LumEngine *engine = self_get_active_engine(self);
		if(engine == NULL)
			engine = g_object_new(LUM_TYPE_ENGINE, NULL);
		lum_engine_drag_received(engine, context, data, time);
	}}
#line 1595 "lum-shell.c"
#undef __GOB_FUNCTION__
