/* Generated by GOB (v2.0.11) on Sat Apr 16 19:56:21 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-skin-textbox.gob"

/***************************************************************************
                   lum-skin-textbox.gob  -  Lumiere Skin textbox  
                             -------------------
    begin                : lun oct 24 02:08:47 CET 2003
    copyright            : (C) 2003 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.8 $
 * $Date: 2004/10/22 13:58:26 $
 *
 */

#line 36 "lum-skin-textbox.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-skin-textbox.h"

#include "lum-skin-textbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 39 "lum-skin-textbox.gob"

#include <ctype.h>

#line 61 "lum-skin-textbox.c"
static const GEnumValue _lum_skin_textboxtype_values[] = {
	{ TXTB_RATE, (char *)"TXTB_RATE", (char *)"rate" },
	{ TXTB_FREQ, (char *)"TXTB_FREQ", (char *)"freq" },
	{ TXTB_MIN, (char *)"TXTB_MIN", (char *)"min" },
	{ TXTB_SEC, (char *)"TXTB_SEC", (char *)"sec" },
	{ 0, NULL, NULL }
};

GType
lum_skin_textboxtype_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumSkinTextboxType", _lum_skin_textboxtype_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_SKIN_TEXTBOX(x)
#define SELF_CONST(x) LUM_SKIN_TEXTBOX_CONST(x)
#define IS_SELF(x) LUM_IS_SKIN_TEXTBOX(x)
#define TYPE_SELF LUM_TYPE_SKIN_TEXTBOX
#define SELF_CLASS(x) LUM_SKIN_TEXTBOX_CLASS(x)

#define SELF_GET_CLASS(x) LUM_SKIN_TEXTBOX_GET_CLASS(x)

/* self typedefs */
typedef LumSkinTextbox Self;
typedef LumSkinTextboxClass SelfClass;

/* here are local prototypes */
static void lum_skin_textbox_init (LumSkinTextbox * o) G_GNUC_UNUSED;
static void lum_skin_textbox_class_init (LumSkinTextboxClass * c) G_GNUC_UNUSED;
static void ___2_lum_skin_textbox_dispose (GObject * object) G_GNUC_UNUSED;
static void ___3_lum_skin_textbox_finalize (GObject * object) G_GNUC_UNUSED;
static void ___4_lum_skin_textbox_draw (LumSkinWidget * widget) G_GNUC_UNUSED;
static bool lum_skin_textbox_scroll (LumSkinTextbox * self) G_GNUC_UNUSED;
static void ___6_lum_skin_textbox_button_press_cb (LumSkinWidget * widget, GdkEventButton * event) G_GNUC_UNUSED;
static void ___7_lum_skin_textbox_motion_cb (LumSkinWidget * widget, GdkEventMotion * event) G_GNUC_UNUSED;
static void ___8_lum_skin_textbox_button_release_cb (LumSkinWidget * widget, GdkEventButton * event) G_GNUC_UNUSED;
static bool lum_skin_textbox_should_scroll (LumSkinTextbox * self) G_GNUC_UNUSED;
static void lum_skin_textbox_generate_xfont_pixmap (LumSkinTextbox * self, gchar * pixmaptext) G_GNUC_UNUSED;
static void lum_skin_textbox_handle_special_char (char c, int * x, int * y) G_GNUC_UNUSED;
static void lum_skin_textbox_generate_pixmap (LumSkinTextbox * self) G_GNUC_UNUSED;
static bool lum_skin_textbox_text_get_extents (LumSkinTextbox * self, const gchar * fontname, const gchar * text, gint * width, gint * height, gint * ascent, gint * descent) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static LumSkinWidgetClass *parent_class = NULL;

/* Short form macros */
#define self_new lum_skin_textbox_new
#define self_scroll lum_skin_textbox_scroll
#define self_should_scroll lum_skin_textbox_should_scroll
#define self_set_text lum_skin_textbox_set_text
#define self_generate_xfont_pixmap lum_skin_textbox_generate_xfont_pixmap
#define self_handle_special_char lum_skin_textbox_handle_special_char
#define self_generate_pixmap lum_skin_textbox_generate_pixmap
#define self_set_scroll lum_skin_textbox_set_scroll
#define self_set_xfont lum_skin_textbox_set_xfont
#define self_text_get_extents lum_skin_textbox_text_get_extents
GType
lum_skin_textbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumSkinTextboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_skin_textbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumSkinTextbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_skin_textbox_init,
			NULL
		};

		type = g_type_register_static (LUM_TYPE_SKIN_WIDGET, "LumSkinTextbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumSkinTextbox *)g_object_new(lum_skin_textbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumSkinTextbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumSkinTextbox *
GET_NEW_VARG (const char *first, ...)
{
	LumSkinTextbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumSkinTextbox *)g_object_new_valist (lum_skin_textbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::dispose"
	LumSkinTextbox *self G_GNUC_UNUSED = LUM_SKIN_TEXTBOX (obj_self);
#line 91 "lum-skin-textbox.gob"
	___2_lum_skin_textbox_dispose(obj_self);
#line 172 "lum-skin-textbox.c"
#line 68 "lum-skin-textbox.gob"
	if(self->pixmap) { g_object_unref ((gpointer) self->pixmap); self->pixmap = NULL; }
#line 175 "lum-skin-textbox.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::finalize"
	LumSkinTextbox *self G_GNUC_UNUSED = LUM_SKIN_TEXTBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 100 "lum-skin-textbox.gob"
	___3_lum_skin_textbox_finalize(obj_self);
#line 188 "lum-skin-textbox.c"
#line 51 "lum-skin-textbox.gob"
	if(self->text) { g_free ((gpointer) self->text); self->text = NULL; }
#line 191 "lum-skin-textbox.c"
#line 52 "lum-skin-textbox.gob"
	if(self->pixmap_text) { g_free ((gpointer) self->pixmap_text); self->pixmap_text = NULL; }
#line 194 "lum-skin-textbox.c"
#line 53 "lum-skin-textbox.gob"
	if(self->fontname) { g_free ((gpointer) self->fontname); self->fontname = NULL; }
#line 197 "lum-skin-textbox.c"
}
#undef __GOB_FUNCTION__

static void 
lum_skin_textbox_init (LumSkinTextbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,LumSkinTextboxPrivate);
#line 39 "lum-skin-textbox.gob"
	o->text = NULL;
#line 208 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->pixmap_text = NULL;
#line 211 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->fontname = NULL;
#line 214 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->pixmap_width = 0;
#line 217 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->offset = 0;
#line 220 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->drag_x = 0;
#line 223 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->drag_off = 0;
#line 226 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->nominal_y = 0;
#line 229 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->nominal_height = 0;
#line 232 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->skin_id = 0;
#line 235 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->font_descent = 0;
#line 238 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->font_ascent = 0;
#line 241 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->scroll_allowed = false;
#line 244 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->scroll_enabled = false;
#line 247 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->is_scrollable = false;
#line 250 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->is_dragging = false;
#line 253 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->font = NULL;
#line 256 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->pixmap = NULL;
#line 259 "lum-skin-textbox.c"
#line 39 "lum-skin-textbox.gob"
	o->_priv->timeout_tag = false;
#line 262 "lum-skin-textbox.c"
}
#undef __GOB_FUNCTION__
static void 
lum_skin_textbox_class_init (LumSkinTextboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	LumSkinWidgetClass *lum_skin_widget_class = (LumSkinWidgetClass *)c;

	g_type_class_add_private(c,sizeof(LumSkinTextboxPrivate));

	parent_class = g_type_class_ref (LUM_TYPE_SKIN_WIDGET);

#line 91 "lum-skin-textbox.gob"
	g_object_class->dispose = ___dispose;
#line 100 "lum-skin-textbox.gob"
	g_object_class->finalize = ___finalize;
#line 109 "lum-skin-textbox.gob"
	lum_skin_widget_class->draw = ___4_lum_skin_textbox_draw;
#line 166 "lum-skin-textbox.gob"
	lum_skin_widget_class->button_press_cb = ___6_lum_skin_textbox_button_press_cb;
#line 183 "lum-skin-textbox.gob"
	lum_skin_widget_class->motion_cb = ___7_lum_skin_textbox_motion_cb;
#line 202 "lum-skin-textbox.gob"
	lum_skin_widget_class->button_release_cb = ___8_lum_skin_textbox_button_release_cb;
#line 288 "lum-skin-textbox.c"
}
#undef __GOB_FUNCTION__



#line 71 "lum-skin-textbox.gob"
LumSkinTextbox * 
lum_skin_textbox_new (LumSkin * skin, gint x, gint y, gint w, bool scroll_allowed, LumSkinPixmap * spixmap)
#line 297 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::new"
#line 71 "lum-skin-textbox.gob"
	g_return_val_if_fail (skin != NULL, (LumSkinTextbox * )0);
#line 71 "lum-skin-textbox.gob"
	g_return_val_if_fail (LUM_IS_SKIN (skin), (LumSkinTextbox * )0);
#line 304 "lum-skin-textbox.c"
{
#line 73 "lum-skin-textbox.gob"
	
		Self *self = GET_NEW;
		LUM_SKIN_WIDGET(self)->skin = skin;
		LUM_SKIN_WIDGET(self)->skin_pixmap = spixmap;
		LUM_SKIN_WIDGET(self)->pixmap = g_object_ref(skin->bg);
		LUM_SKIN_WIDGET(self)->gc = g_object_ref(skin->gc);
		LUM_SKIN_WIDGET(self)->x = x;
		LUM_SKIN_WIDGET(self)->y = y;
		LUM_SKIN_WIDGET(self)->width = w;
		LUM_SKIN_WIDGET(self)->height = 6;
		self->scroll_allowed = scroll_allowed;
		self->scroll_enabled = true;
		self->nominal_y = y;
		self->nominal_height = LUM_SKIN_WIDGET(self)->height;
		
		return self;
	}}
#line 324 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 91 "lum-skin-textbox.gob"
static void 
___2_lum_skin_textbox_dispose (GObject * object G_GNUC_UNUSED)
#line 330 "lum-skin-textbox.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::dispose"
#line 91 "lum-skin-textbox.gob"
	g_return_if_fail (object != NULL);
#line 91 "lum-skin-textbox.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 340 "lum-skin-textbox.c"
{
#line 91 "lum-skin-textbox.gob"
	
		Self *self = SELF(object);
		if(selfp->timeout_tag){
			g_source_remove(selfp->timeout_tag);
			selfp->timeout_tag = false;
		}
		PARENT_HANDLER(object);
	}}
#line 351 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 100 "lum-skin-textbox.gob"
static void 
___3_lum_skin_textbox_finalize (GObject * object G_GNUC_UNUSED)
#line 358 "lum-skin-textbox.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::finalize"
#line 100 "lum-skin-textbox.gob"
	g_return_if_fail (object != NULL);
#line 100 "lum-skin-textbox.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 368 "lum-skin-textbox.c"
{
#line 100 "lum-skin-textbox.gob"
	
		Self *self = SELF(object);
		if(self->font){
			pango_font_description_free(self->font);
			self->font = NULL;
		}
		PARENT_HANDLER(object);
	}}
#line 379 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 109 "lum-skin-textbox.gob"
static void 
___4_lum_skin_textbox_draw (LumSkinWidget * widget G_GNUC_UNUSED)
#line 386 "lum-skin-textbox.c"
#define PARENT_HANDLER(___widget) \
	{ if(LUM_SKIN_WIDGET_CLASS(parent_class)->draw) \
		(* LUM_SKIN_WIDGET_CLASS(parent_class)->draw)(___widget); }
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::draw"
{
#line 109 "lum-skin-textbox.gob"
	
		Self *self = SELF(widget);
		gint cw;

		if (self->text && 
				(!self->pixmap_text || strcmp(self->text, self->pixmap_text)))
			self_generate_pixmap(self);

		if (self->pixmap){
			cw = self->pixmap_width - self->offset;

			if (cw > widget->width)
				cw = widget->width;
			gdk_draw_drawable(GDK_DRAWABLE(widget->pixmap), widget->gc,
					self->pixmap, self->offset, 0,
					widget->x, widget->y, cw, widget->height);

			if (cw < widget->width)
				gdk_draw_drawable(GDK_DRAWABLE(widget->pixmap),
					widget->gc, self->pixmap, 0, 0,
					widget->x + cw, widget->y, widget->width - cw,
					widget->height);
	
			if (lum_skin_get_doublesize(widget->skin)) {
				GdkImage *img, *img2;

				img = gdk_drawable_get_image(
						widget->skin->bg, widget->x, widget->y,
						widget->width, widget->height);
				img2 = lum_skin_get_doublesize_img(img);
				gdk_draw_image(widget->skin->bg_ds, widget->gc,
				       img2, 0, 0, widget->x << 1, widget->y << 1,
				       widget->width << 1, widget->height << 1);
				g_object_unref(img);
				g_object_unref(img2);
				gdk_window_clear_area_e(GTK_WIDGET(widget->skin)->window,
						widget->x << 1, widget->y << 1,
						widget->width << 1, widget->height << 1);

			} else {
				gdk_window_clear_area_e(GTK_WIDGET(widget->skin)->window,
					widget->x, widget->y, widget->width, widget->height);
			}
			gdk_flush();
		}
	}}
#line 440 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 156 "lum-skin-textbox.gob"
static bool 
lum_skin_textbox_scroll (LumSkinTextbox * self)
#line 447 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::scroll"
#line 156 "lum-skin-textbox.gob"
	g_return_val_if_fail (self != NULL, (bool )false);
#line 156 "lum-skin-textbox.gob"
	g_return_val_if_fail (LUM_IS_SKIN_TEXTBOX (self), (bool )false);
#line 454 "lum-skin-textbox.c"
{
#line 156 "lum-skin-textbox.gob"
	
		if (!self->is_dragging) {
			self->offset++;
			if (self->offset >= self->pixmap_width)
				self->offset -= self->pixmap_width;
			lum_skin_widget_draw(LUM_SKIN_WIDGET(self));
		}
		return true;
	}}
#line 466 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 166 "lum-skin-textbox.gob"
static void 
___6_lum_skin_textbox_button_press_cb (LumSkinWidget * widget G_GNUC_UNUSED, GdkEventButton * event)
#line 472 "lum-skin-textbox.c"
#define PARENT_HANDLER(___widget,___event) \
	{ if(LUM_SKIN_WIDGET_CLASS(parent_class)->button_press_cb) \
		(* LUM_SKIN_WIDGET_CLASS(parent_class)->button_press_cb)(___widget,___event); }
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::button_press_cb"
#line 166 "lum-skin-textbox.gob"
	g_return_if_fail (widget != NULL);
#line 480 "lum-skin-textbox.c"
{
#line 168 "lum-skin-textbox.gob"
	
		LumSkinTextbox *self = LUM_SKIN_TEXTBOX(widget);

		if (event->button != 1)
			return;
		if (self->scroll_allowed && self->pixmap_width > widget->width &&
				self->is_scrollable) {
			self->is_dragging = true;
			self->drag_off = self->offset;
			self->drag_x = event->x;
		}

		PARENT_HANDLER(widget, event);
	}}
#line 497 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 183 "lum-skin-textbox.gob"
static void 
___7_lum_skin_textbox_motion_cb (LumSkinWidget * widget G_GNUC_UNUSED, GdkEventMotion * event)
#line 504 "lum-skin-textbox.c"
#define PARENT_HANDLER(___widget,___event) \
	{ if(LUM_SKIN_WIDGET_CLASS(parent_class)->motion_cb) \
		(* LUM_SKIN_WIDGET_CLASS(parent_class)->motion_cb)(___widget,___event); }
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::motion_cb"
#line 183 "lum-skin-textbox.gob"
	g_return_if_fail (widget != NULL);
#line 183 "lum-skin-textbox.gob"
	g_return_if_fail (LUM_IS_SKIN_WIDGET (widget));
#line 514 "lum-skin-textbox.c"
{
#line 185 "lum-skin-textbox.gob"
	
		Self *self = SELF(widget);

		if (self->is_dragging){
			if (self->scroll_allowed &&
					self->pixmap_width > widget->width){
				self->offset = self->drag_off - (event->x - self->drag_x);
				while (self->offset < 0)
					self->offset += self->pixmap_width;
				while (self->offset > self->pixmap_width)
					self->offset -= self->pixmap_width;
			}
		}

		PARENT_HANDLER(widget, event);
	}}
#line 533 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 202 "lum-skin-textbox.gob"
static void 
___8_lum_skin_textbox_button_release_cb (LumSkinWidget * widget G_GNUC_UNUSED, GdkEventButton * event)
#line 540 "lum-skin-textbox.c"
#define PARENT_HANDLER(___widget,___event) \
	{ if(LUM_SKIN_WIDGET_CLASS(parent_class)->button_release_cb) \
		(* LUM_SKIN_WIDGET_CLASS(parent_class)->button_release_cb)(___widget,___event); }
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::button_release_cb"
#line 202 "lum-skin-textbox.gob"
	g_return_if_fail (widget != NULL);
#line 202 "lum-skin-textbox.gob"
	g_return_if_fail (LUM_IS_SKIN_WIDGET (widget));
#line 550 "lum-skin-textbox.c"
{
#line 204 "lum-skin-textbox.gob"
	
		Self *self = SELF(widget);

		if (event->button == 1)
			self->is_dragging = false;
		
		PARENT_HANDLER(widget, event);
	}}
#line 561 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 213 "lum-skin-textbox.gob"
static bool 
lum_skin_textbox_should_scroll (LumSkinTextbox * self)
#line 568 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::should_scroll"
#line 213 "lum-skin-textbox.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 213 "lum-skin-textbox.gob"
	g_return_val_if_fail (LUM_IS_SKIN_TEXTBOX (self), (bool )0);
#line 575 "lum-skin-textbox.c"
{
#line 213 "lum-skin-textbox.gob"
	
		if (!self->scroll_allowed)
			return false;

		if (self->font){
			gint width;
			self_text_get_extents(self, self->fontname,self->text,
					&width,NULL, NULL, NULL);
			    
			if (width <= LUM_SKIN_WIDGET(self)->width)
				return false;
			else
				return true;
		}

		if (g_utf8_strlen(self->text, -1) * 5 > LUM_SKIN_WIDGET(self)->width)
			return true;

		return false;
	}}
#line 598 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 234 "lum-skin-textbox.gob"
void 
lum_skin_textbox_set_text (LumSkinTextbox * self, const gchar * text)
#line 604 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::set_text"
#line 234 "lum-skin-textbox.gob"
	g_return_if_fail (self != NULL);
#line 234 "lum-skin-textbox.gob"
	g_return_if_fail (LUM_IS_SKIN_TEXTBOX (self));
#line 611 "lum-skin-textbox.c"
{
#line 234 "lum-skin-textbox.gob"
	
		if (self->text){
			if (!strcmp(text, self->text))
				return;
			g_free(self->text);
		}
		self->text = g_strdup(text);
		lum_skin_widget_draw(LUM_SKIN_WIDGET(self));
	}}
#line 623 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 244 "lum-skin-textbox.gob"
static void 
lum_skin_textbox_generate_xfont_pixmap (LumSkinTextbox * self, gchar * pixmaptext)
#line 629 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::generate_xfont_pixmap"
#line 244 "lum-skin-textbox.gob"
	g_return_if_fail (self != NULL);
#line 244 "lum-skin-textbox.gob"
	g_return_if_fail (LUM_IS_SKIN_TEXTBOX (self));
#line 636 "lum-skin-textbox.c"
{
#line 244 "lum-skin-textbox.gob"
	
		gint length, i, width;
		GdkGC *gc, *maskgc;
		GdkColor *c, pattern;
		GdkBitmap *mask;
		PangoLayout * layout;

		length = strlen(pixmaptext);

		self_text_get_extents(self, self->fontname,pixmaptext,&width,NULL, NULL,NULL);
		self->pixmap_width = width;
	
		if (self->pixmap_width < LUM_SKIN_WIDGET(self)->width)
			self->pixmap_width = LUM_SKIN_WIDGET(self)->width;

		self->pixmap = gdk_pixmap_new(GTK_WIDGET(LUM_SKIN_WIDGET(
							self)->skin)->window, self->pixmap_width,
						LUM_SKIN_WIDGET(self)->height,
   						gdk_rgb_get_visual()->depth);

		gc = LUM_SKIN_WIDGET(self)->gc;
		c = lum_skin_get_skin_color(LUM_SKIN_WIDGET(self)->skin,SKIN_TEXTBG);
		for (i = 0; i < LUM_SKIN_WIDGET(self)->height; i++){
			gdk_gc_set_foreground(gc, &c[6 * i / LUM_SKIN_WIDGET(self)->height]);
			gdk_draw_line(self->pixmap, gc, 0, i, self->pixmap_width, i);
		}

		mask = gdk_pixmap_new(GTK_WIDGET(LUM_SKIN_WIDGET(
							self)->skin)->window, self->pixmap_width,
				LUM_SKIN_WIDGET(self)->height, 1);
	
		maskgc = gdk_gc_new(mask);
		pattern.pixel = 0;
		gdk_gc_set_foreground(maskgc, &pattern);
		gdk_draw_rectangle(mask, maskgc, true, 0, 0,
				   self->pixmap_width, LUM_SKIN_WIDGET(self)->height);
		pattern.pixel = 1;
		gdk_gc_set_foreground(maskgc, &pattern);
		gdk_gc_set_foreground(gc, lum_skin_get_skin_color(
					LUM_SKIN_WIDGET(self)->skin,SKIN_TEXTFG));
		layout = gtk_widget_create_pango_layout(GTK_WIDGET(LUM_SKIN_WIDGET(
							self)->skin),pixmaptext);
		pango_layout_set_font_description (layout, self->font); 
		gdk_draw_layout(self->pixmap, gc, 0, (self->font_descent/2),layout);
		g_object_unref(layout);
		g_object_unref(maskgc);

		gdk_gc_set_clip_mask(gc, mask);
		c = lum_skin_get_skin_color(LUM_SKIN_WIDGET(self)->skin,SKIN_TEXTFG);
		for (i = 0; i < LUM_SKIN_WIDGET(self)->height; i++) {
			gdk_gc_set_foreground(gc, &c[6 * i / LUM_SKIN_WIDGET(self)->height]);
			gdk_draw_line(self->pixmap, gc, 0, i, self->pixmap_width, i);
		}
		g_object_unref(mask);
		gdk_gc_set_clip_mask(gc, NULL);
	}}
#line 695 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 301 "lum-skin-textbox.gob"
static void 
lum_skin_textbox_handle_special_char (char c, int * x, int * y)
#line 701 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::handle_special_char"
{
#line 301 "lum-skin-textbox.gob"
	
		switch (c)
		{
			case '"':
				*x = 130;
				*y = 0;
				break;
			case ':':
				*x = 60;
				*y = 6;
				break;
			case '(':
				*x = 65;
				*y = 6;
				break;
			case ')':
				*x = 70;
				*y = 6;
				break;
			case '-':
				*x = 75;
				*y = 6;
				break;
			case '`':
			case '\'':
				*x = 80;
				*y = 6;
				break;
			case '!':
				*x = 85;
				*y = 6;
				break;
			case '_':
				*x = 90;
				*y = 6;
				break;
			case '+':
				*x = 95;
				*y = 6;
				break;
			case '\\':
				*x = 100;
				*y = 6;
				break;
			case '/':
				*x = 105;
				*y = 6;
				break;
			case '[':
				*x = 110;
				*y = 6;
				break;
			case ']':
				*x = 115;
				*y = 6;
				break;
			case '^':
				*x = 120;
				*y = 6;
				break;
			case '&':
				*x = 125;
				*y = 6;
				break;
			case '%':
				*x = 130;
				*y = 6;
				break;
			case '.':
			case ',':
				*x = 135;
				*y = 6;
				break;
			case '=':
				*x = 140;
				*y = 6;
				break;
			case '$':
				*x = 145;
				*y = 6;
				break;
			case '#':
				*x = 150;
				*y = 6;
				break;
			case '?':
				*x = 15;
				*y = 12;
				break;
			case '*':
				*x = 20;
				*y = 12;
				break;
			default:
				*x = 145;
				*y = 0;
				break;
		}
	}}
#line 805 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 401 "lum-skin-textbox.gob"
static void 
lum_skin_textbox_generate_pixmap (LumSkinTextbox * self)
#line 811 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::generate_pixmap"
#line 401 "lum-skin-textbox.gob"
	g_return_if_fail (self != NULL);
#line 401 "lum-skin-textbox.gob"
	g_return_if_fail (LUM_IS_SKIN_TEXTBOX (self));
#line 818 "lum-skin-textbox.c"
{
#line 401 "lum-skin-textbox.gob"
	
		gint length, i, x, y, wl;
		gchar *pixmaptext;
		GdkGC *gc;

		if (self->pixmap)
			g_object_unref(self->pixmap);
		self->pixmap = NULL;

		if (!(self->pixmap_text && strrchr(self->text, '(') &&
				!strncmp(self->pixmap_text, self->text,
				strrchr(self->text, '(') - self->text)))
			self->offset = 0;

		g_free(self->pixmap_text);
		self->pixmap_text = g_strdup(self->text);

		wl = LUM_SKIN_WIDGET(self)->width / 5;
		if (wl * 5 != LUM_SKIN_WIDGET(self)->width)
			wl++;

		length = strlen(self->text);
	
		self->is_scrollable = false;

		if (self_should_scroll(self))	{
			self->is_scrollable = true;
			pixmaptext = g_strconcat(self->pixmap_text, "  ***  ", NULL);
			length += 7;
		} else if (!self->font && length <= wl) {
			gint pad = wl - length;
			char *padchars = g_strnfill(pad, ' ');

			pixmaptext = g_strconcat(self->pixmap_text, padchars , NULL);
			g_free(padchars);
			length += pad;		
		} else
			pixmaptext = g_strdup(self->pixmap_text);

		if (self->is_scrollable){
			if (self->scroll_enabled && !selfp->timeout_tag){
				int tag = 200;
				selfp->timeout_tag =
					g_timeout_add(tag, (GtkFunction) (self_scroll),
							(gpointer) self);
			} else if (!self->scroll_enabled && selfp->timeout_tag){
				g_source_remove(selfp->timeout_tag);
				selfp->timeout_tag = false;
			}
		} else {
			if (selfp->timeout_tag)
			{
				g_source_remove(selfp->timeout_tag);
				selfp->timeout_tag = false;
			}
			self->offset = 0;
		}

		if (self->font)
		{
			self_generate_xfont_pixmap(self, pixmaptext);
			g_free(pixmaptext);
			return;
		}

		self->pixmap_width = length * 5;

		self->pixmap = gdk_pixmap_new(GTK_WIDGET(
						LUM_SKIN_WIDGET(self)->skin)->window,
				       self->pixmap_width, 6,
				       gdk_rgb_get_visual()->depth);

		gc = LUM_SKIN_WIDGET(self)->gc;

		for (i = 0; i < length; i++) {
			char c;
			x = y = -1;
			c = toupper(pixmaptext[i]);
			if (c >= 'A' && c <= 'Z')
			{
				x = 5 * (c - 'A');
				y = 0;
			} else if (c >= '0' && c <= '9') {
				x = 5 * (c - '0');
				y = 6;
			} else {
				self_handle_special_char(c, &x, &y);
			}

			lum_skin_widget_draw_pixmap(LUM_SKIN_WIDGET(self),
				 x, y, i * 5, 0, 5, 6);
		}
		g_free(pixmaptext);
	}}
#line 915 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 496 "lum-skin-textbox.gob"
void 
lum_skin_textbox_set_scroll (LumSkinTextbox * self, bool s)
#line 921 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::set_scroll"
#line 496 "lum-skin-textbox.gob"
	g_return_if_fail (self != NULL);
#line 496 "lum-skin-textbox.gob"
	g_return_if_fail (LUM_IS_SKIN_TEXTBOX (self));
#line 928 "lum-skin-textbox.c"
{
#line 496 "lum-skin-textbox.gob"
	
		self->scroll_enabled = s;
		if (self->scroll_enabled && self->is_scrollable && self->scroll_allowed){
			if(!selfp->timeout_tag)
				selfp->timeout_tag = g_timeout_add(100,
						(GtkFunction) self_scroll, self);
		} else {
			if (selfp->timeout_tag){
				g_source_remove(selfp->timeout_tag);
				selfp->timeout_tag = false;
			}
			self->offset = 0;
			lum_skin_widget_draw(LUM_SKIN_WIDGET(self));
		}
	}}
#line 946 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 512 "lum-skin-textbox.gob"
void 
lum_skin_textbox_set_xfont (LumSkinTextbox * self, bool use_xfont, gchar * fontname)
#line 952 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::set_xfont"
#line 512 "lum-skin-textbox.gob"
	g_return_if_fail (self != NULL);
#line 512 "lum-skin-textbox.gob"
	g_return_if_fail (LUM_IS_SKIN_TEXTBOX (self));
#line 959 "lum-skin-textbox.c"
{
#line 512 "lum-skin-textbox.gob"
	
		self->font = NULL;
		LUM_SKIN_WIDGET(self)->y = self->nominal_y;
		LUM_SKIN_WIDGET(self)->height = self->nominal_height;
	
		g_free(self->pixmap_text);
		self->pixmap_text = NULL;
	
		if (!use_xfont || strlen(fontname) == 0)
			return;
		
		self->font = pango_font_description_from_string (fontname);
		self->fontname = fontname;

		self_text_get_extents(self, fontname,
				"AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz ",
				NULL,NULL, &self->font_ascent, &self->font_descent);
		
		if(self->font == NULL)
			return;

		LUM_SKIN_WIDGET(self)->height = self->font_ascent;
		if (LUM_SKIN_WIDGET(self)->height > self->nominal_height)
			LUM_SKIN_WIDGET(self)->y -= (LUM_SKIN_WIDGET(self)->height - 
			self->nominal_height) / 2;
		else
			LUM_SKIN_WIDGET(self)->height = self->nominal_height;
	}}
#line 990 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__

#line 542 "lum-skin-textbox.gob"
static bool 
lum_skin_textbox_text_get_extents (LumSkinTextbox * self, const gchar * fontname, const gchar * text, gint * width, gint * height, gint * ascent, gint * descent)
#line 996 "lum-skin-textbox.c"
{
#define __GOB_FUNCTION__ "Lum:Skin:Textbox::text_get_extents"
#line 542 "lum-skin-textbox.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 542 "lum-skin-textbox.gob"
	g_return_val_if_fail (LUM_IS_SKIN_TEXTBOX (self), (bool )0);
#line 1003 "lum-skin-textbox.c"
{
#line 547 "lum-skin-textbox.gob"
	
		PangoFontDescription *font_desc;
	    	PangoLayout * layout;
	    	PangoRectangle rect;
		/*  PangoContext         *context;
		 *    PangoLayout          *layout;
		 *      PangoRectangle        rect;
		 *      */
		
	   	g_return_val_if_fail (fontname != NULL, false);
	   	g_return_val_if_fail (text != NULL, false);
		
	   	/* FIXME: resolution */
		//  context = pango_ft2_get_context (72.0, 72.0);
		//  layout = pango_layout_new(pango_context_new());
		layout = gtk_widget_create_pango_layout(GTK_WIDGET(
					LUM_SKIN_WIDGET(self)->skin),text);
		//  g_object_unref (context);  

		font_desc = pango_font_description_from_string (fontname);
		pango_layout_set_font_description (layout, font_desc);
		pango_font_description_free (font_desc);
		//  pango_layout_set_text (layout, text, -1);
		pango_layout_get_pixel_extents (layout, NULL, &rect);

		if (width)
 			*width = rect.width;
		if (height)
			*height = rect.height;

		if (ascent || descent){
    			PangoLayoutIter *iter;
    			PangoLayoutLine *line;
			
    			iter = pango_layout_get_iter (layout);
    			line = pango_layout_iter_get_line (iter);
    			pango_layout_iter_free (iter);
			pango_layout_line_get_pixel_extents (line, NULL, &rect);
		
			if (ascent)
	  			*ascent = PANGO_ASCENT (rect);
    			if (descent)
	  			*descent = - PANGO_DESCENT (rect);
 		}
   		g_object_unref (layout);
   		return true;
	}}
#line 1053 "lum-skin-textbox.c"
#undef __GOB_FUNCTION__
