#include <bonobo/Bonobo.h>
#include <bonobo/bonobo-main.h>
#include <bonobo/bonobo-widget.h>
#include <gtk/gtk.h>
#include <stdlib.h>

int main(int argc, char **argv){
	if(!bonobo_activation_is_initialized())
		bonobo_activation_init(argc, argv);

	bonobo_init(&argc, argv);
	bonobo_debug_init();
	gtk_init(&argc, &argv);

	for(int i = 1; i < argc; i++){
		GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		GtkWidget *widget;
		CORBA_Environment ev;
		CORBA_Object o = bonobo_activation_activate_from_id(
					"OAFIID:GNOME_Lum_Control", 0,
					 NULL, &ev);
		if(o){
			widget = bonobo_widget_new_control_from_objref(
						o, CORBA_OBJECT_NIL);
			gtk_widget_show(widget);
			gtk_container_add(GTK_CONTAINER(window), widget);
			gtk_widget_show(window);
			g_signal_connect(G_OBJECT(window), "delete-event",
				G_CALLBACK(gtk_widget_destroy), window);
			CORBA_Object file = bonobo_object_query_remote(
						o,"IDL:Bonobo/PersistFile:1.0", &ev);
			if(file)
				Bonobo_PersistFile_load(file, argv[i], &ev);
		} else {
			g_warning("Could not find GNOME_Lum_Control");
			return EXIT_FAILURE;
		}
	}

	bonobo_main();

	return EXIT_SUCCESS;

}
