#! /usr/bin/env python
# -*- coding: utf-8 -*-
#####################       A U T H O R       ##########################
#                                                                      #
#   Copyright 2010 Jack Desert                                         #
#   <jackdesert556@gmail.com>                                          #
#   <http://www.LetsEATalready.com>                                    #
#                                                                      #
######################      L I C E N S E     ##########################
#                                                                      #
#   This file is part of LyXBlogger.                                   #
#                                                                      #
#   LyXBlogger is free software: you can redistribute it and/or modify #
#   it under the terms of the GNU General Public License as published  #
#   by the Free Software Foundation, either version 3 of the License,  #
#   or (at your option) any later version.                             #
#                                                                      #
#   LyXBlogger is distributed in the hope that it will be useful,      #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of     #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      #
#   GNU General Public License for more details.                       #
#                                                                      #
#   You should have received a copy of the GNU General Public License  #
#   along with LyXBlogger.  If not, see <http://www.gnu.org/licenses>. #
#                                                                      #
########################################################################

# Code to test image.py

import sys
import unittest
from image import get_image_dir
from image import find_image_tag
from image import get_image_url



class ImageTestCase(unittest.TestCase):

    def setUp(self):
        pass
    def test_md5_sums(self):
        # Only run this test if using Python 2.5 or later, which
        # Supports hashlib.
        req_version = (2,5)
        cur_version = sys.version_info
        if(cur_version >= req_version):
            import hashlib
            dict = {'test_files/basic_blog.html' : '37a59a98632e969d2e7e18dba0b54e23',
                'test_files/basic_blog.xhtml' : '3d7c816c4048a4a97a71d6581d7ea384'}
            for in_file, md5sum in dict.iteritems():
                computed =  hashlib.md5(file(in_file).read()).hexdigest()
                self.assertEqual(computed, md5sum)
        else:
            print("Skipping md5sum tests because hashlib is not available in the version of Python.")
            print (sys.version_info)


    def test_get_image_dir(self):
        dict = {'/hi_there/file.txt' : '/hi_there/',
            '/once/there/was/a/dog.txt' : '/once/there/was/a/',
            'no_leading_slash/once.txt' : 'no_leading_slash/',
            '/what/about\backslashes.txt' : '/what/'}
        for input, output in dict.iteritems():
            self.assertEqual(get_image_dir(input), output)

    def test_find_image_tag(self):
        dict = {'test_files/basic_blog.html' : True,
            'test_files/basic_blog.xhtml' : False}
        for in_file, ELYXER_ENGINE in dict.iteritems():
            # Read data from file
            f = open(in_file, 'r')
            html = f.read()
            f.close()
            for counter in range(2):
                tag = find_image_tag(html, ELYXER_ENGINE)
                self.assertTrue(tag)
                # Remove the tag and make sure it's gone
                html = html.replace(tag, '')
                self.assertFalse(tag in html)
            # Third image is nonexistent
            tag = find_image_tag(html, ELYXER_ENGINE)
            self.assertFalse(tag)
    def test_get_image_url(self):
        dict = {'''<img src='some_url' alt='none' />''' : ('some_url', False),
            '''<img alt = ni src='helloáthere'>''' : ('helloáthere', False),
            '''<blah~ src="been there" /> ''': ('been there', True)}
        for tag, url in dict.iteritems():
            found_url = get_image_url(tag, url[1])
            self.assertEqual(found_url, url[0])
            self.assertTrue(len(found_url) > 0)




if __name__ == '__main__':
    unittest.main()

