/*  Plzip - A parallel version of the lzip data compressor
    Copyright (C) 2009 Laszlo Ersek.
    Copyright (C) 2009 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

void show_error( const char * msg, const int errcode = 0, const bool help = false ) throw();
extern void *(*mallocf)(size_t size);
extern void (*freef)(void *ptr);


struct Cond
{
  pthread_mutex_t lock; /* Lock this to protect shared resource. */
  pthread_cond_t cond;  /* Trigger this if predicate becomes true. */
  long unsigned ccount, /* Increment this when checking predicate. */
      wcount;           /* Increment this when waiting is necessary. */
};


/* Terminate the process with EXIT_FAILURE. */
void
fatal(void);

/* Format operation and append resolved error, then call fatal(). */
void
fail(const char *fmt, int err, ...)
#ifdef __GNUC__
__attribute__((format(printf, 1, 3)))
#endif
;

/* If these primitives fail, they call fail(), which in turn calls fatal(). */
void *
xalloc(size_t size);

void
xinit(Cond *cond);

void
xdestroy(Cond *cond);

void
xlock(Cond *cond);

void
xlock_pred(Cond *cond);

void
xunlock(Cond *cond);

void
xwait(Cond *cond);

void
xsignal(Cond *cond);

void
xbroadcast(Cond *cond);

void
xcreate(pthread_t *thread, void *(*routine)(void *), void *arg);

void
xjoin(pthread_t thread);

void
xraise(int sig);
