/*  Tarlz - Archiver with multimember lzip compression
    Copyright (C) 2013-2019 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#define _FILE_OFFSET_BITS 64

#include <climits>
#include <cstdlib>
#include <cstring>
#include <string>
#include <vector>
#include <fnmatch.h>
#include <pthread.h>
#include <stdint.h>

#include "tarlz.h"


namespace Exclude {

std::vector< std::string > patterns;		// list of patterns

} // end namespace Exclude


void Exclude::add_pattern( const std::string & arg )
  { patterns.push_back( arg ); }


bool Exclude::excluded( const char * const filename )
  {
  if( patterns.empty() ) return false;
  const char * p = filename;
  while( *p )
    {
    for( unsigned i = 0; i < patterns.size(); ++i )
      if( fnmatch( patterns[i].c_str(), p, FNM_LEADING_DIR ) == 0 ) return true;
    while( *p && *p != '/' ) ++p;		// skip component
    while( *p == '/' ) ++p;			// skip slashes
    }
  return false;
  }
