/*
 * mail-to-news-light-i.c  ---  Light mail to news gateway - interface.
 *
 * Copyright (C)  2004  Marco Parrone
 *
 * $Id: mail-to-news-light-i.c,v 1.2 2004/03/18 02:41:30 marco_p Exp $
 * Keywords: news, mail, gate, gateway
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Commentary:
 *
 * mail-to-news-light is a light mail to news gateway.
 *
 * This is the code to setup what's needed by mail-to-news-light.asm
 * and to interface to the user and to the network.
 *
 * Code:
 */

#include <unistd.h>
#include <fcntl.h>
#include <malloc.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define WRITE_ERROR "mail-to-news-light: write error.\n"
#define WRITE_ERROR_LENGTH 33

#define READ_ERROR "mail-to-news-light: read error.\n"
#define READ_ERROR_LENGTH 32

char **headers_to_strip;

int mail_to_news (char *newsgroup, int sock);

char ** splithts (char *headers_to_strip)
{
  int count = 1;
  char **items = malloc (400);

  items [0] = strtok (headers_to_strip, ":");
  if (items [0] == NULL)
    return items;
  
  for (; count < 100; count++)
    {
      items [count] = strtok (NULL, ":");
      if (items [count] == NULL)
	return items;
    }

  if (count == 100)
    {
      write (2, "mail-to-news-light: too many headers to strip. Max is 100. Exiting.\n", 69);
      exit (1);
    }

  return items;
}

int to_strip_p (char *header)
{
  int i;

  for (i = 0; headers_to_strip [i] != NULL; i++)
    {
      if (! strcmp (header, headers_to_strip [i]))
	  return 1;
    }

  return 0;
}

int main (int argc, char *argv [])
{
  int sock;
  char buf [] = { 0, 0, 0, 0};
  char trash;
  struct sockaddr_in servername;
  struct hostent *hostinfo;
  int sock_mode;

  if (argc != 5)
    {
      write (2, "usage: mail-to-news-light HEADERSTOSTRIP1:HEADERTOSTRIP2:... NEWSGROUP HOST PORT\n", 81);
      return 1;
    }

  headers_to_strip = splithts (argv [1]);

  sock = socket (PF_INET, SOCK_STREAM, 0);

  if (sock < 0)
    {
      write (2, "mail-to-news-light: connection error.\n", 38);
      return 1;
    }

  servername.sin_family = AF_INET;
  servername.sin_port = htons (atoi (argv [4]));
  hostinfo = gethostbyname (argv [3]);

  if (hostinfo == NULL)
    {
      write (2, "mail-to-news-light: host unknown.\n", 34);
      return 1;
    }

  servername.sin_addr = *(struct in_addr *) hostinfo->h_addr;

  if (connect (sock, (struct sockaddr *) &servername, sizeof (servername)) < 0)
    {
      write (2, "mail-to-news-light: connection error.\n", 38);
      return 1;
    }

  sock_mode = fcntl (sock, F_GETFL, 0);

  read (sock, buf, 3);

  /* trash the rest the server reply */
  fcntl (sock, F_SETFL, O_NONBLOCK | sock_mode);
  while (read (sock, &trash, 1) == 1);
  fcntl (sock, F_SETFL, sock_mode);

  if (write (sock, "post\r\n", 6) == -1)
    {
      write (2, WRITE_ERROR, WRITE_ERROR_LENGTH);
      return 1;
    }

  if (read (sock, buf, 3) == -1)
    {
      write (2, READ_ERROR, READ_ERROR_LENGTH);
      return 1;
    }

  if (strcmp (buf, "340") != 0)
    {
      write (2, "mail-to-news-light: error, cannot post: ", 40);
      write (2, buf, 3);
      fcntl (sock, F_SETFL, O_NONBLOCK | sock_mode);
      while (read (sock, buf, 1) == 1)
	write (2, buf, 1);
      fcntl (sock, F_SETFL, sock_mode);
      write (2, "\n", 1);
      return 1;
    }

  /* trash the rest the server reply */
  fcntl (sock, F_SETFL, O_NONBLOCK | sock_mode);
  while (read (sock, &trash, 1) == 1);
  fcntl (sock, F_SETFL, sock_mode);

  mail_to_news (argv [2], sock);

  if (write (sock, "\r\n.\r\n", 5) == -1)
    {
      write (2, WRITE_ERROR, WRITE_ERROR_LENGTH);
      return 1;
    }

  if (read (sock, buf, 3) == -1)
    {
      write (2, READ_ERROR, READ_ERROR_LENGTH);
      return 1;
    }
  
  if (strcmp (buf, "240") != 0)
    {
      write (2, "mail-to-news-light: error: post failed: ", 40);
      write (2, buf, 3);
      fcntl (sock, F_SETFL, O_NONBLOCK | sock_mode);
      while (read (sock, buf, 1) == 1)
	write (2, buf, 1);
      fcntl (sock, F_SETFL, sock_mode);
      write (2, "\n", 1);
      return 1;
    }

  if (write (sock, "quit\r\n", 6) == -1)
    {
      write (2, WRITE_ERROR, WRITE_ERROR_LENGTH);
      return 1;
    }

  close (sock);
  free (headers_to_strip);

  return 0;
}

/* mail-to-news-light-i.c ends here. */
