;;; mail-to-news-light.asm  ---  Light mail to news gateway.

;; Copyright (C)  2004  Marco Parrone.

;; $Id: mail-to-news-light.asm,v 1.2 2004/03/18 02:40:56 marco_p Exp $
;; Keywords: news, mail, gate, gateway

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;;; Commentary:

;; mail-to-news-light is a light mail to news gateway.

;; This is a stripped-down light version of mail-to-news rewritten in
;; NASM for GNU/Linux x86.

;;; Code:

section .rodata

header_to_add:		db 'Newsgroups: '
dotdot:			db '..'

read_error_msg		db 'mail-to-news-light: read error.',10
write_error_msg		db 'mail-to-news-light: write error.',10

section .data

buf1000i:		dw 0,0
prev:			db 0

section .bss

sock			resw 2
newsgroup		resw 2

buf:			resb 1
buf1000:		resb 1000

section .text

extern	read, write, strlen, to_strip_p, printf

global	mail_to_news:function

read_error:
	push 32
	push read_error_msg
	push 2
	call write
	pop ecx
	pop ecx
	pop ecx
	mov eax, dword 1
	jmp end

write_error:
	push 33
	push write_error_msg
	push 2
	call write
	pop ecx
	pop ecx
	pop ecx
	mov eax, dword 1
	jmp end

read_char:
	push dword 1
	push dword buf
	push dword 0
	call read
	pop ecx
	pop ecx
	pop ecx
	cmp eax, dword -1
	je read_error
	pop ecx
	jmp ecx

write_char:
	push dword 1
	push dword buf
	push dword [sock]
	call write
	pop ecx
	pop ecx
	pop ecx
	cmp eax, dword -1
	je write_error
	pop ecx
	jmp ecx

mail_to_news:
	pop edx
	pop ecx
	pop eax
	push eax
	push ecx
	push edx
	mov [newsgroup], ecx
	mov [sock], eax

remove_from:
	push dword 1
	push dword buf
	push dword 0
	call read
	call read
	call read
	call read
	pop ecx
	pop ecx
	pop ecx
	cmp eax, dword -1
	je read_error

	jmp header_skip

header_content:
	push header_content_2
	jmp read_char
header_content_2:
	push header_name_start
	cmp [buf], byte 10
	je write_char
	pop ecx
	push header_content
	jmp write_char

header_name_start:
	push header_name_start_2
	jmp read_char
header_name_start_2:
	push header_content
	cmp [buf], byte 32
	je write_char
	cmp [buf], byte 9
	je write_char
	pop ecx
	cmp [buf], byte 10
	jne header_name
	jmp header_add

header_name:
	mov ecx, [buf]
	mov eax, dword [buf1000i]
	mov [buf1000+eax], ecx
	add [buf1000i], dword 1
	cmp [buf], byte 58
	je header_name_end
	push header_name
	jmp read_char
header_name_end:
	mov ecx, [buf1000i]
	mov [buf1000+ecx-1], byte 0
	push dword buf1000
	call to_strip_p
	pop ecx
	cmp eax, dword 1
	je header_skip_0
	mov ecx, [buf1000i]
	mov [buf1000+ecx-1], byte 58
	push dword [buf1000i]
	push dword buf1000
	push dword [sock]
	call write
	pop ecx
	pop ecx
 	pop ecx
	cmp eax, dword -1
	je write_error
	mov [buf1000i], dword 0
	jmp header_content

header_skip_0:
	mov [buf1000i], dword 0
header_skip:
	push header_skip_2
	jmp read_char
header_skip_2:
	push header_skip_3
	cmp [buf], byte 10
	je read_char
	pop ecx
	jmp header_skip
header_skip_3:
	cmp [buf], byte 32
	je header_skip
	cmp [buf], byte 9
	je header_skip
	cmp [buf], byte 10
	je header_add
	jmp header_name	

header_add:
	push dword 12
	push header_to_add
	push dword [sock]
	call write
	pop ecx
	pop ecx
	pop ecx
	cmp eax, dword -1
	je write_error
header_add_2:
	push dword [newsgroup]
	call strlen
	pop ecx
	push eax
	push dword [newsgroup]
	push dword [sock]
	call write
	pop ecx
	pop ecx
	pop ecx
	cmp eax, dword -1
	je write_error
header_add_3:
	mov [buf], dword 10
	push header_add_4
	jmp write_char
header_add_4
	mov [buf], dword 10
	push header_add_5
	jmp write_char
header_add_5
	push body
	jmp read_char

body_read:
	push body
	jmp read_char
body:
	cmp eax, dword 0
	je body_tail
	cmp [buf], dword 46
	je body_double
body_write:
	mov eax, [buf]
	mov [prev], eax
	push body_read
	jmp write_char
body_double:
	cmp [prev], dword 10
	jne body_write
	mov eax, [buf]
	mov [prev], eax
	push dword 2
	push dword dotdot
	push dword [sock]
	call write
	pop ecx
	pop ecx
	pop ecx
	cmp eax, dword -1
	je write_error
	jmp body_read
body_tail:

all_good_so_far:
	mov eax, dword 0

end:
	ret

;;;; mail-to-news-light.asm ends here.
