/* Generated by GOB (v2.0.9) on Mon Aug 16 18:13:53 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox-view.h"

#include "mn-mailbox-view-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 22 "mn-mailbox-view.gob"

#include "config.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdkkeysyms.h>
#include "mn-util.h"
#include "mn-shell.h"
#include "mn-stock.h"
#include "mn-mailbox-properties-dialog.h"
#include "mn-conf.h"
#include "mn-dialog.h"
#include "mn-uri.h"

#define GNOME_COPIED_FILES		"x-special/gnome-copied-files"

  enum {
    COLUMN_URI,
    COLUMN_MAILBOX_ICON,
    COLUMN_MAILBOX,
    COLUMN_FORMAT,
    N_COLUMNS
  };

  static GtkClipboard *global_clipboard;
  static GdkAtom gnome_copied_files_atom;

#line 53 "mn-mailbox-view.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX_VIEW(x)
#define SELF_CONST(x) MN_MAILBOX_VIEW_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX_VIEW(x)
#define TYPE_SELF MN_TYPE_MAILBOX_VIEW
#define SELF_CLASS(x) MN_MAILBOX_VIEW_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_VIEW_GET_CLASS(x)

/* self typedefs */
typedef MNMailboxView Self;
typedef MNMailboxViewClass SelfClass;

/* here are local prototypes */
static void ___real_mn_mailbox_view_activate_add (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_remove (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_cut (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_copy (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_paste (MNMailboxView * self);
static void mn_mailbox_view_activate_paste_receive_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, gpointer data) G_GNUC_UNUSED;
static void ___real_mn_mailbox_view_activate_properties (MNMailboxView * self);
static void mn_mailbox_view_activate_properties_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_view_class_init (MNMailboxViewClass * class) G_GNUC_UNUSED;
static void mn_mailbox_view_init (MNMailboxView * self) G_GNUC_UNUSED;
static void ___b_mn_mailbox_view_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_mailbox_view_update (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_update_iter (MNMailboxView * self, GtkTreeIter * iter, MNMailbox * mailbox) G_GNUC_UNUSED;
static gboolean mn_mailbox_view_has_mailbox (MNMailboxView * self, MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_mailbox_view_update_sensitivity (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_remove_mailbox (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_remove_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_view_copy_mailbox (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_copy_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_view_get_clipboard_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, unsigned int info, gpointer user_data_or_owner) G_GNUC_UNUSED;
static void mn_mailbox_view_clear_clipboard_cb (GtkClipboard * clipboard, gpointer user_data_or_owner) G_GNUC_UNUSED;
static void mn_mailbox_view_select_all (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_properties_response_h (GtkDialog * dialog, int response, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_popup_menu (MNMailboxView * self, unsigned int button, guint32 activate_time) G_GNUC_UNUSED;
static void mn_mailbox_view_popup_menu_receive_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, gpointer data) G_GNUC_UNUSED;
static gboolean mn_mailbox_view_popup_menu_h (GtkWidget * widget, gpointer user_data) G_GNUC_UNUSED;
static gboolean mn_mailbox_view_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_row_activated_h (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, gpointer user_data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__activate_add(object,func,data)	mn_mailbox_view_connect__activate_add((object),(func),(data))
#define self_connect_after__activate_add(object,func,data)	mn_mailbox_view_connect_after__activate_add((object),(func),(data))
#define self_connect_data__activate_add(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_add((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_remove(object,func,data)	mn_mailbox_view_connect__activate_remove((object),(func),(data))
#define self_connect_after__activate_remove(object,func,data)	mn_mailbox_view_connect_after__activate_remove((object),(func),(data))
#define self_connect_data__activate_remove(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_remove((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_cut(object,func,data)	mn_mailbox_view_connect__activate_cut((object),(func),(data))
#define self_connect_after__activate_cut(object,func,data)	mn_mailbox_view_connect_after__activate_cut((object),(func),(data))
#define self_connect_data__activate_cut(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_cut((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_copy(object,func,data)	mn_mailbox_view_connect__activate_copy((object),(func),(data))
#define self_connect_after__activate_copy(object,func,data)	mn_mailbox_view_connect_after__activate_copy((object),(func),(data))
#define self_connect_data__activate_copy(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_copy((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_paste(object,func,data)	mn_mailbox_view_connect__activate_paste((object),(func),(data))
#define self_connect_after__activate_paste(object,func,data)	mn_mailbox_view_connect_after__activate_paste((object),(func),(data))
#define self_connect_data__activate_paste(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_paste((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_properties(object,func,data)	mn_mailbox_view_connect__activate_properties((object),(func),(data))
#define self_connect_after__activate_properties(object,func,data)	mn_mailbox_view_connect_after__activate_properties((object),(func),(data))
#define self_connect_data__activate_properties(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_properties((object),(func),(data),(destroy_data),(flags))

enum {
	ACTIVATE_ADD_SIGNAL,
	ACTIVATE_REMOVE_SIGNAL,
	ACTIVATE_CUT_SIGNAL,
	ACTIVATE_COPY_SIGNAL,
	ACTIVATE_PASTE_SIGNAL,
	ACTIVATE_PROPERTIES_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkTreeViewClass *parent_class = NULL;

/* Short form macros */
#define self_activate_add mn_mailbox_view_activate_add
#define self_activate_remove mn_mailbox_view_activate_remove
#define self_activate_cut mn_mailbox_view_activate_cut
#define self_activate_copy mn_mailbox_view_activate_copy
#define self_activate_paste mn_mailbox_view_activate_paste
#define self_activate_paste_receive_cb mn_mailbox_view_activate_paste_receive_cb
#define self_activate_properties mn_mailbox_view_activate_properties
#define self_activate_properties_cb mn_mailbox_view_activate_properties_cb
#define self_update mn_mailbox_view_update
#define self_update_iter mn_mailbox_view_update_iter
#define self_has_mailbox mn_mailbox_view_has_mailbox
#define self_update_sensitivity mn_mailbox_view_update_sensitivity
#define self_remove_mailbox mn_mailbox_view_remove_mailbox
#define self_remove_mailbox_cb mn_mailbox_view_remove_mailbox_cb
#define self_copy_mailbox mn_mailbox_view_copy_mailbox
#define self_copy_mailbox_cb mn_mailbox_view_copy_mailbox_cb
#define self_get_clipboard_cb mn_mailbox_view_get_clipboard_cb
#define self_clear_clipboard_cb mn_mailbox_view_clear_clipboard_cb
#define self_select_all mn_mailbox_view_select_all
#define self_properties_response_h mn_mailbox_view_properties_response_h
#define self_popup_menu mn_mailbox_view_popup_menu
#define self_popup_menu_receive_cb mn_mailbox_view_popup_menu_receive_cb
#define self_popup_menu_h mn_mailbox_view_popup_menu_h
#define self_button_press_event_h mn_mailbox_view_button_press_event_h
#define self_row_activated_h mn_mailbox_view_row_activated_h
#define self_new mn_mailbox_view_new
GType
mn_mailbox_view_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxViewClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_view_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailboxView),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_view_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_TREE_VIEW, "MNMailboxView", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailboxView *)g_object_new(mn_mailbox_view_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailboxView * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailboxView *
GET_NEW_VARG (const char *first, ...)
{
	MNMailboxView *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailboxView *)g_object_new_valist (mn_mailbox_view_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::finalize"
	MNMailboxView *self  G_GNUC_UNUSED = MN_MAILBOX_VIEW (obj_self);
	gpointer priv = self->_priv;
#line 322 "mn-mailbox-view.gob"
	___b_mn_mailbox_view_finalize(obj_self);
#line 212 "mn-mailbox-view.c"
#line 50 "mn-mailbox-view.gob"
	if(self->_priv->menu) { ((*(void (*)(void *))gtk_widget_destroy)) (self->_priv->menu); self->_priv->menu = NULL; }
#line 215 "mn-mailbox-view.c"
	g_free (priv);
}
#undef __GOB_FUNCTION__

#line 214 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_class_init (MNMailboxViewClass * class G_GNUC_UNUSED)
#line 223 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	parent_class = g_type_class_ref (GTK_TYPE_TREE_VIEW);

	object_signals[ACTIVATE_ADD_SIGNAL] =
		g_signal_new ("activate_add",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_add),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_REMOVE_SIGNAL] =
		g_signal_new ("activate_remove",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_remove),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_CUT_SIGNAL] =
		g_signal_new ("activate_cut",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_cut),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_COPY_SIGNAL] =
		g_signal_new ("activate_copy",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_copy),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PASTE_SIGNAL] =
		g_signal_new ("activate_paste",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_paste),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PROPERTIES_SIGNAL] =
		g_signal_new ("activate_properties",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_properties),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 57 "mn-mailbox-view.gob"
	class->activate_add = ___real_mn_mailbox_view_activate_add;
#line 102 "mn-mailbox-view.gob"
	class->activate_remove = ___real_mn_mailbox_view_activate_remove;
#line 108 "mn-mailbox-view.gob"
	class->activate_cut = ___real_mn_mailbox_view_activate_cut;
#line 115 "mn-mailbox-view.gob"
	class->activate_copy = ___real_mn_mailbox_view_activate_copy;
#line 121 "mn-mailbox-view.gob"
	class->activate_paste = ___real_mn_mailbox_view_activate_paste;
#line 179 "mn-mailbox-view.gob"
	class->activate_properties = ___real_mn_mailbox_view_activate_properties;
#line 322 "mn-mailbox-view.gob"
	g_object_class->finalize = ___finalize;
#line 293 "mn-mailbox-view.c"
 {
#line 215 "mn-mailbox-view.gob"

    GtkBindingSet *binding_set;

    global_clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
    gnome_copied_files_atom = gdk_atom_intern(GNOME_COPIED_FILES, FALSE);

    binding_set = gtk_binding_set_by_class(class);

    /* Delete removes a row */
    gtk_binding_entry_add_signal(binding_set, GDK_Delete, 0, "activate-remove", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Delete, 0, "activate-remove", 0);

    /* HIG 2.0 cut/copy/paste shortcuts */
    gtk_binding_entry_add_signal(binding_set, GDK_x, GDK_CONTROL_MASK, "activate-cut", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_c, GDK_CONTROL_MASK, "activate-copy", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_v, GDK_CONTROL_MASK, "activate-paste", 0);
    
    /* cut/copy/paste shortcuts taken from gtkentry.c */
    gtk_binding_entry_add_signal(binding_set, GDK_Delete, GDK_SHIFT_MASK, "activate-cut", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_Insert, GDK_CONTROL_MASK, "activate-copy", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_Insert, GDK_SHIFT_MASK, "activate-paste", 0);

    /* HIG 2.0 properties */
    gtk_binding_entry_add_signal(binding_set, GDK_Return, GDK_MOD1_MASK, "activate-properties", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, GDK_MOD1_MASK, "activate-properties", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, GDK_MOD1_MASK, "activate-properties", 0);
  
#line 323 "mn-mailbox-view.c"
 }
}
#undef __GOB_FUNCTION__
#line 243 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_init (MNMailboxView * self G_GNUC_UNUSED)
#line 330 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::init"
	self->_priv = g_new0 (MNMailboxViewPrivate, 1);
#line 50 "mn-mailbox-view.gob"
	self->_priv->menu = gtk_menu_new();
#line 336 "mn-mailbox-view.c"
 {
#line 244 "mn-mailbox-view.gob"

    GtkMenuShell *shell;
    GtkWidget *add_item;
    GtkWidget *select_all_item;
    GtkListStore *store;
    GtkTreeViewColumn *column;
    GtkCellRenderer *renderer;
    GtkTreeSelection *selection;

    shell = GTK_MENU_SHELL(selfp->menu);
    
    add_item = mn_menu_shell_append(shell, GTK_STOCK_ADD, NULL);
    selfp->remove_item = mn_menu_shell_append(shell, GTK_STOCK_REMOVE, NULL);
    mn_menu_shell_append(shell, NULL, NULL);
    selfp->cut_item = mn_menu_shell_append(shell, GTK_STOCK_CUT, NULL);
    selfp->copy_item = mn_menu_shell_append(shell, GTK_STOCK_COPY, NULL);
    selfp->paste_item = mn_menu_shell_append(shell, GTK_STOCK_PASTE, NULL);
    mn_menu_shell_append(shell, NULL, NULL);
    select_all_item = mn_menu_shell_append(shell, MN_STOCK_SELECT_ALL, NULL);
    mn_menu_shell_append(shell, NULL, NULL);
    selfp->properties_item = mn_menu_shell_append(shell, GTK_STOCK_PROPERTIES, NULL);
    
    g_signal_connect_swapped(G_OBJECT(add_item), "activate", G_CALLBACK(self_activate_add), self);
    g_signal_connect_swapped(G_OBJECT(selfp->remove_item), "activate", G_CALLBACK(self_activate_remove), self);
    g_signal_connect_swapped(G_OBJECT(selfp->cut_item), "activate", G_CALLBACK(self_activate_cut), self);
    g_signal_connect_swapped(G_OBJECT(selfp->copy_item), "activate", G_CALLBACK(self_activate_copy), self);
    g_signal_connect_swapped(G_OBJECT(selfp->paste_item), "activate", G_CALLBACK(self_activate_paste), self);
    g_signal_connect_swapped(G_OBJECT(select_all_item), "activate", G_CALLBACK(self_select_all), self);
    g_signal_connect_swapped(G_OBJECT(selfp->properties_item), "activate", G_CALLBACK(self_activate_properties), self);

    store = gtk_list_store_new(N_COLUMNS,
			       G_TYPE_STRING,
			       G_TYPE_STRING,
			       G_TYPE_STRING,
			       G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(self), GTK_TREE_MODEL(store));
    g_object_unref(store);
    
    column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(column, _("Mailbox"));
    gtk_tree_view_column_set_resizable(column, TRUE);
    gtk_tree_view_column_set_sort_column_id(column, COLUMN_MAILBOX);

    renderer = gtk_cell_renderer_pixbuf_new();
    gtk_tree_view_column_pack_start(column, renderer, FALSE);
    gtk_tree_view_column_add_attribute(column, renderer, "stock-id", COLUMN_MAILBOX_ICON);

    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(column, renderer, TRUE);
    gtk_tree_view_column_add_attribute(column, renderer, "text", COLUMN_MAILBOX);
    
    gtk_tree_view_append_column(GTK_TREE_VIEW(self), column);

    column = gtk_tree_view_column_new_with_attributes(_("Format"),
						      gtk_cell_renderer_text_new(),
						      "text", COLUMN_FORMAT,
						      NULL);

    gtk_tree_view_column_set_resizable(column, TRUE);
    gtk_tree_view_column_set_sort_column_id(column, COLUMN_FORMAT);
    gtk_tree_view_append_column(GTK_TREE_VIEW(self), column);

    gtk_tree_view_set_search_column(GTK_TREE_VIEW(self), COLUMN_MAILBOX);

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    
    self_update(self);
    self_update_sensitivity(self);

    g_signal_connect_swapped(G_OBJECT(mn_shell->mailboxes), "list-changed", G_CALLBACK(self_update), self);
    g_signal_connect_swapped(G_OBJECT(selection), "changed", G_CALLBACK(self_update_sensitivity), self);

    g_signal_connect(G_OBJECT(self), "popup-menu", G_CALLBACK(self_popup_menu_h), NULL);
    g_signal_connect(G_OBJECT(self), "button-press-event", G_CALLBACK(self_button_press_event_h), NULL);
    g_signal_connect(G_OBJECT(self), "row-activated", G_CALLBACK(self_row_activated_h), NULL);
  
#line 416 "mn-mailbox-view.c"
 }
}
#undef __GOB_FUNCTION__

#line 57 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_add (MNMailboxView * self)
#line 424 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 57 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 57 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 436 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_ADD_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 57 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_add (MNMailboxView * self G_GNUC_UNUSED)
#line 452 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_add"
{
#line 59 "mn-mailbox-view.gob"
	
    GtkWidget *toplevel;
    GtkWidget *dialog;

    toplevel = gtk_widget_get_toplevel(GTK_WIDGET(self));
    dialog = mn_mailbox_properties_dialog_new((GtkWindow *) toplevel, MN_MAILBOX_PROPERTIES_DIALOG_MODE_ADD);

  run:
    switch (gtk_dialog_run(GTK_DIALOG(dialog)))
      {
      case GTK_RESPONSE_HELP:
	mn_display_help("mailbox-properties");
	goto run;

      case GTK_RESPONSE_ACCEPT:
	{
	  char *uri;
	
	  uri = mn_mailbox_properties_dialog_get_uri(MN_MAILBOX_PROPERTIES_DIALOG(dialog));
	  g_return_if_fail(uri != NULL);
      
	  if (! mn_mailboxes_find(mn_shell->mailboxes, uri))
	    {
	      GSList *gconf_mailboxes;
	    
	      gconf_mailboxes = eel_gconf_get_string_list(MN_CONF_MAILBOXES);
	      gconf_mailboxes = g_slist_append(gconf_mailboxes, uri);
	      eel_gconf_set_string_list(MN_CONF_MAILBOXES, gconf_mailboxes);
	      mn_pointers_free(gconf_mailboxes);
	    }
	  else
	    {
	      mn_error_dialog(NULL, _("Unable to add mailbox"), _("The mailbox is already in the list."));
	      g_free(uri);
	      goto run;
	    }
	}
	break;
      }

    gtk_widget_destroy(dialog);
  }}
#line 499 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 102 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_remove (MNMailboxView * self)
#line 505 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 102 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 102 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 517 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_REMOVE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 102 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_remove (MNMailboxView * self G_GNUC_UNUSED)
#line 533 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_remove"
{
#line 104 "mn-mailbox-view.gob"
	
    self_remove_mailbox(self);
  }}
#line 541 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 108 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_cut (MNMailboxView * self)
#line 547 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 108 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 108 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 559 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_CUT_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 108 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_cut (MNMailboxView * self G_GNUC_UNUSED)
#line 575 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_cut"
{
#line 110 "mn-mailbox-view.gob"
	
    self_copy_mailbox(self);
    self_remove_mailbox(self);
  }}
#line 584 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 115 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_copy (MNMailboxView * self)
#line 590 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 115 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 115 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 602 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_COPY_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 115 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_copy (MNMailboxView * self G_GNUC_UNUSED)
#line 618 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_copy"
{
#line 117 "mn-mailbox-view.gob"
	
    self_copy_mailbox(self);
  }}
#line 626 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 121 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_paste (MNMailboxView * self)
#line 632 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 121 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 121 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 644 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PASTE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 121 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_paste (MNMailboxView * self G_GNUC_UNUSED)
#line 660 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_paste"
{
#line 123 "mn-mailbox-view.gob"
	
    gtk_clipboard_request_contents(global_clipboard,
				   gnome_copied_files_atom,
				   self_activate_paste_receive_cb,
				   NULL);
  }}
#line 671 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 130 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_activate_paste_receive_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, gpointer data)
#line 677 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_paste_receive_cb"
#line 130 "mn-mailbox-view.gob"
	g_return_if_fail (clipboard != NULL);
#line 130 "mn-mailbox-view.gob"
	g_return_if_fail (selection_data != NULL);
#line 684 "mn-mailbox-view.c"
{
#line 134 "mn-mailbox-view.gob"
	
    if (selection_data->type == gnome_copied_files_atom
	&& selection_data->format == 8
	&& selection_data->length > 0)
      {
	char *gnome_copied_files;
	gboolean status;
	MNGnomeCopiedFilesType type;
	GSList *uri_list;

	gnome_copied_files = g_strndup(selection_data->data, selection_data->length);
	status = mn_parse_gnome_copied_files(gnome_copied_files, &type, &uri_list);
	g_free(gnome_copied_files);

	if (status)
	  {
	    if (type == MN_GNOME_COPIED_FILES_COPY)
	      {
		GSList *new_mailboxes = NULL;
		GSList *l;
		
		MN_LIST_FOREACH(l, uri_list)
	          {
		    const char *uri = l->data;
		    
		    if (! mn_mailboxes_find(mn_shell->mailboxes, uri))
		      new_mailboxes = g_slist_append(new_mailboxes, g_strdup(uri));
		  }

		if (new_mailboxes)
		  {
		    GSList *gconf_mailboxes;
		    
		    gconf_mailboxes = eel_gconf_get_string_list(MN_CONF_MAILBOXES);
		    gconf_mailboxes = g_slist_concat(gconf_mailboxes, new_mailboxes);
		    eel_gconf_set_string_list(MN_CONF_MAILBOXES, gconf_mailboxes);
		    mn_pointers_free(gconf_mailboxes);
		  }
	      }

	    mn_pointers_free(uri_list);
	  }
      }
  }}
#line 731 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 179 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_properties (MNMailboxView * self)
#line 737 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 179 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 179 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 749 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PROPERTIES_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 179 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_properties (MNMailboxView * self G_GNUC_UNUSED)
#line 765 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_properties"
{
#line 181 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_activate_properties_cb, self);
  }}
#line 776 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 188 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_activate_properties_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 782 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_properties_cb"
#line 188 "mn-mailbox-view.gob"
	g_return_if_fail (model != NULL);
#line 188 "mn-mailbox-view.gob"
	g_return_if_fail (GTK_IS_TREE_MODEL (model));
#line 188 "mn-mailbox-view.gob"
	g_return_if_fail (path != NULL);
#line 188 "mn-mailbox-view.gob"
	g_return_if_fail (iter != NULL);
#line 188 "mn-mailbox-view.gob"
	g_return_if_fail (data != NULL);
#line 795 "mn-mailbox-view.c"
{
#line 193 "mn-mailbox-view.gob"
	
    Self *self = data;
    GtkWidget *toplevel;
    GtkWidget *dialog;
    char *uri;

    toplevel = gtk_widget_get_toplevel(GTK_WIDGET(self));
    dialog = mn_mailbox_properties_dialog_new((GtkWindow *) toplevel, MN_MAILBOX_PROPERTIES_DIALOG_MODE_EDIT);

    gtk_tree_model_get(model, iter, COLUMN_URI, &uri, -1);
    mn_mailbox_properties_dialog_set_uri(MN_MAILBOX_PROPERTIES_DIALOG(dialog), uri);
    g_free(uri);
    
    g_signal_connect(G_OBJECT(dialog),
		     "response",
		     G_CALLBACK(self_properties_response_h),
		     NULL);

    gtk_widget_show(dialog);
  }}
#line 818 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__



#line 322 "mn-mailbox-view.gob"
static void 
___b_mn_mailbox_view_finalize (GObject * object G_GNUC_UNUSED)
#line 826 "mn-mailbox-view.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::finalize"
#line 322 "mn-mailbox-view.gob"
	g_return_if_fail (object != NULL);
#line 322 "mn-mailbox-view.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 836 "mn-mailbox-view.c"
{
#line 324 "mn-mailbox-view.gob"
	
    g_signal_handlers_disconnect_by_func(mn_shell->mailboxes, self_update, object);
    PARENT_HANDLER(object);
  }}
#line 843 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 329 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_update (MNMailboxView * self)
#line 850 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::update"
#line 329 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 329 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 857 "mn-mailbox-view.c"
{
#line 331 "mn-mailbox-view.gob"
	
    GtkTreeModel *model;
    GtkTreeIter iter;
    gboolean valid;
    MNMailbox *mailbox;
    GSList *l;
      
    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));

    /* first step: remove or update old mailboxes */

    valid = gtk_tree_model_get_iter_first(model, &iter);
    while (valid)
      {
	char *uri;
      
	gtk_tree_model_get(model, &iter, COLUMN_URI, &uri, -1);
	mailbox = mn_mailboxes_find(mn_shell->mailboxes, uri);
	g_free(uri);
      
	if (mailbox)
	  {
	    self_update_iter(self, &iter, mailbox);
	    valid = gtk_tree_model_iter_next(model, &iter);
	  }
	else
	  valid = gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
      }
  
    /* second step: add new mailboxes */

    MN_LIST_FOREACH(l, mn_mailboxes_get(mn_shell->mailboxes))
      {
	mailbox = l->data;

	if (! self_has_mailbox(self, mailbox))
	{
	  gtk_list_store_append(GTK_LIST_STORE(model), &iter);
	  self_update_iter(self, &iter, mailbox);
	}
      }
  }}
#line 902 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 374 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_update_iter (MNMailboxView * self, GtkTreeIter * iter, MNMailbox * mailbox)
#line 908 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::update_iter"
#line 374 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 374 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 374 "mn-mailbox-view.gob"
	g_return_if_fail (iter != NULL);
#line 374 "mn-mailbox-view.gob"
	g_return_if_fail (mailbox != NULL);
#line 374 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 921 "mn-mailbox-view.c"
{
#line 378 "mn-mailbox-view.gob"
	
    MNMailboxClass *class;
    const char *uri;
    const char *system_uri;
    const char *stock_id;
    GtkTreeModel *model;

    class = MN_MAILBOX_GET_CLASS(mailbox);
    uri = mn_mailbox_get_uri(mailbox);
    system_uri = mn_uri_get_system_mailbox();
  
    if (system_uri && ! mn_uri_cmp(uri, system_uri))
      stock_id = MN_STOCK_SYSTEM_MAILBOX;
    else
    {
      if (class->stock_id)
	stock_id = class->stock_id;
      else
	stock_id = mn_uri_is_local(uri) ? MN_STOCK_LOCAL : MN_STOCK_REMOTE;
    }

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    gtk_list_store_set(GTK_LIST_STORE(model), iter,
		       COLUMN_URI, uri,
		       COLUMN_MAILBOX_ICON, stock_id,
		       COLUMN_MAILBOX, mn_mailbox_get_name(mailbox),
		       COLUMN_FORMAT, class->format,
		       -1);
  }}
#line 953 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 408 "mn-mailbox-view.gob"
static gboolean 
mn_mailbox_view_has_mailbox (MNMailboxView * self, MNMailbox * mailbox)
#line 959 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::has_mailbox"
#line 408 "mn-mailbox-view.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 408 "mn-mailbox-view.gob"
	g_return_val_if_fail (MN_IS_MAILBOX_VIEW (self), (gboolean )0);
#line 408 "mn-mailbox-view.gob"
	g_return_val_if_fail (mailbox != NULL, (gboolean )0);
#line 408 "mn-mailbox-view.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (gboolean )0);
#line 970 "mn-mailbox-view.c"
{
#line 410 "mn-mailbox-view.gob"
	
    const char *uri;
    GtkTreeModel *model;
    GtkTreeIter iter;
    gboolean valid;
    gboolean has = FALSE;

    uri = mn_mailbox_get_uri(mailbox);

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    valid = gtk_tree_model_get_iter_first(model, &iter);
    while (valid)
      {
	char *this_uri;
	
	gtk_tree_model_get(model, &iter, COLUMN_URI, &this_uri, -1);
	has = ! mn_uri_cmp(this_uri, uri);
	g_free(this_uri);

	if (has)
	  break;

	valid = gtk_tree_model_iter_next(model, &iter);
      }

    return has;
  }}
#line 1000 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 438 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_update_sensitivity (MNMailboxView * self)
#line 1006 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::update_sensitivity"
#line 438 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 438 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1013 "mn-mailbox-view.c"
{
#line 440 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;
    gboolean has_selection;
    
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    has_selection = gtk_tree_selection_count_selected_rows(selection) > 0;

    gtk_widget_set_sensitive(selfp->remove_item, has_selection);
    gtk_widget_set_sensitive(selfp->cut_item, has_selection);
    gtk_widget_set_sensitive(selfp->copy_item, has_selection);
    gtk_widget_set_sensitive(selfp->properties_item, has_selection);
  }}
#line 1028 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 453 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_remove_mailbox (MNMailboxView * self)
#line 1034 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::remove_mailbox"
#line 453 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 453 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1041 "mn-mailbox-view.c"
{
#line 455 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;
    GSList *gconf_mailboxes;
    
    gconf_mailboxes = eel_gconf_get_string_list(MN_CONF_MAILBOXES);
    
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_remove_mailbox_cb, &gconf_mailboxes);
    eel_gconf_set_string_list(MN_CONF_MAILBOXES, gconf_mailboxes);
    mn_pointers_free(gconf_mailboxes);
  }}
#line 1055 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 467 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_remove_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 1061 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::remove_mailbox_cb"
#line 467 "mn-mailbox-view.gob"
	g_return_if_fail (model != NULL);
#line 467 "mn-mailbox-view.gob"
	g_return_if_fail (GTK_IS_TREE_MODEL (model));
#line 467 "mn-mailbox-view.gob"
	g_return_if_fail (path != NULL);
#line 467 "mn-mailbox-view.gob"
	g_return_if_fail (iter != NULL);
#line 467 "mn-mailbox-view.gob"
	g_return_if_fail (data != NULL);
#line 1074 "mn-mailbox-view.c"
{
#line 472 "mn-mailbox-view.gob"
	
    GSList **gconf_mailboxes = data;
    char *uri;
    GSList *elem;
  
    gtk_tree_model_get(model, iter, COLUMN_URI, &uri, -1);

    /* remove all the mailboxes with that URI */
    while ((elem = g_slist_find_custom(*gconf_mailboxes, uri, (GCompareFunc) mn_uri_cmp)))
      {
	*gconf_mailboxes = g_slist_remove_link(*gconf_mailboxes, elem);
	g_free(elem->data);
	g_slist_free(elem);
      }

    g_free(uri);
  }}
#line 1094 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 490 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_copy_mailbox (MNMailboxView * self)
#line 1100 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::copy_mailbox"
#line 490 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 490 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1107 "mn-mailbox-view.c"
{
#line 492 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;
    GSList *uri_list = NULL;
    char *gnome_copied_files;
    const GtkTargetEntry target = { GNOME_COPIED_FILES, 0, 0 };
    gboolean status;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_copy_mailbox_cb, &uri_list);

    gnome_copied_files = mn_build_gnome_copied_files(MN_GNOME_COPIED_FILES_COPY, uri_list);
    mn_pointers_free(uri_list);

    status = gtk_clipboard_set_with_data(global_clipboard,
					 &target,
					 1,
					 self_get_clipboard_cb,
					 self_clear_clipboard_cb,
					 gnome_copied_files);
    g_return_if_fail(status == TRUE);
  }}
#line 1131 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 514 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_copy_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 1137 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::copy_mailbox_cb"
#line 514 "mn-mailbox-view.gob"
	g_return_if_fail (model != NULL);
#line 514 "mn-mailbox-view.gob"
	g_return_if_fail (GTK_IS_TREE_MODEL (model));
#line 514 "mn-mailbox-view.gob"
	g_return_if_fail (path != NULL);
#line 514 "mn-mailbox-view.gob"
	g_return_if_fail (iter != NULL);
#line 514 "mn-mailbox-view.gob"
	g_return_if_fail (data != NULL);
#line 1150 "mn-mailbox-view.c"
{
#line 519 "mn-mailbox-view.gob"
	
    GSList **uri_list = data;
    char *uri;

    gtk_tree_model_get(model, iter, COLUMN_URI, &uri, -1);
    *uri_list = g_slist_append(*uri_list, uri);
    /* uri is now owned by uri_list, do not free */
  }}
#line 1161 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 528 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_get_clipboard_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, unsigned int info, gpointer user_data_or_owner)
#line 1167 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::get_clipboard_cb"
#line 528 "mn-mailbox-view.gob"
	g_return_if_fail (clipboard != NULL);
#line 528 "mn-mailbox-view.gob"
	g_return_if_fail (selection_data != NULL);
#line 528 "mn-mailbox-view.gob"
	g_return_if_fail (user_data_or_owner != NULL);
#line 1176 "mn-mailbox-view.c"
{
#line 533 "mn-mailbox-view.gob"
	
    const char *gnome_copied_files = user_data_or_owner;
    gtk_selection_data_set(selection_data, gnome_copied_files_atom, 8, gnome_copied_files, strlen(gnome_copied_files));
  }}
#line 1183 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 538 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_clear_clipboard_cb (GtkClipboard * clipboard, gpointer user_data_or_owner)
#line 1189 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::clear_clipboard_cb"
#line 538 "mn-mailbox-view.gob"
	g_return_if_fail (clipboard != NULL);
#line 538 "mn-mailbox-view.gob"
	g_return_if_fail (user_data_or_owner != NULL);
#line 1196 "mn-mailbox-view.c"
{
#line 541 "mn-mailbox-view.gob"
	
    char *gnome_copied_files = user_data_or_owner;
    g_free(gnome_copied_files);
  }}
#line 1203 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 546 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_select_all (MNMailboxView * self)
#line 1209 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::select_all"
#line 546 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 546 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1216 "mn-mailbox-view.c"
{
#line 548 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;
    
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_select_all(selection);
  }}
#line 1225 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 555 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_properties_response_h (GtkDialog * dialog, int response, gpointer user_data)
#line 1231 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::properties_response_h"
#line 555 "mn-mailbox-view.gob"
	g_return_if_fail (dialog != NULL);
#line 555 "mn-mailbox-view.gob"
	g_return_if_fail (GTK_IS_DIALOG (dialog));
#line 1238 "mn-mailbox-view.c"
{
#line 559 "mn-mailbox-view.gob"
	
    if (response == GTK_RESPONSE_HELP)
      mn_display_help("mailbox-properties");
    else
      {
	if (response == GTK_RESPONSE_APPLY || response == GTK_RESPONSE_OK)
	  mn_mailbox_properties_dialog_apply(MN_MAILBOX_PROPERTIES_DIALOG(dialog));
	if (response == GTK_RESPONSE_CANCEL || response == GTK_RESPONSE_OK)
	  gtk_widget_destroy(GTK_WIDGET(dialog));
      }
  }}
#line 1252 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 571 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_popup_menu (MNMailboxView * self, unsigned int button, guint32 activate_time)
#line 1258 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::popup_menu"
#line 571 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 571 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1265 "mn-mailbox-view.c"
{
#line 573 "mn-mailbox-view.gob"
	
    gtk_clipboard_request_contents(global_clipboard,
				   gnome_copied_files_atom,
				   self_popup_menu_receive_cb,
				   self);
    gtk_menu_popup(GTK_MENU(selfp->menu), NULL, NULL, NULL, NULL, button, activate_time);
  }}
#line 1275 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 581 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_popup_menu_receive_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, gpointer data)
#line 1281 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::popup_menu_receive_cb"
#line 581 "mn-mailbox-view.gob"
	g_return_if_fail (clipboard != NULL);
#line 581 "mn-mailbox-view.gob"
	g_return_if_fail (selection_data != NULL);
#line 581 "mn-mailbox-view.gob"
	g_return_if_fail (data != NULL);
#line 1290 "mn-mailbox-view.c"
{
#line 585 "mn-mailbox-view.gob"
	
    Self *self = data;
    gboolean can_paste = FALSE;

    if (selection_data->type == gnome_copied_files_atom
	&& selection_data->format == 8
	&& selection_data->length > 0)
      {
	char *gnome_copied_files;
	gboolean status;
	MNGnomeCopiedFilesType type;
	GSList *uri_list;
	
	gnome_copied_files = g_strndup(selection_data->data, selection_data->length);
	status = mn_parse_gnome_copied_files(gnome_copied_files, &type, &uri_list);
	g_free(gnome_copied_files);

	if (status)
	  {
	    if (type == MN_GNOME_COPIED_FILES_COPY && uri_list)
	      can_paste = TRUE;
	    mn_pointers_free(uri_list);
	  }
      }

    gtk_widget_set_sensitive(selfp->paste_item, can_paste);
  }}
#line 1320 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 613 "mn-mailbox-view.gob"
static gboolean 
mn_mailbox_view_popup_menu_h (GtkWidget * widget, gpointer user_data)
#line 1326 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::popup_menu_h"
#line 613 "mn-mailbox-view.gob"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
#line 613 "mn-mailbox-view.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (widget), (gboolean )0);
#line 1333 "mn-mailbox-view.c"
{
#line 616 "mn-mailbox-view.gob"
	
    self_popup_menu(SELF(widget), 0, gtk_get_current_event_time());
    return TRUE;		/* a menu was activated */
  }}
#line 1340 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 621 "mn-mailbox-view.gob"
static gboolean 
mn_mailbox_view_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1346 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::button_press_event_h"
#line 621 "mn-mailbox-view.gob"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
#line 621 "mn-mailbox-view.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (widget), (gboolean )0);
#line 621 "mn-mailbox-view.gob"
	g_return_val_if_fail (event != NULL, (gboolean )0);
#line 1355 "mn-mailbox-view.c"
{
#line 625 "mn-mailbox-view.gob"
	
    if (event->button == 3)
      self_popup_menu(SELF(widget), event->button, event->time);
    
    return FALSE;			/* propagate event */
  }}
#line 1364 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 632 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_row_activated_h (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, gpointer user_data)
#line 1370 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::row_activated_h"
#line 632 "mn-mailbox-view.gob"
	g_return_if_fail (treeview != NULL);
#line 632 "mn-mailbox-view.gob"
	g_return_if_fail (GTK_IS_TREE_VIEW (treeview));
#line 632 "mn-mailbox-view.gob"
	g_return_if_fail (path != NULL);
#line 632 "mn-mailbox-view.gob"
	g_return_if_fail (column != NULL);
#line 632 "mn-mailbox-view.gob"
	g_return_if_fail (GTK_IS_TREE_VIEW_COLUMN (column));
#line 1383 "mn-mailbox-view.c"
{
#line 637 "mn-mailbox-view.gob"
	
    self_activate_properties(SELF(treeview));
  }}
#line 1389 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 641 "mn-mailbox-view.gob"
GtkWidget * 
mn_mailbox_view_new (void)
#line 1395 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::new"
{
#line 643 "mn-mailbox-view.gob"
	
    return GTK_WIDGET(GET_NEW);
  }}
#line 1403 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__
