/* Generated by GOB (v2.0.9) on Mon Aug 16 18:13:52 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include "mn-mbox-mailbox.h"

#include "mn-mbox-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "mn-mbox-mailbox.gob"

#include "config.h"
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "mn-mailbox-private.h"
#include "mn-vfs.h"

#line 34 "mn-mbox-mailbox.c"
/* self casting macros */
#define SELF(x) MN_MBOX_MAILBOX(x)
#define SELF_CONST(x) MN_MBOX_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_MBOX_MAILBOX(x)
#define TYPE_SELF MN_TYPE_MBOX_MAILBOX
#define SELF_CLASS(x) MN_MBOX_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MBOX_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNmboxMailbox Self;
typedef MNmboxMailboxClass SelfClass;

/* here are local prototypes */
static void mn_mbox_mailbox_init (MNmboxMailbox * o) G_GNUC_UNUSED;
static void mn_mbox_mailbox_class_init (MNmboxMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_mbox_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_mbox_mailbox_impl_is (MNMailbox * dummy, const char * uri) G_GNUC_UNUSED;
static void ___4_mn_mbox_mailbox_impl_threaded_check (MNMailbox * mailbox) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNMailboxClass *parent_class = NULL;

GType
mn_mbox_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNmboxMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mbox_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNmboxMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mbox_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_MAILBOX, "MNmboxMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNmboxMailbox *)g_object_new(mn_mbox_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNmboxMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNmboxMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNmboxMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNmboxMailbox *)g_object_new_valist (mn_mbox_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:mbox:Mailbox::finalize"
	MNmboxMailbox *self  G_GNUC_UNUSED = MN_MBOX_MAILBOX (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	g_free (priv);
}
#undef __GOB_FUNCTION__

static void 
mn_mbox_mailbox_init (MNmboxMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:mbox:Mailbox::init"
	o->_priv = g_new0 (MNmboxMailboxPrivate, 1);
}
#undef __GOB_FUNCTION__
#line 38 "mn-mbox-mailbox.gob"
static void 
mn_mbox_mailbox_class_init (MNmboxMailboxClass * class G_GNUC_UNUSED)
#line 123 "mn-mbox-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:mbox:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_MAILBOX);

#line 43 "mn-mbox-mailbox.gob"
	g_object_class->constructor = ___2_mn_mbox_mailbox_constructor;
#line 62 "mn-mbox-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_mbox_mailbox_impl_is;
#line 99 "mn-mbox-mailbox.gob"
	mn_mailbox_class->impl_threaded_check = ___4_mn_mbox_mailbox_impl_threaded_check;
#line 137 "mn-mbox-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 39 "mn-mbox-mailbox.gob"

    MN_MAILBOX_CLASS(class)->format = "mbox";
  
#line 144 "mn-mbox-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 43 "mn-mbox-mailbox.gob"
static GObject * 
___2_mn_mbox_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 154 "mn-mbox-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:mbox:Mailbox::constructor"
{
#line 45 "mn-mbox-mailbox.gob"
	
    GObject *object;
    MNMailbox *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = MN_MAILBOX(object);
    
    mn_mailbox_monitor(self,
		       mn_mailbox_get_uri(self),
		       GNOME_VFS_MONITOR_FILE,
		       MN_MAILBOX_MONITOR_EVENT_CHANGED
		       | MN_MAILBOX_MONITOR_EVENT_DELETED
		       | MN_MAILBOX_MONITOR_EVENT_CREATED);

    return object;
  }}
#line 179 "mn-mbox-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 62 "mn-mbox-mailbox.gob"
static gboolean 
___3_mn_mbox_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, const char * uri)
#line 186 "mn-mbox-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:mbox:Mailbox::impl_is"
#line 62 "mn-mbox-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 195 "mn-mbox-mailbox.c"
{
#line 64 "mn-mbox-mailbox.gob"
	
    GnomeVFSFileInfo *file_info;
    gboolean is = FALSE;
    
    file_info = gnome_vfs_file_info_new();
    if (gnome_vfs_get_file_info(uri, file_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS) == GNOME_VFS_OK
	&& file_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_TYPE
	&& file_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_SIZE
	&& file_info->type == GNOME_VFS_FILE_TYPE_REGULAR)
      {
	if (file_info->size == 0) /* can be an empty mbox */
	  is = TRUE;
	else
	  {
	    GnomeVFSHandle *handle;
	    
	    if (gnome_vfs_open(&handle, uri, GNOME_VFS_OPEN_READ) == GNOME_VFS_OK)
	      {
		char buf[5];
		GnomeVFSFileSize bytes_read;
		
		if (gnome_vfs_read(handle, buf, sizeof(buf), &bytes_read) == GNOME_VFS_OK
		    && bytes_read == sizeof(buf)
		    && ! strncmp(buf, "From ", sizeof(buf)))
		  is = TRUE;
		
		gnome_vfs_close(handle);
	      }
	  }
      }
    gnome_vfs_file_info_unref(file_info);
    
    return is;
  }}
#line 232 "mn-mbox-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 99 "mn-mbox-mailbox.gob"
static void 
___4_mn_mbox_mailbox_impl_threaded_check (MNMailbox * mailbox G_GNUC_UNUSED)
#line 239 "mn-mbox-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->impl_threaded_check) \
		(* MN_MAILBOX_CLASS(parent_class)->impl_threaded_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:mbox:Mailbox::impl_threaded_check"
#line 99 "mn-mbox-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 99 "mn-mbox-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 249 "mn-mbox-mailbox.c"
{
#line 101 "mn-mbox-mailbox.gob"
	
    Self *self = SELF(mailbox);
    const char *uri;
    gboolean check = TRUE;
    
    uri = mn_mailbox_get_uri(mailbox);
    
    if (! mn_mailbox_get_automatic(mailbox))
      {
	GnomeVFSFileInfo *file_info;

	/* we're polling, so check only if the mailbox has changed since our last check */

	file_info = gnome_vfs_file_info_new();
	if (gnome_vfs_get_file_info(uri, file_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS) == GNOME_VFS_OK)
	{
	  if (file_info->mtime == selfp->last_mtime)
	    check = FALSE;
	  else
	    selfp->last_mtime = file_info->mtime;
	}
	gnome_vfs_file_info_unref(file_info);
      }

    if (check)
      {
	GnomeVFSResult result;
	GnomeVFSHandle *handle;

	result = gnome_vfs_open(&handle, uri, GNOME_VFS_OPEN_READ);
	if (result == GNOME_VFS_OK)
	  {
	    MNVFSReadLineContext *context = NULL;
	    const char *line;
	    gboolean in_header = FALSE;
	    gboolean seen = TRUE;	/* empty mailboxes have no new mail */
	  
	    while ((result = mn_vfs_read_line(&context, handle, &line)) == GNOME_VFS_OK)
	      {
		if (! *line)
		  {
		    if (! seen)
		      break;
		    in_header = FALSE;
		  }
		else if (! strncmp(line, "From ", 5))
		  {
		    in_header = TRUE;
		    seen = FALSE;
		  }
		else if (in_header
			 && ! strncmp(line, "Status:", 7)
			 && (strchr(line, 'O') || strchr(line, 'R')))
		  seen = TRUE;
	      }
	    
	    mn_vfs_read_line_context_free(context);
	    gnome_vfs_close(handle);

	    GDK_THREADS_ENTER();

	    if (result == GNOME_VFS_OK || result == GNOME_VFS_ERROR_EOF)
	      mn_mailbox_set_has_new(mailbox, ! seen);
	    else
	      mn_mailbox_set_error(mailbox, _("error while reading mailbox: %s"), gnome_vfs_result_to_string(result));

	    gdk_flush();
	    GDK_THREADS_LEAVE();
	  }
	else
	  {
	    GDK_THREADS_ENTER();
	    mn_mailbox_set_error(mailbox, _("unable to open mailbox: %s"), gnome_vfs_result_to_string(result));
	    gdk_flush();
	    GDK_THREADS_LEAVE();
	  }
      }

    GDK_THREADS_ENTER();
    mn_mailbox_end_check(mailbox);
    gdk_flush();
    GDK_THREADS_LEAVE();
  }}
#line 335 "mn-mbox-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
