/* Generated by GOB (v2.0.9) on Thu Sep  9 01:42:01 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox.h"

#include "mn-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 44 "mn-mailbox.gob"

#include "config.h"
#include <glib/gi18n-lib.h>
#ifdef WITH_MBOX
#include "mn-mbox-mailbox.h"
#endif
#ifdef WITH_MH
#include "mn-mh-mailbox.h"
#endif
#ifdef WITH_MAILDIR
#include "mn-maildir-mailbox.h"
#endif
#ifdef WITH_POP3
#include "mn-pop3-mailbox.h"
#endif
#ifdef WITH_IMAP
#include "mn-imap-mailbox.h"
#endif
#ifdef WITH_SYLPHEED
#include "mn-sylpheed-mailbox.h"
#endif
#ifdef WITH_GMAIL
#include "mn-gmail-mailbox.h"
#endif
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-unsupported-mailbox.h"
#include "mn-conf.h"

typedef struct
{
  MNURI		*uri;
  void		(*callback)	(MNMailbox	*self,
				 gpointer	user_data);
  gpointer	user_data;
} NewInfo;

#line 65 "mn-mailbox.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX(x)
#define SELF_CONST(x) MN_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_MAILBOX
#define SELF_CLASS(x) MN_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNMailbox Self;
typedef MNMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_mailbox_init (MNMailbox * o) G_GNUC_UNUSED;
static void mn_mailbox_class_init (MNMailboxClass * c) G_GNUC_UNUSED;
static gpointer mn_mailbox_new_async_thread (gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data) G_GNUC_UNUSED;
static gboolean mn_mailbox_impl_is (MNMailbox * self, MNURI * uri) G_GNUC_UNUSED;
static void mn_mailbox_impl_check (MNMailbox * self) G_GNUC_UNUSED;
static void mn_mailbox_impl_threaded_check (MNMailbox * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_URI,
	PROP_NAME,
	PROP_AUTOMATIC,
	PROP_HAS_NEW,
	PROP_ERROR
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_name mn_mailbox_get_name
#define self_get_automatic mn_mailbox_get_automatic
#define self_set_automatic mn_mailbox_set_automatic
#define self_get_has_new mn_mailbox_get_has_new
#define self_set_has_new mn_mailbox_set_has_new
#define self_set_error mn_mailbox_set_error
#define self_get_error mn_mailbox_get_error
#define self_get_types mn_mailbox_get_types
#define self_new_async mn_mailbox_new_async
#define self_new_async_thread mn_mailbox_new_async_thread
#define self_set_init_error mn_mailbox_set_init_error
#define self_monitor mn_mailbox_monitor
#define self_monitor_cb mn_mailbox_monitor_cb
#define self_impl_is mn_mailbox_impl_is
#define self_impl_check mn_mailbox_impl_check
#define self_impl_threaded_check mn_mailbox_impl_threaded_check
#define self_check mn_mailbox_check
#define self_end_check mn_mailbox_end_check
#define self_notice mn_mailbox_notice
GType
mn_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailbox *)g_object_new(mn_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailbox *)g_object_new_valist (mn_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::dispose"
	MNMailbox *self G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 121 "mn-mailbox.gob"
	if(self->uri) { ((*(void (*)(void *))g_object_unref)) (self->uri); self->uri = NULL; }
#line 174 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
	MNMailbox *self  G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 132 "mn-mailbox.gob"
	if(self->_priv->name) { ((*(void (*)(void *))g_free)) (self->_priv->name); self->_priv->name = NULL; }
#line 189 "mn-mailbox.c"
#line 146 "mn-mailbox.gob"
	if(self->_priv->error) { ((*(void (*)(void *))g_free)) (self->_priv->error); self->_priv->error = NULL; }
#line 192 "mn-mailbox.c"
#line 166 "mn-mailbox.gob"
	if(self->_priv->monitor_handle) { ((*(void (*)(void *))gnome_vfs_monitor_cancel)) (self->_priv->monitor_handle); self->_priv->monitor_handle = NULL; }
#line 195 "mn-mailbox.c"
#line 167 "mn-mailbox.gob"
	if(self->_priv->monitor_uri) { ((*(void (*)(void *))g_free)) (self->_priv->monitor_uri); self->_priv->monitor_uri = NULL; }
#line 198 "mn-mailbox.c"
#line 310 "mn-mailbox.gob"
	if(self->_priv->init_error) { ((*(void (*)(void *))g_free)) (self->_priv->init_error); self->_priv->init_error = NULL; }
#line 201 "mn-mailbox.c"
	g_free (priv);
}
#undef __GOB_FUNCTION__

static void 
mn_mailbox_init (MNMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::init"
	o->_priv = g_new0 (MNMailboxPrivate, 1);
#line 44 "mn-mailbox.gob"
	o->uri = NULL;
#line 213 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__
static void 
mn_mailbox_class_init (MNMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	c->impl_is = NULL;
	c->impl_check = NULL;
	c->impl_threaded_check = NULL;
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_object
		("uri" /* name */,
		 NULL /* nick */,
		 _("The mailbox URI") /* blurb */,
		 MN_TYPE_URI /* object_type */,
		 (GParamFlags)(G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_URI,
		param_spec);
	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 _("The mailbox human-readable name") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_boolean
		("automatic" /* name */,
		 NULL /* nick */,
		 _("Whether the mailbox has to be manually checked or not") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_AUTOMATIC,
		param_spec);
	param_spec = g_param_spec_boolean
		("has_new" /* name */,
		 NULL /* nick */,
		 _("Whether the mailbox has new mail or not") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_HAS_NEW,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 _("The mailbox error, if any") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::set_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_URI:
		{
#line 126 "mn-mailbox.gob"

      g_return_if_fail(self->uri == NULL);
      self->uri = MN_URI(g_value_dup_object(VAL));
      selfp->name = g_strdup(self->uri->human_readable);
    
#line 303 "mn-mailbox.c"
		}
		break;
	case PROP_NAME:
		{
#line 133 "mn-mailbox.gob"
{ char *old = self->_priv->name; self->_priv->name = g_value_dup_string (VAL); g_free (old); }
#line 310 "mn-mailbox.c"
		}
		break;
	case PROP_AUTOMATIC:
		{
#line 137 "mn-mailbox.gob"
self->_priv->automatic = g_value_get_boolean (VAL);
#line 317 "mn-mailbox.c"
		}
		break;
	case PROP_HAS_NEW:
		{
#line 142 "mn-mailbox.gob"
self->_priv->has_new = g_value_get_boolean (VAL);
#line 324 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 147 "mn-mailbox.gob"
{ char *old = self->_priv->error; self->_priv->error = g_value_dup_string (VAL); g_free (old); }
#line 331 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::get_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 133 "mn-mailbox.gob"
g_value_set_string (VAL, self->_priv->name);
#line 362 "mn-mailbox.c"
		}
		break;
	case PROP_AUTOMATIC:
		{
#line 137 "mn-mailbox.gob"
g_value_set_boolean (VAL, self->_priv->automatic);
#line 369 "mn-mailbox.c"
		}
		break;
	case PROP_HAS_NEW:
		{
#line 142 "mn-mailbox.gob"
g_value_set_boolean (VAL, self->_priv->has_new);
#line 376 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 147 "mn-mailbox.gob"
g_value_set_string (VAL, self->_priv->error);
#line 383 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 134 "mn-mailbox.gob"
const char * 
mn_mailbox_get_name (MNMailbox * self)
#line 403 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_name"
#line 134 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 134 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (const char * )0);
#line 410 "mn-mailbox.c"
{
#line 134 "mn-mailbox.gob"
	 return selfp->name; }}
#line 414 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 137 "mn-mailbox.gob"
gboolean 
mn_mailbox_get_automatic (MNMailbox * self)
#line 420 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_automatic"
{
#line 137 "mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "automatic", &val, NULL); return val;
}}
#line 427 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 137 "mn-mailbox.gob"
void 
mn_mailbox_set_automatic (MNMailbox * self, gboolean val)
#line 433 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_automatic"
{
#line 137 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "automatic", val, NULL);
}}
#line 440 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 142 "mn-mailbox.gob"
gboolean 
mn_mailbox_get_has_new (MNMailbox * self)
#line 446 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_has_new"
{
#line 142 "mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "has_new", &val, NULL); return val;
}}
#line 453 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 142 "mn-mailbox.gob"
void 
mn_mailbox_set_has_new (MNMailbox * self, gboolean val)
#line 459 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_has_new"
{
#line 142 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "has_new", val, NULL);
}}
#line 466 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 148 "mn-mailbox.gob"
void 
mn_mailbox_set_error (MNMailbox * self, const char * format, ...)
#line 472 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_error"
#line 148 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 148 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 479 "mn-mailbox.c"
{
#line 150 "mn-mailbox.gob"
	
    va_list args;
    char *error = NULL;

    if (format)
      {
	va_start(args, format);
	error = g_strdup_vprintf(format, args);
	va_end(args);
      }
    
    g_object_set(G_OBJECT(self), MN_MAILBOX_PROP_ERROR(error), NULL);
    g_free(error);
  }}
#line 496 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 164 "mn-mailbox.gob"
const char * 
mn_mailbox_get_error (MNMailbox * self)
#line 502 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_error"
#line 164 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 164 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (const char * )0);
#line 509 "mn-mailbox.c"
{
#line 164 "mn-mailbox.gob"
	 return selfp->error; }}
#line 513 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 172 "mn-mailbox.gob"
const GType * 
mn_mailbox_get_types (void)
#line 519 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_types"
{
#line 174 "mn-mailbox.gob"
	
    static GType *types = NULL;
    G_LOCK_DEFINE_STATIC(types);
    
    G_LOCK(types);
    if (! types)
      {
	GType tmp_types[7];
	int n_types = 0;
	int i;
	
#ifdef WITH_MBOX
	tmp_types[n_types++] = MN_TYPE_MBOX_MAILBOX;
#endif
#ifdef WITH_MH
	tmp_types[n_types++] = MN_TYPE_MH_MAILBOX;
#endif
#ifdef WITH_MAILDIR
	tmp_types[n_types++] = MN_TYPE_MAILDIR_MAILBOX;
#endif
#ifdef WITH_POP3
	tmp_types[n_types++] = MN_TYPE_POP3_MAILBOX;
#endif
#ifdef WITH_IMAP
	tmp_types[n_types++] = MN_TYPE_IMAP_MAILBOX;
#endif
#ifdef WITH_SYLPHEED
	tmp_types[n_types++] = MN_TYPE_SYLPHEED_MAILBOX;
#endif
#ifdef WITH_GMAIL
	tmp_types[n_types++] = MN_TYPE_GMAIL_MAILBOX;
#endif
	
	types = g_new(GType, n_types + 1);
	for (i = 0; i < n_types; i++)
	  types[i] = tmp_types[i];
	types[n_types] = 0;
      }
    G_UNLOCK(types);
    
    return types;
  }}
#line 566 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_new_async:
 * @uri: location of the mailbox
 * @callback: a function like
 *            "void (callback) (#MNMailbox *self, gpointer user_data)"
 * @user_data: data to pass to @callback
 *
 * Creates a new #MNMailbox asynchronously. The newly created
 * #MNMailbox will be passed to @callback.
 **/
#line 227 "mn-mailbox.gob"
void 
mn_mailbox_new_async (MNURI * uri, gpointer callback, gpointer user_data)
#line 582 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_async"
#line 227 "mn-mailbox.gob"
	g_return_if_fail (uri != NULL);
#line 227 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_URI (uri));
#line 227 "mn-mailbox.gob"
	g_return_if_fail (callback != NULL);
#line 591 "mn-mailbox.c"
{
#line 231 "mn-mailbox.gob"
	
    NewInfo *info;

    info = g_new(NewInfo, 1);
    info->uri = g_object_ref(uri);
    info->callback = callback;
    info->user_data = user_data;

    mn_thread_create(self_new_async_thread, info);
  }}
#line 604 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 242 "mn-mailbox.gob"
static gpointer 
mn_mailbox_new_async_thread (gpointer data)
#line 610 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_async_thread"
{
#line 244 "mn-mailbox.gob"
	
    NewInfo *info = data;
    Self *mailbox = NULL;

    if (info->uri->vfs)
      {
	if (! mn_vfs_test(info->uri->vfs, G_FILE_TEST_EXISTS))
	  mailbox = mn_unsupported_mailbox_new(info->uri, _("does not exist"));
      }

    if (! mailbox)
      {
	const GType *types;
	int i;
	
	types = self_get_types();
	for (i = 0; types[i]; i++)
	  {
	    SelfClass *class;
	    gboolean is;

	    class = g_type_class_ref(types[i]);
	    is = class->impl_is(NULL, info->uri);
	    g_type_class_unref(class);

	    if (is)
	      {
		mailbox = g_object_new(types[i], MN_MAILBOX_PROP_URI(G_OBJECT(info->uri)), NULL);
		if (mailbox->_priv->init_error)
		  {
		    MNMailbox *old_mailbox;
		  
		    old_mailbox = mailbox;
		    mailbox = mn_unsupported_mailbox_new(info->uri, old_mailbox->_priv->init_error);
		    g_object_unref(old_mailbox);
		  }
		
		break;
	      }
	  }
      }

    if (! mailbox)
      mailbox = mn_unsupported_mailbox_new(info->uri, _("unknown format"));

    GDK_THREADS_ENTER();

    info->callback(mailbox, info->user_data);

    /*
     * A note on gdk_flush(): as adviced in the GDK threads
     * documentation, we only call gdk_flush() from a thread other
     * than our main thread (so we do not call it in idle and timeout
     * callbacks).
     */
    gdk_flush();
    GDK_THREADS_LEAVE();

    /* mailbox is now owned by the callback, do not unref it */
    
    g_object_unref(info->uri);
    g_free(info);

    return NULL;
  }}
#line 680 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 311 "mn-mailbox.gob"
void 
mn_mailbox_set_init_error (MNMailbox * self, const char * format, ...)
#line 686 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_init_error"
#line 311 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 311 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 311 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 695 "mn-mailbox.c"
{
#line 313 "mn-mailbox.gob"
	
    va_list args;

    g_return_if_fail(selfp->init_error == NULL);

    va_start(args, format);
    selfp->init_error = g_strdup_vprintf(format, args);
    va_end(args);
  }}
#line 707 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 323 "mn-mailbox.gob"
void 
mn_mailbox_monitor (MNMailbox * self, const char * uri, GnomeVFSMonitorType monitor_type, MNMailboxMonitorEventType events)
#line 713 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::monitor"
#line 323 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 323 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 323 "mn-mailbox.gob"
	g_return_if_fail (uri != NULL);
#line 722 "mn-mailbox.c"
{
#line 328 "mn-mailbox.gob"
	
    GnomeVFSResult result;

    g_return_if_fail(MN_MAILBOX_CAN_CHECK(self));
    g_return_if_fail(selfp->monitor_handle == NULL);
    
    gdk_flush();
    GDK_THREADS_LEAVE();

    result = gnome_vfs_monitor_add(&selfp->monitor_handle,
				   uri,
				   monitor_type,
				   self_monitor_cb,
				   self);

    GDK_THREADS_ENTER();
    
    if (result == GNOME_VFS_OK)
      {
	selfp->monitor_uri = g_strdup(uri);
	selfp->monitor_events = events;
	self_set_automatic(self, TRUE);
      }
    else
      {
	static gboolean first_time = TRUE;

	g_warning(_("unable to monitor %s: %s"), uri, gnome_vfs_result_to_string(result));

	if (first_time)
	  {
	    int minutes;
	    int seconds;
	    char *str;
	    
	    first_time = FALSE;
	    
	    minutes = eel_gconf_get_integer(MN_CONF_DELAY_MINUTES);
	    seconds = eel_gconf_get_integer(MN_CONF_DELAY_SECONDS);
	    
	    if (minutes == 0)
	      str = g_strdup_printf(ngettext("As a fallback, they will be "
					     "checked every %i second (this "
					     "delay is configurable from the "
					     "Properties Dialog).",
					     "As a fallback, they will be "
					     "checked every %i seconds (this "
					     "delay is configurable from the "
					     "Properties Dialog).",
					     seconds),
				    seconds);
	    else if (seconds == 0)
	      str = g_strdup_printf(ngettext("As a fallback, they will be "
					     "checked every %i minute (this "
					     "delay is configurable from the "
					     "Properties Dialog).",
					     "As a fallback, they will be "
					     "checked every %i minutes (this "
					     "delay is configurable from the "
					     "Properties Dialog).",
					     minutes),
				    minutes);
	    else
	      str = g_strdup_printf(ngettext("As a fallback, they will be "
					     "checked approximately every %i "
					     "minute (this delay is "
					     "configurable from the "
					     "Properties Dialog).",
					     "As a fallback, they will be "
					     "checked approximately every %i "
					     "minutes (this delay is "
					     "configurable from the "
					     "Properties Dialog).",
					     minutes),
				    minutes);
	    
	    mn_error_dialog("immediate-notification",
			    _("A monitoring error has occurred"),
			    _("Mail Notification was unable to enable immediate "
			      "notification for one or more mailboxes. %s"), str);
	    g_free(str);
	  }
      }
  }}
#line 809 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 413 "mn-mailbox.gob"
static void 
mn_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data)
#line 815 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::monitor_cb"
#line 413 "mn-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 820 "mn-mailbox.c"
{
#line 419 "mn-mailbox.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    if (selfp->monitor_events & (1 << event_type))
      self_check(self);
    GDK_THREADS_LEAVE();
  }}
#line 831 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 428 "mn-mailbox.gob"
static gboolean 
mn_mailbox_impl_is (MNMailbox * self, MNURI * uri)
#line 837 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 428 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 428 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 844 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->impl_is)
		return (*klass->impl_is)(self,uri);
	else
		return (gboolean )(0);
}

#line 430 "mn-mailbox.gob"
static void 
mn_mailbox_impl_check (MNMailbox * self)
#line 856 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 430 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 430 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 863 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->impl_check)
		(*klass->impl_check)(self);
}

#line 432 "mn-mailbox.gob"
static void 
mn_mailbox_impl_threaded_check (MNMailbox * self)
#line 873 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 432 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 432 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 880 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->impl_threaded_check)
		(*klass->impl_threaded_check)(self);
}

#line 435 "mn-mailbox.gob"
void 
mn_mailbox_check (MNMailbox * self)
#line 890 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::check"
#line 435 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 435 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 897 "mn-mailbox.c"
{
#line 437 "mn-mailbox.gob"
	
    g_return_if_fail(MN_MAILBOX_CAN_CHECK(self));

    if (! selfp->checking)
      {
	g_object_ref(self);
	selfp->checking = TRUE;
	self_set_error(self, NULL);

	if (SELF_GET_CLASS(self)->impl_threaded_check)
	  mn_thread_create((GThreadFunc) SELF_GET_CLASS(self)->impl_threaded_check, self);
	else
	  SELF_GET_CLASS(self)->impl_check(self);
      }
  }}
#line 915 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 453 "mn-mailbox.gob"
void 
mn_mailbox_end_check (MNMailbox * self)
#line 921 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::end_check"
#line 453 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 453 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 928 "mn-mailbox.c"
{
#line 455 "mn-mailbox.gob"
	
    g_return_if_fail(selfp->checking == TRUE);

    selfp->checking = FALSE;
    g_object_unref(self);
  }}
#line 937 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 462 "mn-mailbox.gob"
void 
mn_mailbox_notice (MNMailbox * self, const char * format, ...)
#line 943 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::notice"
#line 462 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 462 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 462 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 952 "mn-mailbox.c"
{
#line 464 "mn-mailbox.gob"
	
    va_list args;
    char *notice;
    char *prefixed_notice;
    
    va_start(args, format);
    notice = g_strdup_vprintf(format, args);
    va_end(args);

    prefixed_notice = g_strdup_printf("%s: %s", self->uri->text, notice);
    g_free(notice);
    
    mn_info("%s", prefixed_notice);
    g_free(prefixed_notice);
  }}
#line 970 "mn-mailbox.c"
#undef __GOB_FUNCTION__
