/* Generated by GOB (v2.0.10)   (do not edit directly) */

#include <glib.h>
#include <glib-object.h>


#include <libgnomevfs/gnome-vfs.h>

#ifndef __MN_URI_H__
#define __MN_URI_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



  typedef enum
  {
    MN_URI_VFS,
    MN_URI_POP,
    MN_URI_IMAP,
    MN_URI_GMAIL,
    MN_URI_UNKNOWN
  } MNURIType;

  typedef enum
  {
    MN_URI_LOCAL		= 1 << 0,
    MN_URI_SYSTEM_MAILBOX	= 1 << 1,
    MN_URI_SSL			= 1 << 2,
    MN_URI_INBAND_SSL		= 1 << 3
  } MNURIFlags;

#define MN_URI_IS_VFS(uri)		((uri)->type == MN_URI_VFS)
#define MN_URI_IS_POP(uri)		((uri)->type == MN_URI_POP)
#define MN_URI_IS_IMAP(uri)		((uri)->type == MN_URI_IMAP)
#define MN_URI_IS_GMAIL(uri)		((uri)->type == MN_URI_GMAIL)

#define MN_URI_IS_LOCAL(uri)		(((uri)->flags & MN_URI_LOCAL) != 0)
#define MN_URI_IS_SYSTEM_MAILBOX(uri)	(((uri)->flags & MN_URI_SYSTEM_MAILBOX) != 0)
#define MN_URI_IS_SSL(uri)		(((uri)->flags & MN_URI_SSL) != 0)
#define MN_URI_IS_INBAND_SSL(uri)	(((uri)->flags & MN_URI_INBAND_SSL) != 0)


/*
 * Type checking and casting macros
 */
#define MN_TYPE_URI	(mn_uri_get_type())
#define MN_URI(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), mn_uri_get_type(), MNURI)
#define MN_URI_CONST(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), mn_uri_get_type(), MNURI const)
#define MN_URI_CLASS(klass)	G_TYPE_CHECK_CLASS_CAST((klass), mn_uri_get_type(), MNURIClass)
#define MN_IS_URI(obj)	G_TYPE_CHECK_INSTANCE_TYPE((obj), mn_uri_get_type ())

#define MN_URI_GET_CLASS(obj)	G_TYPE_INSTANCE_GET_CLASS((obj), mn_uri_get_type(), MNURIClass)

/*
 * Main object structure
 */
#ifndef __TYPEDEF_MN_URI__
#define __TYPEDEF_MN_URI__
typedef struct _MNURI MNURI;
#endif
struct _MNURI {
	GObject __parent__;
	/*< public >*/
	char * text;
	GnomeVFSURI * vfs;
	char * human_readable;
	char * scheme;
	char * username;
	char * password;
	char * authmech;
	char * hostname;
	int port;
	char * path;
	char ** queries;
	MNURIType type;
	MNURIFlags flags;
};

/*
 * Class definition
 */
typedef struct _MNURIClass MNURIClass;
struct _MNURIClass {
	GObjectClass __parent__;
};


/*
 * Public methods
 */
GType	mn_uri_get_type	(void);
gboolean 	mn_uri_has_query	(MNURI * self,
					const char * query);
const char * 	mn_uri_get_system_mailbox	(void);
int 	mn_uri_get_default_port	(const char * scheme);
const char * 	mn_uri_get_default_path	(const char * scheme);
MNURI * 	mn_uri_new	(const char * text_uri);
MNURI * 	mn_uri_new_pop	(gboolean ssl,
					gboolean stls,
					const char * username,
					const char * password,
					const char * authmech,
					const char * hostname,
					int port);
MNURI * 	mn_uri_new_imap	(gboolean ssl,
					gboolean starttls,
					const char * username,
					const char * password,
					const char * authmech,
					const char * hostname,
					int port,
					const char * mailbox);
MNURI * 	mn_uri_new_gmail	(const char * username,
					const char * password);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
