/* Generated by GOB (v2.0.11) on Sun Oct 31 18:41:21 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "mn-pop3-mailbox.h"

#include "mn-pop3-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 33 "mn-pop3-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-client-session.h"
#include "mn-util.h"
#include "mn-md5.h"
#ifdef WITH_MIME
#include "mn-message-mime.h"
#endif

  enum
  {
    STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
    STATE_CAPA,
#ifdef WITH_SSL
    STATE_STLS,
#endif
#ifdef WITH_SASL
    STATE_AUTH,
#endif
    STATE_APOP,
    STATE_USER,
    STATE_PASS,
#ifdef WITH_MIME
    STATE_LIST,
    STATE_RETR,
#else /* WITH_MIME */
    STATE_STAT,
#endif
    STATE_QUIT
  };

  enum
  {
    RESULT_ERROR_QUIT		= -1, /* server reported an error, quit normally */
    RESULT_ERROR_END		= -2  /* server reported an error, close the connection */
  };

  struct _MNClientSessionPrivate
  {
    MNMailbox		*mailbox;
    MNPOP3Mailbox	*self;
    MNClientSession	*session;
    gboolean		in_list;
    char		*apop_timestamp;
    GSList		*auth_mechanisms;
#ifdef WITH_SSL
    gboolean		stls_supported;
    gboolean		stls_completed;
#endif
#ifdef WITH_SASL
    const char		*sasl_mechanism;
#endif
    gboolean		authentication_failed;
    gboolean		authenticated;
    gboolean		login_delay_user;
#ifdef WITH_MIME
    GSList		*message_numbers;
    GSList		*current_message_number;
    GSList		*messages;
    GString		*current_message;
#endif
  };

  typedef enum
  {
    RESPONSE_OK,
    RESPONSE_ERR,
    RESPONSE_LIST_ITEM,
    RESPONSE_LIST_END,
    RESPONSE_CONTINUATION
  } ResponseType;

  struct _MNClientSessionResponse
  {
    ResponseType	type;
    char		*arguments;
  };

#line 113 "mn-pop3-mailbox.c"
/* self casting macros */
#define SELF(x) MN_POP3_MAILBOX(x)
#define SELF_CONST(x) MN_POP3_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_POP3_MAILBOX(x)
#define TYPE_SELF MN_TYPE_POP3_MAILBOX
#define SELF_CLASS(x) MN_POP3_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_POP3_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNPOP3Mailbox Self;
typedef MNPOP3MailboxClass SelfClass;

/* here are local prototypes */
static void mn_pop3_mailbox_init (MNPOP3Mailbox * o) G_GNUC_UNUSED;
static void mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_pop3_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_pop3_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_stls_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_stls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_list_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_list_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_retr_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_retr_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_stat_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_stat_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNAuthenticatedMailboxResult ___19_mn_pop3_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox, GError ** err) G_GNUC_UNUSED;
static void mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_check_mail (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static void mn_pop3_mailbox_handle_list_response (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_handle_greeting_cb mn_pop3_mailbox_handle_greeting_cb
#define self_enter_capa_cb mn_pop3_mailbox_enter_capa_cb
#define self_handle_capa_cb mn_pop3_mailbox_handle_capa_cb
#define self_enter_stls_cb mn_pop3_mailbox_enter_stls_cb
#define self_handle_stls_cb mn_pop3_mailbox_handle_stls_cb
#define self_enter_auth_cb mn_pop3_mailbox_enter_auth_cb
#define self_handle_auth_cb mn_pop3_mailbox_handle_auth_cb
#define self_enter_apop_cb mn_pop3_mailbox_enter_apop_cb
#define self_handle_apop_cb mn_pop3_mailbox_handle_apop_cb
#define self_enter_user_cb mn_pop3_mailbox_enter_user_cb
#define self_handle_user_cb mn_pop3_mailbox_handle_user_cb
#define self_enter_pass_cb mn_pop3_mailbox_enter_pass_cb
#define self_handle_pass_cb mn_pop3_mailbox_handle_pass_cb
#define self_enter_list_cb mn_pop3_mailbox_enter_list_cb
#define self_handle_list_cb mn_pop3_mailbox_handle_list_cb
#define self_enter_retr_cb mn_pop3_mailbox_enter_retr_cb
#define self_handle_retr_cb mn_pop3_mailbox_handle_retr_cb
#define self_enter_stat_cb mn_pop3_mailbox_enter_stat_cb
#define self_handle_stat_cb mn_pop3_mailbox_handle_stat_cb
#define self_enter_quit_cb mn_pop3_mailbox_enter_quit_cb
#define self_handle_quit_cb mn_pop3_mailbox_handle_quit_cb
#define self_notice_cb mn_pop3_mailbox_notice_cb
#define self_response_new_cb mn_pop3_mailbox_response_new_cb
#define self_response_free_cb mn_pop3_mailbox_response_free_cb
#define self_custom_handler_cb mn_pop3_mailbox_custom_handler_cb
#define self_session_authenticate mn_pop3_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_pop3_mailbox_session_authenticate_fallback
#define self_session_authenticated mn_pop3_mailbox_session_authenticated
#define self_session_check_mail mn_pop3_mailbox_session_check_mail
#define self_session_set_error_from_arguments mn_pop3_mailbox_session_set_error_from_arguments
#define self_handle_list_response mn_pop3_mailbox_handle_list_response
GType
mn_pop3_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPOP3MailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_pop3_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPOP3Mailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_pop3_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNPOP3Mailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPOP3Mailbox *)g_object_new(mn_pop3_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPOP3Mailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPOP3Mailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNPOP3Mailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPOP3Mailbox *)g_object_new_valist (mn_pop3_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::finalize"
	MNPOP3Mailbox *self G_GNUC_UNUSED = MN_POP3_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 124 "mn-pop3-mailbox.gob"
	if(self->_priv->authentication_timer) { g_timer_destroy ((gpointer) self->_priv->authentication_timer); self->_priv->authentication_timer = NULL; }
#line 253 "mn-pop3-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_pop3_mailbox_init (MNPOP3Mailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNPOP3MailboxPrivate);
}
#undef __GOB_FUNCTION__
#line 126 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class G_GNUC_UNUSED)
#line 267 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNPOP3MailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 131 "mn-pop3-mailbox.gob"
	g_object_class->constructor = ___2_mn_pop3_mailbox_constructor;
#line 148 "mn-pop3-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_pop3_mailbox_impl_is;
#line 638 "mn-pop3-mailbox.gob"
	mn_authenticated_mailbox_class->impl_authenticated_check = ___19_mn_pop3_mailbox_impl_authenticated_check;
#line 284 "mn-pop3-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 127 "mn-pop3-mailbox.gob"

    MN_MAILBOX_CLASS(class)->format = "POP3";
  
#line 291 "mn-pop3-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 131 "mn-pop3-mailbox.gob"
static GObject * 
___2_mn_pop3_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 301 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::constructor"
{
#line 133 "mn-pop3-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);

#ifndef WITH_SSL
    if (MN_URI_IS_SSL(mailbox->uri) || MN_URI_IS_INBAND_SSL(mailbox->uri))
      mn_mailbox_set_init_error(mailbox, _("SSL/TLS support has not been compiled in"));
#endif /* WITH_SSL */
  
    return object;
  }}
#line 324 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 148 "mn-pop3-mailbox.gob"
static gboolean 
___3_mn_pop3_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 331 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::impl_is"
#line 148 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 148 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 342 "mn-pop3-mailbox.c"
{
#line 150 "mn-pop3-mailbox.gob"
	
    return MN_URI_IS_POP(uri);
  }}
#line 348 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 154 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 355 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_greeting_cb"
#line 154 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 154 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 154 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 364 "mn-pop3-mailbox.c"
{
#line 158 "mn-pop3-mailbox.gob"
	
    priv->session = session;
    
    switch (response->type)
      {
      case RESPONSE_OK:
	if (response->arguments)
	  {
	    char *timestamp;
	    
	    timestamp = strchr(response->arguments, '<');
	    if (timestamp)
	      {
		char *timestamp_end;
		
		timestamp_end = strchr(timestamp, '>');
		if (timestamp_end)
		  priv->apop_timestamp = g_strndup(timestamp, timestamp_end - timestamp + 1);
	      }
	  }
	return STATE_CAPA;
	
      case RESPONSE_ERR:	return RESULT_ERROR_END;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 393 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 185 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 399 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_capa_cb"
#line 185 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 185 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 406 "mn-pop3-mailbox.c"
{
#line 188 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "CAPA");
  }}
#line 412 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 192 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 418 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_capa_cb"
#line 192 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 192 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 192 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 427 "mn-pop3-mailbox.c"
{
#line 196 "mn-pop3-mailbox.gob"
	
    self_handle_list_response(priv, response);

    switch (response->type)
      {
      case RESPONSE_OK:
	eel_g_slist_free_deep(priv->auth_mechanisms);
	priv->auth_mechanisms = NULL;
	priv->self->_priv->login_delay = 0;
	priv->login_delay_user = FALSE;
#ifdef WITH_SSL
	priv->stls_supported = FALSE;
#endif

	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      case RESPONSE_ERR:
      case RESPONSE_LIST_END:
	if (priv->authenticated)
	  return self_session_check_mail(priv);

#ifdef WITH_SSL
	if (MN_URI_IS_INBAND_SSL(priv->mailbox->uri)
	    && ! MN_URI_IS_SSL(priv->mailbox->uri)
	    && ! priv->stls_completed)
	  {
	    if (priv->stls_supported)
	      return STATE_STLS;
	    else
	      {
		mn_client_session_error(priv->session, _("server does not support in-band SSL/TLS"));
		return STATE_QUIT;
	      }
	  }
	else
#endif /* WITH_SSL */
	  return self_session_authenticate(priv);
      
      case RESPONSE_LIST_ITEM:
	{
	  char **tokens;
	  gboolean login_delay_error = FALSE;
	  
	  tokens = g_strsplit(response->arguments, " ", 0);
	  if (tokens[0])
	    {
	      if (! strcmp(tokens[0], "SASL"))
		{
		  int i;
		  
		  for (i = 1; tokens[i]; i++)
		    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(tokens[i]));
		}
#ifdef WITH_SSL
	      else if (! strcmp(tokens[0], "STLS"))
		priv->stls_supported = TRUE;
#endif /* WITH_SSL */
	      else if (! strcmp(tokens[0], "LOGIN-DELAY"))
		{
		  if (tokens[1] && mn_str_isnumeric(tokens[1])
		      && (! tokens[2]
			  || (! tokens[3]
			      && ! priv->authenticated
			      && ! strcmp(tokens[2], "USER"))))
		    {
		      priv->self->_priv->login_delay = atoi(tokens[1]);
		      if (tokens[2])
			priv->login_delay_user = TRUE;
		    }
		  else
		    login_delay_error = TRUE;
		}
	    }
	  g_strfreev(tokens);
	  
	  if (login_delay_error)
	    return mn_client_session_error(session, _("invalid arguments for the LOGIN-DELAY capability"));
	}
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 514 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 281 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_stls_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 520 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_stls_cb"
#line 281 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 281 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 527 "mn-pop3-mailbox.c"
{
#line 284 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SSL
    return mn_client_session_write(session, "STLS");
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 537 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 292 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_stls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 543 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_stls_cb"
#line 292 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 292 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 292 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 552 "mn-pop3-mailbox.c"
{
#line 296 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SSL
    switch (response->type)
      {
      case RESPONSE_OK:
	priv->stls_completed = TRUE;
	return mn_client_session_enable_ssl(session)
	  ? STATE_CAPA
	  : RESULT_ERROR_END;

      case RESPONSE_ERR:
	return self_session_authenticate(priv);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 575 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 317 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 581 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_auth_cb"
#line 317 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 317 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 588 "mn-pop3-mailbox.c"
{
#line 320 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    if (mn_client_session_sasl_authentication_start(priv->session,
						    "pop",
						    priv->auth_mechanisms,
						    priv->mailbox->uri->authmech,
						    &priv->sasl_mechanism,
					  /* [1] */ TRUE))
      return mn_client_session_write(session, "AUTH %s", priv->sasl_mechanism);
    else
      return self_session_authenticate_fallback(priv, FALSE);

    /*
     * [1] http://www.ietf.org/internet-drafts/draft-siemborski-rfc1734bis-03.txt
     * section 4 specifies that POP3 supports the initial client
     * response feature of SASL.
     */
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 612 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 342 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 618 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_auth_cb"
#line 342 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 342 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 342 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 627 "mn-pop3-mailbox.c"
{
#line 346 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    switch (response->type)
      {
      case RESPONSE_OK:
	return mn_client_session_sasl_authentication_done(session)
	  ? self_session_authenticated(priv)
	  : MN_CLIENT_SESSION_RESULT_END;
	
      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, FALSE);
	
      case RESPONSE_CONTINUATION:
	return mn_client_session_sasl_authentication_step(session, response->arguments);
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 652 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 369 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 658 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_apop_cb"
#line 369 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 369 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 665 "mn-pop3-mailbox.c"
{
#line 372 "mn-pop3-mailbox.gob"
	
    MNMD5Context context;
    char buf[33];
  
    g_return_val_if_fail(priv->apop_timestamp != NULL, 0);
    
    mn_md5_init(&context);
    mn_md5_update(&context, priv->apop_timestamp, strlen(priv->apop_timestamp));
    mn_md5_update(&context, MN_AUTHENTICATED_MAILBOX(priv->self)->password, strlen(MN_AUTHENTICATED_MAILBOX(priv->self)->password));
    mn_md5_end(&context, buf);

    return mn_client_session_write(session, "APOP %s %s", priv->mailbox->uri->username, buf);
  }}
#line 681 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 386 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 687 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_apop_cb"
#line 386 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 386 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 386 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 696 "mn-pop3-mailbox.c"
{
#line 390 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return self_session_authenticated(priv);
	
      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, TRUE);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 712 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 404 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 718 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_user_cb"
#line 404 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 404 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 725 "mn-pop3-mailbox.c"
{
#line 407 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "USER %s", priv->mailbox->uri->username);
  }}
#line 731 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 411 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 737 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_user_cb"
#line 411 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 411 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 411 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 746 "mn-pop3-mailbox.c"
{
#line 415 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return STATE_PASS;

      case RESPONSE_ERR:
	priv->authentication_failed = TRUE;
	return RESULT_ERROR_QUIT;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 763 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 430 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 769 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_pass_cb"
#line 430 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 430 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 776 "mn-pop3-mailbox.c"
{
#line 433 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "PASS %s", MN_AUTHENTICATED_MAILBOX(priv->self)->password);
  }}
#line 782 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 437 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 788 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_pass_cb"
#line 437 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 437 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 437 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 797 "mn-pop3-mailbox.c"
{
#line 441 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return self_session_authenticated(priv);

      case RESPONSE_ERR:
	priv->authentication_failed = TRUE;
	return RESULT_ERROR_QUIT;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 814 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 456 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_list_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 820 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_list_cb"
#line 456 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 456 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 827 "mn-pop3-mailbox.c"
{
#line 459 "mn-pop3-mailbox.gob"
	
#ifdef WITH_MIME
    return mn_client_session_write(session, "LIST");
#else
    g_return_val_if_reached(0);
#endif
  }}
#line 837 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 467 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_list_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 843 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_list_cb"
#line 467 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 467 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 467 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 852 "mn-pop3-mailbox.c"
{
#line 471 "mn-pop3-mailbox.gob"
	
#ifdef WITH_MIME
    self_handle_list_response(priv, response);

    switch (response->type)
      {
      case RESPONSE_OK:
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      case RESPONSE_LIST_END:
	priv->current_message_number = priv->message_numbers;
	return STATE_RETR;

      case RESPONSE_ERR:
	return RESULT_ERROR_END;

      case RESPONSE_LIST_ITEM:
	{
	  int num;
	  int size;
	  
	  if (sscanf(response->arguments, "%d %d", &num, &size) == 2)
	    priv->message_numbers = g_slist_append(priv->message_numbers, GINT_TO_POINTER(num));
	  else			/* compliance error */
	    return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	}
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else /* WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 890 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 507 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_retr_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 896 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_retr_cb"
#line 507 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 507 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 903 "mn-pop3-mailbox.c"
{
#line 510 "mn-pop3-mailbox.gob"
	
#ifdef WITH_MIME
    if (priv->current_message_number)
      return mn_client_session_write(session, "RETR %i", GPOINTER_TO_INT(priv->current_message_number->data));
    else
      {
	GDK_THREADS_ENTER();
	mn_mailbox_set_has_new(priv->mailbox, priv->messages != NULL);
	mn_mailbox_set_messages(priv->mailbox, priv->messages);
	gdk_flush();
	GDK_THREADS_LEAVE();
	
	return STATE_QUIT;
      }
#else
    g_return_val_if_reached(0);
#endif
  }}
#line 924 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 529 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_retr_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 930 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_retr_cb"
#line 529 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 529 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 529 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 939 "mn-pop3-mailbox.c"
{
#line 533 "mn-pop3-mailbox.gob"
	
#ifdef WITH_MIME
    self_handle_list_response(priv, response);

    switch (response->type)
      {
      case RESPONSE_OK:
	if (priv->current_message)
	  g_string_free(priv->current_message, TRUE);
	priv->current_message = g_string_new(NULL);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      case RESPONSE_LIST_END:
	priv->messages = g_slist_append(priv->messages,
					mn_message_new_from_buffer(priv->mailbox->uri,
								   priv->current_message->str,
								   priv->current_message->len));
	priv->current_message_number = priv->current_message_number->next;
	return STATE_RETR;

      case RESPONSE_ERR:
	priv->messages = g_slist_append(priv->messages,
					mn_message_new_from_error(priv->mailbox->uri,
								  response->arguments ? response->arguments : _("unknown error")));
	priv->current_message_number = priv->current_message_number->next;
	return STATE_RETR;

      case RESPONSE_LIST_ITEM:
	g_string_append_printf(priv->current_message, "%s\n", response->arguments);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif
  }}
#line 980 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 572 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_stat_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 986 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_stat_cb"
#line 572 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 572 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 993 "mn-pop3-mailbox.c"
{
#line 575 "mn-pop3-mailbox.gob"
	
#ifndef WITH_MIME
    return mn_client_session_write(session, "STAT");
#else
    g_return_val_if_reached(0);
#endif
  }}
#line 1003 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 583 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_stat_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1009 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_stat_cb"
#line 583 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 583 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 583 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1018 "mn-pop3-mailbox.c"
{
#line 587 "mn-pop3-mailbox.gob"
	
#ifndef WITH_MIME
    switch (response->type)
      {
      case RESPONSE_OK:
	{
	  int count;
	  int size;
	  
	  if (response->arguments && sscanf(response->arguments, "%d %d", &count, &size) == 2)
	    {
	      GDK_THREADS_ENTER();
	      mn_mailbox_set_has_new(priv->mailbox, count != 0);
	      gdk_flush();
	      GDK_THREADS_LEAVE();
	      
	      return STATE_QUIT;
	    }
	  else			/* compliance error */
	    return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	}
	break;
	
      case RESPONSE_ERR:	return RESULT_ERROR_QUIT;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else /* ! WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1051 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 618 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1057 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_quit_cb"
#line 618 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 618 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1064 "mn-pop3-mailbox.c"
{
#line 621 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "QUIT");
  }}
#line 1070 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 625 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1076 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_quit_cb"
#line 625 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 625 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 625 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1085 "mn-pop3-mailbox.c"
{
#line 629 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:		return MN_CLIENT_SESSION_RESULT_END;
      case RESPONSE_ERR:	return RESULT_ERROR_END;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 1096 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 638 "mn-pop3-mailbox.gob"
static MNAuthenticatedMailboxResult 
___19_mn_pop3_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox G_GNUC_UNUSED, GError ** err)
#line 1102 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___authenticated_mailbox,___err) \
	((MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)? \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)(___authenticated_mailbox,___err): \
		((MNAuthenticatedMailboxResult )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::impl_authenticated_check"
#line 638 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (authenticated_mailbox != NULL, (MNAuthenticatedMailboxResult )0);
#line 638 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (authenticated_mailbox), (MNAuthenticatedMailboxResult )0);
#line 1113 "mn-pop3-mailbox.c"
{
#line 641 "mn-pop3-mailbox.gob"
	
    MNMailbox *mailbox = MN_MAILBOX(authenticated_mailbox);
    Self *self = SELF(authenticated_mailbox);
    MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,			self_handle_greeting_cb },
      { STATE_CAPA,		self_enter_capa_cb,	self_handle_capa_cb },
#ifdef WITH_SSL
      { STATE_STLS,		self_enter_stls_cb,	self_handle_stls_cb },
#endif
#ifdef WITH_SASL
      { STATE_AUTH,		self_enter_auth_cb,	self_handle_auth_cb },
#endif
      { STATE_APOP,		self_enter_apop_cb,	self_handle_apop_cb },
      { STATE_USER,		self_enter_user_cb,	self_handle_user_cb },
      { STATE_PASS,		self_enter_pass_cb,	self_handle_pass_cb },
#ifdef WITH_MIME
      { STATE_LIST,		self_enter_list_cb,	self_handle_list_cb },
      { STATE_RETR,		self_enter_retr_cb,	self_handle_retr_cb },
#else /* WITH_MIME */
      { STATE_STAT,		self_enter_stat_cb,	self_handle_stat_cb },
#endif
      { STATE_QUIT,		self_enter_quit_cb,	self_handle_quit_cb },
      
      MN_CLIENT_SESSION_STATES_END
    };
    MNClientSessionCallbacks callbacks = {
      self_notice_cb,
      self_response_new_cb,
      self_response_free_cb,
      self_custom_handler_cb,
      NULL,			/* pre_read */
      NULL			/* post_read */
    };
    MNClientSessionPrivate priv;
    gboolean status;

    if (selfp->login_delay && selfp->authentication_timer)
      {
	double elapsed;

	g_timer_stop(selfp->authentication_timer);
	elapsed = g_timer_elapsed(selfp->authentication_timer, NULL);

	if (elapsed < selfp->login_delay)
	  {
	    int sleeptime;
	    
	    sleeptime = selfp->login_delay - elapsed;
	    mn_mailbox_notice(mailbox,
			      ngettext("honouring LOGIN-DELAY, sleeping for %i second",
				       "honouring LOGIN-DELAY, sleeping for %i seconds",
				       sleeptime),
			      sleeptime);
	    sleep(sleeptime);
	  }
      }
  
    memset(&priv, 0, sizeof(priv));
    priv.mailbox = mailbox;
    priv.self = self;

    status = mn_client_session_run(states,
				   &callbacks,
#ifdef WITH_SSL
				   MN_URI_IS_SSL(mailbox->uri),
#endif
				   mailbox->uri->hostname,
				   mailbox->uri->port,
				   mailbox->uri->username,
				   MN_AUTHENTICATED_MAILBOX(self)->password,
				   &priv,
				   err);

    g_free(priv.apop_timestamp);
    eel_g_slist_free_deep(priv.auth_mechanisms);
#ifdef WITH_MIME
    g_slist_free(priv.message_numbers);
    mn_g_object_slist_free(priv.messages);
    if (priv.current_message)
      g_string_free(priv.current_message, TRUE);
#endif

    return status
      ? MN_AUTHENTICATED_MAILBOX_OK
      : (priv.authentication_failed
	 ? MN_AUTHENTICATED_MAILBOX_ERROR_AUTHENTICATION
	 : MN_AUTHENTICATED_MAILBOX_ERROR_OTHER);
  }}
#line 1204 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 730 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv)
#line 1211 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::notice_cb"
#line 730 "mn-pop3-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 730 "mn-pop3-mailbox.gob"
	g_return_if_fail (str != NULL);
#line 730 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1220 "mn-pop3-mailbox.c"
{
#line 734 "mn-pop3-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", str);
  }}
#line 1226 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 738 "mn-pop3-mailbox.gob"
static MNClientSessionResponse * 
mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 1232 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_new_cb"
#line 738 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (MNClientSessionResponse * )0);
#line 738 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (input != NULL, (MNClientSessionResponse * )0);
#line 738 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (MNClientSessionResponse * )0);
#line 1241 "mn-pop3-mailbox.c"
{
#line 742 "mn-pop3-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    if (priv->in_list)
      {
	response = g_new0(MNClientSessionResponse, 1);
	if (! strcmp(input, "."))
	  response->type = RESPONSE_LIST_END;
	else if (g_str_has_prefix(input, ".."))
	  {
	    response->type = RESPONSE_LIST_ITEM;
	    response->arguments = g_strdup(input + 1); /* skip the initial dot */
	  }
	else
	  {
	    response->type = RESPONSE_LIST_ITEM;
	    response->arguments = g_strdup(input);
	  }
      }
    else
      {
	if (g_str_has_prefix(input, "+ "))
	  {
	    response = g_new0(MNClientSessionResponse, 1);
	    response->type = RESPONSE_CONTINUATION;
	    response->arguments = g_strdup(input + 2);
	  }
	else
	  {
	    ResponseType type;
	    int after_status = 0;
	    
	    if (g_str_has_prefix(input, "+OK"))
	      {
		type = RESPONSE_OK;
		after_status = 3;
	      }
	    else if (g_str_has_prefix(input, "-ERR"))
	      {
		type = RESPONSE_ERR;
		after_status = 4;
	      }
	    
	    if (after_status)
	      {
		if (input[after_status] == 0 || input[after_status] == ' ')
		  {
		    response = g_new0(MNClientSessionResponse, 1);
		    response->type = type;
		    if (input[after_status] == ' ')
		      response->arguments = g_strdup(input + after_status + 1);
		  }
	      }
	  }
      }
    
    return response;
  }}
#line 1302 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 801 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1308 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_free_cb"
#line 801 "mn-pop3-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 801 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 801 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1317 "mn-pop3-mailbox.c"
{
#line 805 "mn-pop3-mailbox.gob"
	
    g_free(response->arguments);
    g_free(response);
  }}
#line 1324 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 810 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv)
#line 1330 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::custom_handler_cb"
#line 810 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 810 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 810 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1339 "mn-pop3-mailbox.c"
{
#line 815 "mn-pop3-mailbox.gob"
	
    switch (result)
      {
      case RESULT_ERROR_QUIT:
	self_session_set_error_from_arguments(priv, response);
	return STATE_QUIT;

      case RESULT_ERROR_END:
	self_session_set_error_from_arguments(priv, response);
	return MN_CLIENT_SESSION_RESULT_END;
	
    default:
      g_return_val_if_reached(0);
      }
  }}
#line 1357 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 831 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1363 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate"
#line 831 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1368 "mn-pop3-mailbox.c"
{
#line 833 "mn-pop3-mailbox.gob"
	
    if (priv->mailbox->uri->authmech)
      {
	if (*priv->mailbox->uri->authmech != '+')
	  {
#ifdef WITH_SASL
	    return STATE_AUTH;
#else
	    return mn_client_session_error(priv->session, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->mailbox->uri->authmech, "+APOP"))
	      return priv->apop_timestamp
		? STATE_APOP
		: mn_client_session_error(priv->session, _("server does not support APOP authentication"));
	    else if (! strcmp(priv->mailbox->uri->authmech, "+USERPASS"))
	      return STATE_USER;
	    else
	      return mn_client_session_error(priv->session, _("unknown authentication mechanism \"%s\""), priv->mailbox->uri->authmech);
	  }
      }
    else
      {
#ifdef WITH_SASL
	if (priv->auth_mechanisms)
	  return STATE_AUTH;
#endif /* WITH_SASL */
	if (priv->apop_timestamp)
	  return STATE_APOP;
	else
	  return STATE_USER;
      }
  }}
#line 1406 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 869 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop)
#line 1412 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate_fallback"
#line 869 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1417 "mn-pop3-mailbox.c"
{
#line 872 "mn-pop3-mailbox.gob"
	
    if (! priv->mailbox->uri->authmech)
      {
	if (! tried_apop && priv->apop_timestamp)
	  {
	    mn_client_session_notice(priv->session, _("falling back to APOP authentication"));
	    return STATE_APOP;
	  }
	else
	  {
	    mn_client_session_notice(priv->session, _("falling back to USER/PASS authentication"));
	    return STATE_USER;
	  }
      }

    priv->authentication_failed = TRUE;
    return mn_client_session_error(priv->session, _("authentication failed"));
  }}
#line 1438 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 891 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv)
#line 1444 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticated"
#line 891 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1449 "mn-pop3-mailbox.c"
{
#line 893 "mn-pop3-mailbox.gob"
	
    priv->authenticated = TRUE;
    if (priv->self->_priv->login_delay)
      {
	if (priv->self->_priv->authentication_timer)
	  g_timer_start(priv->self->_priv->authentication_timer);
	else
	  priv->self->_priv->authentication_timer = g_timer_new();
      }
    return priv->login_delay_user ? STATE_CAPA : self_session_check_mail(priv);
  }}
#line 1463 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 905 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_check_mail (MNClientSessionPrivate * priv)
#line 1469 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_check_mail"
#line 905 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1474 "mn-pop3-mailbox.c"
{
#line 907 "mn-pop3-mailbox.gob"
	
#ifdef WITH_MIME
    return STATE_LIST;
#else
    return STATE_STAT;
#endif
  }}
#line 1484 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 915 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1490 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_set_error_from_arguments"
#line 915 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 915 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1497 "mn-pop3-mailbox.c"
{
#line 918 "mn-pop3-mailbox.gob"
	
    if (response->arguments)
      mn_client_session_error(priv->session, "\"%s\"", response->arguments);
    else
      mn_client_session_error(priv->session, _("unknown server error"));
  }}
#line 1506 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 925 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_handle_list_response (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1512 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_list_response"
#line 925 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 925 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1519 "mn-pop3-mailbox.c"
{
#line 928 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	priv->in_list = TRUE;
	break;

      case RESPONSE_LIST_ITEM:	/* nop */
	break;

      default:
	priv->in_list = FALSE;
	break;
      }
  }}
#line 1537 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
