/* Generated by GOB (v2.0.11) on Mon Nov 15 16:14:35 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "mn-imap-mailbox.h"

#include "mn-imap-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 36 "mn-imap-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-util.h"
#ifdef WITH_MIME
#include "mn-message-mime.h"
#endif

#define HAS_CURRENT_TAG(response, priv)	(! strcmp((response)->tag, (priv)->tag))
#define IS(response, token)		(! strcmp((response)->response, (token)))
#define IS_OK(response)			IS(response, "OK")
#define IS_NO(response)			IS(response, "NO")
#define IS_BAD(response)		IS(response, "BAD")
#define IS_BYE(response)		IS(response, "BYE")

#define REMOVED(self)			(g_atomic_int_get(&(self)->_priv->removed))

  enum
  {
    STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
    STATE_CAPABILITY,
#ifdef WITH_SSL
    STATE_STARTTLS,
#endif
#ifdef WITH_SASL
    STATE_AUTHENTICATE,
#endif
    STATE_LOGIN,
    STATE_EXAMINE,
    STATE_SEARCH,
#ifdef WITH_MIME
    STATE_FETCH,
#else /* WITH_MIME */
    STATE_STATUS,
#endif
    STATE_IDLE,
    STATE_LOGOUT
  };
  
  enum
  {
    RESULT_ERROR_LOGOUT		= -1, /* server reported an error, logout normally */
    RESULT_ERROR_END		= -2, /* server reported an error, close the connection */
    RESULT_DEFAULT_HANDLER	= -3  /* invoke the default response handler */
  };

  typedef enum
  {
    IDLE_STATE_NORMAL,
    IDLE_STATE_IDLING,
    IDLE_STATE_WAS_IDLING
  } IdleState;

  struct _MNClientSessionPrivate
  {
    MNMailbox		*mailbox;
    MNIMAPMailbox	*self;
    MNClientSession	*session;

    int			numeric_tag;
    char		tag[5];

    char		**capabilities;
    GSList		*auth_mechanisms;
    gboolean		authenticated;
    gboolean		authentication_failed;

    gboolean		search_received;
    GSList		*fetch_numbers;
    char		*fetch_set;

#ifdef WITH_MIME
    GSList		*received_numbers;
    GSList		*messages;
#else /* WITH_MIME */
    gboolean		status_received;
#endif

#ifdef WITH_SSL
    gboolean		starttls_completed;
#endif
#ifdef WITH_SASL
    const char		*sasl_mechanism;
#endif

    IdleState		idle_state;
    gboolean		could_idle;	/* could idle at least once */
  };
  
  struct _MNClientSessionResponse
  {
    char		*continuation;
    char		*tag;
    char		*response;
    char		*code;
    char		*arguments;
  };

#line 131 "mn-imap-mailbox.c"
/* self casting macros */
#define SELF(x) MN_IMAP_MAILBOX(x)
#define SELF_CONST(x) MN_IMAP_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_IMAP_MAILBOX(x)
#define TYPE_SELF MN_TYPE_IMAP_MAILBOX
#define SELF_CLASS(x) MN_IMAP_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_IMAP_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNIMAPMailbox Self;
typedef MNIMAPMailboxClass SelfClass;

/* here are local prototypes */
static void mn_imap_mailbox_init (MNIMAPMailbox * o) G_GNUC_UNUSED;
static void mn_imap_mailbox_class_init (MNIMAPMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_imap_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_imap_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static void ___4_mn_imap_mailbox_removed (MNMailbox * mailbox) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_search_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_search_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_status_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_status_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNAuthenticatedMailboxResult ___1a_mn_imap_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox, GError ** err) G_GNUC_UNUSED;
static void mn_imap_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...) G_GNUC_UNUSED;
static void mn_imap_mailbox_handle_capability_code (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_check_mail (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static char * mn_imap_mailbox_quote (const char * str) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_handle_greeting_cb mn_imap_mailbox_handle_greeting_cb
#define self_enter_capability_cb mn_imap_mailbox_enter_capability_cb
#define self_handle_capability_cb mn_imap_mailbox_handle_capability_cb
#define self_enter_starttls_cb mn_imap_mailbox_enter_starttls_cb
#define self_handle_starttls_cb mn_imap_mailbox_handle_starttls_cb
#define self_enter_authenticate_cb mn_imap_mailbox_enter_authenticate_cb
#define self_handle_authenticate_cb mn_imap_mailbox_handle_authenticate_cb
#define self_enter_login_cb mn_imap_mailbox_enter_login_cb
#define self_handle_login_cb mn_imap_mailbox_handle_login_cb
#define self_enter_examine_cb mn_imap_mailbox_enter_examine_cb
#define self_handle_examine_cb mn_imap_mailbox_handle_examine_cb
#define self_enter_search_cb mn_imap_mailbox_enter_search_cb
#define self_handle_search_cb mn_imap_mailbox_handle_search_cb
#define self_enter_fetch_cb mn_imap_mailbox_enter_fetch_cb
#define self_handle_fetch_cb mn_imap_mailbox_handle_fetch_cb
#define self_enter_idle_cb mn_imap_mailbox_enter_idle_cb
#define self_handle_idle_cb mn_imap_mailbox_handle_idle_cb
#define self_enter_status_cb mn_imap_mailbox_enter_status_cb
#define self_handle_status_cb mn_imap_mailbox_handle_status_cb
#define self_enter_logout_cb mn_imap_mailbox_enter_logout_cb
#define self_handle_logout_cb mn_imap_mailbox_handle_logout_cb
#define self_notice_cb mn_imap_mailbox_notice_cb
#define self_response_new_cb mn_imap_mailbox_response_new_cb
#define self_response_free_cb mn_imap_mailbox_response_free_cb
#define self_custom_handler_cb mn_imap_mailbox_custom_handler_cb
#define self_pre_read_cb mn_imap_mailbox_pre_read_cb
#define self_post_read_cb mn_imap_mailbox_post_read_cb
#define self_session_set_error_from_arguments mn_imap_mailbox_session_set_error_from_arguments
#define self_session_write mn_imap_mailbox_session_write
#define self_handle_capability_code mn_imap_mailbox_handle_capability_code
#define self_session_parse_capabilities mn_imap_mailbox_session_parse_capabilities
#define self_session_has_capability mn_imap_mailbox_session_has_capability
#define self_session_after_capability mn_imap_mailbox_session_after_capability
#define self_session_authenticate mn_imap_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_imap_mailbox_session_authenticate_fallback
#define self_session_check_mail mn_imap_mailbox_session_check_mail
#define self_quote mn_imap_mailbox_quote
GType
mn_imap_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNIMAPMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_imap_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNIMAPMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_imap_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNIMAPMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNIMAPMailbox *)g_object_new(mn_imap_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNIMAPMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNIMAPMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNIMAPMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNIMAPMailbox *)g_object_new_valist (mn_imap_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::finalize"
	MNIMAPMailbox *self G_GNUC_UNUSED = MN_IMAP_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 147 "mn-imap-mailbox.gob"
	if(self->_priv->idle_session_mutex) { g_mutex_free ((gpointer) self->_priv->idle_session_mutex); self->_priv->idle_session_mutex = NULL; }
#line 284 "mn-imap-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_imap_mailbox_init (MNIMAPMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNIMAPMailboxPrivate);
#line 147 "mn-imap-mailbox.gob"
	o->_priv->idle_session_mutex = g_mutex_new();
#line 295 "mn-imap-mailbox.c"
}
#undef __GOB_FUNCTION__
#line 149 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_class_init (MNIMAPMailboxClass * class G_GNUC_UNUSED)
#line 301 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNIMAPMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 154 "mn-imap-mailbox.gob"
	g_object_class->constructor = ___2_mn_imap_mailbox_constructor;
#line 171 "mn-imap-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_imap_mailbox_impl_is;
#line 177 "mn-imap-mailbox.gob"
	mn_mailbox_class->removed = ___4_mn_imap_mailbox_removed;
#line 845 "mn-imap-mailbox.gob"
	mn_authenticated_mailbox_class->impl_authenticated_check = ___1a_mn_imap_mailbox_impl_authenticated_check;
#line 320 "mn-imap-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 150 "mn-imap-mailbox.gob"

    MN_MAILBOX_CLASS(class)->format = "IMAP";
  
#line 327 "mn-imap-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 154 "mn-imap-mailbox.gob"
static GObject * 
___2_mn_imap_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 337 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::constructor"
{
#line 156 "mn-imap-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);

#ifndef WITH_SSL
    if (MN_URI_IS_SSL(mailbox->uri) || MN_URI_IS_INBAND_SSL(mailbox->uri))
      mn_mailbox_set_init_error(mailbox, _("SSL/TLS support has not been compiled in"));
#endif /* WITH_SSL */

    return object;
  }}
#line 360 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 171 "mn-imap-mailbox.gob"
static gboolean 
___3_mn_imap_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 367 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::impl_is"
#line 171 "mn-imap-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 171 "mn-imap-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 378 "mn-imap-mailbox.c"
{
#line 173 "mn-imap-mailbox.gob"
	
    return MN_URI_IS_IMAP(uri);
  }}
#line 384 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 177 "mn-imap-mailbox.gob"
static void 
___4_mn_imap_mailbox_removed (MNMailbox * mailbox G_GNUC_UNUSED)
#line 391 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->removed) \
		(* MN_MAILBOX_CLASS(parent_class)->removed)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::removed"
#line 177 "mn-imap-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 177 "mn-imap-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 401 "mn-imap-mailbox.c"
{
#line 179 "mn-imap-mailbox.gob"
	
    Self *self = SELF(mailbox);

    g_atomic_int_inc(&selfp->removed);

    g_mutex_lock(selfp->idle_session_mutex);
    if (selfp->idle_session)
      {
	mn_client_session_write(selfp->idle_session->session, "DONE");
	selfp->idle_session->idle_state = IDLE_STATE_WAS_IDLING;
      }
    g_mutex_unlock(selfp->idle_session_mutex);

    PARENT_HANDLER(mailbox);
  }}
#line 419 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 195 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 426 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_greeting_cb"
#line 195 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 195 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 195 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 435 "mn-imap-mailbox.c"
{
#line 199 "mn-imap-mailbox.gob"
	
    priv->session = session;

    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (! response->tag && IS_OK(response))
      {
	self_handle_capability_code(priv, response);
	return priv->capabilities
	  ? self_session_after_capability(priv)
	  : STATE_CAPABILITY;
      }
    else if (! response->tag && IS(response, "PREAUTH"))
      {
	self_handle_capability_code(priv, response);
	return self_session_check_mail(priv);
      }
    else if (! response->tag && IS_BYE(response))
      return RESULT_ERROR_END;
    else
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
  }}
#line 460 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 222 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 466 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_capability_cb"
#line 222 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 222 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 473 "mn-imap-mailbox.c"
{
#line 225 "mn-imap-mailbox.gob"
	
    return self_session_write(priv, "CAPABILITY");
  }}
#line 479 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 229 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 485 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_capability_cb"
#line 229 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 229 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 229 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 494 "mn-imap-mailbox.c"
{
#line 233 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		return priv->capabilities
		  ? self_session_after_capability(priv)
		  : mn_client_session_error(session, _("server did not send capabilities"));
	      }
	    else if (IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "CAPABILITY"))
      {
	self_session_parse_capabilities(priv, response->arguments);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }
    
    return RESULT_DEFAULT_HANDLER;
  }}
#line 524 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 261 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 530 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_starttls_cb"
#line 261 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 261 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 537 "mn-imap-mailbox.c"
{
#line 264 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    return self_session_write(priv, "STARTTLS");
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 547 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 272 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 553 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_starttls_cb"
#line 272 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 272 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 272 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 562 "mn-imap-mailbox.c"
{
#line 276 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		priv->starttls_completed = TRUE;
		return mn_client_session_enable_ssl(session)
		  ? STATE_CAPABILITY
		  : RESULT_ERROR_END;
	      }
	    else if (IS_BAD(response))
	      return self_session_authenticate(priv);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return RESULT_DEFAULT_HANDLER;
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 592 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 304 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 598 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_authenticate_cb"
#line 304 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 304 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 605 "mn-imap-mailbox.c"
{
#line 307 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    /*
     * RFC 3501 6.2.2 specifies that the IMAP protocol does not
     * support the "initial response" feature of SASL, so we set the
     * initial_response argument to FALSE.
     */
    if (mn_client_session_sasl_authentication_start(priv->session,
						    "imap",
						    priv->auth_mechanisms,
						    priv->mailbox->uri->authmech,
						    &priv->sasl_mechanism,
						    FALSE))
      return self_session_write(priv, "AUTHENTICATE %s", priv->sasl_mechanism);
    else
      return self_session_authenticate_fallback(priv);
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 628 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 328 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 634 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_authenticate_cb"
#line 328 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 328 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 328 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 643 "mn-imap-mailbox.c"
{
#line 332 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (mn_client_session_sasl_authentication_done(session))
		  {
		    priv->authenticated = TRUE;
		    self_handle_capability_code(priv, response);

		    /*
		     * RFC 3501 2.2.2:
		     *
		     * A server MAY include a CAPABILITY response code
		     * in the tagged OK response of a successful
		     * AUTHENTICATE command in order to send
		     * capabilities automatically.  It is unnecessary
		     * for a client to send a separate CAPABILITY
		     * command if it recognizes these automatic
		     * capabilities.  This should only be done if a
		     * security layer was not negotiated by the
		     * AUTHENTICATE command, because the tagged OK
		     * response as part of an AUTHENTICATE command is
		     * not protected by encryption/integrity checking.
		     * [SASL] requires the client to re-issue a
		     * CAPABILITY command in this case.
		     */
		    return priv->capabilities && mn_client_session_sasl_get_ssf(session)
		      ? self_session_check_mail(priv)
		      : STATE_CAPABILITY;
		  }
		else
		  return MN_CLIENT_SESSION_RESULT_END;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return self_session_authenticate_fallback(priv);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (response->continuation)
      return mn_client_session_sasl_authentication_step(session, response->continuation);
    
    return RESULT_DEFAULT_HANDLER;
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 697 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 384 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 703 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_login_cb"
#line 384 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 384 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 710 "mn-imap-mailbox.c"
{
#line 387 "mn-imap-mailbox.gob"
	
    if (self_session_has_capability(priv, "LOGINDISABLED"))
      {
	mn_client_session_notice(session, _("server advertised LOGINDISABLED, not using LOGIN authentication"));
	mn_client_session_error(session, _("unable to login"));
	return STATE_LOGOUT;
      }
    else
      {
	char *quoted_username;
	char *quoted_password;
	int result;

	quoted_username = self_quote(priv->mailbox->uri->username);
	quoted_password = self_quote(MN_AUTHENTICATED_MAILBOX(priv->self)->password);
	result = self_session_write(priv, "LOGIN %s %s", quoted_username, quoted_password);
	g_free(quoted_username);
	g_free(quoted_password);

	return result;
      }
  }}
#line 735 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 410 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 741 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_login_cb"
#line 410 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 410 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 410 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 750 "mn-imap-mailbox.c"
{
#line 414 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		priv->authenticated = TRUE;
		self_handle_capability_code(priv, response);
		return priv->capabilities
		  ? STATE_CAPABILITY
		  : self_session_check_mail(priv);
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      {
		priv->authentication_failed = TRUE;
		return RESULT_ERROR_LOGOUT;
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    
    return RESULT_DEFAULT_HANDLER;
  }}
#line 780 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 442 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 786 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_examine_cb"
#line 442 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 442 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 793 "mn-imap-mailbox.c"
{
#line 445 "mn-imap-mailbox.gob"
	
    char *quoted_mailbox;
    int result;

    quoted_mailbox = self_quote(priv->mailbox->uri->path);
    result = self_session_write(priv, "EXAMINE %s", quoted_mailbox);
    g_free(quoted_mailbox);

    return result;
  }}
#line 806 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 456 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 812 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_examine_cb"
#line 456 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 456 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 456 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 821 "mn-imap-mailbox.c"
{
#line 460 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      return STATE_SEARCH;
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 842 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 479 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_search_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 848 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_search_cb"
#line 479 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 479 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 855 "mn-imap-mailbox.c"
{
#line 482 "mn-imap-mailbox.gob"
	
    priv->search_received = FALSE;

    g_slist_free(priv->fetch_numbers);
    priv->fetch_numbers = NULL;

    g_free(priv->fetch_set);
    priv->fetch_set = NULL;
    
    return self_session_write(priv, "SEARCH UNSEEN");
  }}
#line 869 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 494 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_search_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 875 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_search_cb"
#line 494 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 494 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 494 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 884 "mn-imap-mailbox.c"
{
#line 498 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (priv->search_received)
		  {
		    if (priv->fetch_set)
		      {
#ifdef WITH_MIME
			return STATE_FETCH;
#else
			GDK_THREADS_ENTER();
			mn_mailbox_set_has_new(priv->mailbox, TRUE);
			gdk_flush();
			GDK_THREADS_LEAVE();

			return STATE_IDLE;
#endif /* WITH_MIME */
		      }
		    else
		      {
			GDK_THREADS_ENTER();
			mn_mailbox_set_has_new(priv->mailbox, FALSE);
#ifdef WITH_MIME
			mn_mailbox_set_messages(priv->mailbox, NULL);
#endif
			gdk_flush();
			GDK_THREADS_LEAVE();

			return self_session_has_capability(priv, "IDLE")
			  ? STATE_IDLE
			  : STATE_LOGOUT;
		      }
		  }
		else		/* compliance error */
		  return mn_client_session_error(session, _("server did not send search results"));
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "SEARCH"))
      {
	if (response->arguments)
	  {
	    char **numbers;
	    GString *string;
	    int i;

	    numbers = g_strsplit(response->arguments, " ", 0);
	    string = g_string_new(NULL);

	    for (i = 0; numbers[i]; i++)
	      if (mn_str_isnumeric(numbers[i]))
		{
		  int n = atoi(numbers[i]);

		  if (*string->str)
		    g_string_append_c(string, ',');
		  g_string_append(string, numbers[i]);

		  priv->fetch_numbers = g_slist_append(priv->fetch_numbers, GINT_TO_POINTER(n));
		}

	    g_strfreev(numbers);
	    priv->fetch_set = g_string_free(string, FALSE);
	  }

	priv->search_received = TRUE;
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 968 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 580 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 974 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_fetch_cb"
#line 580 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 580 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 981 "mn-imap-mailbox.c"
{
#line 583 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    g_return_val_if_fail(priv->fetch_set != NULL, 0);

    g_slist_free(priv->received_numbers);
    priv->received_numbers = NULL;

    mn_g_object_slist_free(priv->messages);
    priv->messages = NULL;

    return self_session_write(priv, "FETCH %s BODY[HEADER]", priv->fetch_set);
#else /* WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 999 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 599 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1005 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_fetch_cb"
#line 599 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 599 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 599 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1014 "mn-imap-mailbox.c"
{
#line 603 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		GSList *l;

		MN_LIST_FOREACH(l, priv->fetch_numbers)
		  if (! g_slist_find(priv->received_numbers, l->data))
		    /* compliance error */
		    return mn_client_session_error(session, _("server did not send all the messages we requested"));
		    
		GDK_THREADS_ENTER();
		mn_mailbox_set_has_new(priv->mailbox, priv->messages != NULL);
		mn_mailbox_set_messages(priv->mailbox, priv->messages);
		gdk_flush();
		GDK_THREADS_LEAVE();
		
		return self_session_has_capability(priv, "IDLE")
		  ? STATE_IDLE
		  : STATE_LOGOUT;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (mn_str_isnumeric(response->response)
	     && response->arguments
	     && g_str_has_prefix(response->arguments, "FETCH (BODY[HEADER]"))
      {
	int n = atoi(response->response);

	if (g_slist_find(priv->fetch_numbers, GINT_TO_POINTER(n)))
	  {
	    char *p;
	    int len;

	    priv->received_numbers = g_slist_append(priv->received_numbers, GINT_TO_POINTER(n));

	    /* we assume the header string will be in literal form */

	    p = strrchr(response->arguments, '{');
	    if (p && sscanf(p, "{%d}", &len) == 1 && len >= 0)
	      {
		gconstpointer buf;
		
		buf = mn_client_session_read(session, len);
		if (! buf)
		  return MN_CLIENT_SESSION_RESULT_END;
		
		priv->messages = g_slist_append(priv->messages, mn_message_new_from_buffer(priv->mailbox->uri, buf, len));
		
		/* read end of line (after literal) */
		if (! mn_client_session_read_line(session))
		  return MN_CLIENT_SESSION_RESULT_END;
	      }
	    else
	      priv->messages = g_slist_append(priv->messages, mn_message_new_from_error(priv->mailbox->uri, _("unable to fetch message")));

	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
      }
	
    return RESULT_DEFAULT_HANDLER;
#else /* WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1092 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 679 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1098 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_idle_cb"
#line 679 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 679 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1105 "mn-imap-mailbox.c"
{
#line 682 "mn-imap-mailbox.gob"
	
    priv->idle_state = IDLE_STATE_NORMAL;
    return REMOVED(priv->self) ? STATE_LOGOUT : self_session_write(priv, "IDLE");
  }}
#line 1112 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 687 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1118 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_idle_cb"
#line 687 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 687 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 687 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1127 "mn-imap-mailbox.c"
{
#line 691 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	if (response->continuation || response->tag)
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;

	priv->idle_state = IDLE_STATE_WAS_IDLING;

	if (IS_BYE(response))
	  return MN_CLIENT_SESSION_RESULT_END; /* we'll reconnect */
	else
	  /* any other response wakes us up */
	  return mn_client_session_write(session, "DONE");
      }
    else
      {
	if (response->continuation)
	  {
	    if (priv->idle_state == IDLE_STATE_WAS_IDLING)
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	    else
	      {
		/* we're now in the idle loop */
		priv->idle_state = IDLE_STATE_IDLING;
		priv->could_idle = TRUE;
		
		GDK_THREADS_ENTER();
		mn_mailbox_set_must_poll(priv->mailbox, FALSE);
		gdk_flush();
		GDK_THREADS_LEAVE();

		return MN_CLIENT_SESSION_RESULT_CONTINUE;
	      }
	  }
	else if (response->tag)
	  {
	    if (HAS_CURRENT_TAG(response, priv))
	      {
		if (IS_OK(response))
		  return REMOVED(priv->self) ? STATE_LOGOUT : STATE_SEARCH;
		else if (IS_NO(response) || IS_BAD(response))
		  /*
		   * The server advertised IDLE but does not actually
		   * support it.
		   *
		   * Although strictly speaking this can be considered
		   * a compliance fault, we'll be tolerant and just
		   * logout without setting an error.
		   */
		  return STATE_LOGOUT;
		else
		  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	      }
	  }
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 1188 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 750 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_status_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1194 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_status_cb"
#line 750 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 750 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1201 "mn-imap-mailbox.c"
{
#line 753 "mn-imap-mailbox.gob"
	
#ifndef WITH_MIME
    char *quoted_mailbox;
    int result;

    quoted_mailbox = self_quote(priv->mailbox->uri->path);
    result = self_session_write(priv, "STATUS %s (UNSEEN)", quoted_mailbox);
    g_free(quoted_mailbox);

    return result;
#else /* ! WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1218 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 768 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_status_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1224 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_status_cb"
#line 768 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 768 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 768 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1233 "mn-imap-mailbox.c"
{
#line 772 "mn-imap-mailbox.gob"
	
#ifndef WITH_MIME
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (priv->status_received)
		  return STATE_LOGOUT;
		else		/* compliance error */
		  return mn_client_session_error(session, _("server did not send status"));
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "STATUS"))
      {
	int count;
	
	if (response->arguments && sscanf(response->arguments, "%*s (UNSEEN %i)", &count) == 1)
	  {
	    priv->status_received = TRUE;
	    
	    GDK_THREADS_ENTER();
	    mn_mailbox_set_has_new(priv->mailbox, count != 0);
	    gdk_flush();
	    GDK_THREADS_LEAVE();
	    
	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
	else
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
    
    return RESULT_DEFAULT_HANDLER;
#else /* ! WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1281 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 818 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1287 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_logout_cb"
#line 818 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 818 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1294 "mn-imap-mailbox.c"
{
#line 821 "mn-imap-mailbox.gob"
	
    return self_session_write(priv, "LOGOUT");
  }}
#line 1300 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 825 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1306 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_logout_cb"
#line 825 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 825 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 825 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1315 "mn-imap-mailbox.c"
{
#line 829 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag && HAS_CURRENT_TAG(response, priv))
      {
	if (IS_OK(response))
	  return MN_CLIENT_SESSION_RESULT_END;
	else if (IS_BAD(response))
	  return RESULT_ERROR_END;
	else
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
    else
      return MN_CLIENT_SESSION_RESULT_CONTINUE;
  }}
#line 1333 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 845 "mn-imap-mailbox.gob"
static MNAuthenticatedMailboxResult 
___1a_mn_imap_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox G_GNUC_UNUSED, GError ** err)
#line 1339 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___authenticated_mailbox,___err) \
	((MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)? \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)(___authenticated_mailbox,___err): \
		((MNAuthenticatedMailboxResult )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::impl_authenticated_check"
#line 845 "mn-imap-mailbox.gob"
	g_return_val_if_fail (authenticated_mailbox != NULL, (MNAuthenticatedMailboxResult )0);
#line 845 "mn-imap-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (authenticated_mailbox), (MNAuthenticatedMailboxResult )0);
#line 1350 "mn-imap-mailbox.c"
{
#line 848 "mn-imap-mailbox.gob"
	
    MNMailbox *mailbox = MN_MAILBOX(authenticated_mailbox);
    Self *self = SELF(authenticated_mailbox);
    MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,				self_handle_greeting_cb },
      { STATE_CAPABILITY,	self_enter_capability_cb,	self_handle_capability_cb },
#ifdef WITH_SSL
      { STATE_STARTTLS,		self_enter_starttls_cb,		self_handle_starttls_cb },
#endif
#ifdef WITH_SASL
      { STATE_AUTHENTICATE,	self_enter_authenticate_cb,	self_handle_authenticate_cb },
#endif
      { STATE_LOGIN,		self_enter_login_cb,		self_handle_login_cb },
      { STATE_EXAMINE,		self_enter_examine_cb,		self_handle_examine_cb },
      { STATE_SEARCH,		self_enter_search_cb,		self_handle_search_cb },
#ifdef WITH_MIME
      { STATE_FETCH,		self_enter_fetch_cb,		self_handle_fetch_cb },
#else
      { STATE_STATUS,		self_enter_status_cb,		self_handle_status_cb },
#endif
      { STATE_IDLE,		self_enter_idle_cb,		self_handle_idle_cb },
      { STATE_LOGOUT,		self_enter_logout_cb,		self_handle_logout_cb },
      
      MN_CLIENT_SESSION_STATES_END
    };
    MNClientSessionCallbacks callbacks = {
      self_notice_cb,
      self_response_new_cb,
      self_response_free_cb,
      self_custom_handler_cb,
      self_pre_read_cb,
      self_post_read_cb
    };
    MNClientSessionPrivate priv;
    gboolean status;

    do
      {
	memset(&priv, 0, sizeof(priv));
	priv.mailbox = mailbox;
	priv.self = self;
    
	status = mn_client_session_run(states,
				       &callbacks,
#ifdef WITH_SSL
				       MN_URI_IS_SSL(mailbox->uri),
#endif
				       mailbox->uri->hostname,
				       mailbox->uri->port,
				       mailbox->uri->username,
				       MN_AUTHENTICATED_MAILBOX(self)->password,
				       &priv,
				       err);
    
	g_strfreev(priv.capabilities);
	eel_g_slist_free_deep(priv.auth_mechanisms);

	g_slist_free(priv.fetch_numbers);
	g_free(priv.fetch_set);

#ifdef WITH_MIME
	g_slist_free(priv.received_numbers);
	mn_g_object_slist_free(priv.messages);
#endif
      }
    while (status && priv.could_idle && ! REMOVED(self));

    GDK_THREADS_ENTER();
    mn_mailbox_set_must_poll(mailbox, TRUE);
    gdk_flush();
    GDK_THREADS_LEAVE();

    return status
      ? MN_AUTHENTICATED_MAILBOX_OK
      : (priv.authentication_failed
	 ? MN_AUTHENTICATED_MAILBOX_ERROR_AUTHENTICATION
	 : MN_AUTHENTICATED_MAILBOX_ERROR_OTHER);
  }}
#line 1431 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 927 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv)
#line 1438 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::notice_cb"
#line 927 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 927 "mn-imap-mailbox.gob"
	g_return_if_fail (str != NULL);
#line 927 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1447 "mn-imap-mailbox.c"
{
#line 931 "mn-imap-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", str);
  }}
#line 1453 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 935 "mn-imap-mailbox.gob"
static MNClientSessionResponse * 
mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 1459 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_new_cb"
#line 935 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (MNClientSessionResponse * )0);
#line 935 "mn-imap-mailbox.gob"
	g_return_val_if_fail (input != NULL, (MNClientSessionResponse * )0);
#line 935 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (MNClientSessionResponse * )0);
#line 1468 "mn-imap-mailbox.c"
{
#line 939 "mn-imap-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    if (g_str_has_prefix(input, "+ "))
      {
	response = g_new0(MNClientSessionResponse, 1);
	response->continuation = g_strdup(input + 2);
      }
    else
      {
	char **tokens;
	
	tokens = g_strsplit(input, " ", 3);
	if (tokens[0] && tokens[1])
	  {
	    if (tokens[2] && tokens[2][0] == '[')
	      {
		char *code_start;
		char *code_end;
		
		code_start = tokens[2] + 1;
		code_end = strchr(code_start, ']');
		if (code_end)
		  {
		    response = g_new0(MNClientSessionResponse, 1);
		    response->code = g_strndup(code_start, code_end - code_start);
		    response->arguments = code_end[1] ? g_strdup(code_end + 2) : NULL;
		  }
	      }
	    else
	      {
		response = g_new0(MNClientSessionResponse, 1);
		response->arguments = g_strdup(tokens[2]);
	      }
	    
	    if (response)
	      {
		response->tag = ! strcmp(tokens[0], "*") ? NULL : g_strdup(tokens[0]);
		response->response = g_strdup(tokens[1]);
	      }
	  }
	g_strfreev(tokens);
      }
    
    return response;
  }}
#line 1517 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 986 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1523 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_free_cb"
#line 986 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 986 "mn-imap-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 986 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1532 "mn-imap-mailbox.c"
{
#line 990 "mn-imap-mailbox.gob"
	
    g_free(response->continuation);
    g_free(response->tag);
    g_free(response->response);
    g_free(response->code);
    g_free(response->arguments);
    g_free(response);
  }}
#line 1543 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 999 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv)
#line 1549 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::custom_handler_cb"
#line 999 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 999 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 999 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1558 "mn-imap-mailbox.c"
{
#line 1004 "mn-imap-mailbox.gob"
	
    switch (result)
      {
      case RESULT_ERROR_LOGOUT:
	self_session_set_error_from_arguments(priv, response);
	return STATE_LOGOUT;

      case RESULT_ERROR_END:
	self_session_set_error_from_arguments(priv, response);
	return MN_CLIENT_SESSION_RESULT_END;

      case RESULT_DEFAULT_HANDLER:
	if (! response->tag && IS_BYE(response))
	  return RESULT_ERROR_END;
	else
	  return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	g_return_val_if_reached(0);
      }
  }}
#line 1582 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1026 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1588 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::pre_read_cb"
#line 1026 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1026 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1595 "mn-imap-mailbox.c"
{
#line 1029 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	g_mutex_lock(priv->self->_priv->idle_session_mutex);
	priv->self->_priv->idle_session = priv;
	g_mutex_unlock(priv->self->_priv->idle_session_mutex);
      }
  }}
#line 1606 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1038 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1612 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::post_read_cb"
#line 1038 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1038 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1619 "mn-imap-mailbox.c"
{
#line 1041 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	g_mutex_lock(priv->self->_priv->idle_session_mutex);
	priv->self->_priv->idle_session = NULL;
	g_mutex_unlock(priv->self->_priv->idle_session_mutex);
      }
  }}
#line 1630 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1050 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1636 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_set_error_from_arguments"
#line 1050 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1050 "mn-imap-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1643 "mn-imap-mailbox.c"
{
#line 1053 "mn-imap-mailbox.gob"
	
    if (response->arguments)
      mn_client_session_error(priv->session, "\"%s\"", response->arguments);
    else
      mn_client_session_error(priv->session, _("unknown server error"));
  }}
#line 1652 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1060 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...)
#line 1658 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_write"
#line 1060 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1060 "mn-imap-mailbox.gob"
	g_return_val_if_fail (format != NULL, (int )0);
#line 1665 "mn-imap-mailbox.c"
{
#line 1064 "mn-imap-mailbox.gob"
	
    va_list args;
    char *command;
    int result;

    va_start(args, format);
    command = g_strdup_vprintf(format, args);
    va_end(args);
    
    if (priv->numeric_tag == 1000)
      priv->numeric_tag = 0;
    sprintf(priv->tag, "a%03i", priv->numeric_tag++);

    result = mn_client_session_write(priv->session, "%s %s", priv->tag, command);
    g_free(command);

    return result;
  }}
#line 1686 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1083 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_handle_capability_code (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1692 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_capability_code"
#line 1083 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1083 "mn-imap-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1699 "mn-imap-mailbox.c"
{
#line 1086 "mn-imap-mailbox.gob"
	
    if (response->code)
      {
	if (! strcmp(response->code, "CAPABILITY"))
	  self_session_parse_capabilities(priv, NULL);
	else if (g_str_has_prefix(response->code, "CAPABILITY "))
	  self_session_parse_capabilities(priv, response->code + 11);
      }
  }}
#line 1711 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1096 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities)
#line 1717 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_parse_capabilities"
#line 1096 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1722 "mn-imap-mailbox.c"
{
#line 1099 "mn-imap-mailbox.gob"
	
    g_strfreev(priv->capabilities);
    priv->capabilities = NULL;

    eel_g_slist_free_deep(priv->auth_mechanisms);
    priv->auth_mechanisms = NULL;

    if (capabilities)
      {
	int i;
	
	priv->capabilities = g_strsplit(capabilities, " ", 0);
	
	for (i = 0; priv->capabilities[i]; i++)
	  if (g_str_has_prefix(priv->capabilities[i], "AUTH="))
	    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(priv->capabilities[i] + 5));
      }
    else
      priv->capabilities = g_new0(char *, 1);
  }}
#line 1745 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1120 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability)
#line 1751 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_has_capability"
#line 1120 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (gboolean )0);
#line 1120 "mn-imap-mailbox.gob"
	g_return_val_if_fail (capability != NULL, (gboolean )0);
#line 1758 "mn-imap-mailbox.c"
{
#line 1123 "mn-imap-mailbox.gob"
	
    int i;

    g_return_val_if_fail(priv->capabilities != NULL, FALSE);

    for (i = 0; priv->capabilities[i]; i++)
      if (! strcmp(priv->capabilities[i], capability))
	return TRUE;
    
    return FALSE;
  }}
#line 1772 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1135 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv)
#line 1778 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_after_capability"
#line 1135 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1783 "mn-imap-mailbox.c"
{
#line 1137 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    if (MN_URI_IS_INBAND_SSL(priv->mailbox->uri)
	&& ! MN_URI_IS_SSL(priv->mailbox->uri)
	&& ! priv->starttls_completed)
      {
	if (self_session_has_capability(priv, "STARTTLS"))
	  return STATE_STARTTLS;
	else
	  {
	    mn_client_session_error(priv->session, _("server does not support in-band SSL/TLS"));
	    return STATE_LOGOUT;
	  }
      }
    else
#endif /* WITH_SSL */
      return priv->authenticated
	? self_session_check_mail(priv)
	: self_session_authenticate(priv);
  }}
#line 1806 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1158 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1812 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate"
#line 1158 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1817 "mn-imap-mailbox.c"
{
#line 1160 "mn-imap-mailbox.gob"
	
    if (priv->mailbox->uri->authmech)
      {
	if (*priv->mailbox->uri->authmech != '+')
	  {
#ifdef WITH_SASL
	    return STATE_AUTHENTICATE;
#else
	    return mn_client_session_error(priv->session, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->mailbox->uri->authmech, "+LOGIN"))
	      return STATE_LOGIN;
	    else
	      return mn_client_session_error(priv->session, _("unknown authentication mechanism \"%s\""), priv->mailbox->uri->authmech);
	  }
      }
    else
      {
#ifdef WITH_SASL
	if (priv->auth_mechanisms)
	  return STATE_AUTHENTICATE;
#endif /* WITH_SASL */
	return STATE_LOGIN;
      }
  }}
#line 1848 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1189 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv)
#line 1854 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate_fallback"
#line 1189 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1859 "mn-imap-mailbox.c"
{
#line 1191 "mn-imap-mailbox.gob"
	
    if (! priv->mailbox->uri->authmech)
      {
	mn_client_session_notice(priv->session, _("falling back to IMAP LOGIN authentication"));
	return STATE_LOGIN;
      }

    priv->authentication_failed = TRUE;
    return mn_client_session_error(priv->session, _("authentication failed"));
  }}
#line 1872 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1202 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_check_mail (MNClientSessionPrivate * priv)
#line 1878 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_check_mail"
#line 1202 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1883 "mn-imap-mailbox.c"
{
#line 1204 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    return STATE_EXAMINE;
#else
    return self_session_has_capability(priv, "IDLE")
      ? STATE_EXAMINE
      : STATE_STATUS;
#endif /* WITH_MIME */
  }}
#line 1895 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_imap_mailbox_quote:
 * @str: the string to quote
 *
 * Quotes a string using RFC 3501 BNF rules.
 *
 * Return value: the quoted string.
 **/
#line 1222 "mn-imap-mailbox.gob"
static char * 
mn_imap_mailbox_quote (const char * str)
#line 1909 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::quote"
#line 1222 "mn-imap-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 1914 "mn-imap-mailbox.c"
{
#line 1224 "mn-imap-mailbox.gob"
	
    GString *quoted;
    int i;

    quoted = g_string_new("\"");
    for (i = 0; str[i]; i++)
      if (str[i] == '"' || str[i] == '\\') /* quoted-specials in BNF */
	g_string_append_printf(quoted, "\\%c", str[i]);
      else
	g_string_append_c(quoted, str[i]);
    g_string_append_c(quoted, '"');

    return g_string_free(quoted, FALSE);
  }}
#line 1931 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
