/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-base-mbox-mailbox-backend.h"

#include "mn-base-mbox-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 28 "mn-base-mbox-mailbox-backend.gob"

#include "config.h"
#include <string.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-message-mime.h"
#include "mn-gmime-stream-vfs.h"
#include "mn-util.h"
#include "mn-vfs.h"
#if WITH_MBOX
#include "mn-mbox-mailbox-backend.h"
#endif
#if WITH_MOZILLA
#include "mn-mozilla-mailbox-backend.h"
#endif

#line 44 "mn-base-mbox-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_BASE_MBOX_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_BASE_MBOX_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_BASE_MBOX_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_BASE_MBOX_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_BASE_MBOX_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_BASE_MBOX_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNBaseMboxMailboxBackend Self;
typedef MNBaseMboxMailboxBackendClass SelfClass;

/* here are local prototypes */
static void mn_base_mbox_mailbox_backend_init (MNBaseMboxMailboxBackend * o) G_GNUC_UNUSED;
static void mn_base_mbox_mailbox_backend_class_init (MNBaseMboxMailboxBackendClass * c) G_GNUC_UNUSED;
static gboolean ___1_mn_base_mbox_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox) G_GNUC_UNUSED;
static GType mn_base_mbox_mailbox_backend_get_mailbox_type (GnomeVFSURI * uri) G_GNUC_UNUSED;
static GMimeParser * mn_base_mbox_mailbox_backend_parser_new (GnomeVFSURI * uri, GnomeVFSResult * result) G_GNUC_UNUSED;
static void ___4_mn_base_mbox_mailbox_backend_check (MNVFSMailboxBackend * backend, int check_id) G_GNUC_UNUSED;
static MNMessage * mn_base_mbox_mailbox_backend_get_new_message (MNBaseMboxMailboxBackend * self, GMimeMessage * mime_message) G_GNUC_UNUSED;
static GnomeVFSURI * mn_base_mbox_mailbox_backend_get_uncompressed_uri (GnomeVFSURI * uri, GnomeVFSFileInfo * file_info) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

/* Short form macros */
#define self_get_mailbox_type mn_base_mbox_mailbox_backend_get_mailbox_type
#define self_parser_new mn_base_mbox_mailbox_backend_parser_new
#define self_get_new_message mn_base_mbox_mailbox_backend_get_new_message
#define self_get_uncompressed_uri mn_base_mbox_mailbox_backend_get_uncompressed_uri
GType
mn_base_mbox_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNBaseMboxMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_base_mbox_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNBaseMboxMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_base_mbox_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNBaseMboxMailboxBackend", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNBaseMboxMailboxBackend *)g_object_new(mn_base_mbox_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNBaseMboxMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNBaseMboxMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNBaseMboxMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNBaseMboxMailboxBackend *)g_object_new_valist (mn_base_mbox_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::dispose"
	MNBaseMboxMailboxBackend *self G_GNUC_UNUSED = MN_BASE_MBOX_MAILBOX_BACKEND (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 50 "mn-base-mbox-mailbox-backend.gob"
	if(self->_priv->uri) { gnome_vfs_uri_unref ((gpointer) self->_priv->uri); self->_priv->uri = NULL; }
#line 128 "mn-base-mbox-mailbox-backend.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::finalize"
	MNBaseMboxMailboxBackend *self G_GNUC_UNUSED = MN_BASE_MBOX_MAILBOX_BACKEND (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 55 "mn-base-mbox-mailbox-backend.gob"
	if(self->_priv->mutex) { g_mutex_free ((gpointer) self->_priv->mutex); self->_priv->mutex = NULL; }
#line 143 "mn-base-mbox-mailbox-backend.c"
}
#undef __GOB_FUNCTION__

static void 
mn_base_mbox_mailbox_backend_init (MNBaseMboxMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_BASE_MBOX_MAILBOX_BACKEND,MNBaseMboxMailboxBackendPrivate);
#line 55 "mn-base-mbox-mailbox-backend.gob"
	o->_priv->mutex = g_mutex_new();
#line 154 "mn-base-mbox-mailbox-backend.c"
}
#undef __GOB_FUNCTION__
static void 
mn_base_mbox_mailbox_backend_class_init (MNBaseMboxMailboxBackendClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)c;

	g_type_class_add_private(c,sizeof(MNBaseMboxMailboxBackendPrivate));

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 57 "mn-base-mbox-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___1_mn_base_mbox_mailbox_backend_is;
#line 194 "mn-base-mbox-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___4_mn_base_mbox_mailbox_backend_check;
#line 172 "mn-base-mbox-mailbox-backend.c"
	c->get_new_message = NULL;
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 57 "mn-base-mbox-mailbox-backend.gob"
static gboolean 
___1_mn_base_mbox_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox)
#line 184 "mn-base-mbox-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___class,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___class,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::is"
{
#line 61 "mn-base-mbox-mailbox-backend.gob"
	
    gboolean is = FALSE;
    GnomeVFSURI *uri;
    GnomeVFSFileInfo *file_info;

    uri = gnome_vfs_uri_ref(mailbox->vfs_uri);
    file_info = gnome_vfs_file_info_new();

    if (gnome_vfs_get_file_info_uri(uri, file_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS | GNOME_VFS_FILE_INFO_GET_MIME_TYPE) == GNOME_VFS_OK)
      {
	GnomeVFSURI *uncompressed_uri;

	/* handle a compressed mailbox */
	uncompressed_uri = self_get_uncompressed_uri(uri, file_info);
	if (uncompressed_uri)
	  {
	    GnomeVFSFileInfo *uncompressed_file_info;

	    uncompressed_file_info = gnome_vfs_file_info_new();
	    if (gnome_vfs_get_file_info_uri(uncompressed_uri, uncompressed_file_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS) == GNOME_VFS_OK)
	      {
		gnome_vfs_file_info_unref(file_info);
		file_info = uncompressed_file_info;

		gnome_vfs_uri_unref(uri);
		uri = uncompressed_uri;
	      }
	    else
	      {
		gnome_vfs_file_info_unref(uncompressed_file_info);
		gnome_vfs_uri_unref(uncompressed_uri);
	      }
	  }

	if ((file_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_TYPE) != 0
	    && file_info->type == GNOME_VFS_FILE_TYPE_REGULAR
	    && self_get_mailbox_type(uri) == G_TYPE_FROM_CLASS(class))
	  is = TRUE;
      }

    gnome_vfs_uri_unref(uri);
    gnome_vfs_file_info_unref(file_info);

    return is;
  }}
#line 238 "mn-base-mbox-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 107 "mn-base-mbox-mailbox-backend.gob"
static GType 
mn_base_mbox_mailbox_backend_get_mailbox_type (GnomeVFSURI * uri)
#line 245 "mn-base-mbox-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::get_mailbox_type"
#line 107 "mn-base-mbox-mailbox-backend.gob"
	g_return_val_if_fail (uri != NULL, (GType )0);
#line 250 "mn-base-mbox-mailbox-backend.c"
{
#line 109 "mn-base-mbox-mailbox-backend.gob"
	
    GMimeParser *parser;
    GType type = 0;

    parser = self_parser_new(uri, NULL);
    if (parser != NULL)
      {
	if (g_mime_parser_eos(parser))
	  /*
	   * The file is empty. For now, treat it as a mbox mailbox
	   * or, if mbox support was not compiled in, as a Mozilla
	   * mailbox. Whenever the file grows, it will be checked
	   * again and at that point we will decide whether it is a
	   * mbox mailbox, a Mozilla mailbox or another type of file.
	   */
	  {
#if WITH_MBOX
	    type = MN_TYPE_MBOX_MAILBOX_BACKEND;
#elif WITH_MOZILLA
	    type = MN_TYPE_MOZILLA_MAILBOX_BACKEND;
#endif
	  }
	else
	  {
	    /*
	     * The file is not empty. Decide whether it is a Mozilla
	     * mailbox or a mbox mailbox by checking if the first
	     * message has a X-Mozilla-Status header. If the first
	     * message cannot be parsed, then it is neither a Mozilla
	     * mailbox nor a mbox mailbox.
	     */

	    GMimeMessage *mime_message;

	    mime_message = g_mime_parser_construct_message(parser);
	    if (mime_message)
	      {
		if (g_mime_message_get_header(mime_message, "X-Mozilla-Status"))
		  {
#if WITH_MOZILLA
		    type = MN_TYPE_MOZILLA_MAILBOX_BACKEND;
#endif
		  }
		else
		  {
#if WITH_MBOX
		    type = MN_TYPE_MBOX_MAILBOX_BACKEND;
#endif
		  }
		g_object_unref(mime_message);
	      }
	  }
	g_object_unref(parser);
      }

    return type;
  }}
#line 310 "mn-base-mbox-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 167 "mn-base-mbox-mailbox-backend.gob"
static GMimeParser * 
mn_base_mbox_mailbox_backend_parser_new (GnomeVFSURI * uri, GnomeVFSResult * result)
#line 316 "mn-base-mbox-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::parser_new"
#line 167 "mn-base-mbox-mailbox-backend.gob"
	g_return_val_if_fail (uri != NULL, (GMimeParser * )0);
#line 321 "mn-base-mbox-mailbox-backend.c"
{
#line 169 "mn-base-mbox-mailbox-backend.gob"
	
    GnomeVFSResult _result;
    GnomeVFSHandle *handle;
    GMimeParser *parser = NULL;

    _result = gnome_vfs_open_uri(&handle, uri, GNOME_VFS_OPEN_READ);
    if (_result == GNOME_VFS_OK)
      {
	GMimeStream *stream;

	stream = mn_gmime_stream_vfs_new(handle, uri, &_result);
	if (stream)
	  {
	    parser = g_mime_parser_new_with_stream(stream);
	    g_object_unref(stream);
	    g_mime_parser_set_scan_from(parser, TRUE);
	  }
      }

    if (result)
      *result = _result;

    return parser;
  }}
#line 348 "mn-base-mbox-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 194 "mn-base-mbox-mailbox-backend.gob"
static void 
___4_mn_base_mbox_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, int check_id)
#line 354 "mn-base-mbox-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::check"
{
#line 196 "mn-base-mbox-mailbox-backend.gob"
	
    Self *self = SELF(backend);
    gboolean polled;
    GMimeParser *parser;
    GnomeVFSResult result;
    gboolean uri_set;

    mn_vfs_mailbox_backend_monitor(backend, check_id, backend->mailbox->uri, GNOME_VFS_MONITOR_FILE);

    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      return;

    /* the poll property is protected by the GDK lock */
    GDK_THREADS_ENTER();

    polled = mn_mailbox_get_poll(MN_MAILBOX(backend->mailbox));

    gdk_flush();
    GDK_THREADS_LEAVE();

    if (polled)
      {
	GnomeVFSFileInfo *file_info;
	gboolean check;

	/*
	 * We are here because the mailbox has to be polled; only
	 * check it if necessary.
	 */

	file_info = gnome_vfs_file_info_new();
	result = gnome_vfs_get_file_info_uri(backend->mailbox->vfs_uri, file_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);

	g_mutex_lock(selfp->mutex);

	if (result == GNOME_VFS_OK
	    && (file_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_SIZE) != 0
	    && (file_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_MTIME) != 0
	    && file_info->size == selfp->last_size
	    && file_info->mtime == selfp->last_mtime)
	  {
	    if ((file_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_CTIME) != 0)
	      check = file_info->ctime != selfp->last_ctime;
	    else
	      /*
	       * The ctime is often missing for remote mailboxes;
	       * since anyway the size and mtime do not have changed,
	       * we do not check the mailbox.
	       */
	      check = FALSE;
	  }
	else
	  check = TRUE;

	if (check)
	  {
	    selfp->last_size = file_info->size;
	    selfp->last_mtime = file_info->mtime;
	    selfp->last_ctime = file_info->ctime;

	    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	      check = FALSE;
	  }

	g_mutex_unlock(selfp->mutex);

	gnome_vfs_file_info_unref(file_info);

	if (! check)
	  return;
      }

    g_mutex_lock(selfp->mutex);
    uri_set = selfp->uri != NULL;
    g_mutex_unlock(selfp->mutex);

    if (! uri_set)
      {
	GnomeVFSFileInfo *file_info;
	GnomeVFSURI *uri;
	gboolean aborted;

	file_info = gnome_vfs_file_info_new();
	if (gnome_vfs_get_file_info_uri(backend->mailbox->vfs_uri, file_info, GNOME_VFS_FILE_INFO_FOLLOW_LINKS | GNOME_VFS_FILE_INFO_GET_MIME_TYPE) == GNOME_VFS_OK)
	  uri = self_get_uncompressed_uri(backend->mailbox->vfs_uri, file_info);
	gnome_vfs_file_info_unref(file_info);

	if (! uri)
	  uri = gnome_vfs_uri_ref(backend->mailbox->vfs_uri);

	g_mutex_lock(selfp->mutex);

	if (! selfp->uri)
	  {
	    selfp->uri = uri;
	    uri = NULL;
	  }

	aborted = mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id);

	g_mutex_unlock(selfp->mutex);

	if (uri)
	  gnome_vfs_uri_unref(uri);

	if (aborted)
	  return;
      }

    parser = self_parser_new(selfp->uri, &result);
    if (parser)
      {
	GSList *messages = NULL;

	while (! g_mime_parser_eos(parser))
	  {
	    GMimeMessage *mime_message;

	    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	      break;

	    mime_message = g_mime_parser_construct_message(parser);
	    if (mime_message)
	      {
		MNMessage *message;

		message = MN_BASE_MBOX_MAILBOX_BACKEND_GET_CLASS(self)->get_new_message(self, mime_message);
		g_object_unref(mime_message);

		if (message)
		  messages = g_slist_prepend(messages, message);
	      }
	  }

	g_object_unref(parser);

	GDK_THREADS_ENTER();

	if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);

	mn_g_object_slist_free(messages);

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;			/* success */
      }

    if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to open mailbox: %s"), gnome_vfs_result_to_string(result));

	gdk_flush();
	GDK_THREADS_LEAVE();
      }
  }}
#line 521 "mn-base-mbox-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 356 "mn-base-mbox-mailbox-backend.gob"
static MNMessage * 
mn_base_mbox_mailbox_backend_get_new_message (MNBaseMboxMailboxBackend * self, GMimeMessage * mime_message)
#line 528 "mn-base-mbox-mailbox-backend.c"
{
	MNBaseMboxMailboxBackendClass *klass;
#line 356 "mn-base-mbox-mailbox-backend.gob"
	g_return_val_if_fail (self != NULL, (MNMessage * )0);
#line 356 "mn-base-mbox-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_BASE_MBOX_MAILBOX_BACKEND (self), (MNMessage * )0);
#line 535 "mn-base-mbox-mailbox-backend.c"
	klass = MN_BASE_MBOX_MAILBOX_BACKEND_GET_CLASS(self);

	if(klass->get_new_message)
		return (*klass->get_new_message)(self,mime_message);
	else
		return (MNMessage * )(0);
}

#line 359 "mn-base-mbox-mailbox-backend.gob"
static GnomeVFSURI * 
mn_base_mbox_mailbox_backend_get_uncompressed_uri (GnomeVFSURI * uri, GnomeVFSFileInfo * file_info)
#line 547 "mn-base-mbox-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Base:Mbox:Mailbox:Backend::get_uncompressed_uri"
#line 359 "mn-base-mbox-mailbox-backend.gob"
	g_return_val_if_fail (uri != NULL, (GnomeVFSURI * )0);
#line 359 "mn-base-mbox-mailbox-backend.gob"
	g_return_val_if_fail (file_info != NULL, (GnomeVFSURI * )0);
#line 554 "mn-base-mbox-mailbox-backend.c"
{
#line 362 "mn-base-mbox-mailbox-backend.gob"
	
    if ((file_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_MIME_TYPE) != 0 && file_info->mime_type)
      {
	/* compression methods supported by GnomeVFS */
	static const struct
	{
	  const char *mime_type;
	  const char *method;
	} compressions[] = {
	  { "application/x-gzip", "gzip" },
	  { "application/x-bzip", "bzip2" }
	};
	int i;

	for (i = 0; i < G_N_ELEMENTS(compressions); i++)
	  if (! strcmp(file_info->mime_type, compressions[i].mime_type))
	    {
	      char *str;
	      GnomeVFSURI *uncompressed_uri;

	      str = g_strdup_printf("%s%s:/", GNOME_VFS_URI_MAGIC_STR, compressions[i].method);
	      uncompressed_uri = gnome_vfs_uri_append_string(uri, str);
	      g_free(str);

	      return uncompressed_uri;
	    }
      }

    return NULL;
  }}
#line 587 "mn-base-mbox-mailbox-backend.c"
#undef __GOB_FUNCTION__
