/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-hotmail-mailbox.h"

#include "mn-hotmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 26 "mn-hotmail-mailbox.gob"

#include "config.h"
#include <unistd.h>
#include <glib/gi18n.h>
#include "mn-conf.h"
#include "mn-webmail-mailbox-private.h"
#include "mn-stock.h"

#line 35 "mn-hotmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_HOTMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_HOTMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_HOTMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_HOTMAIL_MAILBOX
#define SELF_CLASS(x) MN_HOTMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_HOTMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNHotmailMailbox Self;
typedef MNHotmailMailboxClass SelfClass;

/* here are local prototypes */
static void mn_hotmail_mailbox_class_init (MNHotmailMailboxClass * class) G_GNUC_UNUSED;
static void mn_hotmail_mailbox_init (MNHotmailMailbox * self) G_GNUC_UNUSED;
static char * mn_hotmail_mailbox_create_config_file (MNHotmailMailbox * self, const char * spool_file, GError ** err) G_GNUC_UNUSED;
static char * ___4_mn_hotmail_mailbox_get_error_message (MNWebmailMailbox * mailbox, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure) G_GNUC_UNUSED;
static gboolean mn_hotmail_mailbox_run_getlive (MNHotmailMailbox * self, const char * config_file, GError ** err) G_GNUC_UNUSED;
static gboolean ___6_mn_hotmail_mailbox_webmail_check (MNWebmailMailbox * mailbox, GError ** err) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNWebmailMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_create_config_file mn_hotmail_mailbox_create_config_file
#define self_run_getlive mn_hotmail_mailbox_run_getlive
GType
mn_hotmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNHotmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_hotmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNHotmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_hotmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_WEBMAIL_MAILBOX, "MNHotmailMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNHotmailMailbox *)g_object_new(mn_hotmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNHotmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNHotmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNHotmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNHotmailMailbox *)g_object_new_valist (mn_hotmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}

#line 37 "mn-hotmail-mailbox.gob"
static void 
mn_hotmail_mailbox_class_init (MNHotmailMailboxClass * class G_GNUC_UNUSED)
#line 108 "mn-hotmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::class_init"
	MNWebmailMailboxClass *mn_webmail_mailbox_class = (MNWebmailMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_WEBMAIL_MAILBOX);

#line 119 "mn-hotmail-mailbox.gob"
	mn_webmail_mailbox_class->get_error_message = ___4_mn_hotmail_mailbox_get_error_message;
#line 146 "mn-hotmail-mailbox.gob"
	mn_webmail_mailbox_class->webmail_check = ___6_mn_hotmail_mailbox_webmail_check;
#line 119 "mn-hotmail-mailbox.c"
 {
#line 38 "mn-hotmail-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "hotmail";

    /* 5 minutes is a good default */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;

    MN_WEBMAIL_MAILBOX_CLASS(class)->default_domain = "hotmail.com";
  
#line 130 "mn-hotmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 47 "mn-hotmail-mailbox.gob"
static void 
mn_hotmail_mailbox_init (MNHotmailMailbox * self G_GNUC_UNUSED)
#line 137 "mn-hotmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::init"
 {
#line 48 "mn-hotmail-mailbox.gob"

    mn_mailbox_set_format(MN_MAILBOX(self), "Windows Live Hotmail");
    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_HOTMAIL);
  
#line 146 "mn-hotmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 53 "mn-hotmail-mailbox.gob"
static char * 
mn_hotmail_mailbox_create_config_file (MNHotmailMailbox * self, const char * spool_file, GError ** err)
#line 156 "mn-hotmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::create_config_file"
#line 53 "mn-hotmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 53 "mn-hotmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_HOTMAIL_MAILBOX (self), (char * )0);
#line 53 "mn-hotmail-mailbox.gob"
	g_return_val_if_fail (spool_file != NULL, (char * )0);
#line 165 "mn-hotmail-mailbox.c"
{
#line 57 "mn-hotmail-mailbox.gob"
	
    char *username;
    char *domain;
    GString *contents;
    char *filename;

    mn_webmail_mailbox_parse_username(MN_WEBMAIL_MAILBOX(self), &username, &domain);

    contents = g_string_new(NULL);

    g_string_append_printf(contents,
			   "UserName = %s\n"
			   "Domain = %s\n"
			   "Password = %s\n"
			   "FetchOnlyUnread = Yes\n"
			   "Folder = %s\n"
			   "Processor = cat >> '%s'\n"
			   "MarkRead = No\n",
			   username,
			   domain,
			   MN_AUTHENTICATED_MAILBOX(self)->runtime_password,
			   MN_WEBMAIL_MAILBOX(self)->folder,
			   spool_file);

    g_free(username);
    g_free(domain);

    if (eel_gconf_get_boolean(MN_CONF_SYSTEM_HTTP_PROXY_USE_HTTP_PROXY))
      {
	char *host;

	host = eel_gconf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_HOST);
	if (host && *host)
	  {
	    g_string_append_printf(contents, "Proxy = %s:%i\n", host, eel_gconf_get_integer(MN_CONF_SYSTEM_HTTP_PROXY_PORT));

	    if (eel_gconf_get_boolean(MN_CONF_SYSTEM_HTTP_PROXY_USE_AUTHENTICATION))
	      {
		char *user;
		char *password;

		user = eel_gconf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_USER);
		password = eel_gconf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_PASSWORD);

		if (user && *user && password && *password)
		  g_string_append_printf(contents, "ProxyAuth = %s:%s\n", user, password);

		g_free(user);
		g_free(password);
	      }
	  }
	g_free(host);
      }

    mn_webmail_mailbox_display_config(MN_WEBMAIL_MAILBOX(self), contents->str);
    filename = mn_webmail_mailbox_write_temporary_file(contents->str, err);

    g_string_free(contents, TRUE);

    return filename;
  }}
#line 229 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 119 "mn-hotmail-mailbox.gob"
static char * 
___4_mn_hotmail_mailbox_get_error_message (MNWebmailMailbox * mailbox G_GNUC_UNUSED, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure)
#line 235 "mn-hotmail-mailbox.c"
#define PARENT_HANDLER(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure): \
		((char * )0))
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::get_error_message"
{
#line 124 "mn-hotmail-mailbox.gob"
	
    if (helper_stderr && mn_ascii_strcasestr(helper_stderr, "error logging in"))
      {
	*is_auth_failure = TRUE;
	return g_strdup(_("authentication failed"));
      }
    return NULL;
  }}
#line 252 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 133 "mn-hotmail-mailbox.gob"
static gboolean 
mn_hotmail_mailbox_run_getlive (MNHotmailMailbox * self, const char * config_file, GError ** err)
#line 259 "mn-hotmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::run_getlive"
#line 133 "mn-hotmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 133 "mn-hotmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_HOTMAIL_MAILBOX (self), (gboolean )0);
#line 133 "mn-hotmail-mailbox.gob"
	g_return_val_if_fail (config_file != NULL, (gboolean )0);
#line 268 "mn-hotmail-mailbox.c"
{
#line 135 "mn-hotmail-mailbox.gob"
	
    char *command;
    gboolean status;

    command = g_strdup_printf("GetLive --config-file %s", config_file);
    status = mn_webmail_mailbox_run_helper(MN_WEBMAIL_MAILBOX(self), "GetLive", command, err);
    g_free(command);

    return status;
  }}
#line 281 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 146 "mn-hotmail-mailbox.gob"
static gboolean 
___6_mn_hotmail_mailbox_webmail_check (MNWebmailMailbox * mailbox G_GNUC_UNUSED, GError ** err)
#line 287 "mn-hotmail-mailbox.c"
#define PARENT_HANDLER(___mailbox,___err) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)(___mailbox,___err): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::webmail_check"
{
#line 148 "mn-hotmail-mailbox.gob"
	
    Self *self = SELF(mailbox);
    char *spool_file;
    char *config_file = NULL;
    gboolean status = FALSE;

    /*
     * We create an empty spool file beforehand to make sure it is not
     * world-readable.
     */
    spool_file = mn_webmail_mailbox_create_spool_file(err);
    if (! spool_file)
      return FALSE;

    config_file = self_create_config_file(self, spool_file, err);
    if (! config_file)
      goto end;

    if (! self_run_getlive(self, config_file, err))
      goto end;

    if (! mn_webmail_mailbox_read_spool_file(mailbox, spool_file, err))
      goto end;

    status = TRUE;

  end:
    unlink(spool_file);
    g_free(spool_file);

    if (config_file)
      {
	unlink(config_file);
	g_free(config_file);
      }

    return status;
  }}
#line 334 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
