/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-sylpheed-mailbox-backend.h"

#include "mn-sylpheed-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 50 "mn-sylpheed-mailbox-backend.gob"

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-mime.h"
#include "mn-sylpheed-message.h"

/* taken from defs.h in the Sylpheed sources */
#define SYLPHEED_MARK_VERSION		2

/* taken from defs.h in the Claws Mail sources */
#define CLAWS_MAIL_CACHE_FILE		".sylpheed_claws_cache"

#line 49 "mn-sylpheed-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_SYLPHEED_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_SYLPHEED_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_SYLPHEED_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_SYLPHEED_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNSylpheedMailboxBackend Self;
typedef MNSylpheedMailboxBackendClass SelfClass;

/* here are local prototypes */
static void mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o) G_GNUC_UNUSED;
static void mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class) G_GNUC_UNUSED;
static void ___2_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend, const char * info_uri, GnomeVFSMonitorEventType event_type) G_GNUC_UNUSED;
static gboolean ___3_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_is_claws_mail_mailbox (MNSylpheedMailboxBackend * self) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_has_sylpheed_locking (void) G_GNUC_UNUSED;
static void mn_sylpheed_mailbox_backend_update_check_latency (MNSylpheedMailboxBackend * self) G_GNUC_UNUSED;
static void ___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend, int check_id) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_mark_file (GnomeVFSURI * mailbox_uri, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

/* Short form macros */
#define self_is_claws_mail_mailbox mn_sylpheed_mailbox_backend_is_claws_mail_mailbox
#define self_has_sylpheed_locking mn_sylpheed_mailbox_backend_has_sylpheed_locking
#define self_update_check_latency mn_sylpheed_mailbox_backend_update_check_latency
#define self_read_local_mark_file mn_sylpheed_mailbox_backend_read_local_mark_file
#define self_read_remote_mark_file mn_sylpheed_mailbox_backend_read_remote_mark_file
#define self_read_mark_file mn_sylpheed_mailbox_backend_read_mark_file
#define self_marks_new mn_sylpheed_mailbox_backend_marks_new
#define self_marks_write mn_sylpheed_mailbox_backend_marks_write
#define self_marks_free mn_sylpheed_mailbox_backend_marks_free
GType
mn_sylpheed_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNSylpheedMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_sylpheed_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNSylpheedMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_sylpheed_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNSylpheedMailboxBackend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNSylpheedMailboxBackend *)g_object_new(mn_sylpheed_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNSylpheedMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNSylpheedMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNSylpheedMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNSylpheedMailboxBackend *)g_object_new_valist (mn_sylpheed_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::init"
}
#undef __GOB_FUNCTION__
#line 77 "mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class G_GNUC_UNUSED)
#line 140 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::class_init"
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 82 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->monitor_cb = ___2_mn_sylpheed_mailbox_backend_monitor_cb;
#line 109 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___3_mn_sylpheed_mailbox_backend_is;
#line 197 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___7_mn_sylpheed_mailbox_backend_check;
#line 153 "mn-sylpheed-mailbox-backend.c"
 {
#line 78 "mn-sylpheed-mailbox-backend.gob"

    MN_VFS_MAILBOX_BACKEND_CLASS(class)->format = "Sylpheed";
  
#line 159 "mn-sylpheed-mailbox-backend.c"
 }
}
#undef __GOB_FUNCTION__



#line 82 "mn-sylpheed-mailbox-backend.gob"
static void 
___2_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend G_GNUC_UNUSED, const char * info_uri, GnomeVFSMonitorEventType event_type)
#line 169 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___info_uri,___event_type) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb)(___backend,___info_uri,___event_type); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_cb"
{
#line 86 "mn-sylpheed-mailbox-backend.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	char *filename;

	filename = eel_uri_get_basename(info_uri);
	if (filename)
	  {
	    /*
	     * The status of the mailbox can only have changed if the
	     * subject of the event is the mark file or a message file
	     * (having a numbered filename).
	     */
	    if (! strcmp(filename, SYLPHEED_MARK_FILE) || mn_str_isnumeric(filename))
	      mn_vfs_mailbox_backend_queue_check(backend);

	    g_free(filename);
	  }
      }
  }}
#line 199 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 109 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
___3_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox)
#line 206 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___class,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___class,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::is"
{
#line 113 "mn-sylpheed-mailbox-backend.gob"
	
    gboolean is;
    GnomeVFSURI *uri;

    uri = gnome_vfs_uri_append_file_name(mailbox->vfs_uri, SYLPHEED_MARK_FILE);
    is = mn_vfs_test(uri, G_FILE_TEST_IS_REGULAR);
    gnome_vfs_uri_unref(uri);

    return is;
  }}
#line 225 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 124 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_is_claws_mail_mailbox (MNSylpheedMailboxBackend * self)
#line 232 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::is_claws_mail_mailbox"
#line 124 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 124 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_SYLPHEED_MAILBOX_BACKEND (self), (gboolean )0);
#line 239 "mn-sylpheed-mailbox-backend.c"
{
#line 126 "mn-sylpheed-mailbox-backend.gob"
	
    gboolean is;
    GnomeVFSURI *uri;

    uri = gnome_vfs_uri_append_file_name(MN_VFS_MAILBOX_BACKEND(self)->mailbox->vfs_uri, CLAWS_MAIL_CACHE_FILE);
    is = mn_vfs_test(uri, G_FILE_TEST_IS_REGULAR);
    gnome_vfs_uri_unref(uri);

    return is;
  }}
#line 252 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 138 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_has_sylpheed_locking (void)
#line 258 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::has_sylpheed_locking"
{
#line 140 "mn-sylpheed-mailbox-backend.gob"
	
    static gboolean checked = FALSE;
    static gboolean has = FALSE;

    if (! checked)
      {
	char *output;

	if (g_spawn_command_line_sync("sylpheed --version", &output, NULL, NULL, NULL))
	  {
	    if (strstr(output, "+locking"))
	      has = TRUE;
	    g_free(output);
	  }

	checked = TRUE;
      }

    return has;
  }}
#line 283 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 161 "mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_update_check_latency (MNSylpheedMailboxBackend * self)
#line 289 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::update_check_latency"
#line 161 "mn-sylpheed-mailbox-backend.gob"
	g_return_if_fail (self != NULL);
#line 161 "mn-sylpheed-mailbox-backend.gob"
	g_return_if_fail (MN_IS_SYLPHEED_MAILBOX_BACKEND (self));
#line 296 "mn-sylpheed-mailbox-backend.c"
{
#line 163 "mn-sylpheed-mailbox-backend.gob"
	
    MNVFSMailboxBackend *backend = MN_VFS_MAILBOX_BACKEND(self);

    mn_vfs_mailbox_lock(backend->mailbox);

    /*
     * If it is a Claws Mail mailbox, the check_latency can be set to
     * 0, since Claws Mail does not write the mark file in place but
     * uses an atomic rename() to move the new mark file over the
     * previous one.
     */
    if (self_is_claws_mail_mailbox(self))
      backend->check_latency = 0;
    else
      {
	/*
	 * If Sylpheed was compiled with the locking patch and the
	 * mailbox is local, check_latency can be set to 0, since we
	 * lock the mark file while reading it.
	 */
	if (self_has_sylpheed_locking() && gnome_vfs_uri_is_local(backend->mailbox->vfs_uri))
	  backend->check_latency = 0;
	else
	  /*
	   * Otherwise, set check_latency to 3 seconds to avoid race
	   * conditions that can occur when Sylpheed writes the mark
	   * file while we read it.
	   */
	  backend->check_latency = 3000;
      }

    mn_vfs_mailbox_unlock(backend->mailbox);
  }}
#line 332 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 197 "mn-sylpheed-mailbox-backend.gob"
static void 
___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, int check_id)
#line 338 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::check"
{
#line 199 "mn-sylpheed-mailbox-backend.gob"
	
    GError *err = NULL;
    GnomeVFSResult result;
    GnomeVFSResult close_result;
    GnomeVFSDirectoryHandle *handle;
    GnomeVFSFileInfo *file_info;
    Marks *marks;
    GSList *messages = NULL;

    self_update_check_latency(SELF(backend));

    mn_vfs_mailbox_backend_monitor(backend, check_id, backend->mailbox->uri, GNOME_VFS_MONITOR_DIRECTORY);

    marks = self_marks_new(backend->mailbox->vfs_uri, &err);
    if (! marks)
      {
	if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  {
	    GDK_THREADS_ENTER();

	    mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to read %s: %s"), SYLPHEED_MARK_FILE, err->message);

	    gdk_flush();
	    GDK_THREADS_LEAVE();
	  }

	g_error_free(err);
	return;
      }

    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      goto finish;

    result = gnome_vfs_directory_open_from_uri(&handle, backend->mailbox->vfs_uri, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (result != GNOME_VFS_OK)
      {
	if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  {
	    GDK_THREADS_ENTER();

	    mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to open folder: %s"), gnome_vfs_result_to_string(result));

	    gdk_flush();
	    GDK_THREADS_LEAVE();
	  }

	goto end;
      }

    file_info = gnome_vfs_file_info_new();
    while ((result = gnome_vfs_directory_read_next(handle, file_info)) == GNOME_VFS_OK)
      if (mn_str_isnumeric(file_info->name))
	{
	  int num = atoi(file_info->name);
	  MarkEntry *entry = g_hash_table_lookup(marks->table, GINT_TO_POINTER(num));

	  if (! entry || (entry->flags & (SYLPHEED_MSG_NEW | SYLPHEED_MSG_UNREAD)) != 0)
	    {
	      MNMessageFlags flags = 0;
	      MNMessage *message;

	      if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
		break;

	      if (! entry || (entry->flags & SYLPHEED_MSG_NEW) != 0)
		flags |= MN_MESSAGE_NEW;

	      /*
	       * We set handle_status to FALSE, since Sylpheed has its
	       * own way (mark file) of differencing seen/unseen
	       * messages.
	       */
	      message = mn_vfs_message_new(MN_TYPE_SYLPHEED_MESSAGE,
					   backend,
					   backend->mailbox->vfs_uri,
					   file_info->name,
					   flags,
					   FALSE);
	      if (message)
		messages = g_slist_prepend(messages, message);
	    }
	}
    gnome_vfs_file_info_unref(file_info);
    close_result = gnome_vfs_directory_close(handle);

  finish:
    GDK_THREADS_ENTER();

    if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	if (result == GNOME_VFS_ERROR_EOF || result == GNOME_VFS_OK)
	  {
	    if (close_result == GNOME_VFS_OK)
	      mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);
	    else
	      mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to close folder: %s"), gnome_vfs_result_to_string(close_result));
	  }
	else
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("error while reading folder: %s"), gnome_vfs_result_to_string(result));
      }

    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

  end:
    self_marks_free(marks);
  }}
#line 455 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 309 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err)
#line 462 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_local_mark_file"
#line 309 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (filename != NULL, (gboolean )0);
#line 309 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 309 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 471 "mn-sylpheed-mailbox-backend.c"
{
#line 314 "mn-sylpheed-mailbox-backend.gob"
	
    int fd;
    struct flock lock;
    GIOChannel *channel;
    GError *tmp_err = NULL;
    gboolean status = FALSE;

    fd = open(filename, O_RDONLY);
    if (fd < 0)
      {
	g_set_error(err, 0, 0, "%s", g_strerror(errno));
	return FALSE;
      }

    memset(&lock, 0, sizeof(lock));
    lock.l_start = 0;		/* from l_whence */
    lock.l_len = 0;		/* to end of file */
    lock.l_type = F_RDLCK;	/* read lock */
    lock.l_whence = SEEK_SET;	/* from start of file */

    /* ignore lock failures */
    fcntl(fd, F_SETLKW, &lock);

    channel = g_io_channel_unix_new(fd);
    if (g_io_channel_set_encoding(channel, NULL, &tmp_err) == G_IO_STATUS_NORMAL)
      {
	if (g_io_channel_read_to_end(channel, contents, size, err) == G_IO_STATUS_NORMAL)
	  status = TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, _("unable to set encoding: %s"), tmp_err->message);
	g_error_free(tmp_err);
      }

    g_io_channel_shutdown(channel, FALSE, NULL);
    g_io_channel_unref(channel);

    return status;
  }}
#line 514 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 355 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err)
#line 520 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_remote_mark_file"
#line 355 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 355 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 355 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 529 "mn-sylpheed-mailbox-backend.c"
{
#line 360 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSResult result;
    int _size;

    result = mn_vfs_read_entire_file_uri(uri, &_size, contents);
    if (result == GNOME_VFS_OK)
      {
	*size = _size;
	return TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, "%s", gnome_vfs_result_to_string(result));
	return FALSE;
      }
  }}
#line 548 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 377 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_mark_file (GnomeVFSURI * mailbox_uri, gsize * size, char ** contents, GError ** err)
#line 554 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_mark_file"
#line 377 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (gboolean )0);
#line 377 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 377 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 563 "mn-sylpheed-mailbox-backend.c"
{
#line 382 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSURI *markfile_uri;
    char *filename;
    gboolean status;

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox_uri, SYLPHEED_MARK_FILE);

    filename = mn_vfs_get_local_path(markfile_uri);
    if (filename)
      {
	status = self_read_local_mark_file(filename, size, contents, err);
	g_free(filename);
      }
    else
      status = self_read_remote_mark_file(markfile_uri, size, contents, err);

    gnome_vfs_uri_unref(markfile_uri);

    return status;
  }}
#line 586 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 403 "mn-sylpheed-mailbox-backend.gob"
Marks * 
mn_sylpheed_mailbox_backend_marks_new (GnomeVFSURI * mailbox_uri, GError ** err)
#line 592 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::marks_new"
#line 403 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (Marks * )0);
#line 597 "mn-sylpheed-mailbox-backend.c"
{
#line 405 "mn-sylpheed-mailbox-backend.gob"
	
    Marks *marks = NULL;
    gsize bytes_left;
    char *buf;

    if (self_read_mark_file(mailbox_uri, &bytes_left, &buf, err))
      {
	if (bytes_left >= sizeof(int))
	  {
	    int version = *((int *) buf);

	    if (version == SYLPHEED_MARK_VERSION)
	      {
		MarkEntry *entry;

		marks = g_new0(Marks, 1);
		marks->data = buf;
		marks->data_size = bytes_left;
		marks->table = g_hash_table_new(g_direct_hash, g_direct_equal);

		entry = (MarkEntry *) (buf + sizeof(int));
		bytes_left -= sizeof(int);

		buf = NULL;	/* now owned by marks */

		while (bytes_left > 0)
		  {
		    if (bytes_left < sizeof(MarkEntry))
		      {
			g_set_error(err, 0, 0, _("unexpected end of file"));
			self_marks_free(marks);
			marks = NULL;
			break;
		      }

		    g_hash_table_insert(marks->table, GINT_TO_POINTER(entry->num), entry);

		    entry++;
		    bytes_left -= sizeof(MarkEntry);
		  }
	      }
	    else
	      g_set_error(err, 0, 0, _("incompatible file version \"%i\""), version);
	  }
	else
	  g_set_error(err, 0, 0, _("file version missing"));

	g_free(buf);
      }

    return marks;
  }}
#line 652 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 458 "mn-sylpheed-mailbox-backend.gob"
gboolean 
mn_sylpheed_mailbox_backend_marks_write (GnomeVFSURI * mailbox_uri, Marks * marks, GError ** err)
#line 658 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::marks_write"
#line 458 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (mailbox_uri != NULL, (gboolean )0);
#line 458 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (marks != NULL, (gboolean )0);
#line 665 "mn-sylpheed-mailbox-backend.c"
{
#line 462 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSURI *markfile_uri;
    gboolean status;

    /*
     * We do not lock the mark file, since the user is normally unable
     * to at the same time click on the "Mark as Read" button and use
     * Sylpheed.
     */

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox_uri, SYLPHEED_MARK_FILE);
    /* Sylpheed uses S_IRUSR | S_IWUSR for data files */
    status = mn_vfs_write_entire_file_uri_safe(markfile_uri, marks->data_size, marks->data, S_IRUSR | S_IWUSR, err);
    gnome_vfs_uri_unref(markfile_uri);

    return status;
  }}
#line 685 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 480 "mn-sylpheed-mailbox-backend.gob"
void 
mn_sylpheed_mailbox_backend_marks_free (Marks * marks)
#line 691 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::marks_free"
#line 480 "mn-sylpheed-mailbox-backend.gob"
	g_return_if_fail (marks != NULL);
#line 696 "mn-sylpheed-mailbox-backend.c"
{
#line 482 "mn-sylpheed-mailbox-backend.gob"
	
    g_free(marks->data);
    g_hash_table_destroy(marks->table);
    g_free(marks);
  }}
#line 704 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
