/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-vfs-mailbox.h"

#include "mn-vfs-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 37 "mn-vfs-mailbox.gob"

#include "config.h"
#include <glib/gi18n.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#if WITH_MBOX
#include "mn-mbox-mailbox-backend.h"
#endif
#if WITH_MOZILLA
#include "mn-mozilla-mailbox-backend.h"
#endif
#if WITH_MH
#include "mn-mh-mailbox-backend.h"
#endif
#if WITH_MAILDIR
#include "mn-maildir-mailbox-backend.h"
#endif
#if WITH_SYLPHEED
#include "mn-sylpheed-mailbox-backend.h"
#endif
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-stock.h"
#include "mn-conf.h"
#include "mn-util.h"

GType mn_vfs_mailbox_backend_types[MN_VFS_MAILBOX_MAX_BACKEND_TYPES + 1];

typedef struct
{
  char				*uri;
  MNVFSMailboxBackend		*owner;
  GnomeVFSMonitorType		type;
  GnomeVFSMonitorCallback	callback;
  gpointer			user_data;

  GnomeVFSResult		result;
  GnomeVFSMonitorHandle		*handle;
} Monitor;

#line 67 "mn-vfs-mailbox.c"
/* self casting macros */
#define SELF(x) MN_VFS_MAILBOX(x)
#define SELF_CONST(x) MN_VFS_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_VFS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_VFS_MAILBOX
#define SELF_CLASS(x) MN_VFS_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_VFS_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNVFSMailbox Self;
typedef MNVFSMailboxClass SelfClass;

/* here are local prototypes */
static void mn_vfs_mailbox_init (MNVFSMailbox * o) G_GNUC_UNUSED;
static void mn_vfs_mailbox_class_init (MNVFSMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___3_mn_vfs_mailbox_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___4_mn_vfs_mailbox_dispose (GObject * object) G_GNUC_UNUSED;
static void ___5_mn_vfs_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static Monitor * mn_vfs_mailbox_find_monitor (MNVFSMailbox * self, const char * uri, MNVFSMailboxBackend * owner, GnomeVFSMonitorType type, GnomeVFSMonitorCallback callback, gpointer user_data) G_GNUC_UNUSED;
static void mn_vfs_mailbox_monitor_free (Monitor * monitor) G_GNUC_UNUSED;
static void mn_vfs_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data) G_GNUC_UNUSED;
static void mn_vfs_mailbox_queue_update_poll (MNVFSMailbox * self) G_GNUC_UNUSED;
static gboolean mn_vfs_mailbox_update_poll_cb (gpointer data) G_GNUC_UNUSED;
static void ___d_mn_vfs_mailbox_reentrant_check (MNReentrantMailbox * mailbox, int check_id) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNReentrantMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_init_types mn_vfs_mailbox_init_types
#define self_find_monitor mn_vfs_mailbox_find_monitor
#define self_monitor mn_vfs_mailbox_monitor
#define self_monitor_free mn_vfs_mailbox_monitor_free
#define self_monitor_cb mn_vfs_mailbox_monitor_cb
#define self_remove_monitors_by_owner mn_vfs_mailbox_remove_monitors_by_owner
#define self_queue_update_poll mn_vfs_mailbox_queue_update_poll
#define self_update_poll_cb mn_vfs_mailbox_update_poll_cb
#define self_lock mn_vfs_mailbox_lock
#define self_unlock mn_vfs_mailbox_unlock
GType
mn_vfs_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNVFSMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_vfs_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNVFSMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_vfs_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_REENTRANT_MAILBOX, "MNVFSMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNVFSMailbox *)g_object_new(mn_vfs_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNVFSMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNVFSMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNVFSMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNVFSMailbox *)g_object_new_valist (mn_vfs_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::dispose"
	MNVFSMailbox *self G_GNUC_UNUSED = MN_VFS_MAILBOX (obj_self);
#line 145 "mn-vfs-mailbox.gob"
	___4_mn_vfs_mailbox_dispose(obj_self);
#line 158 "mn-vfs-mailbox.c"
#line 81 "mn-vfs-mailbox.gob"
	if(self->vfs_uri) { gnome_vfs_uri_unref ((gpointer) self->vfs_uri); self->vfs_uri = NULL; }
#line 161 "mn-vfs-mailbox.c"
#line 84 "mn-vfs-mailbox.gob"
	if(self->_priv->backend) { g_object_unref ((gpointer) self->_priv->backend); self->_priv->backend = NULL; }
#line 164 "mn-vfs-mailbox.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::finalize"
	MNVFSMailbox *self G_GNUC_UNUSED = MN_VFS_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 80 "mn-vfs-mailbox.gob"
	if(self->uri) { g_free ((gpointer) self->uri); self->uri = NULL; }
#line 179 "mn-vfs-mailbox.c"
#line 87 "mn-vfs-mailbox.gob"
	if(self->_priv->mutex) { g_mutex_free ((gpointer) self->_priv->mutex); self->_priv->mutex = NULL; }
#line 182 "mn-vfs-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_vfs_mailbox_init (MNVFSMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_VFS_MAILBOX,MNVFSMailboxPrivate);
#line 87 "mn-vfs-mailbox.gob"
	o->_priv->mutex = g_mutex_new();
#line 193 "mn-vfs-mailbox.c"
}
#undef __GOB_FUNCTION__
#line 118 "mn-vfs-mailbox.gob"
static void 
mn_vfs_mailbox_class_init (MNVFSMailboxClass * class G_GNUC_UNUSED)
#line 199 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNReentrantMailboxClass *mn_reentrant_mailbox_class = (MNReentrantMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNVFSMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_REENTRANT_MAILBOX);

#line 128 "mn-vfs-mailbox.gob"
	g_object_class->constructor = ___3_mn_vfs_mailbox_constructor;
#line 145 "mn-vfs-mailbox.gob"
	g_object_class->dispose = ___dispose;
#line 160 "mn-vfs-mailbox.gob"
	mn_mailbox_class->seal = ___5_mn_vfs_mailbox_seal;
#line 373 "mn-vfs-mailbox.gob"
	mn_reentrant_mailbox_class->reentrant_check = ___d_mn_vfs_mailbox_reentrant_check;
#line 218 "mn-vfs-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 119 "mn-vfs-mailbox.gob"

    /*
     * Most VFS mailboxes will probably be local files, or remote
     * files located in the same LAN. We therefore choose a small
     * default check delay (1 minute).
     */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 1;
  
#line 230 "mn-vfs-mailbox.c"
 }
}
#undef __GOB_FUNCTION__


#line 89 "mn-vfs-mailbox.gob"
void 
mn_vfs_mailbox_init_types (void)
#line 239 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::init_types"
{
#line 91 "mn-vfs-mailbox.gob"
	
    int i = 0;

#if WITH_MBOX
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_MBOX_MAILBOX_BACKEND;
#endif
#if WITH_MOZILLA
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_MOZILLA_MAILBOX_BACKEND;
#endif
    /*
     * Claws Mail mailboxes contain both a .sylpheed_mark and a
     * .mh_sequences file. List the Sylpheed backend first, in order
     * to treat them as Sylpheed mailboxes. This way, the need to use
     * rcvstore from procmail is removed.
     */
#if WITH_SYLPHEED
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_SYLPHEED_MAILBOX_BACKEND;
#endif
#if WITH_MH
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_MH_MAILBOX_BACKEND;
#endif
#if WITH_MAILDIR
    mn_vfs_mailbox_backend_types[i++] = MN_TYPE_MAILDIR_MAILBOX_BACKEND;
#endif
    mn_vfs_mailbox_backend_types[i] = 0;
  }}
#line 270 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__


#line 128 "mn-vfs-mailbox.gob"
static GObject * 
___3_mn_vfs_mailbox_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 277 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::constructor"
{
#line 130 "mn-vfs-mailbox.gob"
	
    GObject *object;
    Self *self;
    SelfClass *class;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);
    class = SELF_GET_CLASS(self);

    /* set default poll to the most likely value */
    mn_mailbox_set_poll(MN_MAILBOX(self), FALSE);

    return object;
  }}
#line 300 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 145 "mn-vfs-mailbox.gob"
static void 
___4_mn_vfs_mailbox_dispose (GObject * object G_GNUC_UNUSED)
#line 307 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::dispose"
{
#line 147 "mn-vfs-mailbox.gob"
	
    Self *self = SELF(object);

    /*
     * We are no longer operational after dispose (see unrefwith
     * above), so we must remove our monitors.
     */
    mn_locked_g_source_clear(&selfp->update_poll_source);
    mn_g_slist_clear_deep_custom(&selfp->monitors, (GFunc) self_monitor_free, NULL);

    PARENT_HANDLER(object);
  }}
#line 327 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 160 "mn-vfs-mailbox.gob"
static void 
___5_mn_vfs_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 334 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::seal"
{
#line 162 "mn-vfs-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    if (self->uri)
      {
	self->vfs_uri = gnome_vfs_uri_new(self->uri);

	if (! mailbox->stock_id && self->vfs_uri && ! gnome_vfs_uri_is_local(self->vfs_uri))
	  mn_mailbox_set_stock_id(mailbox, MN_STOCK_REMOTE);

	if (! mailbox->runtime_name)
	  {
	    char *path;

	    path = gnome_vfs_get_local_path_from_uri(self->uri);
	    if (path)
	      {
		mailbox->runtime_name = g_filename_display_name(path);
		g_free(path);
	      }
	    else
	      mailbox->runtime_name = self->vfs_uri
		? gnome_vfs_uri_to_string(self->vfs_uri, GNOME_VFS_URI_HIDE_PASSWORD)
		: g_strdup(self->uri);
	  }
      }

    if (! mailbox->stock_id)
      mn_mailbox_set_stock_id(mailbox, MN_STOCK_LOCAL);
  }}
#line 374 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 195 "mn-vfs-mailbox.gob"
static Monitor * 
mn_vfs_mailbox_find_monitor (MNVFSMailbox * self, const char * uri, MNVFSMailboxBackend * owner, GnomeVFSMonitorType type, GnomeVFSMonitorCallback callback, gpointer user_data)
#line 381 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::find_monitor"
#line 195 "mn-vfs-mailbox.gob"
	g_return_val_if_fail (self != NULL, (Monitor * )0);
#line 195 "mn-vfs-mailbox.gob"
	g_return_val_if_fail (MN_IS_VFS_MAILBOX (self), (Monitor * )0);
#line 195 "mn-vfs-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (Monitor * )0);
#line 390 "mn-vfs-mailbox.c"
{
#line 202 "mn-vfs-mailbox.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->monitors)
      {
	Monitor *monitor = l->data;

	if (monitor->owner == owner
	    && monitor->type == type
	    && monitor->callback == callback
	    && monitor->user_data == user_data
	    && ! strcmp(monitor->uri, uri))
	  return monitor;
      }

    return NULL;
  }}
#line 410 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 220 "mn-vfs-mailbox.gob"
void 
mn_vfs_mailbox_monitor (MNVFSMailbox * self, const char * uri, MNVFSMailboxBackend * owner, GnomeVFSMonitorType type, GnomeVFSMonitorCallback callback, gpointer user_data)
#line 416 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::monitor"
#line 220 "mn-vfs-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 220 "mn-vfs-mailbox.gob"
	g_return_if_fail (MN_IS_VFS_MAILBOX (self));
#line 220 "mn-vfs-mailbox.gob"
	g_return_if_fail (uri != NULL);
#line 425 "mn-vfs-mailbox.c"
{
#line 227 "mn-vfs-mailbox.gob"
	
    Monitor *monitor;

    g_return_if_fail(owner == NULL || MN_IS_VFS_MAILBOX_BACKEND(owner));

    monitor = self_find_monitor(self, uri, owner, type, callback, user_data);
    if (! monitor)
      {
	monitor = g_new0(Monitor, 1);
	monitor->uri = g_strdup(uri);
	monitor->owner = owner;
	monitor->type = type;
	monitor->callback = callback;
	monitor->user_data = user_data;
	monitor->result = -1;

	selfp->monitors = g_slist_append(selfp->monitors, monitor);
      }

    if (monitor->result != GNOME_VFS_OK)
      {
	GnomeVFSResult result;

	result = mn_gnome_vfs_monitor_add_locked(&monitor->handle, uri, type, callback, user_data);
	if (result != monitor->result)
	  {
	    monitor->result = result;
	    if (result != GNOME_VFS_OK)
	      mn_mailbox_warning(MN_MAILBOX(self), _("unable to monitor %s (%s), poll mode activated"), uri, gnome_vfs_result_to_string(result));

	    self_queue_update_poll(self);
	  }
      }
  }}
#line 462 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 262 "mn-vfs-mailbox.gob"
static void 
mn_vfs_mailbox_monitor_free (Monitor * monitor)
#line 468 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::monitor_free"
#line 262 "mn-vfs-mailbox.gob"
	g_return_if_fail (monitor != NULL);
#line 473 "mn-vfs-mailbox.c"
{
#line 264 "mn-vfs-mailbox.gob"
	
    g_free(monitor->uri);

    if (monitor->result == GNOME_VFS_OK)
      mn_gnome_vfs_monitor_cancel_locked(monitor->handle);

    g_free(monitor);
  }}
#line 484 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 273 "mn-vfs-mailbox.gob"
static void 
mn_vfs_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data)
#line 490 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::monitor_cb"
{
#line 279 "mn-vfs-mailbox.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	Self *self = user_data;
	MNVFSMailboxBackend *backend;

	/*
	 * Queue a check to detect if the mailbox type has changed. If
	 * the mailbox has a backend, we must use
	 * mn_vfs_mailbox_backend_queue_check() (which respects the
	 * check_latency member of MNVFSMailboxBackend) in order to
	 * avoid race conditions.
	 */

	self_lock(self);

	backend = selfp->backend;
	if (backend)
	  mn_vfs_mailbox_backend_queue_check(backend);

	self_unlock(self);

	/*
	 * Note that at this point, we have released the lock and the
	 * backend might have been finalized by another thread: we can
	 * only test the nullity of the pointer.
	 */
	if (! backend)
	  mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(self));
      }
  }}
#line 528 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 313 "mn-vfs-mailbox.gob"
void 
mn_vfs_mailbox_remove_monitors_by_owner (MNVFSMailbox * self, MNVFSMailboxBackend * owner)
#line 534 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::remove_monitors_by_owner"
#line 313 "mn-vfs-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 313 "mn-vfs-mailbox.gob"
	g_return_if_fail (MN_IS_VFS_MAILBOX (self));
#line 541 "mn-vfs-mailbox.c"
{
#line 315 "mn-vfs-mailbox.gob"
	
    GSList *l;

    g_return_if_fail(owner == NULL || MN_IS_VFS_MAILBOX_BACKEND(owner));

  start:
    MN_LIST_FOREACH(l, selfp->monitors)
      {
	Monitor *monitor = l->data;

	if (monitor->owner == owner)
	  {
	    selfp->monitors = mn_g_slist_delete_link_deep_custom(selfp->monitors, l, (GFunc) self_monitor_free, NULL);
	    self_queue_update_poll(self);
	    goto start;
	  }
      }
  }}
#line 562 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 334 "mn-vfs-mailbox.gob"
static void 
mn_vfs_mailbox_queue_update_poll (MNVFSMailbox * self)
#line 568 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::queue_update_poll"
#line 334 "mn-vfs-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 334 "mn-vfs-mailbox.gob"
	g_return_if_fail (MN_IS_VFS_MAILBOX (self));
#line 575 "mn-vfs-mailbox.c"
{
#line 336 "mn-vfs-mailbox.gob"
	
    if (selfp->update_poll_source)
      mn_locked_g_source_remove(selfp->update_poll_source);

    selfp->update_poll_source = mn_g_idle_add_gdk_locked(self_update_poll_cb, self);
  }}
#line 584 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 343 "mn-vfs-mailbox.gob"
static gboolean 
mn_vfs_mailbox_update_poll_cb (gpointer data)
#line 590 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::update_poll_cb"
{
#line 345 "mn-vfs-mailbox.gob"
	
    Self *self = data;
    gboolean polled = FALSE;
    GSList *l;

    self_lock(self);

    MN_LIST_FOREACH(l, selfp->monitors)
      {
	Monitor *monitor = l->data;

	if (monitor->result != GNOME_VFS_OK)
	  {
	    polled = TRUE;
	    break;
	  }
      }

    selfp->update_poll_source = NULL;

    self_unlock(self);

    if (mn_mailbox_get_poll(MN_MAILBOX(self)) != polled)
      mn_mailbox_set_poll(MN_MAILBOX(self), polled);

    return FALSE;		/* remove source */
  }}
#line 622 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 373 "mn-vfs-mailbox.gob"
static void 
___d_mn_vfs_mailbox_reentrant_check (MNReentrantMailbox * mailbox G_GNUC_UNUSED, int check_id)
#line 628 "mn-vfs-mailbox.c"
#define PARENT_HANDLER(___mailbox,___check_id) \
	{ if(MN_REENTRANT_MAILBOX_CLASS(parent_class)->reentrant_check) \
		(* MN_REENTRANT_MAILBOX_CLASS(parent_class)->reentrant_check)(___mailbox,___check_id); }
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::reentrant_check"
{
#line 375 "mn-vfs-mailbox.gob"
	
    Self *self = SELF(mailbox);
    MNVFSMailboxBackend *backend;
    MNVFSMailboxBackendClass *class;
    GType backend_type = 0;
    gboolean exists;

    self_lock(self);

    /*
     * Install the monitors that detect a mailbox type change. These
     * monitors are not meant to detect if the mail status of a
     * mailbox changes (it is the responsability of the backend),
     * although they will do so with some mailbox formats.
     *
     * For properly detecting the new mailbox type when the file or
     * directory changes we need install both a file and a directory
     * monitor, since depending on the underlying implementation we
     * might not get file events if the URI is a directory, etc.
     */
    self_monitor(self, self->uri, NULL, GNOME_VFS_MONITOR_FILE, self_monitor_cb, self);
    self_monitor(self, self->uri, NULL, GNOME_VFS_MONITOR_DIRECTORY, self_monitor_cb, self);

    backend = selfp->backend;
    if (backend)
      g_object_ref(backend);

    self_unlock(self);

    class = backend ? MN_VFS_MAILBOX_BACKEND_GET_CLASS(backend) : NULL;
    if (class && class->is(NULL, class, self))
      backend_type = G_OBJECT_TYPE(backend);
    else
      {
	exists = mn_vfs_test(self->vfs_uri, G_FILE_TEST_EXISTS);
	if (exists)
	  {
	    int i;

	    for (i = 0; mn_vfs_mailbox_backend_types[i]; i++)
	      {
		class = g_type_class_peek(mn_vfs_mailbox_backend_types[i]);
		g_assert(class != NULL);

		if (class->is(NULL, class, self))
		  {
		    backend_type = mn_vfs_mailbox_backend_types[i];
		    break;
		  }

		if (mn_reentrant_mailbox_check_aborted(mailbox, check_id))
		  goto end;
	      }
	  }
      }

    if (! backend || backend_type != G_OBJECT_TYPE(backend))
      {
	MNVFSMailboxBackend *new_backend = NULL;

	if (! mn_reentrant_mailbox_check_aborted(mailbox, check_id))
	  {
	    GDK_THREADS_ENTER();

	    if (backend_type)
	      {
		new_backend = g_object_new(backend_type, MN_VFS_MAILBOX_BACKEND_PROP_MAILBOX(self), NULL);
		mn_mailbox_set_format(MN_MAILBOX(self), (char *) MN_VFS_MAILBOX_BACKEND_GET_CLASS(new_backend)->format);
	      }
	    else
	      {
		mn_mailbox_set_format(MN_MAILBOX(self), NULL);
		mn_mailbox_set_error(MN_MAILBOX(self), exists ? _("unknown mailbox format") : _("does not exist"));
	      }

	    gdk_flush();
	    GDK_THREADS_LEAVE();
	  }

	self_lock(self);

	if (backend)
	  {
	    g_object_unref(backend);
	    backend = NULL;
	  }

	if (! mn_reentrant_mailbox_check_aborted(mailbox, check_id))
	  {
	    if (selfp->backend)
	      {
		g_object_unref(selfp->backend);
		selfp->backend = NULL;
	      }

	    if (new_backend)
	      {
		selfp->backend = backend = new_backend;
		new_backend = NULL;

		g_object_ref(backend);
	      }
	  }

	self_unlock(self);

	if (new_backend)
	  g_object_unref(new_backend);
      }

    if (backend)
      mn_vfs_mailbox_backend_check(backend, check_id);

  end:
    if (backend)
      {
	self_lock(self);
	g_object_unref(backend);
	self_unlock(self);
      }
  }}
#line 757 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 497 "mn-vfs-mailbox.gob"
void 
mn_vfs_mailbox_lock (MNVFSMailbox * self)
#line 764 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::lock"
#line 497 "mn-vfs-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 497 "mn-vfs-mailbox.gob"
	g_return_if_fail (MN_IS_VFS_MAILBOX (self));
#line 771 "mn-vfs-mailbox.c"
{
#line 499 "mn-vfs-mailbox.gob"
	
    g_mutex_lock(selfp->mutex);
  }}
#line 777 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__

#line 503 "mn-vfs-mailbox.gob"
void 
mn_vfs_mailbox_unlock (MNVFSMailbox * self)
#line 783 "mn-vfs-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:VFS:Mailbox::unlock"
#line 503 "mn-vfs-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 503 "mn-vfs-mailbox.gob"
	g_return_if_fail (MN_IS_VFS_MAILBOX (self));
#line 790 "mn-vfs-mailbox.c"
{
#line 505 "mn-vfs-mailbox.gob"
	
    g_mutex_unlock(selfp->mutex);
  }}
#line 796 "mn-vfs-mailbox.c"
#undef __GOB_FUNCTION__
