/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-yahoo-mailbox.h"

#include "mn-yahoo-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 26 "mn-yahoo-mailbox.gob"

#include "config.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <glib/gi18n.h>
#include "mn-webmail-mailbox-private.h"
#include "mn-stock.h"
#include "mn-conf.h"

#line 38 "mn-yahoo-mailbox.c"
/* self casting macros */
#define SELF(x) MN_YAHOO_MAILBOX(x)
#define SELF_CONST(x) MN_YAHOO_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_YAHOO_MAILBOX(x)
#define TYPE_SELF MN_TYPE_YAHOO_MAILBOX
#define SELF_CLASS(x) MN_YAHOO_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_YAHOO_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNYahooMailbox Self;
typedef MNYahooMailboxClass SelfClass;

/* here are local prototypes */
static void mn_yahoo_mailbox_class_init (MNYahooMailboxClass * class) G_GNUC_UNUSED;
static void mn_yahoo_mailbox_init (MNYahooMailbox * self) G_GNUC_UNUSED;
static char * mn_yahoo_mailbox_create_cookies_file (GError ** err) G_GNUC_UNUSED;
static char * mn_yahoo_mailbox_create_config_file (MNYahooMailbox * self, const char * spool_file, const char * cookies_file, GError ** err) G_GNUC_UNUSED;
static char * ___5_mn_yahoo_mailbox_get_error_message (MNWebmailMailbox * mailbox, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure) G_GNUC_UNUSED;
static gboolean mn_yahoo_mailbox_run_fetchyahoo (MNYahooMailbox * self, const char * config_file, GError ** err) G_GNUC_UNUSED;
static gboolean ___7_mn_yahoo_mailbox_webmail_check (MNWebmailMailbox * mailbox, GError ** err) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNWebmailMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_create_cookies_file mn_yahoo_mailbox_create_cookies_file
#define self_create_config_file mn_yahoo_mailbox_create_config_file
#define self_run_fetchyahoo mn_yahoo_mailbox_run_fetchyahoo
GType
mn_yahoo_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNYahooMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_yahoo_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNYahooMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_yahoo_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_WEBMAIL_MAILBOX, "MNYahooMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNYahooMailbox *)g_object_new(mn_yahoo_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNYahooMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNYahooMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNYahooMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNYahooMailbox *)g_object_new_valist (mn_yahoo_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}

#line 42 "mn-yahoo-mailbox.gob"
static void 
mn_yahoo_mailbox_class_init (MNYahooMailboxClass * class G_GNUC_UNUSED)
#line 113 "mn-yahoo-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::class_init"
	MNWebmailMailboxClass *mn_webmail_mailbox_class = (MNWebmailMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_WEBMAIL_MAILBOX);

#line 167 "mn-yahoo-mailbox.gob"
	mn_webmail_mailbox_class->get_error_message = ___5_mn_yahoo_mailbox_get_error_message;
#line 222 "mn-yahoo-mailbox.gob"
	mn_webmail_mailbox_class->webmail_check = ___7_mn_yahoo_mailbox_webmail_check;
#line 124 "mn-yahoo-mailbox.c"
 {
#line 43 "mn-yahoo-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "yahoo";

    /* 5 minutes is a good default */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;

    MN_WEBMAIL_MAILBOX_CLASS(class)->default_domain = "yahoo.com";
  
#line 135 "mn-yahoo-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 52 "mn-yahoo-mailbox.gob"
static void 
mn_yahoo_mailbox_init (MNYahooMailbox * self G_GNUC_UNUSED)
#line 142 "mn-yahoo-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::init"
 {
#line 53 "mn-yahoo-mailbox.gob"

    mn_mailbox_set_format(MN_MAILBOX(self), "Yahoo! Mail");
    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_YAHOO);
  
#line 151 "mn-yahoo-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 58 "mn-yahoo-mailbox.gob"
static char * 
mn_yahoo_mailbox_create_cookies_file (GError ** err)
#line 161 "mn-yahoo-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::create_cookies_file"
{
#line 60 "mn-yahoo-mailbox.gob"
	
    char *filename;

    /*
     * If the file already exists, ensure it has the proper
     * permissions. Otherwise, create it with the proper permissions.
     */

    filename = g_build_filename(mn_conf_dot_dir, "yahoo-cookies", NULL);
    if (g_file_test(filename, G_FILE_TEST_EXISTS))
      {
	if (chmod(filename, S_IRUSR | S_IWUSR) < 0)
	  {
	    g_set_error(err, 0, 0, _("unable to change the permissions of %s: %s"), filename, g_strerror(errno));
	    goto error;
	  }
      }
    else
      {
	int fd;

	fd = open(filename, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR);
	if (fd < 0)
	  {
	    g_set_error(err, 0, 0, _("unable to create %s: %s"), filename, g_strerror(errno));
	    goto error;
	  }
	close(fd);
      }

    return filename;

  error:
    g_free(filename);
    return NULL;
  }}
#line 202 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 97 "mn-yahoo-mailbox.gob"
static char * 
mn_yahoo_mailbox_create_config_file (MNYahooMailbox * self, const char * spool_file, const char * cookies_file, GError ** err)
#line 208 "mn-yahoo-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::create_config_file"
#line 97 "mn-yahoo-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 97 "mn-yahoo-mailbox.gob"
	g_return_val_if_fail (MN_IS_YAHOO_MAILBOX (self), (char * )0);
#line 97 "mn-yahoo-mailbox.gob"
	g_return_val_if_fail (spool_file != NULL, (char * )0);
#line 97 "mn-yahoo-mailbox.gob"
	g_return_val_if_fail (cookies_file != NULL, (char * )0);
#line 219 "mn-yahoo-mailbox.c"
{
#line 102 "mn-yahoo-mailbox.gob"
	
    GString *contents;
    char *filename;

    contents = g_string_new(NULL);

    g_string_append_printf(contents,
			   "username = %s\n"
			   "password = %s\n"
			   "folder = %s\n"
			   "spool = %s\n"
			   "cookie-file = %s\n"
			   "new-messages-only = 1\n"
			   "no-delete = 1\n"
			   "leave-unread = 1\n",
			   MN_AUTHENTICATED_MAILBOX(self)->username,
			   MN_AUTHENTICATED_MAILBOX(self)->runtime_password,
			   MN_WEBMAIL_MAILBOX(self)->folder,
			   spool_file,
			   cookies_file);

    if (eel_gconf_get_boolean(MN_CONF_SYSTEM_HTTP_PROXY_USE_HTTP_PROXY))
      {
	char *host;

	host = eel_gconf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_HOST);
	if (host && *host)
	  {
	    g_string_append_printf(contents,
				   "use-proxy = 1\n"
				   "proxy-host = %s\n"
				   "proxy-port = %i\n",
				   host,
				   eel_gconf_get_integer(MN_CONF_SYSTEM_HTTP_PROXY_PORT));

	    if (eel_gconf_get_boolean(MN_CONF_SYSTEM_HTTP_PROXY_USE_AUTHENTICATION))
	      {
		char *user;
		char *password;

		user = eel_gconf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_USER);
		password = eel_gconf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_PASSWORD);

		if (user && *user && password && *password)
		  g_string_append_printf(contents,
					 "proxy-username = %s\n"
					 "proxy-password = %s\n",
					 user,
					 password);

		g_free(user);
		g_free(password);
	      }
	  }
	g_free(host);
      }

    mn_webmail_mailbox_display_config(MN_WEBMAIL_MAILBOX(self), contents->str);
    filename = mn_webmail_mailbox_write_temporary_file(contents->str, err);

    g_string_free(contents, TRUE);

    return filename;
  }}
#line 286 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 167 "mn-yahoo-mailbox.gob"
static char * 
___5_mn_yahoo_mailbox_get_error_message (MNWebmailMailbox * mailbox G_GNUC_UNUSED, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure)
#line 292 "mn-yahoo-mailbox.c"
#define PARENT_HANDLER(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure): \
		((char * )0))
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::get_error_message"
{
#line 172 "mn-yahoo-mailbox.gob"
	
    if (helper_stderr)
      {
	char **lines;
	int i;
	char *message = NULL;

	lines = g_strsplit(helper_stderr, "\n", 0);
	for (i = 0; lines[i]; i++)
	  if (g_str_has_prefix(lines[i], "Failed: "))
	    {
	      char *escaped;

	      if (mn_ascii_strcasestr(lines[i], "wrong password")
		  || mn_ascii_strcasestr(lines[i], "invalid ID")
		  || (mn_ascii_strcasestr(lines[i], "Yahoo user")
		      && mn_ascii_strcasestr(lines[i], "does not exist")))
		*is_auth_failure = TRUE;

	      escaped = mn_utf8_escape(lines[i] + 8);
	      message = g_strdup_printf(_("\"%s\""), escaped);
	      g_free(escaped);

	      break;
	    }
	g_strfreev(lines);

	if (message)
	  return message;

	if (mn_ascii_strcasestr(helper_stderr, "an image of text"))
	  return g_strdup(_("delay between mail checks too small"));
      }

    return NULL;
  }}
#line 337 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 209 "mn-yahoo-mailbox.gob"
static gboolean 
mn_yahoo_mailbox_run_fetchyahoo (MNYahooMailbox * self, const char * config_file, GError ** err)
#line 344 "mn-yahoo-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::run_fetchyahoo"
#line 209 "mn-yahoo-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 209 "mn-yahoo-mailbox.gob"
	g_return_val_if_fail (MN_IS_YAHOO_MAILBOX (self), (gboolean )0);
#line 209 "mn-yahoo-mailbox.gob"
	g_return_val_if_fail (config_file != NULL, (gboolean )0);
#line 353 "mn-yahoo-mailbox.c"
{
#line 211 "mn-yahoo-mailbox.gob"
	
    char *command;
    gboolean status;

    command = g_strdup_printf("fetchyahoo --configfile=%s", config_file);
    status = mn_webmail_mailbox_run_helper(MN_WEBMAIL_MAILBOX(self), "fetchyahoo", command, err);
    g_free(command);

    return status;
  }}
#line 366 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__

#line 222 "mn-yahoo-mailbox.gob"
static gboolean 
___7_mn_yahoo_mailbox_webmail_check (MNWebmailMailbox * mailbox G_GNUC_UNUSED, GError ** err)
#line 372 "mn-yahoo-mailbox.c"
#define PARENT_HANDLER(___mailbox,___err) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)(___mailbox,___err): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Yahoo:Mailbox::webmail_check"
{
#line 224 "mn-yahoo-mailbox.gob"
	
    Self *self = SELF(mailbox);
    char *spool_file;
    char *cookies_file;
    char *config_file = NULL;
    gboolean status = FALSE;

    /*
     * We create an empty spool file beforehand to make sure it is not
     * world-readable.
     */
    spool_file = mn_webmail_mailbox_create_spool_file(err);
    if (! spool_file)
      return FALSE;

    /*
     * Likewise, we create an empty cookies file beforehand to make
     * sure it is not world-readable.
     */
    cookies_file = self_create_cookies_file(err);
    if (! cookies_file)
      goto end;

    /*
     * We create a config file rather than use command line arguments
     * because for obvious reasons, we must not pass the password on
     * the command line.
     */
    config_file = self_create_config_file(self, spool_file, cookies_file, err);
    if (! config_file)
      goto end;

    if (! self_run_fetchyahoo(self, config_file, err))
      goto end;

    if (! mn_webmail_mailbox_read_spool_file(mailbox, spool_file, err))
      goto end;

    status = TRUE;

  end:
    unlink(spool_file);
    g_free(spool_file);

    g_free(cookies_file);

    if (config_file)
      {
	unlink(config_file);
	g_free(config_file);
      }

    return status;
  }}
#line 435 "mn-yahoo-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
