# Mail Notification
# Copyright (C) 2003-2008 Jean-Yves Lefort <jylefort@brutele.be>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

dnl AM_PATH_ORBIT_IDL([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN([AM_PATH_ORBIT_IDL],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])

AC_MSG_CHECKING([for orbit-idl-2])

if test -n "$PKG_CONFIG"; then
	ORBIT_IDL="`$PKG_CONFIG --variable=orbit_idl ORBit-2.0 2>/dev/null`"
else
	ORBIT_IDL=""
fi

if test -n "$ORBIT_IDL"; then
	AC_MSG_RESULT([$ORBIT_IDL])
	ifelse([$1],, :, [$1])
else
	AC_MSG_RESULT([not found])
	ifelse([$2],, :, [$2])
fi

AC_SUBST(ORBIT_IDL)])

dnl IDL_CHECK_MODULES(VARIABLE-PREFIX, MODULES, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN([IDL_CHECK_MODULES],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])

AC_MSG_CHECKING([for [$1] IDL])
PKG_CHECK_EXISTS([$2], found=yes, found=no)
AC_MSG_RESULT([$found])

$1_IDLFLAGS=""
if test $found = yes; then
	for module in $2; do
		idldir="`$PKG_CONFIG --variable=idldir $module 2>/dev/null`"
		if test -n "$idldir"; then
			$1_IDLFLAGS="$[$1]_IDLFLAGS -I$idldir"
		fi
	done
	ifelse([$3],, :, [$3])
else
	ifelse([$4],, :, [$4])
fi

AC_SUBST($1_IDLFLAGS)])
