/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-authenticated-mailbox-properties.h"

#include "mn-authenticated-mailbox-properties-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 31 "mn-authenticated-mailbox-properties.gob"

#include "config.h"
#include <glib/gi18n.h>
#include "mn-mailbox-properties-private.h"
#include "mn-util.h"

#line 33 "mn-authenticated-mailbox-properties.c"
/* self casting macros */
#define SELF(x) MN_AUTHENTICATED_MAILBOX_PROPERTIES(x)
#define SELF_CONST(x) MN_AUTHENTICATED_MAILBOX_PROPERTIES_CONST(x)
#define IS_SELF(x) MN_IS_AUTHENTICATED_MAILBOX_PROPERTIES(x)
#define TYPE_SELF MN_TYPE_AUTHENTICATED_MAILBOX_PROPERTIES
#define SELF_CLASS(x) MN_AUTHENTICATED_MAILBOX_PROPERTIES_CLASS(x)

#define SELF_GET_CLASS(x) MN_AUTHENTICATED_MAILBOX_PROPERTIES_GET_CLASS(x)

/* self typedefs */
typedef MNAuthenticatedMailboxProperties Self;
typedef MNAuthenticatedMailboxPropertiesClass SelfClass;

/* here are local prototypes */
static void mn_authenticated_mailbox_properties_class_init (MNAuthenticatedMailboxPropertiesClass * c) G_GNUC_UNUSED;
static void mn_authenticated_mailbox_properties_init (MNAuthenticatedMailboxProperties * self) G_GNUC_UNUSED;
static void ___2_mn_authenticated_mailbox_properties_dispose (GObject * object) G_GNUC_UNUSED;
static void ___4_mn_authenticated_mailbox_properties_set_mailbox (MNMailboxProperties * properties, MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_authenticated_mailbox_properties_clear_mailbox_callbacks (MNAuthenticatedMailboxProperties * self) G_GNUC_UNUSED;
static void mn_authenticated_mailbox_properties_setting_password_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void mn_authenticated_mailbox_properties_get_password (MNAuthenticatedMailboxProperties * self, MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;
static void mn_authenticated_mailbox_properties_get_password_cb (GnomeKeyringResult result, GList * list, gpointer data) G_GNUC_UNUSED;
static MNMailbox * ___9_mn_authenticated_mailbox_properties_get_mailbox (MNMailboxProperties * properties) G_GNUC_UNUSED;
static void mn_authenticated_mailbox_properties_set_password_operation (MNAuthenticatedMailboxProperties * self, const char * operation) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNMailboxPropertiesClass *parent_class = NULL;

/* Short form macros */
#define self_field_new mn_authenticated_mailbox_properties_field_new
#define self_clear_mailbox_callbacks mn_authenticated_mailbox_properties_clear_mailbox_callbacks
#define self_setting_password_notify_h mn_authenticated_mailbox_properties_setting_password_notify_h
#define self_get_password mn_authenticated_mailbox_properties_get_password
#define self_get_password_cb mn_authenticated_mailbox_properties_get_password_cb
#define self_set_password_operation mn_authenticated_mailbox_properties_set_password_operation
#define self_get_contents mn_authenticated_mailbox_properties_get_contents
#define self_is_complete mn_authenticated_mailbox_properties_is_complete
GType
mn_authenticated_mailbox_properties_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNAuthenticatedMailboxPropertiesClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_authenticated_mailbox_properties_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNAuthenticatedMailboxProperties),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_authenticated_mailbox_properties_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_MAILBOX_PROPERTIES, "MNAuthenticatedMailboxProperties", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNAuthenticatedMailboxProperties *)g_object_new(mn_authenticated_mailbox_properties_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNAuthenticatedMailboxProperties * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNAuthenticatedMailboxProperties *
GET_NEW_VARG (const char *first, ...)
{
	MNAuthenticatedMailboxProperties *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNAuthenticatedMailboxProperties *)g_object_new_valist (mn_authenticated_mailbox_properties_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::dispose"
	MNAuthenticatedMailboxProperties *self G_GNUC_UNUSED = MN_AUTHENTICATED_MAILBOX_PROPERTIES (obj_self);
#line 91 "mn-authenticated-mailbox-properties.gob"
	___2_mn_authenticated_mailbox_properties_dispose(obj_self);
#line 121 "mn-authenticated-mailbox-properties.c"
#line 46 "mn-authenticated-mailbox-properties.gob"
	if(self->password_entry) { g_object_unref ((gpointer) self->password_entry); self->password_entry = NULL; }
#line 124 "mn-authenticated-mailbox-properties.c"
#line 47 "mn-authenticated-mailbox-properties.gob"
	if(self->_priv->password_operation_label) { g_object_unref ((gpointer) self->_priv->password_operation_label); self->_priv->password_operation_label = NULL; }
#line 127 "mn-authenticated-mailbox-properties.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::finalize"
	MNAuthenticatedMailboxProperties *self G_GNUC_UNUSED = MN_AUTHENTICATED_MAILBOX_PROPERTIES (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
mn_authenticated_mailbox_properties_class_init (MNAuthenticatedMailboxPropertiesClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	MNMailboxPropertiesClass *mn_mailbox_properties_class = (MNMailboxPropertiesClass *)c;

	g_type_class_add_private(c,sizeof(MNAuthenticatedMailboxPropertiesPrivate));

	parent_class = g_type_class_ref (MN_TYPE_MAILBOX_PROPERTIES);

#line 91 "mn-authenticated-mailbox-properties.gob"
	g_object_class->dispose = ___dispose;
#line 129 "mn-authenticated-mailbox-properties.gob"
	mn_mailbox_properties_class->set_mailbox = ___4_mn_authenticated_mailbox_properties_set_mailbox;
#line 232 "mn-authenticated-mailbox-properties.gob"
	mn_mailbox_properties_class->get_mailbox = ___9_mn_authenticated_mailbox_properties_get_mailbox;
#line 160 "mn-authenticated-mailbox-properties.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 53 "mn-authenticated-mailbox-properties.gob"
static void 
mn_authenticated_mailbox_properties_init (MNAuthenticatedMailboxProperties * self G_GNUC_UNUSED)
#line 167 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_AUTHENTICATED_MAILBOX_PROPERTIES,MNAuthenticatedMailboxPropertiesPrivate);
 {
#line 54 "mn-authenticated-mailbox-properties.gob"

    MNMailboxProperties *properties = MN_MAILBOX_PROPERTIES(self);
    const char *username;

    /* translators: header capitalization */
    self->account_vbox = mn_mailbox_properties_add_general_section(properties, _("Account"));

    self->username_vbox = self_field_new(self,
					 _("_Username:"),
					 &self->username_label,
					 &self->username_entry);
    self->password_vbox = self_field_new(self,
					 _("_Password:"),
					 &self->password_label,
					 &self->password_entry);

    selfp->password_operation_label = gtk_label_new(NULL);
    gtk_misc_set_alignment(GTK_MISC(selfp->password_operation_label), 0.0, 0.5);

    /*
     * These two widgets will alternate in their parent container so
     * we need to reference them.
     */
    mn_gtk_object_ref_and_sink(GTK_OBJECT(self->password_entry));
    mn_gtk_object_ref_and_sink(GTK_OBJECT(selfp->password_operation_label));

    selfp->password_widget = self->password_entry;

    /* defaults to the login name */
    username = g_get_user_name();
    if (username)
      gtk_entry_set_text(GTK_ENTRY(self->username_entry), username);

    gtk_entry_set_visibility(GTK_ENTRY(self->password_entry), FALSE);
  
#line 208 "mn-authenticated-mailbox-properties.c"
 }
}
#undef __GOB_FUNCTION__



#line 91 "mn-authenticated-mailbox-properties.gob"
static void 
___2_mn_authenticated_mailbox_properties_dispose (GObject * object G_GNUC_UNUSED)
#line 218 "mn-authenticated-mailbox-properties.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::dispose"
{
#line 93 "mn-authenticated-mailbox-properties.gob"
	
    Self *self = SELF(object);

    self_clear_mailbox_callbacks(self);

    PARENT_HANDLER(object);
  }}
#line 233 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 101 "mn-authenticated-mailbox-properties.gob"
GtkWidget * 
mn_authenticated_mailbox_properties_field_new (MNAuthenticatedMailboxProperties * self, const char * mnemonic, GtkWidget ** label, GtkWidget ** entry)
#line 240 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::field_new"
#line 101 "mn-authenticated-mailbox-properties.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 101 "mn-authenticated-mailbox-properties.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX_PROPERTIES (self), (GtkWidget * )0);
#line 101 "mn-authenticated-mailbox-properties.gob"
	g_return_val_if_fail (mnemonic != NULL, (GtkWidget * )0);
#line 101 "mn-authenticated-mailbox-properties.gob"
	g_return_val_if_fail (entry != NULL, (GtkWidget * )0);
#line 251 "mn-authenticated-mailbox-properties.c"
{
#line 106 "mn-authenticated-mailbox-properties.gob"
	
    GtkWidget *hbox;
    GtkWidget *_label;

    _label = gtk_label_new_with_mnemonic(mnemonic);
    gtk_misc_set_alignment(GTK_MISC(_label), 0.0, 0.5);

    *entry = gtk_entry_new();
    gtk_label_set_mnemonic_widget(GTK_LABEL(_label), *entry);

    hbox = gtk_hbox_new(FALSE, 12);
    gtk_box_pack_start(GTK_BOX(hbox), _label, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), *entry, TRUE, TRUE, 0);
    gtk_widget_show_all(hbox);

    gtk_size_group_add_widget(MN_MAILBOX_PROPERTIES(self)->label_size_group, _label);

    if (label)
      *label = _label;

    return hbox;
  }}
#line 276 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__

#line 129 "mn-authenticated-mailbox-properties.gob"
static void 
___4_mn_authenticated_mailbox_properties_set_mailbox (MNMailboxProperties * properties G_GNUC_UNUSED, MNMailbox * mailbox)
#line 282 "mn-authenticated-mailbox-properties.c"
#define PARENT_HANDLER(___properties,___mailbox) \
	{ if(MN_MAILBOX_PROPERTIES_CLASS(parent_class)->set_mailbox) \
		(* MN_MAILBOX_PROPERTIES_CLASS(parent_class)->set_mailbox)(___properties,___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::set_mailbox"
{
#line 131 "mn-authenticated-mailbox-properties.gob"
	
    Self *self = SELF(properties);
    MNAuthenticatedMailbox *auth_mailbox = MN_AUTHENTICATED_MAILBOX(mailbox);

    self_clear_mailbox_callbacks(self);

    gtk_entry_set_text(GTK_ENTRY(self->username_entry), auth_mailbox->username);

    /*
     * If the password is currently being saved, wait for that
     * operation to finish before querying the keyring for the
     * password.
     */
    if (mn_authenticated_mailbox_get_setting_password(auth_mailbox))
      {
	selfp->mailbox_setting_password = g_object_ref(auth_mailbox);
	g_signal_connect(auth_mailbox, "notify::setting-password", G_CALLBACK(self_setting_password_notify_h), self);
	self_set_password_operation(self, _("Saving password to keyring..."));
      }
    else
      self_get_password(self, auth_mailbox);
  }}
#line 312 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 154 "mn-authenticated-mailbox-properties.gob"
static void 
mn_authenticated_mailbox_properties_clear_mailbox_callbacks (MNAuthenticatedMailboxProperties * self)
#line 319 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::clear_mailbox_callbacks"
#line 154 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (self != NULL);
#line 154 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX_PROPERTIES (self));
#line 326 "mn-authenticated-mailbox-properties.c"
{
#line 156 "mn-authenticated-mailbox-properties.gob"
	
    if (selfp->mailbox_setting_password)
      {
	g_signal_handlers_disconnect_by_func(selfp->mailbox_setting_password, self_setting_password_notify_h, self);
	g_object_unref(selfp->mailbox_setting_password);
	selfp->mailbox_setting_password = NULL;
      }

    if (selfp->get_password_request)
      {
	gnome_keyring_cancel_request(selfp->get_password_request);
	selfp->get_password_request = NULL;
      }
  }}
#line 343 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__

#line 171 "mn-authenticated-mailbox-properties.gob"
static void 
mn_authenticated_mailbox_properties_setting_password_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 349 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::setting_password_notify_h"
{
#line 175 "mn-authenticated-mailbox-properties.gob"
	
    Self *self = user_data;
    MNAuthenticatedMailbox *mailbox = MN_AUTHENTICATED_MAILBOX(object);

    /*
     * If the password save operation is finished, we can query the
     * keyring for the password.
     */
    if (! mn_authenticated_mailbox_get_setting_password(mailbox))
      {
	g_signal_handlers_disconnect_by_func(mailbox, self_setting_password_notify_h, self);
	self_get_password(self, mailbox);
      }
  }}
#line 368 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__

#line 190 "mn-authenticated-mailbox-properties.gob"
static void 
mn_authenticated_mailbox_properties_get_password (MNAuthenticatedMailboxProperties * self, MNAuthenticatedMailbox * mailbox)
#line 374 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::get_password"
#line 190 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (self != NULL);
#line 190 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX_PROPERTIES (self));
#line 190 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (mailbox != NULL);
#line 383 "mn-authenticated-mailbox-properties.c"
{
#line 192 "mn-authenticated-mailbox-properties.gob"
	
    self_set_password_operation(self, _("Retrieving password from keyring..."));

    selfp->get_password_request = mn_authenticated_mailbox_get_password(mailbox,
									self_get_password_cb,
									self);
  }}
#line 393 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__

#line 200 "mn-authenticated-mailbox-properties.gob"
static void 
mn_authenticated_mailbox_properties_get_password_cb (GnomeKeyringResult result, GList * list, gpointer data)
#line 399 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::get_password_cb"
{
#line 202 "mn-authenticated-mailbox-properties.gob"
	
    Self *self = data;
    const char *password = NULL;

    /*
     * If the request was cancelled, it is either from dispose() and
     * self might already have been finalized (since this is a main
     * loop callback), or it is from set_mailbox() and the password
     * will be retrieved again. In both cases we must do nothing.
     */
    if (result == GNOME_KEYRING_RESULT_CANCELLED)
      return;

    selfp->get_password_request = NULL;

    if (result == GNOME_KEYRING_RESULT_OK && list)
      {
	GnomeKeyringNetworkPasswordData *data = list->data;
	password = data->password;
      }

    GDK_THREADS_ENTER();

    gtk_entry_set_text(GTK_ENTRY(self->password_entry), password ? password : "");
    self_set_password_operation(self, NULL);

    /* do not call gdk_flush(), we're normally in the main thread */
    GDK_THREADS_LEAVE();
  }}
#line 433 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__

#line 232 "mn-authenticated-mailbox-properties.gob"
static MNMailbox * 
___9_mn_authenticated_mailbox_properties_get_mailbox (MNMailboxProperties * properties G_GNUC_UNUSED)
#line 439 "mn-authenticated-mailbox-properties.c"
#define PARENT_HANDLER(___properties) \
	((MN_MAILBOX_PROPERTIES_CLASS(parent_class)->get_mailbox)? \
		(* MN_MAILBOX_PROPERTIES_CLASS(parent_class)->get_mailbox)(___properties): \
		((MNMailbox * )0))
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::get_mailbox"
{
#line 234 "mn-authenticated-mailbox-properties.gob"
	
    Self *self = SELF(properties);
    MNMailbox *mailbox;
    MNAuthenticatedMailbox *auth_mailbox;
    const char *username;
    const char *password;

    mailbox = PARENT_HANDLER(properties);
    auth_mailbox = MN_AUTHENTICATED_MAILBOX(mailbox);

    username = gtk_entry_get_text(GTK_ENTRY(self->username_entry));
    password = gtk_entry_get_text(GTK_ENTRY(self->password_entry));

    auth_mailbox->username = g_strdup(username);
    if (*password)
      auth_mailbox->password = g_strdup(password);

    return mailbox;
  }}
#line 467 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 254 "mn-authenticated-mailbox-properties.gob"
static void 
mn_authenticated_mailbox_properties_set_password_operation (MNAuthenticatedMailboxProperties * self, const char * operation)
#line 474 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::set_password_operation"
#line 254 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (self != NULL);
#line 254 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX_PROPERTIES (self));
#line 481 "mn-authenticated-mailbox-properties.c"
{
#line 256 "mn-authenticated-mailbox-properties.gob"
	
    GtkWidget *password_widget;

    gtk_label_set_text(GTK_LABEL(selfp->password_operation_label), operation);

    if (operation)
      password_widget = selfp->password_operation_label;
    else
      password_widget = self->password_entry;

    if (password_widget != selfp->password_widget)
      {
	gtk_container_remove(GTK_CONTAINER(self->password_vbox), selfp->password_widget);

	gtk_box_pack_start(GTK_BOX(self->password_vbox), password_widget, TRUE, TRUE, 0);
	gtk_widget_show(password_widget);
	selfp->password_widget = password_widget;

	mn_mailbox_properties_notify_complete(MN_MAILBOX_PROPERTIES(self));
      }
  }}
#line 505 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__

#line 278 "mn-authenticated-mailbox-properties.gob"
void 
mn_authenticated_mailbox_properties_get_contents (MNAuthenticatedMailboxProperties * self, const char ** username, const char ** password)
#line 511 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::get_contents"
#line 278 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (self != NULL);
#line 278 "mn-authenticated-mailbox-properties.gob"
	g_return_if_fail (MN_IS_AUTHENTICATED_MAILBOX_PROPERTIES (self));
#line 518 "mn-authenticated-mailbox-properties.c"
{
#line 282 "mn-authenticated-mailbox-properties.gob"
	
    if (username)
      {
	const char *_username;

	_username = gtk_entry_get_text(GTK_ENTRY(self->username_entry));
	*username = *_username ? _username : NULL;
      }
    if (password)
      {
	const char *_password;

	_password = gtk_entry_get_text(GTK_ENTRY(self->password_entry));
	*password = *_password ? _password : NULL;
      }
  }}
#line 537 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__

#line 299 "mn-authenticated-mailbox-properties.gob"
gboolean 
mn_authenticated_mailbox_properties_is_complete (MNAuthenticatedMailboxProperties * self)
#line 543 "mn-authenticated-mailbox-properties.c"
{
#define __GOB_FUNCTION__ "MN:Authenticated:Mailbox:Properties::is_complete"
#line 299 "mn-authenticated-mailbox-properties.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 299 "mn-authenticated-mailbox-properties.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX_PROPERTIES (self), (gboolean )0);
#line 550 "mn-authenticated-mailbox-properties.c"
{
#line 301 "mn-authenticated-mailbox-properties.gob"
	
    const char *username;

    if (selfp->password_widget == selfp->password_operation_label)
      return FALSE;

    username = gtk_entry_get_text(GTK_ENTRY(self->username_entry));

    return *username != 0;
  }}
#line 563 "mn-authenticated-mailbox-properties.c"
#undef __GOB_FUNCTION__
