/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-gmail-mailbox.h"

#include "mn-gmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "mn-gmail-mailbox.gob"

#include "config.h"
#include <string.h>
#ifdef HAVE_TIMEGM
#include <stdlib.h>
#include <time.h>
#ifdef TM_IN_SYS_TIME
#include <sys/time.h>
#endif /* TM_IN_SYS_TIME */
#endif /* HAVE_TIMEGM */
#include <glib/gi18n.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include "mn-mailbox-private.h"
#include "mn-authenticated-mailbox-private.h"
#include "mn-vfs.h"
#include "mn-stock.h"
#include "mn-message.h"
#include "mn-util.h"

#line 45 "mn-gmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_GMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_GMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_GMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_GMAIL_MAILBOX
#define SELF_CLASS(x) MN_GMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_GMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNGmailMailbox Self;
typedef MNGmailMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_gmail_mailbox_class_init (MNGmailMailboxClass * class) G_GNUC_UNUSED;
static void mn_gmail_mailbox_init (MNGmailMailbox * self) G_GNUC_UNUSED;
static void ___3_mn_gmail_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static GnomeVFSURI * mn_gmail_mailbox_build_uri (MNGmailMailbox * self) G_GNUC_UNUSED;
static void ___5_mn_gmail_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;
static void mn_gmail_mailbox_parse_entry (xmlNode * node, time_t * sent_time, char ** id, char ** from, char ** subject, char ** url) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_parse_author (xmlNode * node) G_GNUC_UNUSED;
static time_t mn_gmail_mailbox_parse_date (const char * w3c_datetime) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_LOCATION,
	PROP_LABEL
};

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_build_uri mn_gmail_mailbox_build_uri
#define self_parse_entry mn_gmail_mailbox_parse_entry
#define self_parse_author mn_gmail_mailbox_parse_author
#define self_parse_date mn_gmail_mailbox_parse_date
#define self_build_name mn_gmail_mailbox_build_name
GType
mn_gmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNGmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_gmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNGmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_gmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNGmailMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNGmailMailbox *)g_object_new(mn_gmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNGmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNGmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNGmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNGmailMailbox *)g_object_new_valist (mn_gmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dispose"
	MNGmailMailbox *self G_GNUC_UNUSED = MN_GMAIL_MAILBOX (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 62 "mn-gmail-mailbox.gob"
	if(self->_priv->uri) { gnome_vfs_uri_unref ((gpointer) self->_priv->uri); self->_priv->uri = NULL; }
#line 138 "mn-gmail-mailbox.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::finalize"
	MNGmailMailbox *self G_GNUC_UNUSED = MN_GMAIL_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 53 "mn-gmail-mailbox.gob"
	if(self->location) { g_free ((gpointer) self->location); self->location = NULL; }
#line 153 "mn-gmail-mailbox.c"
#line 59 "mn-gmail-mailbox.gob"
	if(self->label) { g_free ((gpointer) self->label); self->label = NULL; }
#line 156 "mn-gmail-mailbox.c"
}
#undef __GOB_FUNCTION__

#line 64 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_class_init (MNGmailMailboxClass * class G_GNUC_UNUSED)
#line 163 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNGmailMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 78 "mn-gmail-mailbox.gob"
	mn_mailbox_class->seal = ___3_mn_gmail_mailbox_seal;
#line 143 "mn-gmail-mailbox.gob"
	mn_authenticated_mailbox_class->authenticated_check = ___5_mn_gmail_mailbox_authenticated_check;
#line 178 "mn-gmail-mailbox.c"
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("location" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 "https://mail.google.com/mail/feed/atom" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_LOAD_SAVE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_LOCATION,
		param_spec);
	param_spec = g_param_spec_string
		("label" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_LABEL,
		param_spec);
    }
 {
#line 65 "mn-gmail-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "gmail";

    /* 5 minutes is a good default */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;
  
#line 213 "mn-gmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 72 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_init (MNGmailMailbox * self G_GNUC_UNUSED)
#line 220 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_GMAIL_MAILBOX,MNGmailMailboxPrivate);
 {
#line 73 "mn-gmail-mailbox.gob"

    mn_mailbox_set_format(MN_MAILBOX(self), "Gmail");
    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_GMAIL);
  
#line 230 "mn-gmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::set_property"
{
	MNGmailMailbox *self G_GNUC_UNUSED;

	self = MN_GMAIL_MAILBOX (object);

	switch (property_id) {
	case PROP_LOCATION:
		{
#line 54 "mn-gmail-mailbox.gob"
{ char *old = self->location; self->location = g_value_dup_string (VAL); g_free (old); }
#line 251 "mn-gmail-mailbox.c"
		}
		break;
	case PROP_LABEL:
		{
#line 60 "mn-gmail-mailbox.gob"
{ char *old = self->label; self->label = g_value_dup_string (VAL); g_free (old); }
#line 258 "mn-gmail-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_property"
{
	MNGmailMailbox *self G_GNUC_UNUSED;

	self = MN_GMAIL_MAILBOX (object);

	switch (property_id) {
	case PROP_LOCATION:
		{
#line 54 "mn-gmail-mailbox.gob"
g_value_set_string (VAL, self->location);
#line 289 "mn-gmail-mailbox.c"
		}
		break;
	case PROP_LABEL:
		{
#line 60 "mn-gmail-mailbox.gob"
g_value_set_string (VAL, self->label);
#line 296 "mn-gmail-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 78 "mn-gmail-mailbox.gob"
static void 
___3_mn_gmail_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 316 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::seal"
{
#line 80 "mn-gmail-mailbox.gob"
	
    MNAuthenticatedMailbox *auth_mailbox = MN_AUTHENTICATED_MAILBOX(mailbox);
    Self *self = SELF(mailbox);
    GnomeVFSURI *uri;

    PARENT_HANDLER(mailbox);

    if (! mailbox->runtime_name)
      mailbox->runtime_name = self_build_name(auth_mailbox->username, self->label);

    uri = self_build_uri(self);
    if (uri)
      {
	/*
	 * Use keyring attributes that are compatible with what
	 * GnomeVFS uses. This allows the password entered by the user
	 * at the GnomeVFS password prompt to be recognized by Mail
	 * Notification and displayed in the mailbox properties
	 * dialog.
	 */
	auth_mailbox->keyring_server = g_strdup(gnome_vfs_uri_get_host_name(uri));
	auth_mailbox->keyring_protocol = g_strdup("http");
	auth_mailbox->keyring_authtype = g_strdup("basic");
	auth_mailbox->keyring_port = gnome_vfs_uri_get_host_port(uri);
	if (auth_mailbox->keyring_port == 0)
	  {
	    const char *scheme;

	    scheme = gnome_vfs_uri_get_scheme(uri);
	    if (! strcmp(scheme, "http"))
	      auth_mailbox->keyring_port = 80;
	    else if (! strcmp(scheme, "https"))
	      auth_mailbox->keyring_port = 443;
	  }

	gnome_vfs_uri_unref(uri);
      }
    else
      /* fallback */
      auth_mailbox->keyring_domain = g_strdup("gmail.com");
  }}
#line 365 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 122 "mn-gmail-mailbox.gob"
static GnomeVFSURI * 
mn_gmail_mailbox_build_uri (MNGmailMailbox * self)
#line 372 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_uri"
#line 122 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (GnomeVFSURI * )0);
#line 122 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (GnomeVFSURI * )0);
#line 379 "mn-gmail-mailbox.c"
{
#line 124 "mn-gmail-mailbox.gob"
	
    GnomeVFSURI *uri;

    uri = gnome_vfs_uri_new(self->location);
    if (uri)
      {
	GnomeVFSURI *new_uri;

	if (self->label)
	  {
	    new_uri = gnome_vfs_uri_append_file_name(uri, self->label);
	    gnome_vfs_uri_unref(uri);
	    uri = new_uri;
	  }
      }

    return uri;
  }}
#line 400 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 143 "mn-gmail-mailbox.gob"
static void 
___5_mn_gmail_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 406 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::authenticated_check"
{
#line 145 "mn-gmail-mailbox.gob"
	
    Self *self = SELF(mailbox);
    GnomeVFSResult result;
    char *atom;
    int atom_size;
    xmlDoc *doc;
    xmlNode *node;

    PARENT_HANDLER(mailbox);

    if (! selfp->uri)
      {
	selfp->uri = self_build_uri(self);
	if (! selfp->uri)
	  {
	    GDK_THREADS_ENTER();

	    mn_mailbox_set_error(MN_MAILBOX(self), _("invalid feed location"));
	    /* error is not recoverable, disable the mailbox */
	    mn_mailbox_set_poll(MN_MAILBOX(self), FALSE);

	    gdk_flush();
	    GDK_THREADS_LEAVE();

	    return;
	  }

	/*
	 * Obtain the password from the keyring but do not prompt
	 * (GnomeVFS will prompt on our behalf if the password is
	 * missing).
	 */
	mn_authenticated_mailbox_fill_password(mailbox, FALSE);

	gnome_vfs_uri_set_user_name(selfp->uri, mailbox->username);
	gnome_vfs_uri_set_password(selfp->uri, mailbox->runtime_password);
      }

    mn_mailbox_notice(MN_MAILBOX(self), _("retrieving feed from %s"), self->location);

    result = mn_vfs_read_entire_file_uri(selfp->uri, &atom_size, &atom);
    if (result != GNOME_VFS_OK)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), _("unable to retrieve feed: %s"), gnome_vfs_result_to_string(result));

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;
      }

    mn_mailbox_notice(MN_MAILBOX(self),
		      ngettext("feed retrieved successfully (%i byte)",
			       "feed retrieved successfully (%i bytes)",
			       atom_size),
		      atom_size);

    doc = xmlParseMemory(atom, atom_size);
    g_free(atom);

    if (! doc)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), _("unable to parse feed"));

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;
      }

    node = xmlDocGetRootElement(doc);
    if (node && ! strcmp(node->name, "feed"))
      {
	GSList *messages = NULL;

	for (node = node->children; node != NULL; node = node->next)
	  if (node->type == XML_ELEMENT_NODE && ! strcmp(node->name, "entry"))
	    {
	      time_t sent_time;
	      char *id;
	      char *from;
	      char *subject;
	      char *url;

	      self_parse_entry(node, &sent_time, &id, &from, &subject, &url);

	      messages = g_slist_prepend(messages, mn_message_new(MN_MAILBOX(self),
								  NULL,
								  sent_time,
								  id,
								  from,
								  subject,
								  url,
								  MN_MESSAGE_NEW));

	      g_free(id);
	      g_free(from);
	      g_free(subject);
	      g_free(url);
	    }

	GDK_THREADS_ENTER();

	mn_mailbox_set_messages(MN_MAILBOX(self), messages);
	mn_g_object_slist_free(messages);

	gdk_flush();
	GDK_THREADS_LEAVE();
      }
    else
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), _("unable to parse feed"));

	gdk_flush();
	GDK_THREADS_LEAVE();
      }

    xmlFreeDoc(doc);
  }}
#line 539 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 271 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_parse_entry (xmlNode * node, time_t * sent_time, char ** id, char ** from, char ** subject, char ** url)
#line 546 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_entry"
#line 271 "mn-gmail-mailbox.gob"
	g_return_if_fail (node != NULL);
#line 271 "mn-gmail-mailbox.gob"
	g_return_if_fail (sent_time != NULL);
#line 271 "mn-gmail-mailbox.gob"
	g_return_if_fail (id != NULL);
#line 271 "mn-gmail-mailbox.gob"
	g_return_if_fail (from != NULL);
#line 271 "mn-gmail-mailbox.gob"
	g_return_if_fail (subject != NULL);
#line 271 "mn-gmail-mailbox.gob"
	g_return_if_fail (url != NULL);
#line 561 "mn-gmail-mailbox.c"
{
#line 278 "mn-gmail-mailbox.gob"
	
    *sent_time = 0;
    *id = NULL;
    *from = NULL;
    *subject = NULL;
    *url = NULL;

    for (node = node->children; node != NULL; node = node->next)
      if (node->type == XML_ELEMENT_NODE)
	{
	  if (! strcmp(node->name, "title"))
	    {
	      g_free(*subject);
	      *subject = xmlNodeGetContent(node);
	    }
	  else if (! strcmp(node->name, "id"))
	    {
	      g_free(*id);
	      *id = xmlNodeGetContent(node);
	    }
	  else if (! strcmp(node->name, "author"))
	    {
	      g_free(*from);
	      *from = self_parse_author(node);
	    }
	  else if (! strcmp(node->name, "link"))
	    {
	      g_free(*url);
	      *url = xmlGetProp(node, "href");
	    }
#ifdef HAVE_TIMEGM
	  else if (! strcmp(node->name, "issued"))
	    {
	      char *w3c_datetime;

	      w3c_datetime = xmlNodeGetContent(node);
	      if (w3c_datetime)
		{
		  *sent_time = self_parse_date(w3c_datetime);
		  g_free(w3c_datetime);
		}
	    }
#endif
	}
  }}
#line 609 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 324 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_parse_author (xmlNode * node)
#line 615 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_author"
#line 324 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (node != NULL, (char * )0);
#line 620 "mn-gmail-mailbox.c"
{
#line 326 "mn-gmail-mailbox.gob"
	
    char *from;
    char *name = NULL;
    char *email = NULL;

    for (node = node->children; node != NULL; node = node->next)
      if (node->type == XML_ELEMENT_NODE)
	{
	  if (! strcmp(node->name, "name"))
	    {
	      g_free(name);
	      name = xmlNodeGetContent(node);
	    }
	  else if (! strcmp(node->name, "email"))
	    {
	      g_free(email);
	      email = xmlNodeGetContent(node);
	    }
	}

    from = name && email
      ? g_strdup_printf("%s <%s>", name, email)
      : g_strdup(name ? name : email);

    g_free(name);
    g_free(email);

    return from;
  }}
#line 652 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 356 "mn-gmail-mailbox.gob"
static time_t 
mn_gmail_mailbox_parse_date (const char * w3c_datetime)
#line 658 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_date"
#line 356 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (w3c_datetime != NULL, (time_t )0);
#line 663 "mn-gmail-mailbox.c"
{
#line 358 "mn-gmail-mailbox.gob"
	
#ifdef HAVE_TIMEGM
    time_t t = 0;
    char year[5];
    char month[3];
    char day[3];
    char hour[3];
    char minute[3];
    char second[3];

    if (sscanf(w3c_datetime, "%4s-%2s-%2sT%2s:%2s:%2sZ", year, month, day, hour, minute, second) == 6
	&& mn_str_isnumeric(year)
	&& mn_str_isnumeric(month)
	&& mn_str_isnumeric(day)
	&& mn_str_isnumeric(hour)
	&& mn_str_isnumeric(minute)
	&& mn_str_isnumeric(second))
      {
	struct tm tm = { 0 };

	tm.tm_sec = atoi(second);
	tm.tm_min = atoi(minute);
	tm.tm_hour = atoi(hour);
	tm.tm_mday = atoi(day);
	tm.tm_mon = atoi(month) - 1;
	tm.tm_year = atoi(year) - 1900;

	t = timegm(&tm);
	if (t == -1)
	  t = 0;
      }

    return t;
#else
    g_assert_not_reached();
    return 0;
#endif
  }}
#line 704 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 397 "mn-gmail-mailbox.gob"
char * 
mn_gmail_mailbox_build_name (const char * username, const char * label)
#line 710 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_name"
#line 397 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (username != NULL, (char * )0);
#line 715 "mn-gmail-mailbox.c"
{
#line 399 "mn-gmail-mailbox.gob"
	
    GString *name;

    name = g_string_new(NULL);

    if (g_str_has_suffix(username, "@gmail.com"))
      g_string_append(name, username);
    else
      g_string_append_printf(name, "%s@gmail.com", username);

    if (label)
      g_string_append_printf(name, "/%s", label);

    return g_string_free(name, FALSE);
  }}
#line 733 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
