/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailboxes.h"

#include "mn-mailboxes-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "mn-mailboxes.gob"

#include "config.h"
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <errno.h>
#include <glib/gi18n.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <eel/eel.h>
#include "mn-conf.h"
#include "mn-message.h"
#include "mn-mailbox-private.h"
#include "mn-test-mailbox.h"
#include "mn-shell.h"

#line 45 "mn-mailboxes.c"
/* self casting macros */
#define SELF(x) MN_MAILBOXES(x)
#define SELF_CONST(x) MN_MAILBOXES_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOXES(x)
#define TYPE_SELF MN_TYPE_MAILBOXES
#define SELF_CLASS(x) MN_MAILBOXES_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOXES_GET_CLASS(x)

/* self typedefs */
typedef MNMailboxes Self;
typedef MNMailboxesClass SelfClass;

/* here are local prototypes */
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_mailboxes_class_init (MNMailboxesClass * c) G_GNUC_UNUSED;
static void ___real_mn_mailboxes_mailbox_added (MNMailboxes * self, MNMailbox * mailbox);
static void mn_mailboxes_mailbox_added (MNMailboxes * self, MNMailbox * mailbox) G_GNUC_UNUSED;
static void ___real_mn_mailboxes_mailbox_removed (MNMailboxes * self, MNMailbox * mailbox);
static void mn_mailboxes_mailbox_removed (MNMailboxes * self, MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_mailboxes_mailbox_notify (MNMailboxes * self, MNMailbox * mailbox, GParamSpec * pspec) G_GNUC_UNUSED;
static void ___real_mn_mailboxes_list_changed (MNMailboxes * self);
static void mn_mailboxes_list_changed (MNMailboxes * self) G_GNUC_UNUSED;
static void ___real_mn_mailboxes_messages_changed (MNMailboxes * self, gboolean has_new);
static void mn_mailboxes_messages_changed (MNMailboxes * self, gboolean has_new) G_GNUC_UNUSED;
static int mn_mailboxes_messages_sort_cb (MNMessage * a, MNMessage * b) G_GNUC_UNUSED;
static void mn_mailboxes_error_changed (MNMailboxes * self) G_GNUC_UNUSED;
static void mn_mailboxes_init (MNMailboxes * self) G_GNUC_UNUSED;
static void ___a_mn_mailboxes_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_mailboxes_load (MNMailboxes * self) G_GNUC_UNUSED;
static void mn_mailboxes_add_error (GString ** errors, int * n_errors, const char * format, ...) G_GNUC_UNUSED;
static gboolean mn_mailboxes_load_real (MNMailboxes * self, GError ** err) G_GNUC_UNUSED;
static void mn_mailboxes_save (MNMailboxes * self) G_GNUC_UNUSED;
static gboolean mn_mailboxes_save_real (MNMailboxes * self, GError ** err) G_GNUC_UNUSED;
static void mn_mailboxes_mailbox_messages_changed_h (MNMailbox * mailbox, gboolean has_new, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_mailbox_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_mailbox_notify_error_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_mailbox_notify_manually_checkable_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_add_real (MNMailboxes * self, MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_mailboxes_remove_real (MNMailboxes * self, MNMailbox * mailbox) G_GNUC_UNUSED;
static gboolean mn_mailboxes_queue_idle_cb (gpointer data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__mailbox_added(object,func,data)	mn_mailboxes_connect__mailbox_added((object),(func),(data))
#define self_connect_after__mailbox_added(object,func,data)	mn_mailboxes_connect_after__mailbox_added((object),(func),(data))
#define self_connect_data__mailbox_added(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__mailbox_added((object),(func),(data),(destroy_data),(flags))
#define self_connect__mailbox_removed(object,func,data)	mn_mailboxes_connect__mailbox_removed((object),(func),(data))
#define self_connect_after__mailbox_removed(object,func,data)	mn_mailboxes_connect_after__mailbox_removed((object),(func),(data))
#define self_connect_data__mailbox_removed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__mailbox_removed((object),(func),(data),(destroy_data),(flags))
#define self_connect__mailbox_notify(object,func,data)	mn_mailboxes_connect__mailbox_notify((object),(func),(data))
#define self_connect_after__mailbox_notify(object,func,data)	mn_mailboxes_connect_after__mailbox_notify((object),(func),(data))
#define self_connect_data__mailbox_notify(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__mailbox_notify((object),(func),(data),(destroy_data),(flags))
#define self_connect__list_changed(object,func,data)	mn_mailboxes_connect__list_changed((object),(func),(data))
#define self_connect_after__list_changed(object,func,data)	mn_mailboxes_connect_after__list_changed((object),(func),(data))
#define self_connect_data__list_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__list_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__messages_changed(object,func,data)	mn_mailboxes_connect__messages_changed((object),(func),(data))
#define self_connect_after__messages_changed(object,func,data)	mn_mailboxes_connect_after__messages_changed((object),(func),(data))
#define self_connect_data__messages_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__messages_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__error_changed(object,func,data)	mn_mailboxes_connect__error_changed((object),(func),(data))
#define self_connect_after__error_changed(object,func,data)	mn_mailboxes_connect_after__error_changed((object),(func),(data))
#define self_connect_data__error_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__error_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNMailboxes *, GObject *, gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailboxes *)data1,
		(GObject *) g_value_get_object (param_values + 1),
		data2);
}


typedef void  (*___Sig2) (MNMailboxes *, GObject *, gpointer , gpointer);

static void
___marshal_Sig2 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig2 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 3);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig2) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailboxes *)data1,
		(GObject *) g_value_get_object (param_values + 1),
		(gpointer ) g_value_get_pointer (param_values + 2),
		data2);
}


typedef void  (*___Sig3) (MNMailboxes *, gboolean , gpointer);

static void
___marshal_Sig3 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig3 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig3) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailboxes *)data1,
		(gboolean ) g_value_get_boolean (param_values + 1),
		data2);
}


enum {
	MAILBOX_ADDED_SIGNAL,
	MAILBOX_REMOVED_SIGNAL,
	MAILBOX_NOTIFY_SIGNAL,
	LIST_CHANGED_SIGNAL,
	MESSAGES_CHANGED_SIGNAL,
	ERROR_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_MANUALLY_CHECKABLE
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_mailbox_added mn_mailboxes_mailbox_added
#define self_mailbox_removed mn_mailboxes_mailbox_removed
#define self_mailbox_notify mn_mailboxes_mailbox_notify
#define self_list_changed mn_mailboxes_list_changed
#define self_messages_changed mn_mailboxes_messages_changed
#define self_messages_sort_cb mn_mailboxes_messages_sort_cb
#define self_error_changed mn_mailboxes_error_changed
#define self_get_manually_checkable mn_mailboxes_get_manually_checkable
#define self_load mn_mailboxes_load
#define self_add_error mn_mailboxes_add_error
#define self_load_real mn_mailboxes_load_real
#define self_save mn_mailboxes_save
#define self_save_real mn_mailboxes_save_real
#define self_mailbox_messages_changed_h mn_mailboxes_mailbox_messages_changed_h
#define self_mailbox_notify_h mn_mailboxes_mailbox_notify_h
#define self_mailbox_notify_error_h mn_mailboxes_mailbox_notify_error_h
#define self_mailbox_notify_manually_checkable_h mn_mailboxes_mailbox_notify_manually_checkable_h
#define self_check mn_mailboxes_check
#define self_add_real mn_mailboxes_add_real
#define self_add mn_mailboxes_add
#define self_queue_add mn_mailboxes_queue_add
#define self_remove_real mn_mailboxes_remove_real
#define self_remove mn_mailboxes_remove
#define self_queue_remove mn_mailboxes_queue_remove
#define self_queue_idle_cb mn_mailboxes_queue_idle_cb
#define self_compare_by_name_func mn_mailboxes_compare_by_name_func
#define self_new mn_mailboxes_new
GType
mn_mailboxes_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxesClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailboxes_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailboxes),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailboxes_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailboxes", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailboxes *)g_object_new(mn_mailboxes_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailboxes * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailboxes *
GET_NEW_VARG (const char *first, ...)
{
	MNMailboxes *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailboxes *)g_object_new_valist (mn_mailboxes_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailboxes::finalize"
	MNMailboxes *self G_GNUC_UNUSED = MN_MAILBOXES (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 261 "mn-mailboxes.gob"
	___a_mn_mailboxes_finalize(obj_self);
#line 306 "mn-mailboxes.c"
#line 51 "mn-mailboxes.gob"
	if(self->list) { eel_g_object_list_free ((gpointer) self->list); self->list = NULL; }
#line 309 "mn-mailboxes.c"
#line 54 "mn-mailboxes.gob"
	if(self->messages) { mn_g_object_slist_free ((gpointer) self->messages); self->messages = NULL; }
#line 312 "mn-mailboxes.c"
#line 56 "mn-mailboxes.gob"
	if(self->_priv->add_queue) { mn_g_object_slist_free ((gpointer) self->_priv->add_queue); self->_priv->add_queue = NULL; }
#line 315 "mn-mailboxes.c"
#line 57 "mn-mailboxes.gob"
	if(self->_priv->remove_queue) { mn_g_object_slist_free ((gpointer) self->_priv->remove_queue); self->_priv->remove_queue = NULL; }
#line 318 "mn-mailboxes.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailboxes_class_init (MNMailboxesClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailboxes::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMailboxesPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[MAILBOX_ADDED_SIGNAL] =
		g_signal_new ("mailbox_added",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, mailbox_added),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(MNMailbox * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("mn-mailboxes.gob line 74: Type mismatch of \"mailbox_added\" signal signature");
	}
	object_signals[MAILBOX_REMOVED_SIGNAL] =
		g_signal_new ("mailbox_removed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, mailbox_removed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(MNMailbox * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("mn-mailboxes.gob line 97: Type mismatch of \"mailbox_removed\" signal signature");
	}
	object_signals[MAILBOX_NOTIFY_SIGNAL] =
		g_signal_new ("mailbox_notify",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED),
			G_STRUCT_OFFSET (MNMailboxesClass, mailbox_notify),
			NULL, NULL,
			___marshal_Sig2,
			G_TYPE_NONE, 2,
			G_TYPE_OBJECT,
			G_TYPE_POINTER);
	if ___GOB_UNLIKELY(sizeof(MNMailbox * ) != sizeof(GObject *) || sizeof(GParamSpec * ) != sizeof(gpointer ) || parent_class == NULL /* avoid warning */) {
		g_error("mn-mailboxes.gob line 116: Type mismatch of \"mailbox_notify\" signal signature");
	}
	object_signals[LIST_CHANGED_SIGNAL] =
		g_signal_new ("list_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, list_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[MESSAGES_CHANGED_SIGNAL] =
		g_signal_new ("messages_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, messages_changed),
			NULL, NULL,
			___marshal_Sig3,
			G_TYPE_NONE, 1,
			G_TYPE_BOOLEAN);
	if ___GOB_UNLIKELY(sizeof(gboolean ) != sizeof(gboolean ) || parent_class == NULL /* avoid warning */) {
		g_error("mn-mailboxes.gob line 150: Type mismatch of \"messages_changed\" signal signature");
	}
	object_signals[ERROR_CHANGED_SIGNAL] =
		g_signal_new ("error_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxesClass, error_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 74 "mn-mailboxes.gob"
	c->mailbox_added = ___real_mn_mailboxes_mailbox_added;
#line 97 "mn-mailboxes.gob"
	c->mailbox_removed = ___real_mn_mailboxes_mailbox_removed;
#line 402 "mn-mailboxes.c"
	c->mailbox_notify = NULL;
#line 129 "mn-mailboxes.gob"
	c->list_changed = ___real_mn_mailboxes_list_changed;
#line 150 "mn-mailboxes.gob"
	c->messages_changed = ___real_mn_mailboxes_messages_changed;
#line 408 "mn-mailboxes.c"
	c->error_changed = NULL;
#line 261 "mn-mailboxes.gob"
	g_object_class->finalize = ___finalize;
#line 412 "mn-mailboxes.c"
	g_object_class->get_property = ___object_get_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("manually_checkable" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_MANUALLY_CHECKABLE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 206 "mn-mailboxes.gob"
static void 
mn_mailboxes_init (MNMailboxes * self G_GNUC_UNUSED)
#line 432 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_MAILBOXES,MNMailboxesPrivate);
 {
#line 207 "mn-mailboxes.gob"

    char *filename;
    gboolean exists;

    mn_shell->mailboxes = self;

    filename = g_build_filename(mn_conf_dot_dir, "mailboxes.xml", NULL);
    exists = g_file_test(filename, G_FILE_TEST_EXISTS);
    g_free(filename);

    if (exists)
      self_load(self);
    else if (mn_conf_is_set(MN_CONF_OBSOLETE_MAILBOXES))
      {
	GSList *gconf_mailboxes;
	GSList *l;
	GSList *invalid_uri_list = NULL;
	gboolean list_changed = FALSE;

	gconf_mailboxes = eel_gconf_get_string_list(MN_CONF_OBSOLETE_MAILBOXES);
	MN_LIST_FOREACH(l, gconf_mailboxes)
	  {
	    const char *uri = l->data;
	    MNMailbox *mailbox;

	    mailbox = mn_mailbox_new_from_obsolete_uri(uri);
	    if (mailbox)
	      {
		mn_mailbox_seal(mailbox);
		self_add_real(self, mailbox);
		g_object_unref(mailbox);

		list_changed = TRUE;
	      }
	    else
	      invalid_uri_list = g_slist_append(invalid_uri_list, (gpointer) uri);
	  }

	if (list_changed)
	  {
	    self_list_changed(self);
	    self_save(self);	/* save the imported mailboxes */
	  }

	if (invalid_uri_list)
	  {
	    mn_invalid_uri_list_dialog(NULL, _("An error has occurred while importing old mailboxes"), invalid_uri_list);
	    g_slist_free(invalid_uri_list);
	  }

	eel_g_slist_free_deep(gconf_mailboxes);
      }
  
#line 491 "mn-mailboxes.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailboxes::get_property"
{
	MNMailboxes *self G_GNUC_UNUSED;

	self = MN_MAILBOXES (object);

	switch (property_id) {
	case PROP_MANUALLY_CHECKABLE:
		{
#line 188 "mn-mailboxes.gob"

      GList *l;
      gboolean value = FALSE;

      MN_LIST_FOREACH(l, self->list)
	{
	  MNMailbox *mailbox = l->data;

	  if (mn_mailbox_get_manually_checkable(mailbox))
	    {
	      value = TRUE;
	      break;
	    }
	}

      g_value_set_boolean(VAL, value);
    
#line 528 "mn-mailboxes.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 74 "mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_added (MNMailboxes * self, MNMailbox * mailbox)
#line 547 "mn-mailboxes.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 74 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 74 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 74 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 74 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 563 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) mailbox);

	g_signal_emitv (___param_values,
		object_signals[MAILBOX_ADDED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 74 "mn-mailboxes.gob"
static void 
___real_mn_mailboxes_mailbox_added (MNMailboxes * self G_GNUC_UNUSED, MNMailbox * mailbox)
#line 584 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_added"
{
#line 76 "mn-mailboxes.gob"
	
    /* connect signals */
    g_object_connect(mailbox,
		     "signal::messages-changed", self_mailbox_messages_changed_h, self,
		     "signal::notify", self_mailbox_notify_h, self,
		     "signal::notify::error", self_mailbox_notify_error_h, self,
		     "signal::notify::manually-checkable", self_mailbox_notify_manually_checkable_h, self,
		     NULL);

    /* emit the "added" signal on the mailbox */
    mn_mailbox_added(mailbox);
  }}
#line 601 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 97 "mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_removed (MNMailboxes * self, MNMailbox * mailbox)
#line 607 "mn-mailboxes.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 97 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 97 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 97 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 97 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 623 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) mailbox);

	g_signal_emitv (___param_values,
		object_signals[MAILBOX_REMOVED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 97 "mn-mailboxes.gob"
static void 
___real_mn_mailboxes_mailbox_removed (MNMailboxes * self G_GNUC_UNUSED, MNMailbox * mailbox)
#line 644 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_removed"
{
#line 99 "mn-mailboxes.gob"
	
    /* disconnect signals */
    g_object_disconnect(mailbox,
			"any-signal", self_mailbox_messages_changed_h, self,
			"any-signal", self_mailbox_notify_h, self,
			"any-signal", self_mailbox_notify_error_h, self,
			"any-signal", self_mailbox_notify_manually_checkable_h, self,
			NULL);

    /* emit the "removed" signal on the mailbox */
    mn_mailbox_removed(mailbox);

    /* messages and error have possibly changed */
    self_messages_changed(self, FALSE);
    self_error_changed(self);
  }}
#line 665 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 116 "mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify (MNMailboxes * self, MNMailbox * mailbox, GParamSpec * pspec)
#line 671 "mn-mailboxes.c"
{
	GValue ___param_values[3];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 116 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 116 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 116 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 116 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 116 "mn-mailboxes.gob"
	g_return_if_fail (pspec != NULL);
#line 689 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) mailbox);

	___param_values[2].g_type = 0;
	g_value_init (&___param_values[2], G_TYPE_POINTER);
	g_value_set_pointer (&___param_values[2], (gpointer ) pspec);

	g_signal_emitv (___param_values,
		object_signals[MAILBOX_NOTIFY_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
	g_value_unset (&___param_values[2]);
}

#line 129 "mn-mailboxes.gob"
static void 
mn_mailboxes_list_changed (MNMailboxes * self)
#line 716 "mn-mailboxes.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 129 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 129 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 728 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[LIST_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 129 "mn-mailboxes.gob"
static void 
___real_mn_mailboxes_list_changed (MNMailboxes * self G_GNUC_UNUSED)
#line 744 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::list_changed"
{
#line 131 "mn-mailboxes.gob"
	
    /* manually-checkable has possibly changed */
    g_object_notify(G_OBJECT(self), "manually-checkable");
  }}
#line 753 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 150 "mn-mailboxes.gob"
static void 
mn_mailboxes_messages_changed (MNMailboxes * self, gboolean has_new)
#line 759 "mn-mailboxes.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 150 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 150 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 771 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_BOOLEAN);
	g_value_set_boolean (&___param_values[1], (gboolean ) has_new);

	g_signal_emitv (___param_values,
		object_signals[MESSAGES_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 150 "mn-mailboxes.gob"
static void 
___real_mn_mailboxes_messages_changed (MNMailboxes * self G_GNUC_UNUSED, gboolean has_new)
#line 792 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::messages_changed"
{
#line 152 "mn-mailboxes.gob"
	
    GList *la;

    mn_g_object_slist_clear(&self->messages);

    MN_LIST_FOREACH(la, self->list)
      {
	MNMailbox *mailbox = la->data;
	GSList *lb;

	MN_LIST_FOREACH(lb, mailbox->messages)
	  self->messages = g_slist_insert_sorted(self->messages, g_object_ref(lb->data), (GCompareFunc) self_messages_sort_cb);
      }
  }}
#line 811 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 167 "mn-mailboxes.gob"
static int 
mn_mailboxes_messages_sort_cb (MNMessage * a, MNMessage * b)
#line 817 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::messages_sort_cb"
{
#line 169 "mn-mailboxes.gob"
	
    /* sort by sent time in descending order */
    return b->sent_time - a->sent_time;
  }}
#line 826 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 183 "mn-mailboxes.gob"
static void 
mn_mailboxes_error_changed (MNMailboxes * self)
#line 832 "mn-mailboxes.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 183 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 183 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 844 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ERROR_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

#line 188 "mn-mailboxes.gob"
gboolean 
mn_mailboxes_get_manually_checkable (MNMailboxes * self)
#line 861 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::get_manually_checkable"
{
#line 186 "mn-mailboxes.gob"
		gboolean val; g_object_get (G_OBJECT (self), "manually_checkable", &val, NULL); return val;
}}
#line 868 "mn-mailboxes.c"
#undef __GOB_FUNCTION__


#line 261 "mn-mailboxes.gob"
static void 
___a_mn_mailboxes_finalize (GObject * object G_GNUC_UNUSED)
#line 875 "mn-mailboxes.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Mailboxes::finalize"
{
#line 263 "mn-mailboxes.gob"
	
    Self *self = SELF(object);

    if (selfp->queue_idle_source)
      mn_locked_g_source_remove(selfp->queue_idle_source);

    PARENT_HANDLER(object);
  }}
#line 891 "mn-mailboxes.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 272 "mn-mailboxes.gob"
static void 
mn_mailboxes_load (MNMailboxes * self)
#line 898 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::load"
#line 272 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 272 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 905 "mn-mailboxes.c"
{
#line 274 "mn-mailboxes.gob"
	
    GError *err = NULL;

    if (! self_load_real(self, &err))
      {
	mn_error_dialog(NULL, _("Unable to load the mailboxes configuration"), "%s", err->message);
	g_error_free(err);
      }

    if (self->must_save_after_load)
      self_save(self);
  }}
#line 920 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 287 "mn-mailboxes.gob"
static void 
mn_mailboxes_add_error (GString ** errors, int * n_errors, const char * format, ...)
#line 926 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::add_error"
#line 287 "mn-mailboxes.gob"
	g_return_if_fail (errors != NULL);
#line 287 "mn-mailboxes.gob"
	g_return_if_fail (n_errors != NULL);
#line 933 "mn-mailboxes.c"
{
#line 291 "mn-mailboxes.gob"
	
    va_list args;
    char *message;

    if (*errors)
      g_string_append_c(*errors, '\n');
    else
      *errors = g_string_new(NULL);

    va_start(args, format);
    message = g_strdup_vprintf(format, args);
    va_end(args);

    g_string_append(*errors, message);
    g_free(message);

    (*n_errors)++;
  }}
#line 954 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 310 "mn-mailboxes.gob"
static gboolean 
mn_mailboxes_load_real (MNMailboxes * self, GError ** err)
#line 960 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::load_real"
#line 310 "mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 310 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (gboolean )0);
#line 967 "mn-mailboxes.c"
{
#line 312 "mn-mailboxes.gob"
	
    char *filename;
    xmlDoc *doc;
    xmlNode *root;
    xmlNode *node;
    gboolean list_changed = FALSE;
    gboolean status = TRUE;
    GString *errors = NULL;
    int n_errors = 0;

    filename = g_build_filename(mn_conf_dot_dir, "mailboxes.xml", NULL);
    doc = xmlParseFile(filename);
    g_free(filename);

    if (! doc)
      {
	g_set_error(err, 0, 0, _("Unable to parse the XML document."));
	return FALSE;
      }

    root = xmlDocGetRootElement(doc);
    if (! root)
      {
	g_set_error(err, 0, 0, _("The root element is missing."));
	goto error;
      }

    if (strcmp(root->name, "mailboxes"))
      {
	g_set_error(err, 0, 0, _("The root element \"%s\" is invalid."), root->name);
	goto error;
      }

    for (node = root->children; node; node = node->next)
      if (node->type == XML_ELEMENT_NODE)
	{
	  if (! strcmp(node->name, "mailbox"))
	    {
	      MNMailbox *mailbox;
	      GError *tmp_err = NULL;

	      mailbox = mn_mailbox_new_from_xml_node(node, &tmp_err);
	      if (mailbox)
		{
		  mn_mailbox_seal(mailbox);
		  self_add_real(self, mailbox);
		  g_object_unref(mailbox);
		  list_changed = TRUE;
		}
	      else
		{
		  self_add_error(&errors, &n_errors, _("On line %i: %s."), node->line, tmp_err->message);
		  g_error_free(tmp_err);
		}
	    }
	  else
	    self_add_error(&errors, &n_errors, _("On line %i: unknown element \"%s\"."), node->line, node->name);
	}

    if (list_changed)
      self_list_changed(self);

    if (errors)
      {
	mn_error_dialog(NULL,
			ngettext("An error has occurred while loading the mailboxes configuration",
				 "Errors have occurred while loading the mailboxes configuration",
				 n_errors),
			"%s", errors->str);
	g_string_free(errors, TRUE);
      }

    goto end;

  error:
    status = FALSE;

  end:
    xmlFreeDoc(doc);

    return status;
  }}
#line 1052 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 395 "mn-mailboxes.gob"
static void 
mn_mailboxes_save (MNMailboxes * self)
#line 1058 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::save"
#line 395 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 395 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 1065 "mn-mailboxes.c"
{
#line 397 "mn-mailboxes.gob"
	
    GError *err = NULL;

    if (! self_save_real(self, &err))
      {
	mn_error_dialog(NULL, _("Unable to save the mailboxes configuration"), "%s", err->message);
	g_error_free(err);
      }
  }}
#line 1077 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 407 "mn-mailboxes.gob"
static gboolean 
mn_mailboxes_save_real (MNMailboxes * self, GError ** err)
#line 1083 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::save_real"
#line 407 "mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 407 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (gboolean )0);
#line 1090 "mn-mailboxes.c"
{
#line 409 "mn-mailboxes.gob"
	
    int indent;
    xmlDoc *doc;
    xmlNode *root;
    GList *l;
    char *filename;
    char *tmp_filename;
    char *old_filename;
    int fd = -1;
    FILE *f = NULL;
    gboolean old_exists;
    gboolean status = TRUE;

    indent = xmlIndentTreeOutput;
    xmlIndentTreeOutput = 1;

    doc = xmlNewDoc("1.0");
    root = xmlNewNode(NULL, "mailboxes");
    xmlDocSetRootElement(doc, root);

    MN_LIST_FOREACH(l, self->list)
      {
	MNMailbox *mailbox = l->data;
	xmlNode *node;

	if (! MN_IS_TEST_MAILBOX(mailbox))
	  {
	    node = mn_mailbox_xml_node_new(mailbox);
	    xmlAddChild(root, node); /* owns node */
	  }
      }

    filename = g_build_filename(mn_conf_dot_dir, "mailboxes.xml", NULL);
    tmp_filename = g_strconcat(filename, ".tmp", NULL);
    old_filename = g_strconcat(filename, ".old", NULL);

    if (g_file_test(tmp_filename, G_FILE_TEST_EXISTS) && unlink(tmp_filename) < 0)
      {
	g_set_error(err, 0, 0, _("Unable to remove %s: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }

    /* the file may contain passwords; restrict permissions (600) */
    fd = open(tmp_filename, O_WRONLY | O_CREAT | O_EXCL, S_IRUSR | S_IWUSR);
    if (fd < 0)
      {
	g_set_error(err, 0, 0, _("Unable to create %s: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }

    f = fdopen(fd, "w");
    if (! f)
      {
	g_set_error(err, 0, 0, _("Unable to open %s for writing: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }
    fd = -1;			/* now owned by f */

    if (xmlDocFormatDump(f, doc, 1) < 0)
      {
	g_set_error(err, 0, 0, _("Unable to write the XML document."));
	goto error;
      }

    if (fclose(f) != 0)
      {
	g_set_error(err, 0, 0, _("Unable to close %s: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }
    f = NULL;

    old_exists = g_file_test(filename, G_FILE_TEST_EXISTS);
    if (old_exists)
      {
	if (rename(filename, old_filename) < 0)
	  {
	    g_set_error(err, 0, 0, _("Unable to rename %s to %s: %s."), filename, old_filename, g_strerror(errno));
	    goto error;
	  }
      }

    if (rename(tmp_filename, filename) < 0)
      {
	g_set_error(err, 0, 0, _("Unable to rename %s to %s: %s."), tmp_filename, filename, g_strerror(errno));
	goto error;
      }

    if (old_exists)
      if (unlink(old_filename) < 0) /* non fatal */
	g_warning(_("unable to delete %s: %s"), old_filename, g_strerror(errno));

    goto end;			/* success */

  error:
    status = FALSE;

  end:
    xmlFreeDoc(doc);
    xmlIndentTreeOutput = indent;

    g_free(filename);
    g_free(tmp_filename);
    g_free(old_filename);

    if (fd >= 0)
      close(fd);
    if (f)
      fclose(f);

    return status;
  }}
#line 1204 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 521 "mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_messages_changed_h (MNMailbox * mailbox, gboolean has_new, gpointer user_data)
#line 1210 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_messages_changed_h"
{
#line 525 "mn-mailboxes.gob"
	
    Self *self = user_data;

    mn_info(ngettext("%s has %i new message", "%s has %i new messages", mailbox->n_messages),
	    mailbox->runtime_name, mailbox->n_messages);

    self_messages_changed(self, has_new);
  }}
#line 1223 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 534 "mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 1229 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_notify_h"
{
#line 536 "mn-mailboxes.gob"
	
    Self *self = user_data;
    char *detailed_signal;

    detailed_signal = g_strconcat("mailbox-notify::", g_param_spec_get_name(pspec), NULL);
    g_signal_emit_by_name(self, detailed_signal, object, pspec);
    g_free(detailed_signal);
  }}
#line 1242 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 545 "mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify_error_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 1248 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_notify_error_h"
{
#line 549 "mn-mailboxes.gob"
	
    Self *self = user_data;
    MNMailbox *mailbox = MN_MAILBOX(object);

    if (mailbox->error)
      mn_info(_("%s reported an error: %s"), mailbox->runtime_name, mailbox->error);

    self_error_changed(self);
  }}
#line 1262 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 559 "mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify_manually_checkable_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 1268 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_notify_manually_checkable_h"
{
#line 563 "mn-mailboxes.gob"
	
    Self *self = user_data;

    /* manually-checkable has possibly changed */
    g_object_notify(G_OBJECT(self), "manually-checkable");
  }}
#line 1279 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 570 "mn-mailboxes.gob"
void 
mn_mailboxes_check (MNMailboxes * self)
#line 1285 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::check"
#line 570 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 570 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 1292 "mn-mailboxes.c"
{
#line 572 "mn-mailboxes.gob"
	
    GList *l;

    MN_LIST_FOREACH(l, self->list)
      {
	MNMailbox *mailbox = l->data;

	if (mn_mailbox_get_manually_checkable(mailbox))
	  mn_mailbox_check(mailbox);
      }
  }}
#line 1306 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 584 "mn-mailboxes.gob"
static void 
mn_mailboxes_add_real (MNMailboxes * self, MNMailbox * mailbox)
#line 1312 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::add_real"
#line 584 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 584 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 584 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 584 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1323 "mn-mailboxes.c"
{
#line 586 "mn-mailboxes.gob"
	
    g_object_ref(mailbox);
    self->list = g_list_insert_sorted(self->list, mailbox, self_compare_by_name_func);
    self_mailbox_added(self, mailbox);
  }}
#line 1331 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 592 "mn-mailboxes.gob"
void 
mn_mailboxes_add (MNMailboxes * self, MNMailbox * mailbox)
#line 1337 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::add"
#line 592 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 592 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 592 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 592 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1348 "mn-mailboxes.c"
{
#line 594 "mn-mailboxes.gob"
	
    self_add_real(self, mailbox);
    self_list_changed(self);

    if (! MN_IS_TEST_MAILBOX(mailbox))
      self_save(self);
  }}
#line 1358 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 602 "mn-mailboxes.gob"
void 
mn_mailboxes_queue_add (MNMailboxes * self, MNMailbox * mailbox)
#line 1364 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::queue_add"
#line 602 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 602 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 602 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 602 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1375 "mn-mailboxes.c"
{
#line 604 "mn-mailboxes.gob"
	
    g_object_ref(mailbox);
    selfp->add_queue = g_slist_append(selfp->add_queue, mailbox);

    if (! selfp->queue_idle_source)
      selfp->queue_idle_source = mn_g_idle_add_gdk_locked(self_queue_idle_cb, self);
  }}
#line 1385 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 612 "mn-mailboxes.gob"
static void 
mn_mailboxes_remove_real (MNMailboxes * self, MNMailbox * mailbox)
#line 1391 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::remove_real"
#line 612 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 612 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 612 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 612 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1402 "mn-mailboxes.c"
{
#line 614 "mn-mailboxes.gob"
	
    self->list = g_list_remove(self->list, mailbox);
    self_mailbox_removed(self, mailbox);
    g_object_unref(mailbox);
  }}
#line 1410 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 620 "mn-mailboxes.gob"
void 
mn_mailboxes_remove (MNMailboxes * self, MNMailbox * mailbox)
#line 1416 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::remove"
#line 620 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 620 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 620 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 620 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1427 "mn-mailboxes.c"
{
#line 622 "mn-mailboxes.gob"
	
    self_remove_real(self, mailbox);
    self_list_changed(self);
    if (! MN_IS_TEST_MAILBOX(mailbox))
      self_save(self);
  }}
#line 1436 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 629 "mn-mailboxes.gob"
void 
mn_mailboxes_queue_remove (MNMailboxes * self, MNMailbox * mailbox)
#line 1442 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::queue_remove"
#line 629 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 629 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 629 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 629 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1453 "mn-mailboxes.c"
{
#line 631 "mn-mailboxes.gob"
	
    g_object_ref(mailbox);
    selfp->remove_queue = g_slist_append(selfp->remove_queue, mailbox);

    if (! selfp->queue_idle_source)
      selfp->queue_idle_source = mn_g_idle_add_gdk_locked(self_queue_idle_cb, self);
  }}
#line 1463 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 639 "mn-mailboxes.gob"
static gboolean 
mn_mailboxes_queue_idle_cb (gpointer data)
#line 1469 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::queue_idle_cb"
{
#line 641 "mn-mailboxes.gob"
	
    Self *self = data;
    GSList *l;

    MN_LIST_FOREACH(l, selfp->add_queue)
      self_add_real(self, l->data);

    mn_g_object_slist_clear(&selfp->add_queue);

    MN_LIST_FOREACH(l, selfp->remove_queue)
      self_remove_real(self, l->data);

    mn_g_object_slist_clear(&selfp->remove_queue);

    self_list_changed(self);
    self_save(self);

    selfp->queue_idle_source = NULL;
    return FALSE;		/* remove */
  }}
#line 1494 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 662 "mn-mailboxes.gob"
int 
mn_mailboxes_compare_by_name_func (gconstpointer a, gconstpointer b)
#line 1500 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::compare_by_name_func"
{
#line 664 "mn-mailboxes.gob"
	
    MNMailbox *mailbox_a = (MNMailbox *) a;
    MNMailbox *mailbox_b = (MNMailbox *) b;

    return g_utf8_collate(mailbox_a->runtime_name, mailbox_b->runtime_name);
  }}
#line 1511 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 671 "mn-mailboxes.gob"
MNMailboxes * 
mn_mailboxes_new (void)
#line 1517 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::new"
{
#line 673 "mn-mailboxes.gob"
	
    return GET_NEW;
  }}
#line 1525 "mn-mailboxes.c"
#undef __GOB_FUNCTION__
