/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-maildir-message.h"

#include "mn-maildir-message-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "mn-maildir-message.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-vfs-mailbox.h"
#include "mn-vfs.h"
#include "mn-util.h"

#line 35 "mn-maildir-message.c"
/* self casting macros */
#define SELF(x) MN_MAILDIR_MESSAGE(x)
#define SELF_CONST(x) MN_MAILDIR_MESSAGE_CONST(x)
#define IS_SELF(x) MN_IS_MAILDIR_MESSAGE(x)
#define TYPE_SELF MN_TYPE_MAILDIR_MESSAGE
#define SELF_CLASS(x) MN_MAILDIR_MESSAGE_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILDIR_MESSAGE_GET_CLASS(x)

/* self typedefs */
typedef MNMaildirMessage Self;
typedef MNMaildirMessageClass SelfClass;

/* here are local prototypes */
static void mn_maildir_message_init (MNMaildirMessage * o) G_GNUC_UNUSED;
static void mn_maildir_message_class_init (MNMaildirMessageClass * c) G_GNUC_UNUSED;
static int mn_maildir_message_flags_sort_cb (const void * a, const void * b) G_GNUC_UNUSED;
static gboolean ___2_mn_maildir_message_mark_as_read_impl (MNMessage * message, GError ** err) G_GNUC_UNUSED;
static GnomeVFSURI * mn_maildir_message_get_trash_uri (MNMaildirMessage * self) G_GNUC_UNUSED;
static gboolean mn_maildir_message_delete_with_prompt (MNMaildirMessage * self, GError ** err, const char * format, ...) G_GNUC_UNUSED;
static gboolean ___5_mn_maildir_message_delete_impl (MNMessage * message, GError ** err) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNVFSMessageClass *parent_class = NULL;

/* Short form macros */
#define self_flags_sort_cb mn_maildir_message_flags_sort_cb
#define self_get_trash_uri mn_maildir_message_get_trash_uri
#define self_delete_with_prompt mn_maildir_message_delete_with_prompt
GType
mn_maildir_message_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMaildirMessageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_maildir_message_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMaildirMessage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_maildir_message_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MESSAGE, "MNMaildirMessage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMaildirMessage *)g_object_new(mn_maildir_message_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMaildirMessage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMaildirMessage *
GET_NEW_VARG (const char *first, ...)
{
	MNMaildirMessage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMaildirMessage *)g_object_new_valist (mn_maildir_message_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::dispose"
	MNMaildirMessage *self G_GNUC_UNUSED = MN_MAILDIR_MESSAGE (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#define delete_dialog (self->_priv->delete_dialog)
#define VAR delete_dialog
	{
#line 41 "mn-maildir-message.gob"
	
    if (VAR != NULL)
      gtk_dialog_response(GTK_DIALOG(VAR), GTK_RESPONSE_CANCEL);
  }
#line 123 "mn-maildir-message.c"
	memset(&delete_dialog, 0, sizeof(delete_dialog));
#undef VAR
#undef delete_dialog
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::finalize"
	MNMaildirMessage *self G_GNUC_UNUSED = MN_MAILDIR_MESSAGE (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
mn_maildir_message_init (MNMaildirMessage * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_MAILDIR_MESSAGE,MNMaildirMessagePrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_maildir_message_class_init (MNMaildirMessageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	MNMessageClass *mn_message_class = (MNMessageClass *)c;

	g_type_class_add_private(c,sizeof(MNMaildirMessagePrivate));

	parent_class = g_type_class_ref (MN_TYPE_VFS_MESSAGE);

#line 57 "mn-maildir-message.gob"
	mn_message_class->mark_as_read_impl = ___2_mn_maildir_message_mark_as_read_impl;
#line 190 "mn-maildir-message.gob"
	mn_message_class->delete_impl = ___5_mn_maildir_message_delete_impl;
#line 164 "mn-maildir-message.c"
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 46 "mn-maildir-message.gob"
static int 
mn_maildir_message_flags_sort_cb (const void * a, const void * b)
#line 175 "mn-maildir-message.c"
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::flags_sort_cb"
{
#line 48 "mn-maildir-message.gob"
	
    char ca = *((char *) a);
    char cb = *((char *) b);

    /* sort flags using ASCII order, see http://cr.yp.to/proto/maildir.html */

    return ca - cb;
  }}
#line 188 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 57 "mn-maildir-message.gob"
static gboolean 
___2_mn_maildir_message_mark_as_read_impl (MNMessage * message G_GNUC_UNUSED, GError ** err)
#line 194 "mn-maildir-message.c"
#define PARENT_HANDLER(___message,___err) \
	((MN_MESSAGE_CLASS(parent_class)->mark_as_read_impl)? \
		(* MN_MESSAGE_CLASS(parent_class)->mark_as_read_impl)(___message,___err): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::mark_as_read_impl"
{
#line 59 "mn-maildir-message.gob"
	
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(message);
    char *old_flags;
    char *old_filename;
    char *new_filename;
    GnomeVFSURI *dir_uri;
    GnomeVFSURI *new_uri;
    gboolean status;

    /* http://cr.yp.to/proto/maildir.html */

    old_filename = gnome_vfs_uri_extract_short_name(vmessage->vfs_uri);

    old_flags = strrchr(old_filename, ',');
    if (old_flags)
      {
	char *new_flags;
	int old_len;
	char *base_filename;

	/* append the S (seen) flag */

	old_flags++;
	g_assert(strchr(old_flags, 'S') == NULL);

	old_len = strlen(old_flags);
	new_flags = g_new(char, old_len + 2); /* + space for S and nul */
	memcpy(new_flags, old_flags, old_len);
	new_flags[old_len] = 'S';
	new_flags[old_len + 1] = 0;
	qsort(new_flags, old_len + 1, sizeof(char), self_flags_sort_cb);

	base_filename = g_strndup(old_filename, old_flags - old_filename - 1);
	new_filename = g_strdup_printf("%s,%s", base_filename, new_flags);
	g_free(base_filename);
	g_free(new_flags);
      }
    else
      new_filename = g_strconcat(old_filename, ":2,S", NULL);

    g_free(old_filename);

    dir_uri = gnome_vfs_uri_append_path(MN_VFS_MAILBOX(MN_MESSAGE(message)->mailbox)->vfs_uri, "cur");
    new_uri = gnome_vfs_uri_append_file_name(dir_uri, new_filename);
    gnome_vfs_uri_unref(dir_uri);
    g_free(new_filename);

    status = mn_vfs_result_to_g_error(gnome_vfs_move_uri(vmessage->vfs_uri, new_uri, TRUE), err);
    gnome_vfs_uri_unref(new_uri);

    return status;
  }}
#line 255 "mn-maildir-message.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 113 "mn-maildir-message.gob"
static GnomeVFSURI * 
mn_maildir_message_get_trash_uri (MNMaildirMessage * self)
#line 262 "mn-maildir-message.c"
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::get_trash_uri"
#line 113 "mn-maildir-message.gob"
	g_return_val_if_fail (self != NULL, (GnomeVFSURI * )0);
#line 113 "mn-maildir-message.gob"
	g_return_val_if_fail (MN_IS_MAILDIR_MESSAGE (self), (GnomeVFSURI * )0);
#line 269 "mn-maildir-message.c"
{
#line 115 "mn-maildir-message.gob"
	
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(self);
    GnomeVFSURI *trash_uri;

    /*
     * Do what is advised in the gnome_vfs_find_directory()
     * documentation: first pass find_if_needed, then create_if_needed.
     */

    if (gnome_vfs_find_directory(vmessage->vfs_uri,
				 GNOME_VFS_DIRECTORY_KIND_TRASH,
				 &trash_uri,
				 FALSE,
				 TRUE,
				 0) == GNOME_VFS_OK)
      return trash_uri;

    if (gnome_vfs_find_directory(vmessage->vfs_uri,
				 GNOME_VFS_DIRECTORY_KIND_TRASH,
				 &trash_uri,
				 TRUE,
				 FALSE,
				 S_IRUSR | S_IWUSR | S_IXUSR) == GNOME_VFS_OK)
      return trash_uri;

    return NULL;
  }}
#line 299 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 144 "mn-maildir-message.gob"
static gboolean 
mn_maildir_message_delete_with_prompt (MNMaildirMessage * self, GError ** err, const char * format, ...)
#line 305 "mn-maildir-message.c"
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::delete_with_prompt"
#line 144 "mn-maildir-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 144 "mn-maildir-message.gob"
	g_return_val_if_fail (MN_IS_MAILDIR_MESSAGE (self), (gboolean )0);
#line 312 "mn-maildir-message.c"
{
#line 146 "mn-maildir-message.gob"
	
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(self);
    GtkWidget *dialog;
    va_list args;
    char *prompt;
    gboolean status;

    g_assert(selfp->delete_dialog == NULL);

    va_start(args, format);
    prompt = g_strdup_vprintf(format, args);
    va_end(args);

    selfp->delete_dialog = dialog = mn_alert_dialog_new(NULL,
							GTK_MESSAGE_WARNING,
							0,
							_("Delete message?"),
							prompt);
    g_free(prompt);

    eel_add_weak_pointer(&dialog);
    eel_add_weak_pointer(&selfp->delete_dialog);

    gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
    gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_DELETE, GTK_RESPONSE_OK);

    status = mn_dialog_run_nonmodal(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK;

    /*
     * At this point @self is no longer valid since it might have been
     * finalized while the recursive main loop ran in
     * mn_dialog_run_nonmodal().
     */

    /* can have been nullified by the weak pointer set above */
    if (dialog != NULL)
      gtk_widget_destroy(dialog);

    if (! status)
      return FALSE;

    return mn_vfs_result_to_g_error(gnome_vfs_unlink_from_uri(vmessage->vfs_uri), err);
  }}
#line 358 "mn-maildir-message.c"
#undef __GOB_FUNCTION__

#line 190 "mn-maildir-message.gob"
static gboolean 
___5_mn_maildir_message_delete_impl (MNMessage * message G_GNUC_UNUSED, GError ** err)
#line 364 "mn-maildir-message.c"
#define PARENT_HANDLER(___message,___err) \
	((MN_MESSAGE_CLASS(parent_class)->delete_impl)? \
		(* MN_MESSAGE_CLASS(parent_class)->delete_impl)(___message,___err): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Maildir:Message::delete_impl"
{
#line 192 "mn-maildir-message.gob"
	
    Self *self = SELF(message);
    MNVFSMessage *vmessage = MN_VFS_MESSAGE(message);
    GnomeVFSURI *trash_uri;
    char *filename;
    GnomeVFSURI *dest_uri;
    GnomeVFSResult result;

    trash_uri = self_get_trash_uri(self);
    if (trash_uri == NULL)
      return self_delete_with_prompt(self, err, _("The message cannot be moved to the trash. Permanently delete it?"));

    filename = gnome_vfs_uri_extract_short_name(vmessage->vfs_uri);
    dest_uri = gnome_vfs_uri_append_file_name(trash_uri, filename);
    gnome_vfs_uri_unref(trash_uri);
    g_free(filename);

    /*
     * Use gnome_vfs_xfer_uri() rather than gnome_vfs_move_uri(), in
     * case the trash resides on a different file system than the
     * message.
     */
    result = gnome_vfs_xfer_uri(vmessage->vfs_uri,
				dest_uri,
				GNOME_VFS_XFER_REMOVESOURCE
				| GNOME_VFS_XFER_FOLLOW_LINKS,
				GNOME_VFS_XFER_ERROR_MODE_ABORT,
				GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE,
				NULL,
				NULL);
    gnome_vfs_uri_unref(dest_uri);

    if (result != GNOME_VFS_OK)
      return self_delete_with_prompt(self, err, _("The message could not be moved to the trash (%s). Permanently delete it?"), gnome_vfs_result_to_string(result));

    return TRUE;
  }}
#line 410 "mn-maildir-message.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
