/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-message.h"

#include "mn-message-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 44 "mn-message.gob"

#include "config.h"
#include <errno.h>
#include <glib/gi18n.h>
#include <gnome.h>
#include <libgnomevfs/gnome-vfs.h>
#include "mn-util.h"

#line 35 "mn-message.c"
/* self casting macros */
#define SELF(x) MN_MESSAGE(x)
#define SELF_CONST(x) MN_MESSAGE_CONST(x)
#define IS_SELF(x) MN_IS_MESSAGE(x)
#define TYPE_SELF MN_TYPE_MESSAGE
#define SELF_CLASS(x) MN_MESSAGE_CLASS(x)

#define SELF_GET_CLASS(x) MN_MESSAGE_GET_CLASS(x)

/* self typedefs */
typedef MNMessage Self;
typedef MNMessageClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_message_init (MNMessage * o) G_GNUC_UNUSED;
static void mn_message_class_init (MNMessageClass * c) G_GNUC_UNUSED;
static GObject * ___1_mn_message_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean mn_message_subst_command_cb (const char * name, char ** value, gpointer data) G_GNUC_UNUSED;
static gboolean mn_message_execute_command_real (MNMessage * self, const char * command, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_execute_command (MNMessage * self, const char * id, gboolean * status, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_open_impl (MNMessage * self);
static gboolean mn_message_can_open_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean ___real_mn_message_open_impl (MNMessage * self, GError ** err);
static gboolean mn_message_open_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_mark_as_read_impl (MNMessage * self);
static gboolean mn_message_can_mark_as_read_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_read_real (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_read_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_mark_as_spam (MNMessage * self);
static gboolean ___real_mn_message_can_mark_as_spam_impl (MNMessage * self);
static gboolean mn_message_can_mark_as_spam_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_spam_real (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_mark_as_spam_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean ___real_mn_message_can_delete (MNMessage * self);
static gboolean ___real_mn_message_can_delete_impl (MNMessage * self);
static gboolean mn_message_can_delete_impl (MNMessage * self) G_GNUC_UNUSED;
static gboolean mn_message_delete_real (MNMessage * self, GError ** err) G_GNUC_UNUSED;
static gboolean mn_message_delete_impl (MNMessage * self, GError ** err) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_MAILBOX,
	PROP_ERROR,
	PROP_SENT_TIME,
	PROP_ID,
	PROP_FROM,
	PROP_SUBJECT,
	PROP_URI,
	PROP_FILENAME,
	PROP_FLAGS
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_subst_command_cb mn_message_subst_command_cb
#define self_execute_command_real mn_message_execute_command_real
#define self_execute_command mn_message_execute_command
#define self_can_open mn_message_can_open
#define self_can_open_impl mn_message_can_open_impl
#define self_open mn_message_open
#define self_open_impl mn_message_open_impl
#define self_can_mark_as_read mn_message_can_mark_as_read
#define self_can_mark_as_read_impl mn_message_can_mark_as_read_impl
#define self_mark_as_read_real mn_message_mark_as_read_real
#define self_mark_as_read mn_message_mark_as_read
#define self_mark_as_read_impl mn_message_mark_as_read_impl
#define self_can_mark_as_spam mn_message_can_mark_as_spam
#define self_can_mark_as_spam_impl mn_message_can_mark_as_spam_impl
#define self_mark_as_spam_real mn_message_mark_as_spam_real
#define self_mark_as_spam mn_message_mark_as_spam
#define self_mark_as_spam_impl mn_message_mark_as_spam_impl
#define self_can_delete mn_message_can_delete
#define self_can_delete_impl mn_message_can_delete_impl
#define self_delete_real mn_message_delete_real
#define self_delete mn_message_delete
#define self_delete_impl mn_message_delete_impl
#define self_new mn_message_new
#define self_new_from_error mn_message_new_from_error
#define self_xml_node_new mn_message_xml_node_new
GType
mn_message_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMessageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_message_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMessage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_message_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMessage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMessage *)g_object_new(mn_message_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMessage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMessage *
GET_NEW_VARG (const char *first, ...)
{
	MNMessage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMessage *)g_object_new_valist (mn_message_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message::finalize"
	MNMessage *self G_GNUC_UNUSED = MN_MESSAGE (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 66 "mn-message.gob"
	if(self->error) { g_free ((gpointer) self->error); self->error = NULL; }
#line 171 "mn-message.c"
#line 74 "mn-message.gob"
	if(self->id) { g_free ((gpointer) self->id); self->id = NULL; }
#line 174 "mn-message.c"
#line 78 "mn-message.gob"
	if(self->from) { g_free ((gpointer) self->from); self->from = NULL; }
#line 177 "mn-message.c"
#line 82 "mn-message.gob"
	if(self->subject) { g_free ((gpointer) self->subject); self->subject = NULL; }
#line 180 "mn-message.c"
#line 86 "mn-message.gob"
	if(self->uri) { g_free ((gpointer) self->uri); self->uri = NULL; }
#line 183 "mn-message.c"
}
#undef __GOB_FUNCTION__

static void 
mn_message_init (MNMessage * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message::init"
}
#undef __GOB_FUNCTION__
static void 
mn_message_class_init (MNMessageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 98 "mn-message.gob"
	g_object_class->constructor = ___1_mn_message_constructor;
#line 234 "mn-message.gob"
	c->can_open_impl = ___real_mn_message_can_open_impl;
#line 254 "mn-message.gob"
	c->open_impl = ___real_mn_message_open_impl;
#line 266 "mn-message.gob"
	c->can_mark_as_read_impl = ___real_mn_message_can_mark_as_read_impl;
#line 209 "mn-message.c"
	c->mark_as_read_impl = NULL;
#line 298 "mn-message.gob"
	c->can_mark_as_spam = ___real_mn_message_can_mark_as_spam;
#line 304 "mn-message.gob"
	c->can_mark_as_spam_impl = ___real_mn_message_can_mark_as_spam_impl;
#line 215 "mn-message.c"
	c->mark_as_spam_impl = NULL;
#line 336 "mn-message.gob"
	c->can_delete = ___real_mn_message_can_delete;
#line 342 "mn-message.gob"
	c->can_delete_impl = ___real_mn_message_can_delete_impl;
#line 221 "mn-message.c"
	c->delete_impl = NULL;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("mailbox" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MAILBOX,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
	param_spec = g_param_spec_ulong
		("sent_time" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXULONG /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SENT_TIME,
		param_spec);
	param_spec = g_param_spec_string
		("id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_ID,
		param_spec);
	param_spec = g_param_spec_string
		("from" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_FROM,
		param_spec);
	param_spec = g_param_spec_string
		("subject" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SUBJECT,
		param_spec);
	param_spec = g_param_spec_string
		("uri" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_URI,
		param_spec);
	param_spec = g_param_spec_string
		("filename" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | MN_MESSAGE_PARAM_EXPORT));
	g_object_class_install_property (g_object_class,
		PROP_FILENAME,
		param_spec);
	param_spec = g_param_spec_uint
		("flags" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXUINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_FLAGS,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message::set_property"
{
	MNMessage *self G_GNUC_UNUSED;

	self = MN_MESSAGE (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 63 "mn-message.gob"
self->mailbox = g_value_get_pointer (VAL);
#line 333 "mn-message.c"
		}
		break;
	case PROP_ERROR:
		{
#line 67 "mn-message.gob"
{ char *old = self->error; self->error = g_value_dup_string (VAL); g_free (old); }
#line 340 "mn-message.c"
		}
		break;
	case PROP_SENT_TIME:
		{
#line 71 "mn-message.gob"
self->sent_time = g_value_get_ulong (VAL);
#line 347 "mn-message.c"
		}
		break;
	case PROP_ID:
		{
#line 75 "mn-message.gob"
{ char *old = self->id; self->id = g_value_dup_string (VAL); g_free (old); }
#line 354 "mn-message.c"
		}
		break;
	case PROP_FROM:
		{
#line 79 "mn-message.gob"
{ char *old = self->from; self->from = g_value_dup_string (VAL); g_free (old); }
#line 361 "mn-message.c"
		}
		break;
	case PROP_SUBJECT:
		{
#line 83 "mn-message.gob"
{ char *old = self->subject; self->subject = g_value_dup_string (VAL); g_free (old); }
#line 368 "mn-message.c"
		}
		break;
	case PROP_URI:
		{
#line 87 "mn-message.gob"
{ char *old = self->uri; self->uri = g_value_dup_string (VAL); g_free (old); }
#line 375 "mn-message.c"
		}
		break;
	case PROP_FLAGS:
		{
#line 96 "mn-message.gob"
self->flags = g_value_get_uint (VAL);
#line 382 "mn-message.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message::get_property"
{
	MNMessage *self G_GNUC_UNUSED;

	self = MN_MESSAGE (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 63 "mn-message.gob"
g_value_set_pointer (VAL, self->mailbox);
#line 413 "mn-message.c"
		}
		break;
	case PROP_ERROR:
		{
#line 67 "mn-message.gob"
g_value_set_string (VAL, self->error);
#line 420 "mn-message.c"
		}
		break;
	case PROP_SENT_TIME:
		{
#line 71 "mn-message.gob"
g_value_set_ulong (VAL, self->sent_time);
#line 427 "mn-message.c"
		}
		break;
	case PROP_ID:
		{
#line 75 "mn-message.gob"
g_value_set_string (VAL, self->id);
#line 434 "mn-message.c"
		}
		break;
	case PROP_FROM:
		{
#line 79 "mn-message.gob"
g_value_set_string (VAL, self->from);
#line 441 "mn-message.c"
		}
		break;
	case PROP_SUBJECT:
		{
#line 83 "mn-message.gob"
g_value_set_string (VAL, self->subject);
#line 448 "mn-message.c"
		}
		break;
	case PROP_URI:
		{
#line 87 "mn-message.gob"
g_value_set_string (VAL, self->uri);
#line 455 "mn-message.c"
		}
		break;
	case PROP_FILENAME:
		{
#line 91 "mn-message.gob"

      g_value_take_string(VAL, self->uri ? gnome_vfs_get_local_path_from_uri(self->uri) : NULL);
    
#line 464 "mn-message.c"
		}
		break;
	case PROP_FLAGS:
		{
#line 96 "mn-message.gob"
g_value_set_uint (VAL, self->flags);
#line 471 "mn-message.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 98 "mn-message.gob"
static GObject * 
___1_mn_message_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 491 "mn-message.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Message::constructor"
{
#line 100 "mn-message.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    g_assert(MN_IS_MAILBOX(self->mailbox));

    if (! self->id)
      {
	GString *id;

	/*
	 * An ID should (not mandatory):
	 *
	 *	- be unique (application-wise, because we use the ID
	 *	  to check if a message has already been displayed in
	 *	  the mail summary popup)
	 *	- persist across checks if the message does not change
	 */

	id = g_string_new(NULL);

	if (self->sent_time > 0)
	  g_string_append_printf(id, ":sent-time:%i:", (int) self->sent_time);
	if (self->from)
	  g_string_append_printf(id, ":from:%s:", self->from);
	if (self->subject)
	  g_string_append_printf(id, ":subject:%s:", self->subject);

	if (! *id->str)
	  {
	    static int unique = 0;
	    g_string_append_printf(id, "%i", g_atomic_int_exchange_and_add(&unique, 1));
	  }

	self->id = g_string_free(id, FALSE);
      }

    /* these must be filled after we have processed the id */

    if (! self->from)
      self->from = g_strdup(_("Unknown"));
    if (! self->subject)
      self->subject = g_strdup("");

    return object;
  }}
#line 549 "mn-message.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 150 "mn-message.gob"
static gboolean 
mn_message_subst_command_cb (const char * name, char ** value, gpointer data)
#line 556 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::subst_command_cb"
{
#line 152 "mn-message.gob"
	
    Self *self = data;
    GParamSpec **properties;
    unsigned int n_properties;
    gboolean status = FALSE;
    int i;

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MESSAGE_PARAM_EXPORT) != 0
	  && ! strcmp(g_param_spec_get_name(properties[i]), name))
	{
	  GValue gvalue = { 0, };

	  g_value_init(&gvalue, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(G_OBJECT(self), name, &gvalue);

	  *value = mn_g_value_to_string(&gvalue);
	  g_value_unset(&gvalue);

	  status = TRUE;
	  break;
	}
    g_free(properties);

    return status;
  }}
#line 588 "mn-message.c"
#undef __GOB_FUNCTION__

#line 180 "mn-message.gob"
static gboolean 
mn_message_execute_command_real (MNMessage * self, const char * command, GError ** err)
#line 594 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::execute_command_real"
#line 180 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 180 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 180 "mn-message.gob"
	g_return_val_if_fail (command != NULL, (gboolean )0);
#line 603 "mn-message.c"
{
#line 184 "mn-message.gob"
	
    char *subst;
    int status;

    subst = mn_subst_command(command, self_subst_command_cb, self, err);
    if (! subst)
      return FALSE;

    status = gnome_execute_shell(NULL, subst);
    g_free(subst);

    if (status < 0)
      {
	g_set_error(err, 0, 0, "%s", g_strerror(errno));
	return FALSE;
      }

    return TRUE;
  }}
#line 625 "mn-message.c"
#undef __GOB_FUNCTION__

#line 204 "mn-message.gob"
static gboolean 
mn_message_execute_command (MNMessage * self, const char * id, gboolean * status, GError ** err)
#line 631 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::execute_command"
#line 204 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 204 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 204 "mn-message.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 204 "mn-message.gob"
	g_return_val_if_fail (status != NULL, (gboolean )0);
#line 642 "mn-message.c"
{
#line 209 "mn-message.gob"
	
    char *command;
    GError *tmp_err = NULL;

    command = mn_mailbox_get_command(self->mailbox, id);
    if (! command)
      return FALSE;

    *status = self_execute_command_real(self, command, &tmp_err);
    if (! *status)
      {
	g_set_error(err, 0, 0, _("Unable to execute \"%s\": %s."), command, tmp_err->message);
	g_error_free(tmp_err);
      }

    g_free(command);
    return TRUE;
  }}
#line 663 "mn-message.c"
#undef __GOB_FUNCTION__

#line 228 "mn-message.gob"
gboolean 
mn_message_can_open (MNMessage * self)
#line 669 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_open"
#line 228 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 228 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 676 "mn-message.c"
{
#line 230 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "open") || self_can_open_impl(self);
  }}
#line 682 "mn-message.c"
#undef __GOB_FUNCTION__

#line 234 "mn-message.gob"
static gboolean 
mn_message_can_open_impl (MNMessage * self)
#line 688 "mn-message.c"
{
	MNMessageClass *klass;
#line 234 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 234 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 695 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_open_impl)
		return (*klass->can_open_impl)(self);
	else
		return (gboolean )(0);
}
#line 234 "mn-message.gob"
static gboolean 
___real_mn_message_can_open_impl (MNMessage * self G_GNUC_UNUSED)
#line 706 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_open_impl"
{
#line 236 "mn-message.gob"
	
    return self->uri != NULL;
  }}
#line 714 "mn-message.c"
#undef __GOB_FUNCTION__

#line 240 "mn-message.gob"
gboolean 
mn_message_open (MNMessage * self, GError ** err)
#line 720 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::open"
#line 240 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 240 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 727 "mn-message.c"
{
#line 242 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "open", &status, err))
      {
	mn_mailbox_consider_as_read(self);
	return status;
      }
    else
      return self_open_impl(self, err);
  }}
#line 741 "mn-message.c"
#undef __GOB_FUNCTION__

#line 254 "mn-message.gob"
static gboolean 
mn_message_open_impl (MNMessage * self, GError ** err)
#line 747 "mn-message.c"
{
	MNMessageClass *klass;
#line 254 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 254 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 754 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->open_impl)
		return (*klass->open_impl)(self,err);
	else
		return (gboolean )(0);
}
#line 254 "mn-message.gob"
static gboolean 
___real_mn_message_open_impl (MNMessage * self G_GNUC_UNUSED, GError ** err)
#line 765 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::open_impl"
{
#line 256 "mn-message.gob"
	
    return gnome_url_show(self->uri, err);
  }}
#line 773 "mn-message.c"
#undef __GOB_FUNCTION__

#line 260 "mn-message.gob"
gboolean 
mn_message_can_mark_as_read (MNMessage * self)
#line 779 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_read"
#line 260 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 260 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 786 "mn-message.c"
{
#line 262 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "mark-as-read") || self_can_mark_as_read_impl(self);
  }}
#line 792 "mn-message.c"
#undef __GOB_FUNCTION__

#line 266 "mn-message.gob"
static gboolean 
mn_message_can_mark_as_read_impl (MNMessage * self)
#line 798 "mn-message.c"
{
	MNMessageClass *klass;
#line 266 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 266 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 805 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_mark_as_read_impl)
		return (*klass->can_mark_as_read_impl)(self);
	else
		return (gboolean )(0);
}
#line 266 "mn-message.gob"
static gboolean 
___real_mn_message_can_mark_as_read_impl (MNMessage * self G_GNUC_UNUSED)
#line 816 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_read_impl"
{
#line 268 "mn-message.gob"
	
    return SELF_GET_CLASS(self)->mark_as_read_impl != NULL;
  }}
#line 824 "mn-message.c"
#undef __GOB_FUNCTION__

#line 272 "mn-message.gob"
static gboolean 
mn_message_mark_as_read_real (MNMessage * self, GError ** err)
#line 830 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_read_real"
#line 272 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 272 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 837 "mn-message.c"
{
#line 274 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "mark-as-read", &status, err))
      return status;
    else
      return self_mark_as_read_impl(self, err);
  }}
#line 848 "mn-message.c"
#undef __GOB_FUNCTION__

#line 283 "mn-message.gob"
gboolean 
mn_message_mark_as_read (MNMessage * self, GError ** err)
#line 854 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_read"
#line 283 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 283 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 861 "mn-message.c"
{
#line 285 "mn-message.gob"
	
    if (self_mark_as_read_real(self, err))
      {
	mn_mailbox_consider_as_read(self);
	return TRUE;
      }
    else
      return FALSE;
  }}
#line 873 "mn-message.c"
#undef __GOB_FUNCTION__

#line 295 "mn-message.gob"
static gboolean 
mn_message_mark_as_read_impl (MNMessage * self, GError ** err)
#line 879 "mn-message.c"
{
	MNMessageClass *klass;
#line 295 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 295 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 886 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->mark_as_read_impl)
		return (*klass->mark_as_read_impl)(self,err);
	else
		return (gboolean )(0);
}

#line 298 "mn-message.gob"
gboolean 
mn_message_can_mark_as_spam (MNMessage * self)
#line 898 "mn-message.c"
{
	MNMessageClass *klass;
#line 298 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 298 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 905 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_mark_as_spam)
		return (*klass->can_mark_as_spam)(self);
	else
		return (gboolean )(0);
}
#line 298 "mn-message.gob"
static gboolean 
___real_mn_message_can_mark_as_spam (MNMessage * self G_GNUC_UNUSED)
#line 916 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_spam"
{
#line 300 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "mark-as-spam") || self_can_mark_as_spam_impl(self);
  }}
#line 924 "mn-message.c"
#undef __GOB_FUNCTION__

#line 304 "mn-message.gob"
static gboolean 
mn_message_can_mark_as_spam_impl (MNMessage * self)
#line 930 "mn-message.c"
{
	MNMessageClass *klass;
#line 304 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 304 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 937 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_mark_as_spam_impl)
		return (*klass->can_mark_as_spam_impl)(self);
	else
		return (gboolean )(0);
}
#line 304 "mn-message.gob"
static gboolean 
___real_mn_message_can_mark_as_spam_impl (MNMessage * self G_GNUC_UNUSED)
#line 948 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_mark_as_spam_impl"
{
#line 306 "mn-message.gob"
	
    return SELF_GET_CLASS(self)->mark_as_spam_impl != NULL;
  }}
#line 956 "mn-message.c"
#undef __GOB_FUNCTION__

#line 310 "mn-message.gob"
static gboolean 
mn_message_mark_as_spam_real (MNMessage * self, GError ** err)
#line 962 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_spam_real"
#line 310 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 310 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 969 "mn-message.c"
{
#line 312 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "mark-as-spam", &status, err))
      return status;
    else
      return self_mark_as_spam_impl(self, err);
  }}
#line 980 "mn-message.c"
#undef __GOB_FUNCTION__

#line 321 "mn-message.gob"
gboolean 
mn_message_mark_as_spam (MNMessage * self, GError ** err)
#line 986 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::mark_as_spam"
#line 321 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 321 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 993 "mn-message.c"
{
#line 323 "mn-message.gob"
	
    if (self_mark_as_spam_real(self, err))
      {
	mn_mailbox_consider_as_read(self);
	return TRUE;
      }
    else
      return FALSE;
  }}
#line 1005 "mn-message.c"
#undef __GOB_FUNCTION__

#line 333 "mn-message.gob"
static gboolean 
mn_message_mark_as_spam_impl (MNMessage * self, GError ** err)
#line 1011 "mn-message.c"
{
	MNMessageClass *klass;
#line 333 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 333 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1018 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->mark_as_spam_impl)
		return (*klass->mark_as_spam_impl)(self,err);
	else
		return (gboolean )(0);
}

#line 336 "mn-message.gob"
gboolean 
mn_message_can_delete (MNMessage * self)
#line 1030 "mn-message.c"
{
	MNMessageClass *klass;
#line 336 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 336 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1037 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_delete)
		return (*klass->can_delete)(self);
	else
		return (gboolean )(0);
}
#line 336 "mn-message.gob"
static gboolean 
___real_mn_message_can_delete (MNMessage * self G_GNUC_UNUSED)
#line 1048 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_delete"
{
#line 338 "mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, "delete") || self_can_delete_impl(self);
  }}
#line 1056 "mn-message.c"
#undef __GOB_FUNCTION__

#line 342 "mn-message.gob"
static gboolean 
mn_message_can_delete_impl (MNMessage * self)
#line 1062 "mn-message.c"
{
	MNMessageClass *klass;
#line 342 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 342 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1069 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->can_delete_impl)
		return (*klass->can_delete_impl)(self);
	else
		return (gboolean )(0);
}
#line 342 "mn-message.gob"
static gboolean 
___real_mn_message_can_delete_impl (MNMessage * self G_GNUC_UNUSED)
#line 1080 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::can_delete_impl"
{
#line 344 "mn-message.gob"
	
    return SELF_GET_CLASS(self)->delete_impl != NULL;
  }}
#line 1088 "mn-message.c"
#undef __GOB_FUNCTION__

#line 348 "mn-message.gob"
static gboolean 
mn_message_delete_real (MNMessage * self, GError ** err)
#line 1094 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::delete_real"
#line 348 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 348 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1101 "mn-message.c"
{
#line 350 "mn-message.gob"
	
    gboolean status;

    if (self_execute_command(self, "delete", &status, err))
      return status;
    else
      return self_delete_impl(self, err);
  }}
#line 1112 "mn-message.c"
#undef __GOB_FUNCTION__

#line 360 "mn-message.gob"
gboolean 
mn_message_delete (MNMessage * self, GError ** err)
#line 1118 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::delete"
#line 360 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 360 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1125 "mn-message.c"
{
#line 362 "mn-message.gob"
	
    if (self_delete_real(self, err))
      {
	mn_mailbox_consider_as_read(self);
	return TRUE;
      }
    else
      return FALSE;
  }}
#line 1137 "mn-message.c"
#undef __GOB_FUNCTION__

#line 372 "mn-message.gob"
static gboolean 
mn_message_delete_impl (MNMessage * self, GError ** err)
#line 1143 "mn-message.c"
{
	MNMessageClass *klass;
#line 372 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 372 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1150 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->delete_impl)
		return (*klass->delete_impl)(self,err);
	else
		return (gboolean )(0);
}

#line 375 "mn-message.gob"
MNMessage * 
mn_message_new (MNMailbox * mailbox, const char * error, time_t sent_time, const char * id, const char * from, const char * subject, const char * uri, MNMessageFlags flags)
#line 1162 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::new"
#line 375 "mn-message.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMessage * )0);
#line 375 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMessage * )0);
#line 1169 "mn-message.c"
{
#line 384 "mn-message.gob"
	
    return GET_NEW_VARG(MN_MESSAGE_PROP_MAILBOX(mailbox),
			MN_MESSAGE_PROP_ERROR((char *) error),
			MN_MESSAGE_PROP_SENT_TIME(sent_time),
			MN_MESSAGE_PROP_ID((char *) id),
			MN_MESSAGE_PROP_FROM((char *) from),
			MN_MESSAGE_PROP_SUBJECT((char *) subject),
			MN_MESSAGE_PROP_URI((char *) uri),
			MN_MESSAGE_PROP_FLAGS(flags),
			NULL);
  }}
#line 1183 "mn-message.c"
#undef __GOB_FUNCTION__

#line 396 "mn-message.gob"
MNMessage * 
mn_message_new_from_error (MNMailbox * mailbox, const char * error, MNMessageFlags flags)
#line 1189 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::new_from_error"
#line 396 "mn-message.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMessage * )0);
#line 396 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMessage * )0);
#line 396 "mn-message.gob"
	g_return_val_if_fail (error != NULL, (MNMessage * )0);
#line 1198 "mn-message.c"
{
#line 400 "mn-message.gob"
	
    return self_new(mailbox, error, 0, NULL, NULL, NULL, NULL, flags);
  }}
#line 1204 "mn-message.c"
#undef __GOB_FUNCTION__

#line 404 "mn-message.gob"
xmlNode * 
mn_message_xml_node_new (MNMessage * self)
#line 1210 "mn-message.c"
{
#define __GOB_FUNCTION__ "MN:Message::xml_node_new"
#line 404 "mn-message.gob"
	g_return_val_if_fail (self != NULL, (xmlNode * )0);
#line 404 "mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (xmlNode * )0);
#line 1217 "mn-message.c"
{
#line 406 "mn-message.gob"
	
    xmlNode *node;

    node = xmlNewNode(NULL, "message");

    xmlSetProp(node, "mailbox", self->mailbox->runtime_name);

    if ((self->flags & MN_MESSAGE_NEW) != 0)
      xmlSetProp(node, "new", "true");

    mn_xml_export_properties(G_OBJECT(self), node);

    return node;
  }}
#line 1234 "mn-message.c"
#undef __GOB_FUNCTION__
