/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-pi-mailbox.h"

#include "mn-pi-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 41 "mn-pi-mailbox.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-authenticated-mailbox-private.h"
#include "mn-mailbox-private.h"
#include "mn-util.h"
#include "mn-stock.h"
#include "mn-conf.h"

struct _MNClientSessionPrivate
{
  MN_PI_MAILBOX_SESSION_PRIVATE;
};

#line 42 "mn-pi-mailbox.c"
static const GEnumValue _mn_pi_mailbox_connection_type_values[] = {
	{ MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL", (char *)"normal" },
	{ MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL", (char *)"inband-ssl" },
	{ MN_PI_MAILBOX_CONNECTION_TYPE_SSL, (char *)"MN_PI_MAILBOX_CONNECTION_TYPE_SSL", (char *)"ssl" },
	{ 0, NULL, NULL }
};

GType
mn_pi_mailbox_connection_type_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPIMailboxConnectionType", _mn_pi_mailbox_connection_type_values);
	return type;
}

/* self casting macros */
#define SELF(x) MN_PI_MAILBOX(x)
#define SELF_CONST(x) MN_PI_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_PI_MAILBOX(x)
#define TYPE_SELF MN_TYPE_PI_MAILBOX
#define SELF_CLASS(x) MN_PI_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_PI_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNPIMailbox Self;
typedef MNPIMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_pi_mailbox_class_init (MNPIMailboxClass * class) G_GNUC_UNUSED;
static void mn_pi_mailbox_init (MNPIMailbox * self) G_GNUC_UNUSED;
static void ___3_mn_pi_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static void ___4_mn_pi_mailbox_removed (MNMailbox * mailbox) G_GNUC_UNUSED;
static void ___5_mn_pi_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;
static gboolean mn_pi_mailbox_run_untrusted_dialog (MNPIMailbox * self, const char * server, const char * reason, const char * cert_fingerprint) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_CONNECTION_TYPE,
	PROP_AUTHMECH,
	PROP_HOSTNAME,
	PROP_PORT
};

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_split_uri mn_pi_mailbox_split_uri
#define self_split_uri_auth mn_pi_mailbox_split_uri_auth
#define self_split_uri_hostport mn_pi_mailbox_split_uri_hostport
#define self_session_private_init mn_pi_mailbox_session_private_init
#define self_sasl_get_credentials_cb mn_pi_mailbox_sasl_get_credentials_cb
#define self_ssl_trust_server_cb mn_pi_mailbox_ssl_trust_server_cb
#define self_run_untrusted_dialog mn_pi_mailbox_run_untrusted_dialog
#define self_notice_cb mn_pi_mailbox_notice_cb
#define self_warning_cb mn_pi_mailbox_warning_cb
GType
mn_pi_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPIMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_pi_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPIMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_pi_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNPIMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPIMailbox *)g_object_new(mn_pi_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPIMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPIMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNPIMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPIMailbox *)g_object_new_valist (mn_pi_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::finalize"
	MNPIMailbox *self G_GNUC_UNUSED = MN_PI_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 74 "mn-pi-mailbox.gob"
	if(self->authmech) { g_free ((gpointer) self->authmech); self->authmech = NULL; }
#line 156 "mn-pi-mailbox.c"
#line 78 "mn-pi-mailbox.gob"
	if(self->hostname) { g_free ((gpointer) self->hostname); self->hostname = NULL; }
#line 159 "mn-pi-mailbox.c"
}
#undef __GOB_FUNCTION__

#line 91 "mn-pi-mailbox.gob"
static void 
mn_pi_mailbox_class_init (MNPIMailboxClass * class G_GNUC_UNUSED)
#line 166 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNPIMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 105 "mn-pi-mailbox.gob"
	mn_mailbox_class->seal = ___3_mn_pi_mailbox_seal;
#line 125 "mn-pi-mailbox.gob"
	mn_mailbox_class->removed = ___4_mn_pi_mailbox_removed;
#line 136 "mn-pi-mailbox.gob"
	mn_authenticated_mailbox_class->authenticated_check = ___5_mn_pi_mailbox_authenticated_check;
#line 183 "mn-pi-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_enum
		("connection_type" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_PI_MAILBOX_CONNECTION_TYPE /* enum_type */,
		 MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CONNECTION_TYPE,
		param_spec);
	param_spec = g_param_spec_string
		("authmech" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_AUTHMECH,
		param_spec);
	param_spec = g_param_spec_string
		("hostname" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_HOSTNAME,
		param_spec);
	param_spec = g_param_spec_int
		("port" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 65535 /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_PORT,
		param_spec);
    }
 {
#line 92 "mn-pi-mailbox.gob"

    /*
     * 5 minutes is a good default check delay for remote POP3/IMAP
     * mailboxes.
     */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;
  
#line 239 "mn-pi-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 100 "mn-pi-mailbox.gob"
static void 
mn_pi_mailbox_init (MNPIMailbox * self G_GNUC_UNUSED)
#line 246 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_PI_MAILBOX,MNPIMailboxPrivate);
 {
#line 101 "mn-pi-mailbox.gob"

    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_REMOTE);
  
#line 255 "mn-pi-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:PI:Mailbox::set_property"
{
	MNPIMailbox *self G_GNUC_UNUSED;

	self = MN_PI_MAILBOX (object);

	switch (property_id) {
	case PROP_CONNECTION_TYPE:
		{
#line 69 "mn-pi-mailbox.gob"
self->connection_type = g_value_get_enum (VAL);
#line 276 "mn-pi-mailbox.c"
		}
		break;
	case PROP_AUTHMECH:
		{
#line 75 "mn-pi-mailbox.gob"
{ char *old = self->authmech; self->authmech = g_value_dup_string (VAL); g_free (old); }
#line 283 "mn-pi-mailbox.c"
		}
		break;
	case PROP_HOSTNAME:
		{
#line 79 "mn-pi-mailbox.gob"
{ char *old = self->hostname; self->hostname = g_value_dup_string (VAL); g_free (old); }
#line 290 "mn-pi-mailbox.c"
		}
		break;
	case PROP_PORT:
		{
#line 82 "mn-pi-mailbox.gob"
self->port = g_value_get_int (VAL);
#line 297 "mn-pi-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:PI:Mailbox::get_property"
{
	MNPIMailbox *self G_GNUC_UNUSED;

	self = MN_PI_MAILBOX (object);

	switch (property_id) {
	case PROP_CONNECTION_TYPE:
		{
#line 69 "mn-pi-mailbox.gob"
g_value_set_enum (VAL, self->connection_type);
#line 328 "mn-pi-mailbox.c"
		}
		break;
	case PROP_AUTHMECH:
		{
#line 75 "mn-pi-mailbox.gob"
g_value_set_string (VAL, self->authmech);
#line 335 "mn-pi-mailbox.c"
		}
		break;
	case PROP_HOSTNAME:
		{
#line 79 "mn-pi-mailbox.gob"
g_value_set_string (VAL, self->hostname);
#line 342 "mn-pi-mailbox.c"
		}
		break;
	case PROP_PORT:
		{
#line 82 "mn-pi-mailbox.gob"
g_value_set_int (VAL, self->port);
#line 349 "mn-pi-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 105 "mn-pi-mailbox.gob"
static void 
___3_mn_pi_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 369 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::seal"
{
#line 107 "mn-pi-mailbox.gob"
	
    MNAuthenticatedMailbox *auth_mailbox = MN_AUTHENTICATED_MAILBOX(mailbox);
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    /* do not save default port to mailboxes.xml */
    if (self->port == SELF_GET_CLASS(self)->default_ports[self->connection_type])
      self->port = 0;

    self->runtime_port = self->port == 0
      ? SELF_GET_CLASS(self)->default_ports[self->connection_type]
      : self->port;

    auth_mailbox->keyring_server = g_strdup(self->hostname);
    auth_mailbox->keyring_port = self->runtime_port;
  }}
#line 394 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 125 "mn-pi-mailbox.gob"
static void 
___4_mn_pi_mailbox_removed (MNMailbox * mailbox G_GNUC_UNUSED)
#line 401 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->removed) \
		(* MN_MAILBOX_CLASS(parent_class)->removed)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::removed"
{
#line 127 "mn-pi-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    if (selfp->untrusted_dialog)
      gtk_dialog_response(GTK_DIALOG(selfp->untrusted_dialog), GTK_RESPONSE_CANCEL);
  }}
#line 417 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 136 "mn-pi-mailbox.gob"
static void 
___5_mn_pi_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 424 "mn-pi-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::authenticated_check"
{
#line 138 "mn-pi-mailbox.gob"
	
#if ! WITH_SSL
    Self *self = SELF(mailbox);
#endif

    PARENT_HANDLER(mailbox);

#if ! WITH_SSL
    if (self->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL
	|| self->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_SSL)
      {
	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(mailbox), _("SSL/TLS support has not been compiled in"));
	mn_mailbox_set_poll(MN_MAILBOX(mailbox), FALSE); /* disable the mailbox */

	gdk_flush();
	GDK_THREADS_LEAVE();
      }
#endif
  }}
#line 453 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 160 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_split_uri (const char * uri, int maxlen, char * scheme, char * auth, char * location)
#line 460 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri"
#line 160 "mn-pi-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 160 "mn-pi-mailbox.gob"
	g_return_val_if_fail (scheme != NULL, (gboolean )0);
#line 160 "mn-pi-mailbox.gob"
	g_return_val_if_fail (auth != NULL, (gboolean )0);
#line 160 "mn-pi-mailbox.gob"
	g_return_val_if_fail (location != NULL, (gboolean )0);
#line 471 "mn-pi-mailbox.c"
{
#line 166 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    pat = g_strdup_printf("%%%i[^:]://%%%i[^@]@%%%is", maxlen, maxlen, maxlen);
    n = sscanf(uri, pat, scheme, auth, location);
    g_free(pat);

    return n == 3;	/* MN requires an username, hence the auth part */
  }}
#line 484 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 177 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_split_uri_auth (const char * auth, int maxlen, char * username, char * authmech, gboolean * has_authmech)
#line 490 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri_auth"
#line 177 "mn-pi-mailbox.gob"
	g_return_val_if_fail (auth != NULL, (gboolean )0);
#line 177 "mn-pi-mailbox.gob"
	g_return_val_if_fail (username != NULL, (gboolean )0);
#line 177 "mn-pi-mailbox.gob"
	g_return_val_if_fail (authmech != NULL, (gboolean )0);
#line 177 "mn-pi-mailbox.gob"
	g_return_val_if_fail (has_authmech != NULL, (gboolean )0);
#line 501 "mn-pi-mailbox.c"
{
#line 183 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    pat = g_strdup_printf("%%%i[^;];AUTH=%%%is", maxlen, maxlen);
    n = sscanf(auth, pat, username, authmech);
    g_free(pat);

    if (n < 1)
      return FALSE;		/* MN requires an username */

    *has_authmech = n == 2;

    return TRUE;
  }}
#line 519 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 199 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_split_uri_hostport (const char * hostport, int maxlen, char * hostname, int * port)
#line 525 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::split_uri_hostport"
#line 199 "mn-pi-mailbox.gob"
	g_return_if_fail (hostport != NULL);
#line 199 "mn-pi-mailbox.gob"
	g_return_if_fail (hostname != NULL);
#line 199 "mn-pi-mailbox.gob"
	g_return_if_fail (port != NULL);
#line 534 "mn-pi-mailbox.c"
{
#line 204 "mn-pi-mailbox.gob"
	
    char *pat;
    int n;

    /* split host:port part in 2 subparts: host and port */

    pat = g_strdup_printf("[%%%i[^]]]:%%u", maxlen);
    n = sscanf(hostport, pat, hostname, port);
    g_free(pat);

    if (n < 1)
      {
	pat = g_strdup_printf("%%%i[^:]:%%u", maxlen);
	n = sscanf(hostport, pat, hostname, port);
	g_free(pat);
      }

    g_assert(n >= 1);

    if (n < 2)
      *port = 0;
  }}
#line 559 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 227 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_session_private_init (MNPIMailbox * self, MNClientSessionPrivate * priv)
#line 565 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::session_private_init"
#line 227 "mn-pi-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 227 "mn-pi-mailbox.gob"
	g_return_if_fail (MN_IS_PI_MAILBOX (self));
#line 227 "mn-pi-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 574 "mn-pi-mailbox.c"
{
#line 229 "mn-pi-mailbox.gob"
	
    priv->mailbox = MN_MAILBOX(self);
    priv->auth_mailbox = MN_AUTHENTICATED_MAILBOX(self);
    priv->pi_mailbox = MN_PI_MAILBOX(self);
  }}
#line 582 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 235 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_sasl_get_credentials_cb (MNClientSession * session, MNClientSessionPrivate * priv, const char ** username, const char ** password)
#line 588 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::sasl_get_credentials_cb"
{
#line 240 "mn-pi-mailbox.gob"
	
#if WITH_SASL
    g_return_val_if_fail(username != NULL || password != NULL, FALSE);

    if (username)
      *username = priv->auth_mailbox->username;

    if (password)
      {
	if (mn_authenticated_mailbox_fill_password(priv->auth_mailbox, TRUE))
	  *password = priv->auth_mailbox->runtime_password;
	else
	  return FALSE;
      }
    else
      /*
       * Reset auth_cancelled ourselves since we did not call
       * mn_authenticated_mailbox_fill_password().
       */
      priv->auth_mailbox->auth_cancelled = FALSE;

    return TRUE;
#else
    g_assert_not_reached();
    return FALSE;
#endif /* WITH_SASL */
  }}
#line 620 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 268 "mn-pi-mailbox.gob"
gboolean 
mn_pi_mailbox_ssl_trust_server_cb (MNClientSession * session, const char * server, int port, const char * fingerprint, const char * verify_error, MNClientSessionPrivate * priv)
#line 626 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::ssl_trust_server_cb"
{
#line 275 "mn-pi-mailbox.gob"
	
#if WITH_SSL
    gboolean status = FALSE;

    if (fingerprint)
      {
	GSList *gconf_fingerprints;

	gconf_fingerprints = eel_gconf_get_string_list(MN_CONF_TRUSTED_X509_CERTIFICATES);

	if (mn_g_str_slist_find(gconf_fingerprints, fingerprint))
	  status = TRUE;
	else
	  if (self_run_untrusted_dialog(priv->pi_mailbox, server, verify_error, fingerprint))
	    {
	      status = TRUE;
	      gconf_fingerprints = g_slist_append(gconf_fingerprints, g_strdup(fingerprint));
	      eel_gconf_set_string_list(MN_CONF_TRUSTED_X509_CERTIFICATES, gconf_fingerprints);
	    }

	eel_g_slist_free_deep(gconf_fingerprints);
      }
    else
      {
	char *key;
	GSList *gconf_servers = NULL;

	key = g_strdup_printf("%s:%i", server, port);
	gconf_servers = eel_gconf_get_string_list(MN_CONF_TRUSTED_SERVERS);

	if (mn_g_str_slist_find(gconf_servers, key))
	  status = TRUE;
	else
	  {
	    if (self_run_untrusted_dialog(priv->pi_mailbox, server, _("missing certificate"), NULL))
	      {
		status = TRUE;
		gconf_servers = g_slist_append(gconf_servers, g_strdup(key));
		eel_gconf_set_string_list(MN_CONF_TRUSTED_SERVERS, gconf_servers);
	      }
	  }

	g_free(key);
	eel_g_slist_free_deep(gconf_servers);
      }

    return status;
#else
    g_assert_not_reached();
    return FALSE;
#endif /* WITH_SSL */
  }}
#line 683 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 328 "mn-pi-mailbox.gob"
static gboolean 
mn_pi_mailbox_run_untrusted_dialog (MNPIMailbox * self, const char * server, const char * reason, const char * cert_fingerprint)
#line 689 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::run_untrusted_dialog"
#line 328 "mn-pi-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 328 "mn-pi-mailbox.gob"
	g_return_val_if_fail (MN_IS_PI_MAILBOX (self), (gboolean )0);
#line 328 "mn-pi-mailbox.gob"
	g_return_val_if_fail (server != NULL, (gboolean )0);
#line 328 "mn-pi-mailbox.gob"
	g_return_val_if_fail (reason != NULL, (gboolean )0);
#line 700 "mn-pi-mailbox.c"
{
#line 333 "mn-pi-mailbox.gob"
	
#if WITH_SSL
    GString *secondary;
    gboolean status;

    g_return_val_if_fail(server != NULL, FALSE);
    g_return_val_if_fail(reason != NULL, FALSE);

    secondary = g_string_new(NULL);
    g_string_printf(secondary,
		    _("Mail Notification was unable to trust \"%s\" "
		      "(%s). It is possible that someone is "
		      "intercepting your communication to obtain "
		      "your confidential information.\n"
		      "\n"
		      "You should only connect to the server if you "
		      "are certain you are connected to \"%s\". "
		      "If you choose to connect to the server, this "
		      "message will not be shown again."),
		    server, reason, server);

    if (cert_fingerprint)
      {
	g_string_append(secondary, "\n\n");
	g_string_append_printf(secondary, _("Certificate fingerprint: %s."), cert_fingerprint);
      }

    GDK_THREADS_ENTER();

    selfp->untrusted_dialog = mn_alert_dialog_new(NULL,
						  GTK_MESSAGE_WARNING, 0,
						  _("Connect to untrusted server?"),
						  secondary->str);
    g_string_free(secondary, TRUE);

    eel_add_weak_pointer(&selfp->untrusted_dialog);

    gtk_dialog_add_button(GTK_DIALOG(selfp->untrusted_dialog), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
    gtk_dialog_add_button(GTK_DIALOG(selfp->untrusted_dialog), GTK_STOCK_CONNECT, GTK_RESPONSE_OK);

    status = mn_dialog_run_nonmodal(GTK_DIALOG(selfp->untrusted_dialog)) == GTK_RESPONSE_OK;
    gtk_widget_destroy(selfp->untrusted_dialog);

    gdk_flush();
    GDK_THREADS_LEAVE();

    return status;
#else
    g_assert_not_reached();
    return FALSE;
#endif /* WITH_SSL */
  }}
#line 755 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 386 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_notice_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv)
#line 761 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::notice_cb"
{
#line 390 "mn-pi-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", message);
  }}
#line 769 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__

#line 394 "mn-pi-mailbox.gob"
void 
mn_pi_mailbox_warning_cb (MNClientSession * session, const char * message, MNClientSessionPrivate * priv)
#line 775 "mn-pi-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:PI:Mailbox::warning_cb"
{
#line 398 "mn-pi-mailbox.gob"
	
    mn_mailbox_warning(priv->mailbox, "%s", message);
  }}
#line 783 "mn-pi-mailbox.c"
#undef __GOB_FUNCTION__
