/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-message.h"

#include "mn-message-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 76 "src/mn-message.gob"

#include <errno.h>
#include <glib/gi18n.h>
#include <gnome.h>
#include <libgnomevfs/gnome-vfs.h>
#include "mn-util.h"

typedef struct
{
  MNMessageActionRequest		*request;
  MNMessageActionPerformCallback	callback;
  gpointer				user_data;
} PerformInfo;

#line 41 "mn-message.c"
/* self casting macros */
#define SELF(x) MN_MESSAGE(x)
#define SELF_CONST(x) MN_MESSAGE_CONST(x)
#define IS_SELF(x) MN_IS_MESSAGE(x)
#define TYPE_SELF MN_TYPE_MESSAGE
#define SELF_CLASS(x) MN_MESSAGE_CLASS(x)

#define SELF_GET_CLASS(x) MN_MESSAGE_GET_CLASS(x)

/* self typedefs */
typedef MNMessage Self;
typedef MNMessageClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-message.gob"
static void mn_message_init (MNMessage * o);
#line 60 "mn-message.c"
#line 0 "src/mn-message.gob"
static void mn_message_class_init (MNMessageClass * c);
#line 63 "mn-message.c"
#line 224 "src/mn-message.gob"
static void mn_message_constructor (MNMessage * self);
#line 66 "mn-message.c"
#line 266 "src/mn-message.gob"
static gboolean mn_message_subst_command_cb (const char * name, char ** value, gpointer data);
#line 69 "mn-message.c"
#line 296 "src/mn-message.gob"
static gboolean mn_message_execute_command_real (MNMessage * self, const char * command, GError ** err);
#line 72 "mn-message.c"
#line 324 "src/mn-message.gob"
static gboolean mn_message_execute_command (MNMessage * self, const char * id, GError ** err);
#line 75 "mn-message.c"
#line 393 "src/mn-message.gob"
static void mn_message_perform_action_in_thread_cb (PerformInfo * info);
#line 78 "mn-message.c"
#line 411 "src/mn-message.gob"
static void mn_message_action_done_real (MNMessage * self, MNMessageAction * action, GError * err, MNMessageActionResultCallback callback, gpointer data);
#line 81 "mn-message.c"
static gboolean ___real_mn_message_builtin_can_open (MNMessage * self);
#line 439 "src/mn-message.gob"
static gboolean mn_message_builtin_can_open (MNMessage * self);
#line 85 "mn-message.c"
static void ___real_mn_message_builtin_open (MNMessage * self, MNMessageActionRequest * request);
#line 445 "src/mn-message.gob"
static void mn_message_builtin_open (MNMessage * self, MNMessageActionRequest * request);
#line 89 "mn-message.c"
#line 455 "src/mn-message.gob"
static void mn_message_open_done (MNMessage * self, GError * err);
#line 92 "mn-message.c"
static gboolean ___real_mn_message_builtin_can_mark_as_read (MNMessage * self);
#line 462 "src/mn-message.gob"
static gboolean mn_message_builtin_can_mark_as_read (MNMessage * self);
#line 96 "mn-message.c"
#line 468 "src/mn-message.gob"
static void mn_message_builtin_mark_as_read (MNMessage * self, MNMessageActionRequest * request);
#line 99 "mn-message.c"
#line 471 "src/mn-message.gob"
static void mn_message_mark_as_read_done (MNMessage * self, GError * err);
#line 102 "mn-message.c"
static gboolean ___real_mn_message_builtin_can_mark_as_spam (MNMessage * self);
#line 478 "src/mn-message.gob"
static gboolean mn_message_builtin_can_mark_as_spam (MNMessage * self);
#line 106 "mn-message.c"
#line 484 "src/mn-message.gob"
static void mn_message_builtin_mark_as_spam (MNMessage * self, MNMessageActionRequest * request);
#line 109 "mn-message.c"
#line 487 "src/mn-message.gob"
static void mn_message_mark_as_spam_done (MNMessage * self, GError * err);
#line 112 "mn-message.c"
static gboolean ___real_mn_message_builtin_can_delete (MNMessage * self);
#line 494 "src/mn-message.gob"
static gboolean mn_message_builtin_can_delete (MNMessage * self);
#line 116 "mn-message.c"
#line 500 "src/mn-message.gob"
static void mn_message_builtin_delete (MNMessage * self, MNMessageActionRequest * request);
#line 119 "mn-message.c"
#line 503 "src/mn-message.gob"
static void mn_message_delete_done (MNMessage * self, GError * err);
#line 122 "mn-message.c"

enum {
	PROP_0,
	PROP_MAILBOX,
	PROP_SENT_TIME,
	PROP_ID,
	PROP_MID,
	PROP_FROM,
	PROP_SUBJECT,
	PROP_URI,
	PROP_FILENAME,
	PROP_FLAGS
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_action mn_message_get_action
#define self_subst_command_cb mn_message_subst_command_cb
#define self_execute_command_real mn_message_execute_command_real
#define self_execute_command mn_message_execute_command
#define self_can_perform_action mn_message_can_perform_action
#define self_perform_action mn_message_perform_action
#define self_perform_action_in_thread mn_message_perform_action_in_thread
#define self_perform_action_in_thread_cb mn_message_perform_action_in_thread_cb
#define self_action_done_real mn_message_action_done_real
#define self_action_done mn_message_action_done
#define self_action_error_quark mn_message_action_error_quark
#define self_builtin_can_open mn_message_builtin_can_open
#define self_builtin_open mn_message_builtin_open
#define self_open_done mn_message_open_done
#define self_builtin_can_mark_as_read mn_message_builtin_can_mark_as_read
#define self_builtin_mark_as_read mn_message_builtin_mark_as_read
#define self_mark_as_read_done mn_message_mark_as_read_done
#define self_builtin_can_mark_as_spam mn_message_builtin_can_mark_as_spam
#define self_builtin_mark_as_spam mn_message_builtin_mark_as_spam
#define self_mark_as_spam_done mn_message_mark_as_spam_done
#define self_builtin_can_delete mn_message_builtin_can_delete
#define self_builtin_delete mn_message_builtin_delete
#define self_delete_done mn_message_delete_done
#define self_new mn_message_new
#define self_xml_node_new mn_message_xml_node_new
GType
mn_message_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMessageClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_message_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMessage),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_message_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMessage", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMessage *)g_object_new(mn_message_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMessage * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMessage *
GET_NEW_VARG (const char *first, ...)
{
	MNMessage *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMessage *)g_object_new_valist (mn_message_get_type (), first, ap);
	va_end (ap);
	return ret;
}


#line 91 "src/mn-message.gob"

static const MNMessageAction message_actions[] = {
  {
    "open",
    "mail-open",
    /* translators: header capitalization */
    N_("Open"),
    N_("Unable to open message"),
    self_builtin_can_open,
    self_builtin_open,
    self_open_done
  },
  {
    "mark-as-read",
    "mark",
    /* translators: header capitalization */
    N_("Mark as Read"),
    N_("Unable to mark message as read"),
    self_builtin_can_mark_as_read,
    self_builtin_mark_as_read,
    self_mark_as_read_done
  },
  {
    "mark-as-spam",
    "spam",
    /* translators: header capitalization */
    N_("Mark as Spam"),
    N_("Unable to mark message as spam"),
    self_builtin_can_mark_as_spam,
    self_builtin_mark_as_spam,
    self_mark_as_spam_done
  },
  {
    "delete",
    "delete",
    /* translators: header capitalization */
    N_("Delete"),
    N_("Unable to mark message as spam"),
    self_builtin_can_delete,
    self_builtin_delete,
    self_delete_done
  }
};

#line 254 "mn-message.c"

static GObject *
___constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
#define __GOB_FUNCTION__ "MN:Message::constructor"
	GObject *obj_self;
	MNMessage *self;
	obj_self = G_OBJECT_CLASS (parent_class)->constructor (type, n_construct_properties, construct_properties);
	self = MN_MESSAGE (obj_self);
#line 224 "src/mn-message.gob"
	mn_message_constructor (self);
#line 266 "mn-message.c"
	return obj_self;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message::finalize"
	MNMessage *self G_GNUC_UNUSED = MN_MESSAGE (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 163 "src/mn-message.gob"
	if(self->id) { g_free ((gpointer) self->id); self->id = NULL; }
#line 281 "mn-message.c"
#line 178 "src/mn-message.gob"
	if(self->mid) { g_free ((gpointer) self->mid); self->mid = NULL; }
#line 284 "mn-message.c"
#line 182 "src/mn-message.gob"
	if(self->from) { g_free ((gpointer) self->from); self->from = NULL; }
#line 287 "mn-message.c"
#line 186 "src/mn-message.gob"
	if(self->subject) { g_free ((gpointer) self->subject); self->subject = NULL; }
#line 290 "mn-message.c"
#line 190 "src/mn-message.gob"
	if(self->uri) { g_free ((gpointer) self->uri); self->uri = NULL; }
#line 293 "mn-message.c"
}
#undef __GOB_FUNCTION__

static void 
mn_message_init (MNMessage * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message::init"
}
#undef __GOB_FUNCTION__
static void 
mn_message_class_init (MNMessageClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 439 "src/mn-message.gob"
	c->builtin_can_open = ___real_mn_message_builtin_can_open;
#line 445 "src/mn-message.gob"
	c->builtin_open = ___real_mn_message_builtin_open;
#line 462 "src/mn-message.gob"
	c->builtin_can_mark_as_read = ___real_mn_message_builtin_can_mark_as_read;
#line 317 "mn-message.c"
	c->builtin_mark_as_read = NULL;
#line 478 "src/mn-message.gob"
	c->builtin_can_mark_as_spam = ___real_mn_message_builtin_can_mark_as_spam;
#line 321 "mn-message.c"
	c->builtin_mark_as_spam = NULL;
#line 494 "src/mn-message.gob"
	c->builtin_can_delete = ___real_mn_message_builtin_can_delete;
#line 325 "mn-message.c"
	c->builtin_delete = NULL;
	g_object_class->constructor = ___constructor;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("mailbox" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MAILBOX,
		param_spec);
	param_spec = g_param_spec_ulong
		("sent_time" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXULONG /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SENT_TIME,
		param_spec);
	param_spec = g_param_spec_string
		("id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_ID,
		param_spec);
	param_spec = g_param_spec_string
		("mid" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MID,
		param_spec);
	param_spec = g_param_spec_string
		("from" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_FROM,
		param_spec);
	param_spec = g_param_spec_string
		("subject" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SUBJECT,
		param_spec);
	param_spec = g_param_spec_string
		("uri" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MESSAGE_PARAM_EXPORT | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_URI,
		param_spec);
	param_spec = g_param_spec_string
		("filename" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | MN_MESSAGE_PARAM_EXPORT));
	g_object_class_install_property (g_object_class,
		PROP_FILENAME,
		param_spec);
	param_spec = g_param_spec_uint
		("flags" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 0 /* minimum */,
		 G_MAXUINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_FLAGS,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message::set_property"
{
	MNMessage *self G_GNUC_UNUSED;

	self = MN_MESSAGE (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 146 "src/mn-message.gob"
self->mailbox = g_value_get_pointer (VAL);
#line 438 "mn-message.c"
		}
		break;
	case PROP_SENT_TIME:
		{
#line 150 "src/mn-message.gob"
self->sent_time = g_value_get_ulong (VAL);
#line 445 "mn-message.c"
		}
		break;
	case PROP_ID:
		{
#line 164 "src/mn-message.gob"
{ char *old = self->id; self->id = g_value_dup_string (VAL); g_free (old); }
#line 452 "mn-message.c"
		}
		break;
	case PROP_MID:
		{
#line 179 "src/mn-message.gob"
{ char *old = self->mid; self->mid = g_value_dup_string (VAL); g_free (old); }
#line 459 "mn-message.c"
		}
		break;
	case PROP_FROM:
		{
#line 183 "src/mn-message.gob"
{ char *old = self->from; self->from = g_value_dup_string (VAL); g_free (old); }
#line 466 "mn-message.c"
		}
		break;
	case PROP_SUBJECT:
		{
#line 187 "src/mn-message.gob"
{ char *old = self->subject; self->subject = g_value_dup_string (VAL); g_free (old); }
#line 473 "mn-message.c"
		}
		break;
	case PROP_URI:
		{
#line 191 "src/mn-message.gob"
{ char *old = self->uri; self->uri = g_value_dup_string (VAL); g_free (old); }
#line 480 "mn-message.c"
		}
		break;
	case PROP_FLAGS:
		{
#line 200 "src/mn-message.gob"
self->flags = g_value_get_uint (VAL);
#line 487 "mn-message.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message::get_property"
{
	MNMessage *self G_GNUC_UNUSED;

	self = MN_MESSAGE (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 146 "src/mn-message.gob"
g_value_set_pointer (VAL, self->mailbox);
#line 518 "mn-message.c"
		}
		break;
	case PROP_SENT_TIME:
		{
#line 150 "src/mn-message.gob"
g_value_set_ulong (VAL, self->sent_time);
#line 525 "mn-message.c"
		}
		break;
	case PROP_ID:
		{
#line 164 "src/mn-message.gob"
g_value_set_string (VAL, self->id);
#line 532 "mn-message.c"
		}
		break;
	case PROP_MID:
		{
#line 179 "src/mn-message.gob"
g_value_set_string (VAL, self->mid);
#line 539 "mn-message.c"
		}
		break;
	case PROP_FROM:
		{
#line 183 "src/mn-message.gob"
g_value_set_string (VAL, self->from);
#line 546 "mn-message.c"
		}
		break;
	case PROP_SUBJECT:
		{
#line 187 "src/mn-message.gob"
g_value_set_string (VAL, self->subject);
#line 553 "mn-message.c"
		}
		break;
	case PROP_URI:
		{
#line 191 "src/mn-message.gob"
g_value_set_string (VAL, self->uri);
#line 560 "mn-message.c"
		}
		break;
	case PROP_FILENAME:
		{
#line 195 "src/mn-message.gob"

      g_value_take_string(VAL, self->uri ? gnome_vfs_get_local_path_from_uri(self->uri) : NULL);
    
#line 569 "mn-message.c"
		}
		break;
	case PROP_FLAGS:
		{
#line 200 "src/mn-message.gob"
g_value_set_uint (VAL, self->flags);
#line 576 "mn-message.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 202 "src/mn-message.gob"
MNMessageAction * 
mn_message_get_action (const char * name)
{
#line 597 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::get_action"
#line 202 "src/mn-message.gob"
	g_return_val_if_fail (name != NULL, (MNMessageAction * )0);
#line 601 "mn-message.c"
{
#line 204 "src/mn-message.gob"
	
    static GHashTable *actions = NULL;

    if (! actions)
      {
	int i;

	actions = g_hash_table_new(g_str_hash, g_str_equal);

	for (i = 0; i < G_N_ELEMENTS(message_actions); i++)
	  {
	    const MNMessageAction *action = &message_actions[i];

	    g_hash_table_insert(actions, (gpointer) action->name, (gpointer) action);
	  }
      }

    return g_hash_table_lookup(actions, name);
  }}
#line 623 "mn-message.c"
#undef __GOB_FUNCTION__

#line 224 "src/mn-message.gob"
static void 
mn_message_constructor (MNMessage * self)
{
#line 630 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::constructor"
{
#line 225 "src/mn-message.gob"
	
    g_assert(MN_IS_MAILBOX(self->mailbox));

    if (! self->id)
      {
	GString *id;

	/* no ID was provided, try to generate a persistent one */

	id = g_string_new(NULL);

	if (self->sent_time > 0)
	  g_string_append_printf(id, ":sent-time:%i:", (int) self->sent_time);
	if (self->from)
	  g_string_append_printf(id, ":from:%s:", self->from);
	if (self->subject)
	  g_string_append_printf(id, ":subject:%s:", self->subject);

	if (! *id->str)
	  {
	    static int unique = 0;

	    /*
	     * We could not generate a persistent ID. Fallback to a
	     * non-persistent one.
	     */

	    g_string_append_printf(id, "%i", g_atomic_int_exchange_and_add(&unique, 1));
	  }

	self->id = g_string_free(id, FALSE);
      }

    /* these fields must only be filled after we have generated an ID */

    if (! self->from)
      self->from = g_strdup("");
    if (! self->subject)
      self->subject = g_strdup("");
  }}
#line 674 "mn-message.c"
#undef __GOB_FUNCTION__

#line 266 "src/mn-message.gob"
static gboolean 
mn_message_subst_command_cb (const char * name, char ** value, gpointer data)
{
#line 681 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::subst_command_cb"
{
#line 268 "src/mn-message.gob"
	
    Self *self = data;
    GParamSpec **properties;
    unsigned int n_properties;
    gboolean status = FALSE;
    int i;

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MESSAGE_PARAM_EXPORT) != 0
	  && ! strcmp(g_param_spec_get_name(properties[i]), name))
	{
	  GValue gvalue = { 0, };

	  g_value_init(&gvalue, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(G_OBJECT(self), name, &gvalue);

	  *value = mn_g_value_to_string(&gvalue);
	  g_value_unset(&gvalue);

	  status = TRUE;
	  break;
	}
    g_free(properties);

    return status;
  }}
#line 712 "mn-message.c"
#undef __GOB_FUNCTION__

#line 296 "src/mn-message.gob"
static gboolean 
mn_message_execute_command_real (MNMessage * self, const char * command, GError ** err)
{
#line 719 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::execute_command_real"
#line 296 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 296 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 296 "src/mn-message.gob"
	g_return_val_if_fail (command != NULL, (gboolean )0);
#line 727 "mn-message.c"
{
#line 300 "src/mn-message.gob"
	
    char *subst;
    int status;

    subst = mn_subst_command(command, self_subst_command_cb, self, err);
    if (! subst)
      return FALSE;

    status = gnome_execute_shell(NULL, subst);
    g_free(subst);

    if (status < 0)
      {
	g_set_error(err, 0, 0, "%s", g_strerror(errno));
	return FALSE;
      }

    return TRUE;
  }}
#line 749 "mn-message.c"
#undef __GOB_FUNCTION__

#line 324 "src/mn-message.gob"
static gboolean 
mn_message_execute_command (MNMessage * self, const char * id, GError ** err)
{
#line 756 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::execute_command"
#line 324 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 324 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 324 "src/mn-message.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 764 "mn-message.c"
{
#line 326 "src/mn-message.gob"
	
    char *command;
    GError *tmp_err = NULL;

    command = mn_mailbox_get_command(self->mailbox, id);
    if (! command)
      return FALSE;

    if (! self_execute_command_real(self, command, &tmp_err))
      {
	g_set_error(err, 0, 0, _("Unable to execute \"%s\": %s."), command, tmp_err->message);
	g_error_free(tmp_err);
      }

    g_free(command);
    return TRUE;
  }}
#line 784 "mn-message.c"
#undef __GOB_FUNCTION__

#line 344 "src/mn-message.gob"
gboolean 
mn_message_can_perform_action (MNMessage * self, MNMessageAction * action)
{
#line 791 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::can_perform_action"
#line 344 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 344 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 344 "src/mn-message.gob"
	g_return_val_if_fail (action != NULL, (gboolean )0);
#line 799 "mn-message.c"
{
#line 346 "src/mn-message.gob"
	
    return mn_mailbox_has_command(self->mailbox, action->name)
      || action->can_perform(self);
  }}
#line 806 "mn-message.c"
#undef __GOB_FUNCTION__

#line 351 "src/mn-message.gob"
void 
mn_message_perform_action (MNMessage * self, MNMessageAction * action, MNMessageActionResultCallback callback, gpointer data)
{
#line 813 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::perform_action"
#line 351 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 351 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 351 "src/mn-message.gob"
	g_return_if_fail (action != NULL);
#line 351 "src/mn-message.gob"
	g_return_if_fail (callback != NULL);
#line 823 "mn-message.c"
{
#line 356 "src/mn-message.gob"
	
    GError *err = NULL;

    if (self_execute_command(self, action->name, &err))
      self_action_done_real(self, action, err, callback, data);
    else
      {
	MNMessageActionRequest *request;

	request = g_new0(MNMessageActionRequest, 1);
	request->message = g_object_ref(self);
	request->action = action;
	request->callback = callback;
	request->data = data;

	action->perform(self, request);
      }
  }}
#line 844 "mn-message.c"
#undef __GOB_FUNCTION__

#line 375 "src/mn-message.gob"
void 
mn_message_perform_action_in_thread (MNMessageActionRequest * request, MNMessageActionPerformCallback callback, gpointer user_data)
{
#line 851 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::perform_action_in_thread"
#line 375 "src/mn-message.gob"
	g_return_if_fail (request != NULL);
#line 375 "src/mn-message.gob"
	g_return_if_fail (callback != NULL);
#line 857 "mn-message.c"
{
#line 379 "src/mn-message.gob"
	
    PerformInfo *info;

    info = g_new0(PerformInfo, 1);
    info->request = request;
    info->callback = callback;
    info->user_data = user_data;

    g_object_ref(request->message);
    g_object_ref(request->message->mailbox);

    mn_thread_create((GThreadFunc) self_perform_action_in_thread_cb, info);
  }}
#line 873 "mn-message.c"
#undef __GOB_FUNCTION__

#line 393 "src/mn-message.gob"
static void 
mn_message_perform_action_in_thread_cb (PerformInfo * info)
{
#line 880 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::perform_action_in_thread_cb"
{
#line 395 "src/mn-message.gob"
	
    GError *err;

    err = info->callback(info->request->message, info->user_data);

    GDK_THREADS_ENTER();

    self_action_done(info->request, err);

    g_object_unref(info->request->message->mailbox);
    g_object_unref(info->request->message);

    gdk_flush();
    GDK_THREADS_LEAVE();
  }}
#line 899 "mn-message.c"
#undef __GOB_FUNCTION__

#line 411 "src/mn-message.gob"
static void 
mn_message_action_done_real (MNMessage * self, MNMessageAction * action, GError * err, MNMessageActionResultCallback callback, gpointer data)
{
#line 906 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::action_done_real"
#line 411 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 411 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 411 "src/mn-message.gob"
	g_return_if_fail (action != NULL);
#line 914 "mn-message.c"
{
#line 417 "src/mn-message.gob"
	
    action->done(self, err);
    callback(action, err, data);
  }}
#line 921 "mn-message.c"
#undef __GOB_FUNCTION__

#line 422 "src/mn-message.gob"
void 
mn_message_action_done (MNMessageActionRequest * request, GError * err)
{
#line 928 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::action_done"
#line 422 "src/mn-message.gob"
	g_return_if_fail (request != NULL);
#line 932 "mn-message.c"
{
#line 424 "src/mn-message.gob"
	
    Self *self = request->message;

    self_action_done_real(self, request->action, err, request->callback, request->data);

    g_object_unref(request->message);
    g_free(request);
  }}
#line 943 "mn-message.c"
#undef __GOB_FUNCTION__

#line 433 "src/mn-message.gob"
GQuark 
mn_message_action_error_quark (void)
{
#line 950 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::action_error_quark"
{
#line 435 "src/mn-message.gob"
	
    return g_quark_from_static_string("mn-message-action-error");
  }}
#line 957 "mn-message.c"
#undef __GOB_FUNCTION__

#line 439 "src/mn-message.gob"
static gboolean 
mn_message_builtin_can_open (MNMessage * self)
{
#line 964 "mn-message.c"
	MNMessageClass *klass;
#line 439 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 439 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 970 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_can_open)
		return (*klass->builtin_can_open)(self);
	else
		return (gboolean )(0);
}
#line 439 "src/mn-message.gob"
static gboolean 
___real_mn_message_builtin_can_open (MNMessage * self G_GNUC_UNUSED)
{
#line 982 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::builtin_can_open"
{
#line 441 "src/mn-message.gob"
	
    return self->uri != NULL;
  }}
#line 989 "mn-message.c"
#undef __GOB_FUNCTION__

#line 445 "src/mn-message.gob"
static void 
mn_message_builtin_open (MNMessage * self, MNMessageActionRequest * request)
{
#line 996 "mn-message.c"
	MNMessageClass *klass;
#line 445 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 445 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1002 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_open)
		(*klass->builtin_open)(self,request);
}
#line 445 "src/mn-message.gob"
static void 
___real_mn_message_builtin_open (MNMessage * self G_GNUC_UNUSED, MNMessageActionRequest * request)
{
#line 1012 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::builtin_open"
{
#line 447 "src/mn-message.gob"
	
    GError *err = NULL;

    gnome_url_show(self->uri, &err);

    self_action_done(request, err);
  }}
#line 1023 "mn-message.c"
#undef __GOB_FUNCTION__

#line 455 "src/mn-message.gob"
static void 
mn_message_open_done (MNMessage * self, GError * err)
{
#line 1030 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::open_done"
#line 455 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 455 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1036 "mn-message.c"
{
#line 457 "src/mn-message.gob"
	
    if (! err)
      mn_mailbox_consider_as_read(self);
  }}
#line 1043 "mn-message.c"
#undef __GOB_FUNCTION__

#line 462 "src/mn-message.gob"
static gboolean 
mn_message_builtin_can_mark_as_read (MNMessage * self)
{
#line 1050 "mn-message.c"
	MNMessageClass *klass;
#line 462 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 462 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1056 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_can_mark_as_read)
		return (*klass->builtin_can_mark_as_read)(self);
	else
		return (gboolean )(0);
}
#line 462 "src/mn-message.gob"
static gboolean 
___real_mn_message_builtin_can_mark_as_read (MNMessage * self G_GNUC_UNUSED)
{
#line 1068 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::builtin_can_mark_as_read"
{
#line 464 "src/mn-message.gob"
	
    return SELF_GET_CLASS(self)->builtin_mark_as_read != NULL;
  }}
#line 1075 "mn-message.c"
#undef __GOB_FUNCTION__

#line 468 "src/mn-message.gob"
static void 
mn_message_builtin_mark_as_read (MNMessage * self, MNMessageActionRequest * request)
{
#line 1082 "mn-message.c"
	MNMessageClass *klass;
#line 468 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 468 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1088 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_mark_as_read)
		(*klass->builtin_mark_as_read)(self,request);
}

#line 471 "src/mn-message.gob"
static void 
mn_message_mark_as_read_done (MNMessage * self, GError * err)
{
#line 1099 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::mark_as_read_done"
#line 471 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 471 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1105 "mn-message.c"
{
#line 473 "src/mn-message.gob"
	
    if (! err)
      mn_mailbox_consider_as_read(self);
  }}
#line 1112 "mn-message.c"
#undef __GOB_FUNCTION__

#line 478 "src/mn-message.gob"
static gboolean 
mn_message_builtin_can_mark_as_spam (MNMessage * self)
{
#line 1119 "mn-message.c"
	MNMessageClass *klass;
#line 478 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 478 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1125 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_can_mark_as_spam)
		return (*klass->builtin_can_mark_as_spam)(self);
	else
		return (gboolean )(0);
}
#line 478 "src/mn-message.gob"
static gboolean 
___real_mn_message_builtin_can_mark_as_spam (MNMessage * self G_GNUC_UNUSED)
{
#line 1137 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::builtin_can_mark_as_spam"
{
#line 480 "src/mn-message.gob"
	
    return SELF_GET_CLASS(self)->builtin_mark_as_spam != NULL;
  }}
#line 1144 "mn-message.c"
#undef __GOB_FUNCTION__

#line 484 "src/mn-message.gob"
static void 
mn_message_builtin_mark_as_spam (MNMessage * self, MNMessageActionRequest * request)
{
#line 1151 "mn-message.c"
	MNMessageClass *klass;
#line 484 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 484 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1157 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_mark_as_spam)
		(*klass->builtin_mark_as_spam)(self,request);
}

#line 487 "src/mn-message.gob"
static void 
mn_message_mark_as_spam_done (MNMessage * self, GError * err)
{
#line 1168 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::mark_as_spam_done"
#line 487 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 487 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1174 "mn-message.c"
{
#line 489 "src/mn-message.gob"
	
    if (! err)
      mn_mailbox_consider_as_read(self);
  }}
#line 1181 "mn-message.c"
#undef __GOB_FUNCTION__

#line 494 "src/mn-message.gob"
static gboolean 
mn_message_builtin_can_delete (MNMessage * self)
{
#line 1188 "mn-message.c"
	MNMessageClass *klass;
#line 494 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 494 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (gboolean )0);
#line 1194 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_can_delete)
		return (*klass->builtin_can_delete)(self);
	else
		return (gboolean )(0);
}
#line 494 "src/mn-message.gob"
static gboolean 
___real_mn_message_builtin_can_delete (MNMessage * self G_GNUC_UNUSED)
{
#line 1206 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::builtin_can_delete"
{
#line 496 "src/mn-message.gob"
	
    return SELF_GET_CLASS(self)->builtin_delete != NULL;
  }}
#line 1213 "mn-message.c"
#undef __GOB_FUNCTION__

#line 500 "src/mn-message.gob"
static void 
mn_message_builtin_delete (MNMessage * self, MNMessageActionRequest * request)
{
#line 1220 "mn-message.c"
	MNMessageClass *klass;
#line 500 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 500 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1226 "mn-message.c"
	klass = MN_MESSAGE_GET_CLASS(self);

	if(klass->builtin_delete)
		(*klass->builtin_delete)(self,request);
}

#line 503 "src/mn-message.gob"
static void 
mn_message_delete_done (MNMessage * self, GError * err)
{
#line 1237 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::delete_done"
#line 503 "src/mn-message.gob"
	g_return_if_fail (self != NULL);
#line 503 "src/mn-message.gob"
	g_return_if_fail (MN_IS_MESSAGE (self));
#line 1243 "mn-message.c"
{
#line 505 "src/mn-message.gob"
	
    if (! err)
      mn_mailbox_consider_as_read(self);
  }}
#line 1250 "mn-message.c"
#undef __GOB_FUNCTION__

#line 510 "src/mn-message.gob"
MNMessage * 
mn_message_new (MNMailbox * mailbox, time_t sent_time, const char * id, const char * mid, const char * from, const char * subject, const char * uri, MNMessageFlags flags)
{
#line 1257 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::new"
#line 510 "src/mn-message.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMessage * )0);
#line 510 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMessage * )0);
#line 1263 "mn-message.c"
{
#line 519 "src/mn-message.gob"
	
    return GET_NEW_VARG(MN_MESSAGE_PROP_MAILBOX(mailbox),
			MN_MESSAGE_PROP_SENT_TIME(sent_time),
			MN_MESSAGE_PROP_ID((char *) id),
			MN_MESSAGE_PROP_MID((char *) mid),
			MN_MESSAGE_PROP_FROM((char *) from),
			MN_MESSAGE_PROP_SUBJECT((char *) subject),
			MN_MESSAGE_PROP_URI((char *) uri),
			MN_MESSAGE_PROP_FLAGS(flags),
			NULL);
  }}
#line 1277 "mn-message.c"
#undef __GOB_FUNCTION__

#line 531 "src/mn-message.gob"
xmlNode * 
mn_message_xml_node_new (MNMessage * self)
{
#line 1284 "mn-message.c"
#define __GOB_FUNCTION__ "MN:Message::xml_node_new"
#line 531 "src/mn-message.gob"
	g_return_val_if_fail (self != NULL, (xmlNode * )0);
#line 531 "src/mn-message.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (self), (xmlNode * )0);
#line 1290 "mn-message.c"
{
#line 533 "src/mn-message.gob"
	
    xmlNode *node;

    node = xmlNewNode(NULL, "message");

    xmlSetProp(node, "mailbox", self->mailbox->runtime_name);

    if ((self->flags & MN_MESSAGE_NEW) != 0)
      xmlSetProp(node, "new", "true");

    mn_xml_export_properties(G_OBJECT(self), node);

    return node;
  }}
#line 1307 "mn-message.c"
#undef __GOB_FUNCTION__
