/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-evolution-server.h"

#include "mn-evolution-server-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "src/mn-evolution-server.gob"

#include <stdio.h>
#include <libintl.h>
#include <gobject/gvaluecollector.h>
#include <camel/camel-folder.h>
#include <mail/em-folder-view.h>
#include <mail/em-format.h>
#include <mail/em-message-browser.h>
#include <mail/em-utils.h>
#include <mail/mail-session.h>
#include <mail/mail-tools.h>
#include "mn-evolution.h"
#include "mn-evolution-folder-tree-server.h"
#include "mn-evolution-plugin.h"

/* see https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=208774 */
static GHashTable *folders = NULL;

typedef struct
{
  char		*uri;
  CamelFolder	*folder;
} FolderInfo;

#define MN_EVOLUTION_SERVER_ERROR	(mn_evolution_server_error_quark())

typedef enum
{
  MN_EVOLUTION_SERVER_ERROR_FOLDER_NOT_FOUND,
  MN_EVOLUTION_SERVER_ERROR_MESSAGE_NOT_FOUND,
  MN_EVOLUTION_SERVER_ERROR_FOLDER_TREE_REGISTRATION_FAILED,
} MNEvolutionServerError;

#line 60 "mn-evolution-server.c"
/* self casting macros */
#define SELF(x) MN_EVOLUTION_SERVER(x)
#define SELF_CONST(x) MN_EVOLUTION_SERVER_CONST(x)
#define IS_SELF(x) MN_IS_EVOLUTION_SERVER(x)
#define TYPE_SELF MN_TYPE_EVOLUTION_SERVER
#define SELF_CLASS(x) MN_EVOLUTION_SERVER_CLASS(x)

#define SELF_GET_CLASS(x) MN_EVOLUTION_SERVER_GET_CLASS(x)

/* self typedefs */
typedef MNEvolutionServer Self;
typedef MNEvolutionServerClass SelfClass;

/* here are local prototypes */
#line 0 "src/mn-evolution-server.gob"
static void mn_evolution_server_init (MNEvolutionServer * o);
#line 77 "mn-evolution-server.c"
#line 75 "src/mn-evolution-server.gob"
static void mn_evolution_server_class_init (MNEvolutionServerClass * class);
#line 80 "mn-evolution-server.c"
#line 80 "src/mn-evolution-server.gob"
static GQuark mn_evolution_server_error_quark (void);
#line 83 "mn-evolution-server.c"
#line 86 "src/mn-evolution-server.gob"
static void mn_evolution_server_cache_folder (const char * uri, CamelFolder * folder);
#line 86 "mn-evolution-server.c"
#line 103 "src/mn-evolution-server.gob"
static void mn_evolution_server_folder_info_free (FolderInfo * info);
#line 89 "mn-evolution-server.c"
#line 112 "src/mn-evolution-server.gob"
static void mn_evolution_server_folder_deleted_cb (CamelObject * object, gpointer event_data, gpointer user_data);
#line 92 "mn-evolution-server.c"
#line 124 "src/mn-evolution-server.gob"
static CamelFolder * mn_evolution_server_lookup_folder (const char * uri, GError ** err);
#line 95 "mn-evolution-server.c"
#line 158 "src/mn-evolution-server.gob"
static GValueArray * mn_evolution_server_value_array_new (GType type, ...);
#line 98 "mn-evolution-server.c"
#line 188 "src/mn-evolution-server.gob"
static GValueArray * mn_evolution_server_camel_message_info_to_dbus_struct (CamelMessageInfo * info);
#line 101 "mn-evolution-server.c"
#line 216 "src/mn-evolution-server.gob"
static gboolean mn_evolution_server_get_unseen_messages (MNEvolutionServer * self, const char * folder_uri, GPtrArray ** ret, GError ** err);
#line 104 "mn-evolution-server.c"
#line 253 "src/mn-evolution-server.gob"
static gboolean mn_evolution_server_get_folder_name (MNEvolutionServer * self, const char * folder_uri, char ** ret, GError ** err);
#line 107 "mn-evolution-server.c"
#line 275 "src/mn-evolution-server.gob"
static gboolean mn_evolution_server_open_message (MNEvolutionServer * self, const char * folder_uri, const char * message_uid, GError ** err);
#line 110 "mn-evolution-server.c"
#line 307 "src/mn-evolution-server.gob"
static gboolean mn_evolution_server_set_message_flags (MNEvolutionServer * self, const char * folder_uri, const char * message_uid, unsigned int flags, GError ** err);
#line 113 "mn-evolution-server.c"
#line 337 "src/mn-evolution-server.gob"
static gboolean mn_evolution_server_folder_tree_new (MNEvolutionServer * self, guint32 id, GError ** err);
#line 116 "mn-evolution-server.c"

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__folder_changed(object,func,data)	mn_evolution_server_connect__folder_changed((object),(func),(data))
#define self_connect_after__folder_changed(object,func,data)	mn_evolution_server_connect_after__folder_changed((object),(func),(data))
#define self_connect_data__folder_changed(object,func,data,destroy_data,flags)	mn_evolution_server_connect_data__folder_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__message_reading(object,func,data)	mn_evolution_server_connect__message_reading((object),(func),(data))
#define self_connect_after__message_reading(object,func,data)	mn_evolution_server_connect_after__message_reading((object),(func),(data))
#define self_connect_data__message_reading(object,func,data,destroy_data,flags)	mn_evolution_server_connect_data__message_reading((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNEvolutionServer *, gchar *, gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNEvolutionServer *)data1,
		(gchar *) g_value_get_string (param_values + 1),
		data2);
}


enum {
	FOLDER_CHANGED_SIGNAL,
	MESSAGE_READING_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_folder_changed mn_evolution_server_folder_changed
#define self_message_reading mn_evolution_server_message_reading
#define self_error_quark mn_evolution_server_error_quark
#define self_cache_folder mn_evolution_server_cache_folder
#define self_folder_info_free mn_evolution_server_folder_info_free
#define self_folder_deleted_cb mn_evolution_server_folder_deleted_cb
#define self_lookup_folder mn_evolution_server_lookup_folder
#define self_value_array_new mn_evolution_server_value_array_new
#define self_camel_message_info_to_dbus_struct mn_evolution_server_camel_message_info_to_dbus_struct
#define self_get_unseen_messages mn_evolution_server_get_unseen_messages
#define self_get_folder_name mn_evolution_server_get_folder_name
#define self_open_message mn_evolution_server_open_message
#define self_set_message_flags mn_evolution_server_set_message_flags
#define self_folder_tree_new mn_evolution_server_folder_tree_new
#define self_new mn_evolution_server_new
GType
mn_evolution_server_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNEvolutionServerClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_evolution_server_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNEvolutionServer),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_evolution_server_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNEvolutionServer", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNEvolutionServer *)g_object_new(mn_evolution_server_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNEvolutionServer * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNEvolutionServer *
GET_NEW_VARG (const char *first, ...)
{
	MNEvolutionServer *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNEvolutionServer *)g_object_new_valist (mn_evolution_server_get_type (), first, ap);
	va_end (ap);
	return ret;
}


#line 58 "src/mn-evolution-server.gob"

#include "mn-evolution-server-dbus.h"

#line 234 "mn-evolution-server.c"
static void 
mn_evolution_server_init (MNEvolutionServer * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Evolution:Server::init"
}
#undef __GOB_FUNCTION__
#line 75 "src/mn-evolution-server.gob"
static void 
mn_evolution_server_class_init (MNEvolutionServerClass * class G_GNUC_UNUSED)
{
#line 245 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[FOLDER_CHANGED_SIGNAL] =
		g_signal_new ("folder_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNEvolutionServerClass, folder_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_STRING);
	if ___GOB_UNLIKELY(sizeof(const char * ) != sizeof(gchar *) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-evolution-server.gob line 69: Type mismatch of \"folder_changed\" signal signature");
	}
	object_signals[MESSAGE_READING_SIGNAL] =
		g_signal_new ("message_reading",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNEvolutionServerClass, message_reading),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_STRING);
	if ___GOB_UNLIKELY(sizeof(const char * ) != sizeof(gchar *) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-evolution-server.gob line 72: Type mismatch of \"message_reading\" signal signature");
	}

	class->folder_changed = NULL;
	class->message_reading = NULL;
 {
#line 76 "src/mn-evolution-server.gob"

    dbus_g_object_type_install_info(TYPE_SELF, &dbus_glib_mn_evolution_server_object_info);
  
#line 283 "mn-evolution-server.c"
 }
}
#undef __GOB_FUNCTION__


#line 69 "src/mn-evolution-server.gob"
void 
mn_evolution_server_folder_changed (MNEvolutionServer * self, const char * uri)
{
#line 293 "mn-evolution-server.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 69 "src/mn-evolution-server.gob"
	g_return_if_fail (self != NULL);
#line 69 "src/mn-evolution-server.gob"
	g_return_if_fail (MN_IS_EVOLUTION_SERVER (self));
#line 69 "src/mn-evolution-server.gob"
	g_return_if_fail (uri != NULL);
#line 306 "mn-evolution-server.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_STRING);
	g_value_set_static_string (&___param_values[1], (gchar *) uri);

	g_signal_emitv (___param_values,
		object_signals[FOLDER_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 72 "src/mn-evolution-server.gob"
void 
mn_evolution_server_message_reading (MNEvolutionServer * self, const char * uri)
{
#line 329 "mn-evolution-server.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 72 "src/mn-evolution-server.gob"
	g_return_if_fail (self != NULL);
#line 72 "src/mn-evolution-server.gob"
	g_return_if_fail (MN_IS_EVOLUTION_SERVER (self));
#line 72 "src/mn-evolution-server.gob"
	g_return_if_fail (uri != NULL);
#line 342 "mn-evolution-server.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_STRING);
	g_value_set_static_string (&___param_values[1], (gchar *) uri);

	g_signal_emitv (___param_values,
		object_signals[MESSAGE_READING_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}


#line 80 "src/mn-evolution-server.gob"
static GQuark 
mn_evolution_server_error_quark (void)
{
#line 366 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::error_quark"
{
#line 82 "src/mn-evolution-server.gob"
	
    return g_quark_from_static_string("mn-evolution-server-error");
  }}
#line 373 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 86 "src/mn-evolution-server.gob"
static void 
mn_evolution_server_cache_folder (const char * uri, CamelFolder * folder)
{
#line 380 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::cache_folder"
#line 86 "src/mn-evolution-server.gob"
	g_return_if_fail (uri != NULL);
#line 86 "src/mn-evolution-server.gob"
	g_return_if_fail (folder != NULL);
#line 386 "mn-evolution-server.c"
{
#line 89 "src/mn-evolution-server.gob"
	
    FolderInfo *info;

    info = g_new0(FolderInfo, 1);
    info->uri = g_strdup(uri);
    info->folder = folder;
    camel_object_ref(folder);

    /* uncache the folder when it is deleted */
    camel_object_hook_event(folder, "deleted", self_folder_deleted_cb, info);

    g_hash_table_replace(folders, info->uri, info);
  }}
#line 402 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 103 "src/mn-evolution-server.gob"
static void 
mn_evolution_server_folder_info_free (FolderInfo * info)
{
#line 409 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::folder_info_free"
#line 103 "src/mn-evolution-server.gob"
	g_return_if_fail (info != NULL);
#line 413 "mn-evolution-server.c"
{
#line 105 "src/mn-evolution-server.gob"
	
    camel_object_unhook_event(info->folder, "deleted", self_folder_deleted_cb, info);
    camel_object_unref(info->folder);
    g_free(info->uri);
    g_free(info);
  }}
#line 422 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 112 "src/mn-evolution-server.gob"
static void 
mn_evolution_server_folder_deleted_cb (CamelObject * object, gpointer event_data, gpointer user_data)
{
#line 429 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::folder_deleted_cb"
{
#line 116 "src/mn-evolution-server.gob"
	
    FolderInfo *info = user_data;
    gboolean status;

    status = g_hash_table_remove(folders, info->uri);
    g_assert(status == TRUE);
  }}
#line 440 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 124 "src/mn-evolution-server.gob"
static CamelFolder * 
mn_evolution_server_lookup_folder (const char * uri, GError ** err)
{
#line 447 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::lookup_folder"
#line 124 "src/mn-evolution-server.gob"
	g_return_val_if_fail (uri != NULL, (CamelFolder * )0);
#line 451 "mn-evolution-server.c"
{
#line 126 "src/mn-evolution-server.gob"
	
    CamelFolder *folder = NULL;

    if (folders)
      {
	FolderInfo *info;

	info = g_hash_table_lookup(folders, uri);
	if (info)
	  {
	    folder = info->folder;
	    camel_object_ref(folder);
	  }
      }
    else
      folders = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, (GDestroyNotify) self_folder_info_free);

    if (! folder)
      {
	folder = mail_tool_uri_to_folder(uri, 0, NULL);
	if (folder)
	  self_cache_folder(uri, folder);
	else
	  g_set_error(err,
		      MN_EVOLUTION_SERVER_ERROR,
		      MN_EVOLUTION_SERVER_ERROR_FOLDER_NOT_FOUND,
		      dgettext(GETTEXT_PACKAGE, "folder not found"));
      }

    return folder;
  }}
#line 485 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 158 "src/mn-evolution-server.gob"
static GValueArray * 
mn_evolution_server_value_array_new (GType type, ...)
{
#line 492 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::value_array_new"
{
#line 160 "src/mn-evolution-server.gob"
	
    GValueArray *value_array;
    va_list args;

    value_array = g_value_array_new(0);

    va_start(args, type);

    while (type)
      {
	GValue value = { 0, };
	char *error = NULL;

	g_value_init(&value, type);
	G_VALUE_COLLECT(&value, args, 0, &error);
	g_assert(error == NULL);

	g_value_array_append(value_array, &value);
	g_value_unset(&value);

	type = va_arg(args, GType);
      }

    va_end(args);

    return value_array;
  }}
#line 523 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 188 "src/mn-evolution-server.gob"
static GValueArray * 
mn_evolution_server_camel_message_info_to_dbus_struct (CamelMessageInfo * info)
{
#line 530 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::camel_message_info_to_dbus_struct"
#line 188 "src/mn-evolution-server.gob"
	g_return_val_if_fail (info != NULL, (GValueArray * )0);
#line 534 "mn-evolution-server.c"
{
#line 190 "src/mn-evolution-server.gob"
	
    const CamelSummaryMessageID *id;
    char hexhash[sizeof(CamelSummaryMessageID) * 2 + 1];
    int i;

    id = camel_message_info_message_id(info);
    for (i = 0; i < sizeof(id->id.hash); i++)
      sprintf(hexhash + i * 2, "%.2x", id->id.hash[i]);

    g_assert(camel_message_info_uid(info) != NULL);

    return self_value_array_new(/* char *uid */
				G_TYPE_STRING, camel_message_info_uid(info),
				/* unsigned int sent_time */
				G_TYPE_UINT, (unsigned int) camel_message_info_date_sent(info),
				/* unsigned int received_time */
				G_TYPE_UINT, (unsigned int) camel_message_info_date_received(info),
				/* char *id */
				G_TYPE_STRING, hexhash,
				/* char *from */
				G_TYPE_STRING, camel_message_info_from(info),
				/* char *subject */
				G_TYPE_STRING, camel_message_info_subject(info),
				0);
  }}
#line 562 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 216 "src/mn-evolution-server.gob"
static gboolean 
mn_evolution_server_get_unseen_messages (MNEvolutionServer * self, const char * folder_uri, GPtrArray ** ret, GError ** err)
{
#line 569 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::get_unseen_messages"
#line 216 "src/mn-evolution-server.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 216 "src/mn-evolution-server.gob"
	g_return_val_if_fail (MN_IS_EVOLUTION_SERVER (self), (gboolean )0);
#line 216 "src/mn-evolution-server.gob"
	g_return_val_if_fail (folder_uri != NULL, (gboolean )0);
#line 216 "src/mn-evolution-server.gob"
	g_return_val_if_fail (ret != NULL, (gboolean )0);
#line 579 "mn-evolution-server.c"
{
#line 221 "src/mn-evolution-server.gob"
	
    CamelFolder *folder;

    GDK_THREADS_ENTER();

    folder = self_lookup_folder(folder_uri, err);
    if (folder)
      {
	GPtrArray *summary;
	int i;

	*ret = g_ptr_array_new();

	summary = camel_folder_get_summary(folder);

	for (i = 0; i < summary->len; i++)
	  {
	    CamelMessageInfo *info = summary->pdata[i];

	    if ((camel_message_info_flags(info) & CAMEL_MESSAGE_SEEN) == 0)
	      g_ptr_array_add(*ret, self_camel_message_info_to_dbus_struct(info));
	  }

	camel_folder_free_summary(folder, summary);
	camel_object_unref(folder);
      }

    GDK_THREADS_LEAVE();

    return folder != NULL;
  }}
#line 613 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 253 "src/mn-evolution-server.gob"
static gboolean 
mn_evolution_server_get_folder_name (MNEvolutionServer * self, const char * folder_uri, char ** ret, GError ** err)
{
#line 620 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::get_folder_name"
#line 253 "src/mn-evolution-server.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 253 "src/mn-evolution-server.gob"
	g_return_val_if_fail (MN_IS_EVOLUTION_SERVER (self), (gboolean )0);
#line 253 "src/mn-evolution-server.gob"
	g_return_val_if_fail (folder_uri != NULL, (gboolean )0);
#line 253 "src/mn-evolution-server.gob"
	g_return_val_if_fail (ret != NULL, (gboolean )0);
#line 630 "mn-evolution-server.c"
{
#line 258 "src/mn-evolution-server.gob"
	
    CamelFolder *folder;

    GDK_THREADS_ENTER();

    folder = self_lookup_folder(folder_uri, err);
    if (folder)
      {
	*ret = g_strdup(camel_folder_get_name(folder));
	camel_object_unref(folder);
      }

    GDK_THREADS_LEAVE();

    return folder != NULL;
  }}
#line 649 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 275 "src/mn-evolution-server.gob"
static gboolean 
mn_evolution_server_open_message (MNEvolutionServer * self, const char * folder_uri, const char * message_uid, GError ** err)
{
#line 656 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::open_message"
#line 275 "src/mn-evolution-server.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 275 "src/mn-evolution-server.gob"
	g_return_val_if_fail (MN_IS_EVOLUTION_SERVER (self), (gboolean )0);
#line 275 "src/mn-evolution-server.gob"
	g_return_val_if_fail (folder_uri != NULL, (gboolean )0);
#line 275 "src/mn-evolution-server.gob"
	g_return_val_if_fail (message_uid != NULL, (gboolean )0);
#line 666 "mn-evolution-server.c"
{
#line 280 "src/mn-evolution-server.gob"
	
    CamelFolder *folder;

    GDK_THREADS_ENTER();

    folder = self_lookup_folder(folder_uri, err);
    if (folder)
      {
	GtkWidget *browser;

	/* modelled after Evolution's handleuri_got_folder() */

	browser = em_message_browser_window_new();

	em_format_set_session((EMFormat *) ((EMFolderView *) browser)->preview, session);
	em_folder_view_set_folder((EMFolderView *) browser, folder, folder_uri);
	em_folder_view_set_message((EMFolderView *) browser, message_uid, FALSE);
	gtk_widget_show(((EMMessageBrowser *) browser)->window);

	camel_object_unref(folder);
      }

    GDK_THREADS_LEAVE();

    return folder != NULL;
  }}
#line 695 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 307 "src/mn-evolution-server.gob"
static gboolean 
mn_evolution_server_set_message_flags (MNEvolutionServer * self, const char * folder_uri, const char * message_uid, unsigned int flags, GError ** err)
{
#line 702 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::set_message_flags"
#line 307 "src/mn-evolution-server.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 307 "src/mn-evolution-server.gob"
	g_return_val_if_fail (MN_IS_EVOLUTION_SERVER (self), (gboolean )0);
#line 307 "src/mn-evolution-server.gob"
	g_return_val_if_fail (folder_uri != NULL, (gboolean )0);
#line 307 "src/mn-evolution-server.gob"
	g_return_val_if_fail (message_uid != NULL, (gboolean )0);
#line 712 "mn-evolution-server.c"
{
#line 313 "src/mn-evolution-server.gob"
	
    CamelFolder *folder;
    gboolean status = FALSE;

    GDK_THREADS_ENTER();

    folder = self_lookup_folder(folder_uri, err);
    if (folder)
      {
	status = camel_folder_set_message_flags(folder, message_uid, flags, flags);
	camel_object_unref(folder);

	if (! status)
	  g_set_error(err,
		      MN_EVOLUTION_SERVER_ERROR,
		      MN_EVOLUTION_SERVER_ERROR_MESSAGE_NOT_FOUND,
		      dgettext(GETTEXT_PACKAGE, "message not found"));
      }

    GDK_THREADS_LEAVE();

    return status;
  }}
#line 738 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 337 "src/mn-evolution-server.gob"
static gboolean 
mn_evolution_server_folder_tree_new (MNEvolutionServer * self, guint32 id, GError ** err)
{
#line 745 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::folder_tree_new"
#line 337 "src/mn-evolution-server.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 337 "src/mn-evolution-server.gob"
	g_return_val_if_fail (MN_IS_EVOLUTION_SERVER (self), (gboolean )0);
#line 751 "mn-evolution-server.c"
{
#line 339 "src/mn-evolution-server.gob"
	
    MNEvolutionFolderTreeServer *tree;
    char *service;
    char *path;
    GError *tmp_err = NULL;
    gboolean status;

    GDK_THREADS_ENTER();

    tree = mn_evolution_folder_tree_server_new(id);

    service = g_strdup_printf(MN_EVOLUTION_FOLDER_TREE_SERVER_SERVICE, id);
    path = g_strdup_printf(MN_EVOLUTION_FOLDER_TREE_SERVER_PATH, id);

    status = mn_evolution_plugin_register_server(G_OBJECT(tree), service, path, &tmp_err);

    g_free(service);
    g_free(path);

    if (! status)
      {
	/* unlikely to ever happen, not worth a translation */
	g_set_error(err,
		    MN_EVOLUTION_SERVER_ERROR,
		    MN_EVOLUTION_SERVER_ERROR_FOLDER_TREE_REGISTRATION_FAILED,
		    "cannot register folder tree server: %s", tmp_err->message);
	g_error_free(tmp_err);
	g_object_unref(tree);
      }

    GDK_THREADS_LEAVE();

    return status;
  }}
#line 788 "mn-evolution-server.c"
#undef __GOB_FUNCTION__

#line 374 "src/mn-evolution-server.gob"
MNEvolutionServer * 
mn_evolution_server_new (void)
{
#line 795 "mn-evolution-server.c"
#define __GOB_FUNCTION__ "MN:Evolution:Server::new"
{
#line 376 "src/mn-evolution-server.gob"
	
    return GET_NEW;
  }}
#line 802 "mn-evolution-server.c"
#undef __GOB_FUNCTION__
