/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox.h"

#include "mn-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 56 "src/mn-mailbox.gob"

#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs.h>
#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
#include "mn-system-vfs-mailbox.h"
#include "mn-custom-vfs-mailbox.h"
#endif
#if WITH_POP3
#include "mn-pop3-mailbox.h"
#endif
#if WITH_IMAP
#include "mn-imap-mailbox.h"
#endif
#if WITH_GMAIL
#include "mn-gmail-mailbox.h"
#endif
#if WITH_YAHOO
#include "mn-yahoo-mailbox.h"
#endif
#if WITH_HOTMAIL
#include "mn-hotmail-mailbox.h"
#endif
#if WITH_EVOLUTION
#include "mn-evolution-mailbox.h"
#endif
#include "mn-util.h"
#include "mn-message.h"
#include "mn-conf.h"
#include "mn-locked-callback.h"

struct _MNMailboxConfiguration
{
  GType		type;
  unsigned int	n_parameters;
  GParameter	*parameters;
};

GType mn_mailbox_types[MN_MAILBOX_MAX_TYPES + 1];

typedef struct
{
  GHashTable	*other;
  gboolean	changed;
} CompareMessagesInfo;

#line 72 "mn-mailbox.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX(x)
#define SELF_CONST(x) MN_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_MAILBOX
#define SELF_CLASS(x) MN_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNMailbox Self;
typedef MNMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-mailbox.gob"
static void mn_mailbox_class_init (MNMailboxClass * c);
#line 91 "mn-mailbox.c"
#line 130 "src/mn-mailbox.gob"
static void mn_mailbox_set_active (MNMailbox * self, gboolean value);
#line 94 "mn-mailbox.c"
static void ___real_mn_mailbox_added (MNMailbox * self);
static void ___real_mn_mailbox_removed (MNMailbox * self);
#line 234 "src/mn-mailbox.gob"
static void mn_mailbox_update_check_timeout (MNMailbox * self);
#line 99 "mn-mailbox.c"
#line 291 "src/mn-mailbox.gob"
static void mn_mailbox_filter_messages (MNMailbox * self);
#line 102 "mn-mailbox.c"
#line 357 "src/mn-mailbox.gob"
static gboolean mn_mailbox_remove_stale_messages_cb (gpointer key, MNMessage * message, GHashTable * messages);
#line 105 "mn-mailbox.c"
#line 375 "src/mn-mailbox.gob"
static gboolean mn_mailbox_compare_messages (GHashTable * messages1, GHashTable * messages2);
#line 108 "mn-mailbox.c"
#line 387 "src/mn-mailbox.gob"
static void mn_mailbox_compare_messages_cb (const char * id, MNMessage * message, CompareMessagesInfo * info);
#line 111 "mn-mailbox.c"
#line 409 "src/mn-mailbox.gob"
static void mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new);
#line 114 "mn-mailbox.c"
#line 502 "src/mn-mailbox.gob"
static void mn_mailbox_init (MNMailbox * self);
#line 117 "mn-mailbox.c"
#line 507 "src/mn-mailbox.gob"
static void mn_mailbox_finalize (MNMailbox * self);
#line 120 "mn-mailbox.c"
#line 518 "src/mn-mailbox.gob"
static void mn_mailbox_notify_display_seen_messages_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data);
#line 123 "mn-mailbox.c"
#line 703 "src/mn-mailbox.gob"
static MNMailbox * mn_mailbox_parse_obsolete_uri (const char * uri);
#line 126 "mn-mailbox.c"
#line 927 "src/mn-mailbox.gob"
static gboolean mn_mailbox_check_timeout_cb (gpointer data);
#line 129 "mn-mailbox.c"
#line 937 "src/mn-mailbox.gob"
static gboolean mn_mailbox_validate (MNMailbox * self, GError ** err);
#line 132 "mn-mailbox.c"
static void ___real_mn_mailbox_seal (MNMailbox * self);
#line 1001 "src/mn-mailbox.gob"
static MNMailbox * mn_mailbox_parse_uri (MNMailbox * self, const char * uri) G_GNUC_UNUSED;
#line 136 "mn-mailbox.c"
static void ___real_mn_mailbox_check (MNMailbox * self);
#line 1072 "src/mn-mailbox.gob"
static void mn_mailbox_consider_as_read_real (MNMailbox * self, MNMessage * message);
#line 140 "mn-mailbox.c"

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__added(object,func,data)	mn_mailbox_connect__added((object),(func),(data))
#define self_connect_after__added(object,func,data)	mn_mailbox_connect_after__added((object),(func),(data))
#define self_connect_data__added(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__added((object),(func),(data),(destroy_data),(flags))
#define self_connect__removed(object,func,data)	mn_mailbox_connect__removed((object),(func),(data))
#define self_connect_after__removed(object,func,data)	mn_mailbox_connect_after__removed((object),(func),(data))
#define self_connect_data__removed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__removed((object),(func),(data),(destroy_data),(flags))
#define self_connect__messages_changed(object,func,data)	mn_mailbox_connect__messages_changed((object),(func),(data))
#define self_connect_after__messages_changed(object,func,data)	mn_mailbox_connect_after__messages_changed((object),(func),(data))
#define self_connect_data__messages_changed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__messages_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNMailbox *, gboolean , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailbox *)data1,
		(gboolean ) g_value_get_boolean (param_values + 1),
		data2);
}


enum {
	ADDED_SIGNAL,
	REMOVED_SIGNAL,
	MESSAGES_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_NAME,
	PROP_OPEN_COMMAND,
	PROP_MARK_AS_READ_COMMAND,
	PROP_MARK_AS_SPAM_COMMAND,
	PROP_DELETE_COMMAND,
	PROP_STOCK_ID,
	PROP_FORMAT,
	PROP_CHECK_DELAY,
	PROP_POLL,
	PROP_MANUALLY_CHECKABLE,
	PROP_MESSAGES,
	PROP_ERROR
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_active mn_mailbox_get_active
#define self_set_active mn_mailbox_set_active
#define self_added mn_mailbox_added
#define self_removed mn_mailbox_removed
#define self_get_stock_id mn_mailbox_get_stock_id
#define self_set_stock_id mn_mailbox_set_stock_id
#define self_get_format mn_mailbox_get_format
#define self_set_format mn_mailbox_set_format
#define self_get_poll mn_mailbox_get_poll
#define self_set_poll mn_mailbox_set_poll
#define self_get_manually_checkable mn_mailbox_get_manually_checkable
#define self_update_check_timeout mn_mailbox_update_check_timeout
#define self_set_messages mn_mailbox_set_messages
#define self_filter_messages mn_mailbox_filter_messages
#define self_remove_stale_messages_cb mn_mailbox_remove_stale_messages_cb
#define self_compare_messages mn_mailbox_compare_messages
#define self_compare_messages_cb mn_mailbox_compare_messages_cb
#define self_messages_changed mn_mailbox_messages_changed
#define self_set_error mn_mailbox_set_error
#define self_init_types mn_mailbox_init_types
#define self_get_class_from_name mn_mailbox_get_class_from_name
#define self_get_type_from_name mn_mailbox_get_type_from_name
#define self_notify_display_seen_messages_cb mn_mailbox_notify_display_seen_messages_cb
#define self_new mn_mailbox_new
#define self_new_from_xml_node mn_mailbox_new_from_xml_node
#define self_xml_node_new mn_mailbox_xml_node_new
#define self_new_from_uri mn_mailbox_new_from_uri
#define self_new_from_configuration mn_mailbox_new_from_configuration
#define self_get_configuration mn_mailbox_get_configuration
#define self_configuration_free mn_mailbox_configuration_free
#define self_new_from_obsolete_uri mn_mailbox_new_from_obsolete_uri
#define self_parse_obsolete_uri mn_mailbox_parse_obsolete_uri
#define self_check_timeout_cb mn_mailbox_check_timeout_cb
#define self_validate mn_mailbox_validate
#define self_seal mn_mailbox_seal
#define self_parse_uri mn_mailbox_parse_uri
#define self_check mn_mailbox_check
#define self_enable_checking mn_mailbox_enable_checking
#define self_notice mn_mailbox_notice
#define self_warning mn_mailbox_warning
#define self_get_message_from_mid mn_mailbox_get_message_from_mid
#define self_consider_as_read_real mn_mailbox_consider_as_read_real
#define self_consider_as_read mn_mailbox_consider_as_read
#define self_consider_as_read_list mn_mailbox_consider_as_read_list
#define self_get_command mn_mailbox_get_command
#define self_has_command mn_mailbox_has_command
GType
mn_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailbox *)g_object_new(mn_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailbox *)g_object_new_valist (mn_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
	MNMailbox *self G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 507 "src/mn-mailbox.gob"
	mn_mailbox_finalize (self);
#line 313 "mn-mailbox.c"
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 167 "src/mn-mailbox.gob"
	if(self->runtime_name) { g_free ((gpointer) self->runtime_name); self->runtime_name = NULL; }
#line 318 "mn-mailbox.c"
#line 169 "src/mn-mailbox.gob"
	if(self->name) { g_free ((gpointer) self->name); self->name = NULL; }
#line 321 "mn-mailbox.c"
#line 172 "src/mn-mailbox.gob"
	if(self->open_command) { g_free ((gpointer) self->open_command); self->open_command = NULL; }
#line 324 "mn-mailbox.c"
#line 175 "src/mn-mailbox.gob"
	if(self->mark_as_read_command) { g_free ((gpointer) self->mark_as_read_command); self->mark_as_read_command = NULL; }
#line 327 "mn-mailbox.c"
#line 178 "src/mn-mailbox.gob"
	if(self->mark_as_spam_command) { g_free ((gpointer) self->mark_as_spam_command); self->mark_as_spam_command = NULL; }
#line 330 "mn-mailbox.c"
#line 181 "src/mn-mailbox.gob"
	if(self->delete_command) { g_free ((gpointer) self->delete_command); self->delete_command = NULL; }
#line 333 "mn-mailbox.c"
#line 184 "src/mn-mailbox.gob"
	if(self->stock_id) { g_free ((gpointer) self->stock_id); self->stock_id = NULL; }
#line 336 "mn-mailbox.c"
#line 187 "src/mn-mailbox.gob"
	if(self->format) { g_free ((gpointer) self->format); self->format = NULL; }
#line 339 "mn-mailbox.c"
#line 246 "src/mn-mailbox.gob"
	if(self->_priv->all_messages) { mn_g_object_slist_free ((gpointer) self->_priv->all_messages); self->_priv->all_messages = NULL; }
#line 342 "mn-mailbox.c"
#line 249 "src/mn-mailbox.gob"
	if(self->_priv->all_messages_mid_hash_table) { g_hash_table_destroy ((gpointer) self->_priv->all_messages_mid_hash_table); self->_priv->all_messages_mid_hash_table = NULL; }
#line 345 "mn-mailbox.c"
#line 256 "src/mn-mailbox.gob"
	if(self->_priv->all_messages_considered_as_read) { g_hash_table_destroy ((gpointer) self->_priv->all_messages_considered_as_read); self->_priv->all_messages_considered_as_read = NULL; }
#line 348 "mn-mailbox.c"
#line 259 "src/mn-mailbox.gob"
	if(self->messages) { mn_g_object_ptr_array_free ((gpointer) self->messages); self->messages = NULL; }
#line 351 "mn-mailbox.c"
#line 262 "src/mn-mailbox.gob"
	if(self->_priv->messages_hash_table) { g_hash_table_destroy ((gpointer) self->_priv->messages_hash_table); self->_priv->messages_hash_table = NULL; }
#line 354 "mn-mailbox.c"
#line 412 "src/mn-mailbox.gob"
	if(self->error) { g_free ((gpointer) self->error); self->error = NULL; }
#line 357 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailbox_class_init (MNMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMailboxPrivate));
#line 56 "src/mn-mailbox.gob"
	c->default_check_delay = -1;
#line 370 "mn-mailbox.c"
#line 56 "src/mn-mailbox.gob"
	c->enable_checking_when_added = TRUE;
#line 373 "mn-mailbox.c"

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[ADDED_SIGNAL] =
		g_signal_new ("added",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, added),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[REMOVED_SIGNAL] =
		g_signal_new ("removed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[MESSAGES_CHANGED_SIGNAL] =
		g_signal_new ("messages_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxClass, messages_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_BOOLEAN);
	if ___GOB_UNLIKELY(sizeof(gboolean ) != sizeof(gboolean ) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-mailbox.gob line 409: Type mismatch of \"messages_changed\" signal signature");
	}

#line 143 "src/mn-mailbox.gob"
	c->added = ___real_mn_mailbox_added;
#line 159 "src/mn-mailbox.gob"
	c->removed = ___real_mn_mailbox_removed;
#line 410 "mn-mailbox.c"
	c->messages_changed = NULL;
#line 986 "src/mn-mailbox.gob"
	c->seal = ___real_mn_mailbox_seal;
#line 414 "mn-mailbox.c"
	c->parse_uri = NULL;
#line 1004 "src/mn-mailbox.gob"
	c->check = ___real_mn_mailbox_check;
#line 418 "mn-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_string
		("open_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_OPEN_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("mark_as_read_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_MARK_AS_READ_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("mark_as_spam_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_MARK_AS_SPAM_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("delete_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE));
	g_object_class_install_property (g_object_class,
		PROP_DELETE_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("stock_id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_STOCK_ID,
		param_spec);
	param_spec = g_param_spec_string
		("format" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_FORMAT,
		param_spec);
	param_spec = g_param_spec_int
		("check_delay" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 -1 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_LOAD_SAVE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CHECK_DELAY,
		param_spec);
	param_spec = g_param_spec_boolean
		("poll" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_POLL,
		param_spec);
	param_spec = g_param_spec_boolean
		("manually_checkable" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_MANUALLY_CHECKABLE,
		param_spec);
	param_spec = g_param_spec_pointer
		("messages" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGES,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 502 "src/mn-mailbox.gob"
static void 
mn_mailbox_init (MNMailbox * self G_GNUC_UNUSED)
{
#line 541 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_MAILBOX,MNMailboxPrivate);
#line 161 "src/mn-mailbox.gob"
	self->_priv->poll = TRUE;
#line 546 "mn-mailbox.c"
#line 249 "src/mn-mailbox.gob"
	self->_priv->all_messages_mid_hash_table = g_hash_table_new(g_str_hash, g_str_equal);
#line 549 "mn-mailbox.c"
#line 256 "src/mn-mailbox.gob"
	self->_priv->all_messages_considered_as_read = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_object_unref);
#line 552 "mn-mailbox.c"
#line 259 "src/mn-mailbox.gob"
	self->messages = g_ptr_array_new();
#line 555 "mn-mailbox.c"
#line 262 "src/mn-mailbox.gob"
	self->_priv->messages_hash_table = g_hash_table_new(g_str_hash, g_str_equal);
#line 558 "mn-mailbox.c"
 {
#line 503 "src/mn-mailbox.gob"

    mn_g_object_gconf_notification_add_gdk_locked(self, MN_CONF_DISPLAY_SEEN_MAIL, self_notify_display_seen_messages_cb, self);
  
#line 564 "mn-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::set_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 170 "src/mn-mailbox.gob"
{ char *old = self->name; self->name = g_value_dup_string (VAL); g_free (old); }
#line 585 "mn-mailbox.c"
		}
		break;
	case PROP_OPEN_COMMAND:
		{
#line 173 "src/mn-mailbox.gob"
{ char *old = self->open_command; self->open_command = g_value_dup_string (VAL); g_free (old); }
#line 592 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_READ_COMMAND:
		{
#line 176 "src/mn-mailbox.gob"
{ char *old = self->mark_as_read_command; self->mark_as_read_command = g_value_dup_string (VAL); g_free (old); }
#line 599 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_SPAM_COMMAND:
		{
#line 179 "src/mn-mailbox.gob"
{ char *old = self->mark_as_spam_command; self->mark_as_spam_command = g_value_dup_string (VAL); g_free (old); }
#line 606 "mn-mailbox.c"
		}
		break;
	case PROP_DELETE_COMMAND:
		{
#line 182 "src/mn-mailbox.gob"
{ char *old = self->delete_command; self->delete_command = g_value_dup_string (VAL); g_free (old); }
#line 613 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 185 "src/mn-mailbox.gob"
{ char *old = self->stock_id; self->stock_id = g_value_dup_string (VAL); g_free (old); }
#line 620 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 188 "src/mn-mailbox.gob"
{ char *old = self->format; self->format = g_value_dup_string (VAL); g_free (old); }
#line 627 "mn-mailbox.c"
		}
		break;
	case PROP_CHECK_DELAY:
		{
#line 195 "src/mn-mailbox.gob"
self->check_delay = g_value_get_int (VAL);
#line 634 "mn-mailbox.c"
		}
		break;
	case PROP_POLL:
		{
#line 202 "src/mn-mailbox.gob"

      gboolean new_poll = g_value_get_boolean(VAL);

      /*
       * We do nothing unless the property has changed, because we do
       * not want to reset an already existing check timeout.
       */
      if (new_poll != selfp->poll)
	{
	  selfp->poll = new_poll;
	  if (self_get_active(self) && selfp->checking_enabled)
	    self_update_check_timeout(self);

	  g_object_notify(G_OBJECT(self), "manually-checkable");
	}
    
#line 656 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 413 "src/mn-mailbox.gob"
{ char *old = self->error; self->error = g_value_dup_string (VAL); g_free (old); }
#line 663 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::get_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 170 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->name);
#line 694 "mn-mailbox.c"
		}
		break;
	case PROP_OPEN_COMMAND:
		{
#line 173 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->open_command);
#line 701 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_READ_COMMAND:
		{
#line 176 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->mark_as_read_command);
#line 708 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_SPAM_COMMAND:
		{
#line 179 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->mark_as_spam_command);
#line 715 "mn-mailbox.c"
		}
		break;
	case PROP_DELETE_COMMAND:
		{
#line 182 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->delete_command);
#line 722 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 185 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->stock_id);
#line 729 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 188 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->format);
#line 736 "mn-mailbox.c"
		}
		break;
	case PROP_CHECK_DELAY:
		{
#line 195 "src/mn-mailbox.gob"
g_value_set_int (VAL, self->check_delay);
#line 743 "mn-mailbox.c"
		}
		break;
	case PROP_POLL:
		{
#line 219 "src/mn-mailbox.gob"

      g_value_set_boolean(VAL, selfp->poll);
    
#line 752 "mn-mailbox.c"
		}
		break;
	case PROP_MANUALLY_CHECKABLE:
		{
#line 230 "src/mn-mailbox.gob"

      g_value_set_boolean(VAL, selfp->checking_enabled && selfp->poll);
    
#line 761 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 269 "src/mn-mailbox.gob"

      g_value_set_pointer(VAL, self->messages);
    
#line 770 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 413 "src/mn-mailbox.gob"
g_value_set_string (VAL, self->error);
#line 777 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 124 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_get_active (MNMailbox * self)
{
#line 797 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_active"
#line 124 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 124 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 803 "mn-mailbox.c"
{
#line 126 "src/mn-mailbox.gob"
	
    return g_atomic_int_get(&selfp->_active);
  }}
#line 809 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 130 "src/mn-mailbox.gob"
static void 
mn_mailbox_set_active (MNMailbox * self, gboolean value)
{
#line 816 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_active"
#line 130 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 130 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 822 "mn-mailbox.c"
{
#line 132 "src/mn-mailbox.gob"
	
    g_atomic_int_set(&selfp->_active, value);
  }}
#line 828 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_added:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is added to the
 * mailboxes list.
 **/
#line 143 "src/mn-mailbox.gob"
void 
mn_mailbox_added (MNMailbox * self)
{
#line 842 "mn-mailbox.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 143 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 143 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 853 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ADDED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 143 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_added (MNMailbox * self)
{
#line 870 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::added"
{
#line 145 "src/mn-mailbox.gob"
	
    self_set_active(self, TRUE);

    if (SELF_GET_CLASS(self)->enable_checking_when_added)
      self_enable_checking(self);
  }}
#line 880 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_removed:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is removed from the
 * mailboxes list.
 **/
#line 159 "src/mn-mailbox.gob"
void 
mn_mailbox_removed (MNMailbox * self)
{
#line 894 "mn-mailbox.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 159 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 159 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 905 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[REMOVED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 159 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_removed (MNMailbox * self)
{
#line 922 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::removed"
{
#line 161 "src/mn-mailbox.gob"
	
    self_set_active(self, FALSE);

    mn_source_clear(&selfp->check_timeout_id);
  }}
#line 931 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 185 "src/mn-mailbox.gob"
gchar * 
mn_mailbox_get_stock_id (MNMailbox * self)
{
#line 938 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_stock_id"
{
#line 185 "src/mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "stock_id", &val, NULL); return val;
}}
#line 944 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 185 "src/mn-mailbox.gob"
void 
mn_mailbox_set_stock_id (MNMailbox * self, gchar * val)
{
#line 951 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_stock_id"
{
#line 185 "src/mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "stock_id", val, NULL);
}}
#line 957 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 188 "src/mn-mailbox.gob"
gchar * 
mn_mailbox_get_format (MNMailbox * self)
{
#line 964 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_format"
{
#line 188 "src/mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "format", &val, NULL); return val;
}}
#line 970 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 188 "src/mn-mailbox.gob"
void 
mn_mailbox_set_format (MNMailbox * self, gchar * val)
{
#line 977 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_format"
{
#line 188 "src/mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "format", val, NULL);
}}
#line 983 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 219 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_get_poll (MNMailbox * self)
{
#line 990 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_poll"
{
#line 200 "src/mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "poll", &val, NULL); return val;
}}
#line 996 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 202 "src/mn-mailbox.gob"
void 
mn_mailbox_set_poll (MNMailbox * self, gboolean val)
{
#line 1003 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_poll"
{
#line 200 "src/mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "poll", val, NULL);
}}
#line 1009 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 230 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_get_manually_checkable (MNMailbox * self)
{
#line 1016 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_manually_checkable"
{
#line 228 "src/mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "manually_checkable", &val, NULL); return val;
}}
#line 1022 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 234 "src/mn-mailbox.gob"
static void 
mn_mailbox_update_check_timeout (MNMailbox * self)
{
#line 1029 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::update_check_timeout"
#line 234 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 234 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1035 "mn-mailbox.c"
{
#line 236 "src/mn-mailbox.gob"
	
    g_assert(self_get_active(self) == TRUE);
    g_assert(selfp->checking_enabled == TRUE);

    mn_source_clear(&selfp->check_timeout_id);
    if (selfp->poll && self->runtime_check_delay > 0)
      selfp->check_timeout_id = gdk_threads_add_timeout(self->runtime_check_delay * 1000, self_check_timeout_cb, self);
  }}
#line 1046 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 273 "src/mn-mailbox.gob"
void 
mn_mailbox_set_messages (MNMailbox * self, GSList * messages)
{
#line 1053 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_messages"
#line 273 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 273 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1059 "mn-mailbox.c"
{
#line 275 "src/mn-mailbox.gob"
	
    mn_g_object_slist_free(selfp->all_messages);
    selfp->all_messages = mn_g_object_slist_copy(messages);

    self_filter_messages(self);
  }}
#line 1068 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_filter_messages:
 * @self: the mailbox to act upon
 *
 * Filters @self->all_messages with the "seen mail" filter and
 * @selfp->all_messages_considered_as_read, and stores the resulting
 * list in @self->messages. Additionally, if @self->messages has
 * changed, emits the "messages-changed" signal.
 **/
#line 291 "src/mn-mailbox.gob"
static void 
mn_mailbox_filter_messages (MNMailbox * self)
{
#line 1084 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::filter_messages"
#line 291 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 291 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1090 "mn-mailbox.c"
{
#line 293 "src/mn-mailbox.gob"
	
    GPtrArray *messages;
    GHashTable *all_messages_hash_table;
    GHashTable *messages_hash_table;
    gboolean display_seen_mail;
    GSList *l;
    gboolean changed = FALSE;
    gboolean has_new = FALSE;

    /* filter messages */

    messages = g_ptr_array_new();
    self->timestamp = 0;

    all_messages_hash_table = g_hash_table_new(g_str_hash, g_str_equal);
    messages_hash_table = g_hash_table_new(g_str_hash, g_str_equal);

    display_seen_mail = mn_conf_get_bool(MN_CONF_DISPLAY_SEEN_MAIL);

    MN_LIST_FOREACH(l, selfp->all_messages)
      {
	MNMessage *message = l->data;

	g_hash_table_replace(all_messages_hash_table, message->id, message);

	if (message->mid)
	  g_hash_table_replace(selfp->all_messages_mid_hash_table, message->mid, message);

	if ((display_seen_mail || (message->flags & MN_MESSAGE_NEW) != 0)
	    && ! g_hash_table_lookup(selfp->all_messages_considered_as_read, message->id))
	  {
	    if (message->sent_time > self->timestamp)
	      self->timestamp = message->sent_time;

	    g_ptr_array_add(messages, g_object_ref(message));
	    g_hash_table_replace(messages_hash_table, message->id, message);
	  }
      }

    /* remove stale messages */
    g_hash_table_foreach_remove(selfp->all_messages_mid_hash_table, (GHRFunc) self_remove_stale_messages_cb, all_messages_hash_table);
    g_hash_table_foreach_remove(selfp->all_messages_considered_as_read, (GHRFunc) self_remove_stale_messages_cb, all_messages_hash_table);

    g_hash_table_destroy(all_messages_hash_table);

    /* detect changes */

    if (self_compare_messages(selfp->messages_hash_table, messages_hash_table))
      changed = TRUE;
    if (self_compare_messages(messages_hash_table, selfp->messages_hash_table))
      changed = has_new = TRUE;

    mn_g_object_ptr_array_free(self->messages);
    self->messages = messages;

    g_hash_table_destroy(selfp->messages_hash_table);
    selfp->messages_hash_table = messages_hash_table;

    g_object_notify(G_OBJECT(self), "messages");

    if (changed)
      self_messages_changed(self, has_new);
  }}
#line 1156 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 357 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_remove_stale_messages_cb (gpointer key, MNMessage * message, GHashTable * messages)
{
#line 1163 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::remove_stale_messages_cb"
{
#line 361 "src/mn-mailbox.gob"
	
    return g_hash_table_lookup(messages, message->id) == NULL;
  }}
#line 1170 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_compare_messages:
 * @messages1: a %GHashTable containing %MNMessage objects
 * @messages2: another %GHashTable containing %MNMessage objects
 *
 * Compares @messages1 and @messages2.
 *
 * Return value: %TRUE if @messages1 contains messages not present
 * in @messages2, %FALSE otherwise.
 **/
#line 375 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_compare_messages (GHashTable * messages1, GHashTable * messages2)
{
#line 1187 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::compare_messages"
{
#line 377 "src/mn-mailbox.gob"
	
    CompareMessagesInfo info;

    info.other = messages2;
    info.changed = FALSE;
    g_hash_table_foreach(messages1, (GHFunc) self_compare_messages_cb, &info);

    return info.changed;
  }}
#line 1200 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 387 "src/mn-mailbox.gob"
static void 
mn_mailbox_compare_messages_cb (const char * id, MNMessage * message, CompareMessagesInfo * info)
{
#line 1207 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::compare_messages_cb"
{
#line 391 "src/mn-mailbox.gob"
	
    if (! info->changed && ! g_hash_table_lookup(info->other, id))
      info->changed = TRUE;
  }}
#line 1215 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 409 "src/mn-mailbox.gob"
static void 
mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new)
{
#line 1222 "mn-mailbox.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 409 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 409 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1233 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_BOOLEAN);
	g_value_set_boolean (&___param_values[1], (gboolean ) has_new);

	g_signal_emitv (___param_values,
		object_signals[MESSAGES_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 416 "src/mn-mailbox.gob"
void 
mn_mailbox_set_error (MNMailbox * self, const char * format, ...)
{
#line 1256 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::set_error"
#line 416 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 416 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1262 "mn-mailbox.c"
{
#line 418 "src/mn-mailbox.gob"
	
    char *error = NULL;

    if (format)
      MN_STRDUP_VPRINTF(error, format);

    g_object_set(G_OBJECT(self), MN_MAILBOX_PROP_ERROR(error), NULL);
    g_free(error);
  }}
#line 1274 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 428 "src/mn-mailbox.gob"
void 
mn_mailbox_init_types (void)
{
#line 1281 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::init_types"
{
#line 430 "src/mn-mailbox.gob"
	
    int i = 0;

#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
    /*
     * MNSystemVFSMailbox must be registered before
     * MNCustomVFSMailbox, because the latter's parse_uri() method
     * will accept any URI.
     */
    mn_mailbox_types[i++] = MN_TYPE_SYSTEM_VFS_MAILBOX;
    mn_mailbox_types[i++] = MN_TYPE_CUSTOM_VFS_MAILBOX;
#endif
#if WITH_POP3
    mn_mailbox_types[i++] = MN_TYPE_POP3_MAILBOX;
#endif
#if WITH_IMAP
    mn_mailbox_types[i++] = MN_TYPE_IMAP_MAILBOX;
#endif
#if WITH_GMAIL
    mn_mailbox_types[i++] = MN_TYPE_GMAIL_MAILBOX;
#endif
#if WITH_YAHOO
    mn_mailbox_types[i++] = MN_TYPE_YAHOO_MAILBOX;
#endif
#if WITH_HOTMAIL
    mn_mailbox_types[i++] = MN_TYPE_HOTMAIL_MAILBOX;
#endif
#if WITH_EVOLUTION
    mn_mailbox_types[i++] = MN_TYPE_EVOLUTION_MAILBOX;
#endif
    mn_mailbox_types[i] = 0;
  }}
#line 1317 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 464 "src/mn-mailbox.gob"
MNMailboxClass * 
mn_mailbox_get_class_from_name (const char * type)
{
#line 1324 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_class_from_name"
#line 464 "src/mn-mailbox.gob"
	g_return_val_if_fail (type != NULL, (MNMailboxClass * )0);
#line 1328 "mn-mailbox.c"
{
#line 466 "src/mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	SelfClass *class;

	class = g_type_class_ref(mn_mailbox_types[i]);
	if (! strcmp(class->type, type))
	  return class;

	g_type_class_unref(class);
      }

    return NULL;
  }}
#line 1347 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 483 "src/mn-mailbox.gob"
GType 
mn_mailbox_get_type_from_name (const char * type)
{
#line 1354 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_type_from_name"
#line 483 "src/mn-mailbox.gob"
	g_return_val_if_fail (type != NULL, (GType )0);
#line 1358 "mn-mailbox.c"
{
#line 485 "src/mn-mailbox.gob"
	
    SelfClass *class;

    class = self_get_class_from_name(type);
    if (class)
      {
	GType gtype;

	gtype = G_OBJECT_CLASS_TYPE(class);
	g_type_class_unref(class);

	return gtype;
      }

    return 0;
  }}
#line 1377 "mn-mailbox.c"
#undef __GOB_FUNCTION__


#line 507 "src/mn-mailbox.gob"
static void 
mn_mailbox_finalize (MNMailbox * self)
{
#line 1385 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
{
#line 508 "src/mn-mailbox.gob"
	
    /*
     * Even though we clear the source in removed(), it might have
     * been reinstalled afterwards (by a mn_mailbox_set_poll() call
     * from a check thread, etc).
     */
    if (selfp->check_timeout_id)
      g_source_remove(selfp->check_timeout_id);
  }}
#line 1398 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 518 "src/mn-mailbox.gob"
static void 
mn_mailbox_notify_display_seen_messages_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
{
#line 1405 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::notify_display_seen_messages_cb"
{
#line 523 "src/mn-mailbox.gob"
	
    Self *self = user_data;

    self_filter_messages(self);
  }}
#line 1414 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 530 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new (const char * type, ...)
{
#line 1421 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new"
#line 530 "src/mn-mailbox.gob"
	g_return_val_if_fail (type != NULL, (MNMailbox * )0);
#line 1425 "mn-mailbox.c"
{
#line 532 "src/mn-mailbox.gob"
	
    va_list args;
    GType type_id;
    const char *first_property_name;
    GObject *object;

    type_id = self_get_type_from_name(type);
    if (! type_id)
      return NULL;

    va_start(args, type);
    first_property_name = va_arg(args, const char *);
    object = g_object_new_valist(type_id, first_property_name, args);
    va_end(args);

    return SELF(object);
  }}
#line 1445 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 550 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_xml_node (xmlNode * node, GError ** err)
{
#line 1452 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_xml_node"
#line 550 "src/mn-mailbox.gob"
	g_return_val_if_fail (node != NULL, (MNMailbox * )0);
#line 1456 "mn-mailbox.c"
{
#line 552 "src/mn-mailbox.gob"
	
    char *type;
    Self *self = NULL;

    type = xmlGetProp(node, "type");
    if (! type)
      {
	g_set_error(err, 0, 0, _("\"type\" attribute missing"));
	return NULL;
      }

    self = self_new(type, NULL);
    if (! self)
      {
	g_set_error(err, 0, 0, _("unknown mailbox type \"%s\""), type);
	goto end;
      }

    mn_xml_import_properties(G_OBJECT(self), node);

    if (! self_validate(self, err))
      {
	g_object_unref(self);
	self = NULL;
      }

  end:
    g_free(type);
    return self;
  }}
#line 1489 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 583 "src/mn-mailbox.gob"
xmlNode * 
mn_mailbox_xml_node_new (MNMailbox * self)
{
#line 1496 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::xml_node_new"
#line 583 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (xmlNode * )0);
#line 583 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (xmlNode * )0);
#line 1502 "mn-mailbox.c"
{
#line 585 "src/mn-mailbox.gob"
	
    xmlNode *node;

    node = xmlNewNode(NULL, "mailbox");
    xmlSetProp(node, "type", SELF_GET_CLASS(self)->type);
    mn_xml_export_properties(G_OBJECT(self), node);

    return node;
  }}
#line 1514 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 595 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_uri (const char * uri)
{
#line 1521 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_uri"
#line 595 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1525 "mn-mailbox.c"
{
#line 597 "src/mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	MNMailboxClass *class;
	MNMailbox *mailbox;

	class = g_type_class_ref(mn_mailbox_types[i]);
	mailbox = class->parse_uri ? class->parse_uri(NULL, uri) : NULL;
	g_type_class_unref(class);

	if (mailbox)
	  return mailbox;
      }

    return NULL;
  }}
#line 1546 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 616 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_configuration (MNMailboxConfiguration * config)
{
#line 1553 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_configuration"
#line 616 "src/mn-mailbox.gob"
	g_return_val_if_fail (config != NULL, (MNMailbox * )0);
#line 1557 "mn-mailbox.c"
{
#line 618 "src/mn-mailbox.gob"
	
    return g_object_newv(config->type, config->n_parameters, config->parameters);
  }}
#line 1563 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 622 "src/mn-mailbox.gob"
MNMailboxConfiguration * 
mn_mailbox_get_configuration (MNMailbox * self)
{
#line 1570 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_configuration"
#line 622 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxConfiguration * )0);
#line 622 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailboxConfiguration * )0);
#line 1576 "mn-mailbox.c"
{
#line 624 "src/mn-mailbox.gob"
	
    GObject *object = G_OBJECT(self);
    GArray *parameters;
    GParamSpec **properties;
    unsigned int n_properties;
    int i;
    MNMailboxConfiguration *config;

    parameters = g_array_new(FALSE, FALSE, sizeof(GParameter));

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_SAVE) != 0)
	{
	  GParameter parameter = { NULL, { 0, } };

	  parameter.name = g_param_spec_get_name(properties[i]);

	  g_value_init(&parameter.value, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(object, parameter.name, &parameter.value);

	  g_array_append_val(parameters, parameter);
	}
    g_free(properties);

    config = g_new0(MNMailboxConfiguration, 1);
    config->type = G_OBJECT_TYPE(self);
    config->n_parameters = parameters->len;
    config->parameters = (GParameter *) g_array_free(parameters, FALSE);

    return config;
  }}
#line 1611 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 657 "src/mn-mailbox.gob"
void 
mn_mailbox_configuration_free (MNMailboxConfiguration * config)
{
#line 1618 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::configuration_free"
#line 657 "src/mn-mailbox.gob"
	g_return_if_fail (config != NULL);
#line 1622 "mn-mailbox.c"
{
#line 659 "src/mn-mailbox.gob"
	
    int i;

    for (i = 0; i < config->n_parameters; i++)
      g_value_unset(&config->parameters[i].value);

    g_free(config->parameters);
    g_free(config);
  }}
#line 1634 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 669 "src/mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_obsolete_uri (const char * uri)
{
#line 1641 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_obsolete_uri"
#line 669 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1645 "mn-mailbox.c"
{
#line 671 "src/mn-mailbox.gob"
	
    char *real_uri;
    char *scheme;
    gboolean obsolete = FALSE;
    Self *self = NULL;

    real_uri = g_str_has_prefix(uri, "pop3:") /* also handle very old pop3 locators */
      ? g_strconcat("pop://", uri + 5, NULL)
      : g_strdup(uri);

    scheme = gnome_vfs_get_uri_scheme(real_uri);
    if (scheme)
      {
	if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops")
	    || ! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps")
	    || ! strcmp(scheme, "gmail"))
	  obsolete = TRUE;
	g_free(scheme);
      }

    self = obsolete ? self_parse_obsolete_uri(real_uri) : self_new_from_uri(real_uri);
    g_free(real_uri);

    if (self && ! self_validate(self, NULL))
      {
	g_object_unref(self);
	self = NULL;
      }

    return self;
  }}
#line 1679 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 703 "src/mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_obsolete_uri (const char * uri)
{
#line 1686 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::parse_obsolete_uri"
#line 703 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1690 "mn-mailbox.c"
{
#line 705 "src/mn-mailbox.gob"
	
    int len;
    int buflen;
    char *scheme;
    char *username;
    char *password;
    char *authmech;
    char *hostname;
    int port;
    char *path;
    char **queries;
    Self *self = NULL;

    len = strlen(uri);
    buflen = len + 1;

    {
      char *pat;
      char scheme_buf[buflen];
      char auth_buf[buflen];
      char location_buf[buflen];
      char username_buf[buflen];
      char password_buf[buflen];
      char authmech_buf[buflen];
      char hostname_buf[buflen];
      int _port;
      char path_buf[buflen];
      char queries_buf[buflen];
      gboolean has_location = FALSE;
      gboolean has_password = FALSE;
      gboolean has_authmech = FALSE;
      gboolean has_port = FALSE;
      gboolean has_path = FALSE;
      gboolean has_queries = FALSE;
      int n;

      /* split URI in 3 parts: scheme, auth and location */

      pat = g_strdup_printf("%%%i[^:]://%%%i[^@]@%%%is", len, len, len);
      n = sscanf(uri, pat, scheme_buf, auth_buf, location_buf);
      g_free(pat);

      if (n >= 2)
	{
	  if (n == 3)
	    has_location = TRUE;
	}
      else
	return NULL;		/* unparsable */

      /* split auth part in 3 subparts: username, password and authmech */

      /*
       * For backward compatibility with previous versions of Mail
       * Notification, we also support ;auth= (in lowercase).
       */

      pat = g_strdup_printf("%%%i[^:]:%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len, len);
      n = sscanf(auth_buf, pat, username_buf, password_buf, authmech_buf);
      g_free(pat);

      if (n >= 2)
	{
	  has_password = TRUE;
	  if (n == 3)
	    has_authmech = TRUE;
	}
      else
	{
	  pat = g_strdup_printf("%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len);
	  n = sscanf(auth_buf, pat, username_buf, authmech_buf);
	  g_free(pat);

	  if (n >= 1)
	    {
	      if (n == 2)
		has_authmech = TRUE;
	    }
	  else
	    return NULL;	/* unparsable */
	}

      if (has_location)
	{
	  char hostport_buf[buflen];

	  /* split location part in 3 subparts: hostport, path and queries */

	  pat = g_strdup_printf("%%%i[^/]/%%%i[^?]?%%%is", len, len, len);
	  n = sscanf(location_buf, pat, hostport_buf, path_buf, queries_buf);
	  g_free(pat);

	  if (n >= 2)
	    {
	      has_path = TRUE;
	      if (n == 3)
		has_queries = TRUE;
	    }
	  else
	    {
	      pat = g_strdup_printf("%%%i[^?]?%%%is", len, len);
	      n = sscanf(location_buf, pat, hostport_buf, queries_buf);
	      g_free(pat);

	      if (n == 2)
		has_queries = TRUE;
	    }

	  /* split hostport in 2 subparts: host and port */

	  pat = g_strdup_printf("[%%%i[^]]]:%%u", len);
	  n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	  g_free(pat);

	  if (n < 1)
	    {
	      pat = g_strdup_printf("%%%i[^:]:%%u", len);
	      n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	      g_free(pat);
	    }

	  if (n == 2)
	    has_port = TRUE;
	}

      scheme = gnome_vfs_unescape_string(scheme_buf, NULL);
      username = gnome_vfs_unescape_string(username_buf, NULL);
      password = has_password ? gnome_vfs_unescape_string(password_buf, NULL) : NULL;
      authmech = has_authmech ? gnome_vfs_unescape_string(authmech_buf, NULL) : NULL;
      hostname = has_location ? gnome_vfs_unescape_string(hostname_buf, NULL) : NULL;
      port = has_port ? _port : 0;
      path = has_path ? gnome_vfs_unescape_string(path_buf, NULL) : NULL;
      if (has_queries)
	{
	  int i;

	  queries = g_strsplit(queries_buf, "&", 0);
	  for (i = 0; queries[i]; i++)
	    {
	      char *unescaped;

	      unescaped = gnome_vfs_unescape_string(queries[i], NULL);

	      g_free(queries[i]);
	      queries[i] = unescaped;
	    }
	}
      else
	queries = NULL;
    }

    if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops"))
      {
#if WITH_POP3
	MNPIMailboxConnectionType connection_type;

	if (queries && mn_strv_find(queries, "STLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "pops")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("pop3",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			NULL);
#endif
      }
    else if (! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps"))
      {
#if WITH_IMAP
	MNPIMailboxConnectionType connection_type;

	if (queries && mn_strv_find(queries, "STARTTLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "imaps")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("imap",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			NULL);

	if (path)
	  g_object_set(self, MN_IMAP_MAILBOX_PROP_MAILBOX(path), NULL);

	if (queries && mn_strv_find(queries, "noidle") != -1)
	  g_object_set(G_OBJECT(self), MN_IMAP_MAILBOX_PROP_USE_IDLE_EXTENSION(MN_IMAP_MAILBOX_USE_IDLE_NEVER), NULL);
#endif
      }
    else if (! strcmp(scheme, "gmail"))
      {
#if WITH_GMAIL
	self = self_new("gmail",
			"username", username,
			"password", password,
			NULL);
#endif
      }

    g_free(scheme);
    g_free(username);
    g_free(password);
    g_free(authmech);
    g_free(hostname);
    g_free(path);
    g_strfreev(queries);

    return self;
  }}
#line 1914 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 927 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_check_timeout_cb (gpointer data)
{
#line 1921 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::check_timeout_cb"
{
#line 929 "src/mn-mailbox.gob"
	
    Self *self = data;

    self_check(self);

    return TRUE;		/* continue */
  }}
#line 1932 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 937 "src/mn-mailbox.gob"
static gboolean 
mn_mailbox_validate (MNMailbox * self, GError ** err)
{
#line 1939 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::validate"
#line 937 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 937 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 1945 "mn-mailbox.c"
{
#line 939 "src/mn-mailbox.gob"
	
    GParamSpec **properties;
    unsigned int n_properties;
    int i;
    gboolean status = TRUE;

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_REQUIRED) != 0)
	{
	  GValue value = { 0, };
	  const char *str;
	  gboolean is_empty;

	  g_assert(G_IS_PARAM_SPEC_STRING(properties[i]));

	  g_value_init(&value, G_TYPE_STRING);
	  g_object_get_property(G_OBJECT(self), g_param_spec_get_name(properties[i]), &value);

	  str = g_value_get_string(&value);
	  is_empty = ! str || ! *str;

	  g_value_unset(&value);

	  if (is_empty)
	    {
	      g_set_error(err, 0, 0, _("property \"%s\" has no value"), g_param_spec_get_name(properties[i]));
	      status = FALSE;
	      break;
	    }
	}
    g_free(properties);

    return status;
  }}
#line 1983 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_seal:
 * @self: a mailbox
 *
 * Seals the mailbox before it is made operational by being added to
 * the mailboxes list. The point of this function is to allow
 * subclasses to perform initialization which needs to consult the
 * value of properties loaded from mailboxes.xml or set by the
 * properties dialog. That would not be possible from init(), since
 * these properties are only set after the mailbox is constructed.
 **/
#line 986 "src/mn-mailbox.gob"
void 
mn_mailbox_seal (MNMailbox * self)
{
#line 2001 "mn-mailbox.c"
	MNMailboxClass *klass;
#line 986 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 986 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 2007 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->seal)
		(*klass->seal)(self);
}
#line 986 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_seal (MNMailbox * self G_GNUC_UNUSED)
{
#line 2017 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::seal"
{
#line 988 "src/mn-mailbox.gob"
	
    if (self->name)
      {
	g_free(self->runtime_name);
	self->runtime_name = g_strdup(self->name);
      }

    self->runtime_check_delay = self->check_delay != -1
      ? self->check_delay
      : SELF_GET_CLASS(self)->default_check_delay;
  }}
#line 2032 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1001 "src/mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_uri (MNMailbox * self, const char * uri)
{
#line 2039 "mn-mailbox.c"
	MNMailboxClass *klass;
#line 1001 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailbox * )0);
#line 1001 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailbox * )0);
#line 1001 "src/mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 2047 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->parse_uri)
		return (*klass->parse_uri)(self,uri);
	else
		return (MNMailbox * )(0);
}

#line 1004 "src/mn-mailbox.gob"
void 
mn_mailbox_check (MNMailbox * self)
{
#line 2060 "mn-mailbox.c"
	MNMailboxClass *klass;
#line 1004 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1004 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 2066 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->check)
		(*klass->check)(self);
}
#line 1004 "src/mn-mailbox.gob"
static void 
___real_mn_mailbox_check (MNMailbox * self G_GNUC_UNUSED)
{
#line 2076 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::check"
{
#line 1006 "src/mn-mailbox.gob"
	
    g_assert(self_get_active(self) == TRUE);
    g_assert(selfp->checking_enabled == TRUE);
  }}
#line 2084 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1020 "src/mn-mailbox.gob"
void 
mn_mailbox_enable_checking (MNMailbox * self)
{
#line 2091 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::enable_checking"
#line 1020 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1020 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 2097 "mn-mailbox.c"
{
#line 1022 "src/mn-mailbox.gob"
	
    selfp->checking_enabled = TRUE;
    g_object_notify(G_OBJECT(self), "manually-checkable");

    self_update_check_timeout(self);
    self_check(self);
  }}
#line 2107 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1031 "src/mn-mailbox.gob"
void 
mn_mailbox_notice (MNMailbox * self, const char * format, ...)
{
#line 2114 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::notice"
#line 1031 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1031 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1031 "src/mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 2122 "mn-mailbox.c"
{
#line 1033 "src/mn-mailbox.gob"
	
    char *message;

    /*
     * Disregard messages sent by a threaded check still in progress
     * after the mailbox has been removed.
     */
    if (! self_get_active(self))
      return;

    MN_STRDUP_VPRINTF(message, format);
    mn_info(_("%s: %s"), self->runtime_name, message);
    g_free(message);
  }}
#line 2139 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1049 "src/mn-mailbox.gob"
void 
mn_mailbox_warning (MNMailbox * self, const char * format, ...)
{
#line 2146 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::warning"
#line 1049 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1049 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1049 "src/mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 2154 "mn-mailbox.c"
{
#line 1051 "src/mn-mailbox.gob"
	
    char *message;

    /*
     * Disregard messages sent by a threaded check still in progress
     * after the mailbox has been removed.
     */
    if (! self_get_active(self))
      return;

    MN_STRDUP_VPRINTF(message, format);
    g_warning(_("%s: %s"), self->runtime_name, message);
    g_free(message);
  }}
#line 2171 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1066 "src/mn-mailbox.gob"
MNMessage * 
mn_mailbox_get_message_from_mid (MNMailbox * self, const char * mid)
{
#line 2178 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_message_from_mid"
#line 1066 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMessage * )0);
#line 1066 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMessage * )0);
#line 1066 "src/mn-mailbox.gob"
	g_return_val_if_fail (mid != NULL, (MNMessage * )0);
#line 2186 "mn-mailbox.c"
{
#line 1068 "src/mn-mailbox.gob"
	
    return g_hash_table_lookup(selfp->all_messages_mid_hash_table, mid);
  }}
#line 2192 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1072 "src/mn-mailbox.gob"
static void 
mn_mailbox_consider_as_read_real (MNMailbox * self, MNMessage * message)
{
#line 2199 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::consider_as_read_real"
#line 1072 "src/mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 1072 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1072 "src/mn-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 1072 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MESSAGE (message));
#line 2209 "mn-mailbox.c"
{
#line 1074 "src/mn-mailbox.gob"
	
    g_hash_table_replace(selfp->all_messages_considered_as_read, message->id, g_object_ref(message));
  }}
#line 2215 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1088 "src/mn-mailbox.gob"
void 
mn_mailbox_consider_as_read (MNMessage * message)
{
#line 2222 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::consider_as_read"
#line 1088 "src/mn-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 1088 "src/mn-mailbox.gob"
	g_return_if_fail (MN_IS_MESSAGE (message));
#line 2228 "mn-mailbox.c"
{
#line 1090 "src/mn-mailbox.gob"
	
    Self *self;

    self = message->mailbox;
    g_assert(self != NULL);

    self_consider_as_read_real(self, message);

    self_filter_messages(self);
  }}
#line 2241 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1106 "src/mn-mailbox.gob"
void 
mn_mailbox_consider_as_read_list (GSList * messages)
{
#line 2248 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::consider_as_read_list"
{
#line 1108 "src/mn-mailbox.gob"
	
    Self *self = NULL;
    GSList *l;

    MN_LIST_FOREACH(l, messages)
      {
	MNMessage *message = l->data;

	if (self)
	  g_assert(self == message->mailbox);
	else
	  {
	    self = message->mailbox;
	    g_assert(self != NULL);
	  }

	self_consider_as_read_real(self, message);
      }

    if (self)			/* non empty list */
      self_filter_messages(self);
  }}
#line 2274 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1131 "src/mn-mailbox.gob"
char * 
mn_mailbox_get_command (MNMailbox * self, const char * id)
{
#line 2281 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::get_command"
#line 1131 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 1131 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (char * )0);
#line 1131 "src/mn-mailbox.gob"
	g_return_val_if_fail (id != NULL, (char * )0);
#line 2289 "mn-mailbox.c"
{
#line 1133 "src/mn-mailbox.gob"
	
    char *prop;
    char *command;

    prop = g_strconcat(id, "-command", NULL);
    g_object_get(self, prop, &command, NULL);
    g_free(prop);

    if (command && ! *command)
      {
	g_free(command);
	return NULL;
      }

    return command;
  }}
#line 2308 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1150 "src/mn-mailbox.gob"
gboolean 
mn_mailbox_has_command (MNMailbox * self, const char * id)
{
#line 2315 "mn-mailbox.c"
#define __GOB_FUNCTION__ "MN:Mailbox::has_command"
#line 1150 "src/mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 1150 "src/mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 1150 "src/mn-mailbox.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 2323 "mn-mailbox.c"
{
#line 1152 "src/mn-mailbox.gob"
	
    char *command;
    gboolean has;

    command = self_get_command(self, id);
    has = command != NULL;
    g_free(command);

    return has;
  }}
#line 2336 "mn-mailbox.c"
#undef __GOB_FUNCTION__
