/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-shell.h"

#include "mn-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 33 "src/mn-shell.gob"

#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <glib/gi18n.h>
#include <libxml/tree.h>
#include "mn-properties-dialog.h"
#include "mn-util.h"
#include "mn-conf.h"
#include "mn-mailboxes.h"
#include "mn-about-dialog.h"
#include "mn-standard-message-view.h"
#include "mn-compact-message-view.h"
#include "mn-message.h"
#include "mn-stock.h"
#include "mn-locked-callback.h"

MNShell *mn_shell = NULL;

typedef struct
{
  int		num;
  const char	*name;
} UnixSignalInfo;

#define SIGNAL_INFO(name) { name, #name }

static const UnixSignalInfo unix_quit_signals[] = {
  SIGNAL_INFO(SIGHUP),
  SIGNAL_INFO(SIGINT),
  SIGNAL_INFO(SIGTERM),
  SIGNAL_INFO(SIGUSR1),
  SIGNAL_INFO(SIGUSR2)
};

#line 62 "mn-shell.c"
static const GEnumValue _mn_shell_tooltip_mail_summary_values[] = {
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD", (char *)"standard" },
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT", (char *)"compact" },
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE", (char *)"none" },
	{ 0, NULL, NULL }
};

GType
mn_shell_tooltip_mail_summary_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNShellTooltipMailSummary", _mn_shell_tooltip_mail_summary_values);
	return type;
}

/* self casting macros */
#define SELF(x) MN_SHELL(x)
#define SELF_CONST(x) MN_SHELL_CONST(x)
#define IS_SELF(x) MN_IS_SHELL(x)
#define TYPE_SELF MN_TYPE_SHELL
#define SELF_CLASS(x) MN_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) MN_SHELL_GET_CLASS(x)

/* self typedefs */
typedef MNShell Self;
typedef MNShellClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-shell.gob"
static void mn_shell_init (MNShell * o);
#line 97 "mn-shell.c"
#line 0 "src/mn-shell.gob"
static void mn_shell_class_init (MNShellClass * c);
#line 100 "mn-shell.c"
#line 99 "src/mn-shell.gob"
static void mn_shell_constructor (MNShell * self);
#line 103 "mn-shell.c"
#line 150 "src/mn-shell.gob"
static void mn_shell_finalize (MNShell * self);
#line 106 "mn-shell.c"
#line 193 "src/mn-shell.gob"
static gboolean mn_shell_install_unix_quit_signal_handlers (MNShell * self);
#line 109 "mn-shell.c"
#line 254 "src/mn-shell.gob"
static void mn_shell_unix_quit_signal_handler (int signum);
#line 112 "mn-shell.c"
#line 260 "src/mn-shell.gob"
static const UnixSignalInfo * mn_shell_lookup_unix_quit_signal (int signum);
#line 115 "mn-shell.c"
#line 273 "src/mn-shell.gob"
static gboolean mn_shell_unix_quit_signal_watch_cb (GIOChannel * source, GIOCondition condition, gpointer data);
#line 118 "mn-shell.c"
#line 299 "src/mn-shell.gob"
static void mn_shell_weak_notify_cb (gpointer data, GObject * former_object);
#line 121 "mn-shell.c"
#line 305 "src/mn-shell.gob"
static void mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data);
#line 124 "mn-shell.c"
#line 328 "src/mn-shell.gob"
static void mn_shell_play_new_mail_sound (MNShell * self);
#line 127 "mn-shell.c"
#line 344 "src/mn-shell.gob"
static void mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data);
#line 130 "mn-shell.c"
#line 358 "src/mn-shell.gob"
static void mn_shell_init_icon (MNShell * self);
#line 133 "mn-shell.c"
#line 382 "src/mn-shell.gob"
static void mn_shell_notify_icon_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data);
#line 136 "mn-shell.c"
#line 393 "src/mn-shell.gob"
static void mn_shell_notify_tooltip_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data);
#line 139 "mn-shell.c"
#line 404 "src/mn-shell.gob"
static void mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data);
#line 142 "mn-shell.c"
#line 415 "src/mn-shell.gob"
static void mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data);
#line 145 "mn-shell.c"
#line 466 "src/mn-shell.gob"
static void mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data);
#line 148 "mn-shell.c"
#line 472 "src/mn-shell.gob"
static void mn_shell_icon_activate_open_latest_message_h (MNMailIcon * icon, gpointer user_data);
#line 151 "mn-shell.c"
#line 479 "src/mn-shell.gob"
static void mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data);
#line 154 "mn-shell.c"
#line 486 "src/mn-shell.gob"
static void mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data);
#line 157 "mn-shell.c"
#line 492 "src/mn-shell.gob"
static void mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data);
#line 160 "mn-shell.c"
#line 499 "src/mn-shell.gob"
static void mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data);
#line 163 "mn-shell.c"
#line 508 "src/mn-shell.gob"
static void mn_shell_update_sensitivity (MNShell * self);
#line 166 "mn-shell.c"
#line 523 "src/mn-shell.gob"
static void mn_shell_update_icon (MNShell * self);
#line 169 "mn-shell.c"
#line 569 "src/mn-shell.gob"
static void mn_shell_update_tooltip (MNShell * self);
#line 172 "mn-shell.c"
#line 717 "src/mn-shell.gob"
static int mn_shell_new_mailboxes_compare_cb (MNMailbox * a, MNMailbox * b);
#line 175 "mn-shell.c"
#line 736 "src/mn-shell.gob"
static GtkWidget * mn_shell_tooltip_section_new (GtkVBox ** vbox, const char * title);
#line 178 "mn-shell.c"
#line 756 "src/mn-shell.gob"
static void mn_shell_tooltip_text_section_new (GtkVBox ** vbox, const char * title, const char * text);
#line 181 "mn-shell.c"
#line 773 "src/mn-shell.gob"
static void mn_shell_open_latest_message (MNShell * self);
#line 184 "mn-shell.c"
#line 790 "src/mn-shell.gob"
static void mn_shell_open_latest_message_done_cb (MNMessageAction * action, GError * err, gpointer data);
#line 187 "mn-shell.c"
#line 846 "src/mn-shell.gob"
static void mn_shell_show_window (MNShell * self, GType type, GtkWidget ** ptr, guint32 timestamp);
#line 190 "mn-shell.c"
#line 874 "src/mn-shell.gob"
static void mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object);
#line 193 "mn-shell.c"

enum {
	PROP_0,
	PROP_SESSION_BUS,
	PROP_SESSION_BUS_PROXY
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_install_unix_quit_signal_handlers mn_shell_install_unix_quit_signal_handlers
#define self_unix_quit_signal_handler mn_shell_unix_quit_signal_handler
#define self_lookup_unix_quit_signal mn_shell_lookup_unix_quit_signal
#define self_unix_quit_signal_watch_cb mn_shell_unix_quit_signal_watch_cb
#define self_weak_notify_cb mn_shell_weak_notify_cb
#define self_messages_changed_h mn_shell_messages_changed_h
#define self_play_new_mail_sound mn_shell_play_new_mail_sound
#define self_mailbox_removed_h mn_shell_mailbox_removed_h
#define self_init_icon mn_shell_init_icon
#define self_notify_icon_cb mn_shell_notify_icon_cb
#define self_notify_tooltip_cb mn_shell_notify_tooltip_cb
#define self_notify_mail_reader_cb mn_shell_notify_mail_reader_cb
#define self_icon_activate_h mn_shell_icon_activate_h
#define self_icon_activate_mail_reader_h mn_shell_icon_activate_mail_reader_h
#define self_icon_activate_open_latest_message_h mn_shell_icon_activate_open_latest_message_h
#define self_icon_activate_properties_h mn_shell_icon_activate_properties_h
#define self_icon_activate_help_h mn_shell_icon_activate_help_h
#define self_icon_activate_about_h mn_shell_icon_activate_about_h
#define self_icon_destroy_h mn_shell_icon_destroy_h
#define self_update_sensitivity mn_shell_update_sensitivity
#define self_update_icon mn_shell_update_icon
#define self_update_tooltip mn_shell_update_tooltip
#define self_new_mailboxes_compare_cb mn_shell_new_mailboxes_compare_cb
#define self_tooltip_section_new mn_shell_tooltip_section_new
#define self_tooltip_text_section_new mn_shell_tooltip_text_section_new
#define self_open_latest_message mn_shell_open_latest_message
#define self_open_latest_message_done_cb mn_shell_open_latest_message_done_cb
#define self_new mn_shell_new
#define self_consider_new_mail_as_read mn_shell_consider_new_mail_as_read
#define self_update mn_shell_update
#define self_quit mn_shell_quit
#define self_show_properties_dialog mn_shell_show_properties_dialog
#define self_show_about_dialog mn_shell_show_about_dialog
#define self_show_window mn_shell_show_window
#define self_add_mailbox_properties_dialog mn_shell_add_mailbox_properties_dialog
#define self_mailbox_properties_dialog_weak_notify_cb mn_shell_mailbox_properties_dialog_weak_notify_cb
#define self_get_mailbox_properties_dialog mn_shell_get_mailbox_properties_dialog
#define self_get_summary mn_shell_get_summary
GType
mn_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNShell *)g_object_new(mn_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNShell *
GET_NEW_VARG (const char *first, ...)
{
	MNShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNShell *)g_object_new_valist (mn_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static GObject *
___constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
#define __GOB_FUNCTION__ "MN:Shell::constructor"
	GObject *obj_self;
	MNShell *self;
	obj_self = G_OBJECT_CLASS (parent_class)->constructor (type, n_construct_properties, construct_properties);
	self = MN_SHELL (obj_self);
#line 99 "src/mn-shell.gob"
	mn_shell_constructor (self);
#line 296 "mn-shell.c"
	return obj_self;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 150 "src/mn-shell.gob"
	mn_shell_finalize (self);
#line 310 "mn-shell.c"
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
mn_shell_init (MNShell * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Shell::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_SHELL,MNShellPrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_shell_class_init (MNShellClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->constructor = ___constructor;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("session_bus" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SESSION_BUS,
		param_spec);
	param_spec = g_param_spec_pointer
		("session_bus_proxy" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SESSION_BUS_PROXY,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Shell::set_property"
{
	MNShell *self G_GNUC_UNUSED;

	self = MN_SHELL (object);

	switch (property_id) {
	case PROP_SESSION_BUS:
		{
#line 84 "src/mn-shell.gob"
self->session_bus = g_value_get_pointer (VAL);
#line 376 "mn-shell.c"
		}
		break;
	case PROP_SESSION_BUS_PROXY:
		{
#line 87 "src/mn-shell.gob"
self->session_bus_proxy = g_value_get_pointer (VAL);
#line 383 "mn-shell.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Shell::get_property"
{
	MNShell *self G_GNUC_UNUSED;

	self = MN_SHELL (object);

	switch (property_id) {
	case PROP_SESSION_BUS:
		{
#line 84 "src/mn-shell.gob"
g_value_set_pointer (VAL, self->session_bus);
#line 414 "mn-shell.c"
		}
		break;
	case PROP_SESSION_BUS_PROXY:
		{
#line 87 "src/mn-shell.gob"
g_value_set_pointer (VAL, self->session_bus_proxy);
#line 421 "mn-shell.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 99 "src/mn-shell.gob"
static void 
mn_shell_constructor (MNShell * self)
{
#line 442 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::constructor"
{
#line 100 "src/mn-shell.gob"
	
    g_assert(mn_shell == NULL);

    mn_shell = self;
    g_object_weak_ref(G_OBJECT(self), self_weak_notify_cb, NULL);

    selfp->sound_player = mn_sound_player_new();
    mn_add_weak_pointer(&selfp->sound_player);

    /*
     * self->mailboxes is assigned in MNMailboxes itself, so that
     * mailboxes can access it even during construction of
     * MNMailboxes.
     */
    mn_mailboxes_new();
    mn_add_weak_pointer(&self->mailboxes);

    self_init_icon(self);

    mn_g_object_gconf_notifications_add_gdk_locked(self,
						   MN_CONF_BLINK_ON_ERRORS, self_notify_icon_cb, self,
						   MN_CONF_ALWAYS_DISPLAY_ICON, self_notify_icon_cb, self,
						   MN_CONF_DISPLAY_MESSAGE_COUNT, self_notify_icon_cb, self,
						   MN_CONF_GNOME_MAIL_READER_NAMESPACE, self_notify_mail_reader_cb, self,
						   MN_CONF_TOOLTIP_MAIL_SUMMARY, self_notify_tooltip_cb, self,
						   MN_CONF_TOOLTIP_MAIL_SUMMARY_LIMIT, self_notify_tooltip_cb, self,
						   NULL);

    g_object_connect(self->mailboxes,
		     "signal::messages-changed", self_messages_changed_h, self,
		     "signal::mailbox-removed", self_mailbox_removed_h, self,
		     "swapped-signal::notify::manually-checkable", self_update_sensitivity, self,
		     "swapped-signal::list-changed", self_update_tooltip, self,
		     "swapped-signal::list-changed", self_update_icon, self,
		     "swapped-signal::error-changed", self_update_tooltip, self,
		     "swapped-signal::error-changed", self_update_icon, self,
		     NULL);

    self->popups = mn_popups_new();
    mn_add_weak_pointer(&self->popups);

    /*
     * Exit gracefully (unreferencing our components) when receiving a
     * UNIX signal.
     */
    if (! self_install_unix_quit_signal_handlers(self))
      /* unlikely and unimportant, not worth a translation */
      g_warning("unable to install UNIX quit signal handlers");
  }}
#line 495 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 150 "src/mn-shell.gob"
static void 
mn_shell_finalize (MNShell * self)
{
#line 502 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::finalize"
{
#line 151 "src/mn-shell.gob"
	
    /*
     * We explicitly unreference or destroy each component, even
     * though MN will exit after the shell is finalized. This is done
     * for the sake of respecting encapsulation: we should not know
     * whether a particular component has something to do on exit or
     * not (for instance, MNSoundPlayer must kill the play process).
     *
     * Of course, the order in which we get rid of the components
     * matters: for instance, when destroyed, MNPropertiesDialog might
     * remove the test mailbox and thus requires a valid MNMailboxes
     * object. We destroy the components in the inverse order of their
     * creation.
     *
     * Also note that we do not need to nullify the pointers after
     * destruction since we use mn_add_weak_pointer() at creation
     * time.
     */

    g_slist_foreach(selfp->mailbox_properties_dialogs, (GFunc) gtk_widget_destroy, NULL);
    /* the list is freed in mailbox_properties_dialog_weak_notify_cb() */

    if (selfp->properties_dialog)
      gtk_widget_destroy(selfp->properties_dialog);

    if (selfp->about_dialog)
      gtk_widget_destroy(selfp->about_dialog);

    mn_g_object_null_unref(self->popups);

    if (self->icon)
      {
	/* do not recreate the icon after we destroy it */
	g_signal_handlers_disconnect_by_func(self->icon, self_icon_destroy_h, self);
	gtk_widget_destroy(GTK_WIDGET(self->icon));
      }

    mn_g_object_null_unref(self->mailboxes);

    mn_g_object_null_unref(selfp->sound_player);
  }}
#line 547 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 193 "src/mn-shell.gob"
static gboolean 
mn_shell_install_unix_quit_signal_handlers (MNShell * self)
{
#line 554 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::install_unix_quit_signal_handlers"
#line 193 "src/mn-shell.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 193 "src/mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (gboolean )0);
#line 560 "mn-shell.c"
{
#line 195 "src/mn-shell.gob"
	
    int sigpipe[2];
    int flags;
    GIOChannel *read_channel = NULL;
    int i;

    if (pipe(sigpipe) < 0)
      return FALSE;

    /*
     * Enable non-blocking mode for the write end, so that if another
     * signal occurs while the main thread is busy processing the
     * first signal, the signal handler will not block in write().
     */

    flags = fcntl(sigpipe[1], F_GETFL);
    if (flags < 0)
      goto error;

    if (fcntl(sigpipe[1], F_SETFL, flags | O_NONBLOCK) < 0)
      goto error;

    selfp->unix_signal_pipe_write_end = sigpipe[1];

    read_channel = g_io_channel_unix_new(sigpipe[0]);

    if (g_io_channel_set_encoding(read_channel, NULL, NULL) != G_IO_STATUS_NORMAL)
      goto error;

    for (i = 0; i < G_N_ELEMENTS(unix_quit_signals); i++)
      {
	struct sigaction sa;

	sa.sa_handler = self_unix_quit_signal_handler;
	sa.sa_flags = 0;
	sigemptyset(&sa.sa_mask);

	if (sigaction(unix_quit_signals[i].num, &sa, NULL) < 0)
	  goto error;
      }

    g_io_add_watch(read_channel, G_IO_IN | G_IO_PRI, self_unix_quit_signal_watch_cb, self);

    return TRUE;		/* ok */

  error:
    if (read_channel)
      {
	g_io_channel_shutdown(read_channel, FALSE, NULL);
	g_io_channel_unref(read_channel);
      }
    else
      close(sigpipe[0]);

    close(sigpipe[1]);

    return FALSE;
  }}
#line 621 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 254 "src/mn-shell.gob"
static void 
mn_shell_unix_quit_signal_handler (int signum)
{
#line 628 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::unix_quit_signal_handler"
{
#line 256 "src/mn-shell.gob"
	
    write(mn_shell->_priv->unix_signal_pipe_write_end, &signum, sizeof(signum));
  }}
#line 635 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 260 "src/mn-shell.gob"
static const UnixSignalInfo * 
mn_shell_lookup_unix_quit_signal (int signum)
{
#line 642 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::lookup_unix_quit_signal"
{
#line 262 "src/mn-shell.gob"
	
    int i;

    for (i = 0; i < G_N_ELEMENTS(unix_quit_signals); i++)
      if (unix_quit_signals[i].num == signum)
	return &unix_quit_signals[i];

    g_assert_not_reached();
    return NULL;
  }}
#line 656 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 273 "src/mn-shell.gob"
static gboolean 
mn_shell_unix_quit_signal_watch_cb (GIOChannel * source, GIOCondition condition, gpointer data)
{
#line 663 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::unix_quit_signal_watch_cb"
{
#line 277 "src/mn-shell.gob"
	
    Self *self = data;
    GIOStatus status;
    int signum;
    gsize bytes_read;
    const UnixSignalInfo *info;

    status = g_io_channel_read_chars(source, (char *) &signum, sizeof(signum), &bytes_read, NULL);
    g_assert(status == G_IO_STATUS_NORMAL);
    g_assert(bytes_read == sizeof(signum));

    info = self_lookup_unix_quit_signal(signum);

    g_message(_("received %s signal, exiting"), info->name);

    GDK_THREADS_ENTER();
    self_quit(self);
    GDK_THREADS_LEAVE();

    return FALSE;		/* remove source */
  }}
#line 688 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 299 "src/mn-shell.gob"
static void 
mn_shell_weak_notify_cb (gpointer data, GObject * former_object)
{
#line 695 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::weak_notify_cb"
{
#line 301 "src/mn-shell.gob"
	
    gtk_main_quit();
  }}
#line 702 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 305 "src/mn-shell.gob"
static void 
mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data)
{
#line 709 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::messages_changed_h"
{
#line 309 "src/mn-shell.gob"
	
    Self *self = user_data;

    if (mn_conf_has_command(MN_CONF_COMMANDS_MAIL_CHANGED_NAMESPACE))
      mn_conf_execute_command(MN_CONF_COMMANDS_MAIL_CHANGED_COMMAND);

    if (has_new)
      {
	self_play_new_mail_sound(self);

	if (mn_conf_has_command(MN_CONF_COMMANDS_NEW_MAIL_NAMESPACE))
	  mn_conf_execute_command(MN_CONF_COMMANDS_NEW_MAIL_COMMAND);
      }

    self_update_sensitivity(self);
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 731 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 328 "src/mn-shell.gob"
static void 
mn_shell_play_new_mail_sound (MNShell * self)
{
#line 738 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::play_new_mail_sound"
#line 328 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 328 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 744 "mn-shell.c"
{
#line 330 "src/mn-shell.gob"
	
    char *file;

    if (! mn_conf_get_bool(MN_CONF_SOUNDS_NEW_MAIL_ENABLED))
      return;

    file = mn_conf_get_string(MN_CONF_SOUNDS_NEW_MAIL_FILE);

    if (file && *file)
      mn_sound_player_play(selfp->sound_player, file, NULL);

    g_free(file);
  }}
#line 760 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 344 "src/mn-shell.gob"
static void 
mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data)
{
#line 767 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::mailbox_removed_h"
{
#line 348 "src/mn-shell.gob"
	
    Self *self = user_data;
    MNMailboxPropertiesDialog *dialog;

    /* destroy the associated properties dialog, if any */
    dialog = self_get_mailbox_properties_dialog(self, mailbox);
    if (dialog)
      gtk_widget_destroy(GTK_WIDGET(dialog));
  }}
#line 780 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 358 "src/mn-shell.gob"
static void 
mn_shell_init_icon (MNShell * self)
{
#line 787 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::init_icon"
#line 358 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 358 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 793 "mn-shell.c"
{
#line 360 "src/mn-shell.gob"
	
    self->icon = MN_MAIL_ICON(mn_mail_icon_new());
    mn_add_weak_pointer(&self->icon);

    g_object_connect(self->icon,
		     "signal::activate", self_icon_activate_h, self,
		     "signal::activate-mail-reader", self_icon_activate_mail_reader_h, self,
		     "signal::activate-open-latest-message", self_icon_activate_open_latest_message_h, self,
		     "swapped-signal::activate-consider-new-mail-as-read", self_consider_new_mail_as_read, self,
		     "swapped-signal::activate-update", self_update, self,
		     "signal::activate-properties", self_icon_activate_properties_h, self,
		     "signal::activate-help", self_icon_activate_help_h, self,
		     "signal::activate-about", self_icon_activate_about_h, self,
		     "swapped-signal::activate-remove", self_quit, self,
		     "signal::destroy", self_icon_destroy_h, self,
		     NULL);

    self_update_sensitivity(self);
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 817 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 382 "src/mn-shell.gob"
static void 
mn_shell_notify_icon_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
{
#line 824 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::notify_icon_cb"
{
#line 387 "src/mn-shell.gob"
	
    Self *self = user_data;

    self_update_icon(self);
  }}
#line 833 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 393 "src/mn-shell.gob"
static void 
mn_shell_notify_tooltip_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
{
#line 840 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::notify_tooltip_cb"
{
#line 398 "src/mn-shell.gob"
	
    Self *self = user_data;

    self_update_tooltip(self);
  }}
#line 849 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 404 "src/mn-shell.gob"
static void 
mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
{
#line 856 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::notify_mail_reader_cb"
{
#line 409 "src/mn-shell.gob"
	
    Self *self = user_data;

    self_update_sensitivity(self);
  }}
#line 865 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 415 "src/mn-shell.gob"
static void 
mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data)
{
#line 872 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_h"
{
#line 417 "src/mn-shell.gob"
	
    MNShell *self = user_data;
    MNAction action;

    action = mn_conf_get_enum_value(MN_TYPE_ACTION, MN_CONF_CLICK_ACTION);

    switch (action)
      {
      case MN_ACTION_LAUNCH_MAIL_READER:
	if (mn_conf_has_command(MN_CONF_GNOME_MAIL_READER_NAMESPACE))
	  mn_conf_execute_mail_reader();
	else
	  mn_show_error_dialog_with_markup(NULL,
					   _("No mail reader is configured"),
					   _("You can configure a mail reader by choosing <b>System → Preferences → Preferred Applications</b>."));
	break;

      case MN_ACTION_OPEN_LATEST_MESSAGE:
	if (self->mailboxes->messages->len != 0)
	  {
	    MNMessage *message = g_ptr_array_index(self->mailboxes->messages, 0);

	    if (mn_message_can_perform_action(message, mn_message_get_action("open")))
	      self_open_latest_message(self);
	    else
	      mn_show_error_dialog(NULL,
				   _("Unable to open the latest message"),
				   _("Messages of mailbox \"%s\" cannot be opened."),
				   message->mailbox->runtime_name);
	  }
	else
	  mn_show_error_dialog(NULL,
			       _("Unable to open the latest message"),
			       _("You have no new mail."));
	break;

      case MN_ACTION_CONSIDER_NEW_MAIL_AS_READ:
	self_consider_new_mail_as_read(self);
	break;

      case MN_ACTION_UPDATE_MAIL_STATUS:
	mn_mailboxes_check(self->mailboxes);
	break;

      default:
	g_assert_not_reached();
      }
  }}
#line 924 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 466 "src/mn-shell.gob"
static void 
mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data)
{
#line 931 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_mail_reader_h"
{
#line 468 "src/mn-shell.gob"
	
    mn_conf_execute_mail_reader();
  }}
#line 938 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 472 "src/mn-shell.gob"
static void 
mn_shell_icon_activate_open_latest_message_h (MNMailIcon * icon, gpointer user_data)
{
#line 945 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_open_latest_message_h"
{
#line 474 "src/mn-shell.gob"
	
    Self *self = user_data;
    self_open_latest_message(self);
  }}
#line 953 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 479 "src/mn-shell.gob"
static void 
mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data)
{
#line 960 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_properties_h"
{
#line 481 "src/mn-shell.gob"
	
    Self *self = user_data;
    self_show_properties_dialog(self, gtk_get_current_event_time());
  }}
#line 968 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 486 "src/mn-shell.gob"
static void 
mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data)
{
#line 975 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_help_h"
{
#line 488 "src/mn-shell.gob"
	
    mn_show_help(NULL, NULL);
  }}
#line 982 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 492 "src/mn-shell.gob"
static void 
mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data)
{
#line 989 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_about_h"
{
#line 494 "src/mn-shell.gob"
	
    Self *self = user_data;
    self_show_about_dialog(self, gtk_get_current_event_time());
  }}
#line 997 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 499 "src/mn-shell.gob"
static void 
mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data)
{
#line 1004 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::icon_destroy_h"
{
#line 501 "src/mn-shell.gob"
	
    Self *self = user_data;

    /* The Notification Area applet has been terminated. Recreate the icon. */
    self_init_icon(self);
  }}
#line 1014 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 508 "src/mn-shell.gob"
static void 
mn_shell_update_sensitivity (MNShell * self)
{
#line 1021 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::update_sensitivity"
#line 508 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 508 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1027 "mn-shell.c"
{
#line 510 "src/mn-shell.gob"
	
    gtk_widget_set_sensitive(self->icon->mail_reader_item,
			     mn_conf_has_command(MN_CONF_GNOME_MAIL_READER_NAMESPACE));
    gtk_widget_set_sensitive(self->icon->open_latest_message_item,
			     self->mailboxes->messages->len != 0
			     && mn_message_can_perform_action(g_ptr_array_index(self->mailboxes->messages, 0),
							      mn_message_get_action("open")));
    gtk_widget_set_sensitive(self->icon->consider_new_mail_as_read_item,
			     self->mailboxes->messages->len != 0);
    gtk_widget_set_sensitive(self->icon->update_item,
			     mn_mailboxes_get_manually_checkable(self->mailboxes));
  }}
#line 1042 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 523 "src/mn-shell.gob"
static void 
mn_shell_update_icon (MNShell * self)
{
#line 1049 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::update_icon"
#line 523 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 523 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1055 "mn-shell.c"
{
#line 525 "src/mn-shell.gob"
	
    GList *l;
    gboolean has_new = FALSE;
    gboolean blink = FALSE;
    gboolean always = mn_conf_get_bool(MN_CONF_ALWAYS_DISPLAY_ICON);

    MN_LIST_FOREACH(l, self->mailboxes->list)
      {
	MNMailbox *mailbox = l->data;

	if (mailbox->messages->len != 0)
	  has_new = TRUE;
	if (mailbox->error)
	  blink = TRUE;
      }

    if (selfp->has_new && ! has_new && mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READ_NAMESPACE))
      mn_conf_execute_command(MN_CONF_COMMANDS_MAIL_READ_COMMAND);
    selfp->has_new = has_new;

    if (blink && ! mn_conf_get_bool(MN_CONF_BLINK_ON_ERRORS))
      blink = FALSE;

    if (has_new || blink || always)
      {
	int count;

	if (mn_conf_get_bool(MN_CONF_DISPLAY_MESSAGE_COUNT))
	  count = self->mailboxes->messages->len;
	else
	  count = 0;

	mn_mail_icon_set_from_stock(self->icon, has_new ? MN_STOCK_MAIL : MN_STOCK_NO_MAIL);
	mn_mail_icon_set_blinking(self->icon, blink);
	mn_mail_icon_set_count(self->icon, count);
	gtk_widget_show(GTK_WIDGET(self->icon));
      }
    else
      {
	gtk_widget_hide(GTK_WIDGET(self->icon));
	mn_mail_icon_set_blinking(self->icon, FALSE);
      }
  }}
#line 1101 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 569 "src/mn-shell.gob"
static void 
mn_shell_update_tooltip (MNShell * self)
{
#line 1108 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::update_tooltip"
#line 569 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 569 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1114 "mn-shell.c"
{
#line 571 "src/mn-shell.gob"
	
    GtkVBox *vbox = NULL;

    if (self->mailboxes->list)
      {
	GList *la;
	GSList *lb;
	GSList *new_mailboxes = NULL;
	GSList *error_mailboxes = NULL;

	MN_LIST_FOREACH(la, self->mailboxes->list)
          {
	    MNMailbox *mailbox = la->data;

	    if (mailbox->messages->len != 0)
	      new_mailboxes = g_slist_insert_sorted(new_mailboxes, mailbox, (GCompareFunc) self_new_mailboxes_compare_cb);

	    if (mailbox->error)
	      error_mailboxes = g_slist_insert_sorted(error_mailboxes, mailbox, mn_mailboxes_compare_by_name_func);
	  }

	if (new_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    MN_LIST_FOREACH(lb, new_mailboxes)
	      {
		MNMailbox *mailbox = lb->data;

		g_assert(mailbox->messages->len != 0);

		if (*string->str)
		  g_string_append_c(string, '\n');

		g_string_append_printf(string, _("%s (%i)"), mailbox->runtime_name, mailbox->messages->len);
	      }
	    g_slist_free(new_mailboxes);

	    /* translators: header capitalization */
	    self_tooltip_text_section_new(&vbox, _("Mailboxes Having New Mail"), string->str);
	    g_string_free(string, TRUE);
	  }

	if (error_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    MN_LIST_FOREACH(lb, error_mailboxes)
	      {
		MNMailbox *mailbox = lb->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append_printf(string, _("%s: %s"), mailbox->runtime_name, mailbox->error);
	      }
	    g_slist_free(error_mailboxes);

	    /* translators: header capitalization */
	    self_tooltip_text_section_new(&vbox, _("Errors"), string->str);
	    g_string_free(string, TRUE);
	  }
      }

    if (self->mailboxes->messages->len != 0)
      {
	MNShellTooltipMailSummary mail_summary;

	mail_summary = mn_conf_get_enum_value(MN_TYPE_SHELL_TOOLTIP_MAIL_SUMMARY, MN_CONF_TOOLTIP_MAIL_SUMMARY);
	if (mail_summary != MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE)
	  {
	    GtkWidget *alignment;
	    GtkWidget *message_view;
	    int limit;
	    GSList *messages = NULL;
	    int num_messages;
	    int i;

	    /* translators: header capitalization */
	    alignment = self_tooltip_section_new(&vbox, _("Mail Summary"));

	    switch (mail_summary)
	      {
	      case MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD:
		message_view = mn_standard_message_view_new();
		break;

	      case MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT:
		message_view = mn_compact_message_view_new();
		break;

	      default:
		g_assert_not_reached();
		break;
	      }

	    gtk_widget_set_name(message_view, "mn-message-view");

	    limit = mn_conf_get_int(MN_CONF_TOOLTIP_MAIL_SUMMARY_LIMIT);

	    num_messages = MIN(self->mailboxes->messages->len, limit);
	    for (i = num_messages - 1; i >= 0; i--)
	      messages = g_slist_prepend(messages, g_ptr_array_index(self->mailboxes->messages, i));
	    mn_message_view_set_messages(MN_MESSAGE_VIEW(message_view), messages);
	    g_slist_free(messages);

	    if (self->mailboxes->messages->len <= limit)
	      gtk_container_add(GTK_CONTAINER(alignment), message_view);
	    else
	      {
		int remaining;
		char *markup;
		GtkWidget *label;
		GtkWidget *summary_vbox;

		remaining = self->mailboxes->messages->len - limit;

		label = gtk_label_new(NULL);

		markup = g_strdup_printf(ngettext("<span style=\"italic\">%i message is not displayed</span>",
						  "<span style=\"italic\">%i messages are not displayed</span>",
						  remaining),
					 remaining);
		gtk_label_set_markup(GTK_LABEL(label), markup);
		g_free(markup);

		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

		summary_vbox = gtk_vbox_new(FALSE, 12);

		gtk_box_pack_start(GTK_BOX(summary_vbox), message_view, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(summary_vbox), label, FALSE, FALSE, 0);

		gtk_container_add(GTK_CONTAINER(alignment), summary_vbox);
	      }
	  }
      }

    if (vbox)
      {
	gtk_widget_show_all(GTK_WIDGET(vbox));
	mn_mail_icon_set_tip_widget(self->icon, GTK_WIDGET(vbox));
      }
    else
      mn_mail_icon_set_tip(self->icon, _("You have no new mail."));
  }}
#line 1262 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 717 "src/mn-shell.gob"
static int 
mn_shell_new_mailboxes_compare_cb (MNMailbox * a, MNMailbox * b)
{
#line 1269 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::new_mailboxes_compare_cb"
{
#line 719 "src/mn-shell.gob"
	
    int cmp;

    /* sort by timestamp (descending order) */
    cmp = b->timestamp - a->timestamp;
    if (cmp != 0)
      return cmp;

    /* sort by number of messages (descending order) */
    cmp = b->messages->len - a->messages->len;
    if (cmp != 0)
      return cmp;

    /* sort by name (ascending order) */
    return mn_mailboxes_compare_by_name_func(a, b);
  }}
#line 1289 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 736 "src/mn-shell.gob"
static GtkWidget * 
mn_shell_tooltip_section_new (GtkVBox ** vbox, const char * title)
{
#line 1296 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::tooltip_section_new"
#line 736 "src/mn-shell.gob"
	g_return_val_if_fail (vbox != NULL, (GtkWidget * )0);
#line 736 "src/mn-shell.gob"
	g_return_val_if_fail (title != NULL, (GtkWidget * )0);
#line 1302 "mn-shell.c"
{
#line 739 "src/mn-shell.gob"
	
    GtkWidget *section;
    GtkWidget *label;
    GtkWidget *alignment;

    if (! *vbox)
      *vbox = GTK_VBOX(gtk_vbox_new(FALSE, 18));

    section = mn_hig_section_new(title, &label, &alignment);

    gtk_widget_set_name(label, "mn-tooltip-section-title");

    gtk_box_pack_start(GTK_BOX(*vbox), section, TRUE, TRUE, 0);

    return alignment;
  }}
#line 1321 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 756 "src/mn-shell.gob"
static void 
mn_shell_tooltip_text_section_new (GtkVBox ** vbox, const char * title, const char * text)
{
#line 1328 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::tooltip_text_section_new"
#line 756 "src/mn-shell.gob"
	g_return_if_fail (vbox != NULL);
#line 756 "src/mn-shell.gob"
	g_return_if_fail (title != NULL);
#line 756 "src/mn-shell.gob"
	g_return_if_fail (text != NULL);
#line 1336 "mn-shell.c"
{
#line 760 "src/mn-shell.gob"
	
    GtkWidget *alignment;
    GtkWidget *label;

    alignment = self_tooltip_section_new(vbox, title);

    label = gtk_label_new(text);
    gtk_widget_set_name(label, "mn-tooltip-section-body");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

    gtk_container_add(GTK_CONTAINER(alignment), label);
  }}
#line 1351 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 773 "src/mn-shell.gob"
static void 
mn_shell_open_latest_message (MNShell * self)
{
#line 1358 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::open_latest_message"
#line 773 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 773 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1364 "mn-shell.c"
{
#line 775 "src/mn-shell.gob"
	
    MNMessage *message;
    MNMessageAction *action;

    g_return_if_fail(self->mailboxes->messages->len != 0);

    message = g_ptr_array_index(self->mailboxes->messages, 0);

    action = mn_message_get_action("open");
    g_return_if_fail(action != NULL);
    g_return_if_fail(mn_message_can_perform_action(message, action));

    mn_message_perform_action(message, action, self_open_latest_message_done_cb, NULL);
  }}
#line 1381 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 790 "src/mn-shell.gob"
static void 
mn_shell_open_latest_message_done_cb (MNMessageAction * action, GError * err, gpointer data)
{
#line 1388 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::open_latest_message_done_cb"
{
#line 792 "src/mn-shell.gob"
	
    if (err && ! g_error_matches(err, MN_MESSAGE_ACTION_ERROR, MN_MESSAGE_ACTION_ERROR_CANCELLED))
      mn_show_error_dialog(NULL, _("Unable to open the latest message"), "%s", err->message);
  }}
#line 1396 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 797 "src/mn-shell.gob"
MNShell * 
mn_shell_new (DBusGConnection * session_bus, DBusGProxy * session_bus_proxy)
{
#line 1403 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::new"
#line 797 "src/mn-shell.gob"
	g_return_val_if_fail (session_bus != NULL, (MNShell * )0);
#line 797 "src/mn-shell.gob"
	g_return_val_if_fail (session_bus_proxy != NULL, (MNShell * )0);
#line 1409 "mn-shell.c"
{
#line 800 "src/mn-shell.gob"
	
    return GET_NEW_VARG(MN_SHELL_PROP_SESSION_BUS(session_bus),
			MN_SHELL_PROP_SESSION_BUS_PROXY(session_bus_proxy),
			NULL);
  }}
#line 1417 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 806 "src/mn-shell.gob"
void 
mn_shell_consider_new_mail_as_read (MNShell * self)
{
#line 1424 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::consider_new_mail_as_read"
#line 806 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 806 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1430 "mn-shell.c"
{
#line 808 "src/mn-shell.gob"
	
    GList *l;

    MN_LIST_FOREACH(l, self->mailboxes->list)
      {
	MNMailbox *mailbox = l->data;
	GSList *list;

	list = mn_g_ptr_array_to_slist(mailbox->messages);
	mn_mailbox_consider_as_read_list(list);
	g_slist_free(list);
      }
  }}
#line 1446 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 822 "src/mn-shell.gob"
void 
mn_shell_update (MNShell * self)
{
#line 1453 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::update"
#line 822 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 822 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1459 "mn-shell.c"
{
#line 824 "src/mn-shell.gob"
	
    mn_mailboxes_check(self->mailboxes);
  }}
#line 1465 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 828 "src/mn-shell.gob"
void 
mn_shell_quit (MNShell * self)
{
#line 1472 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::quit"
#line 828 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 828 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1478 "mn-shell.c"
{
#line 830 "src/mn-shell.gob"
	
    g_object_unref(self);
  }}
#line 1484 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 834 "src/mn-shell.gob"
void 
mn_shell_show_properties_dialog (MNShell * self, guint32 timestamp)
{
#line 1491 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::show_properties_dialog"
#line 834 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 834 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1497 "mn-shell.c"
{
#line 836 "src/mn-shell.gob"
	
    self_show_window(self, MN_TYPE_PROPERTIES_DIALOG, &selfp->properties_dialog, timestamp);
  }}
#line 1503 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 840 "src/mn-shell.gob"
void 
mn_shell_show_about_dialog (MNShell * self, guint32 timestamp)
{
#line 1510 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::show_about_dialog"
#line 840 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 840 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1516 "mn-shell.c"
{
#line 842 "src/mn-shell.gob"
	
    self_show_window(self, MN_TYPE_ABOUT_DIALOG, &selfp->about_dialog, timestamp);
  }}
#line 1522 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 846 "src/mn-shell.gob"
static void 
mn_shell_show_window (MNShell * self, GType type, GtkWidget ** ptr, guint32 timestamp)
{
#line 1529 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::show_window"
#line 846 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 846 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 846 "src/mn-shell.gob"
	g_return_if_fail (type != 0);
#line 846 "src/mn-shell.gob"
	g_return_if_fail (ptr != NULL);
#line 1539 "mn-shell.c"
{
#line 851 "src/mn-shell.gob"
	
    if (*ptr)
      {
	if (timestamp)
	  gtk_window_present_with_time(GTK_WINDOW(*ptr), timestamp);
	else
	  gtk_window_present(GTK_WINDOW(*ptr));
	return;
      }

    *ptr = g_object_new(type, NULL);
    mn_add_weak_pointer(ptr);

    gtk_widget_show(*ptr);
  }}
#line 1557 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 867 "src/mn-shell.gob"
void 
mn_shell_add_mailbox_properties_dialog (MNShell * self, MNMailboxPropertiesDialog * dialog)
{
#line 1564 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::add_mailbox_properties_dialog"
#line 867 "src/mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 867 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 867 "src/mn-shell.gob"
	g_return_if_fail (dialog != NULL);
#line 867 "src/mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (dialog));
#line 1574 "mn-shell.c"
{
#line 869 "src/mn-shell.gob"
	
    selfp->mailbox_properties_dialogs = g_slist_append(selfp->mailbox_properties_dialogs, dialog);
    g_object_weak_ref(G_OBJECT(dialog), self_mailbox_properties_dialog_weak_notify_cb, self);
  }}
#line 1581 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 874 "src/mn-shell.gob"
static void 
mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object)
{
#line 1588 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::mailbox_properties_dialog_weak_notify_cb"
{
#line 877 "src/mn-shell.gob"
	
    Self *self = data;

    selfp->mailbox_properties_dialogs = g_slist_remove(selfp->mailbox_properties_dialogs, former_object);
  }}
#line 1597 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 883 "src/mn-shell.gob"
MNMailboxPropertiesDialog * 
mn_shell_get_mailbox_properties_dialog (MNShell * self, MNMailbox * mailbox)
{
#line 1604 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::get_mailbox_properties_dialog"
#line 883 "src/mn-shell.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxPropertiesDialog * )0);
#line 883 "src/mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (MNMailboxPropertiesDialog * )0);
#line 883 "src/mn-shell.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMailboxPropertiesDialog * )0);
#line 883 "src/mn-shell.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMailboxPropertiesDialog * )0);
#line 1614 "mn-shell.c"
{
#line 885 "src/mn-shell.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->mailbox_properties_dialogs)
      {
	MNMailboxPropertiesDialog *dialog = l->data;
	MNMailbox *this_mailbox;
	gboolean found;

	this_mailbox = mn_mailbox_properties_dialog_get_mailbox(dialog);
	found = this_mailbox == mailbox;
	g_object_unref(this_mailbox);

	if (found)
	  return dialog;
      }

    return NULL;
  }}
#line 1636 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 905 "src/mn-shell.gob"
char * 
mn_shell_get_summary (MNShell * self)
{
#line 1643 "mn-shell.c"
#define __GOB_FUNCTION__ "MN:Shell::get_summary"
#line 905 "src/mn-shell.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 905 "src/mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (char * )0);
#line 1649 "mn-shell.c"
{
#line 907 "src/mn-shell.gob"
	
    int indent;
    xmlDoc *doc;
    xmlNode *root;
    int i;
    xmlChar *summary;

    indent = xmlIndentTreeOutput;
    xmlIndentTreeOutput = 1;

    doc = xmlNewDoc("1.0");
    root = xmlNewNode(NULL, "messages");
    xmlDocSetRootElement(doc, root);

    MN_ARRAY_FOREACH(i, self->mailboxes->messages)
      {
	MNMessage *message = g_ptr_array_index(self->mailboxes->messages, i);
	xmlNode *node;

	node = mn_message_xml_node_new(message);
	xmlAddChild(root, node); /* owns node */
      }

    xmlDocDumpFormatMemory(doc, &summary, NULL, 1);

    xmlFreeDoc(doc);
    xmlIndentTreeOutput = indent;

    return summary;
  }}
#line 1682 "mn-shell.c"
#undef __GOB_FUNCTION__
static const GEnumValue _mn_action_values[] = {
	{ MN_ACTION_LAUNCH_MAIL_READER, (char *)"MN_ACTION_LAUNCH_MAIL_READER", (char *)"launch-mail-reader" },
	{ MN_ACTION_OPEN_LATEST_MESSAGE, (char *)"MN_ACTION_OPEN_LATEST_MESSAGE", (char *)"open-latest-message" },
	{ MN_ACTION_CONSIDER_NEW_MAIL_AS_READ, (char *)"MN_ACTION_CONSIDER_NEW_MAIL_AS_READ", (char *)"consider-new-mail-as-read" },
	{ MN_ACTION_UPDATE_MAIL_STATUS, (char *)"MN_ACTION_UPDATE_MAIL_STATUS", (char *)"update-mail-status" },
	{ 0, NULL, NULL }
};

GType
mn_action_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAction", _mn_action_values);
	return type;
}

static const GEnumValue _mn_expiration_enabled_values[] = {
	{ MN_EXPIRATION_ENABLED_DEFAULT, (char *)"MN_EXPIRATION_ENABLED_DEFAULT", (char *)"default" },
	{ MN_EXPIRATION_ENABLED_FALSE, (char *)"MN_EXPIRATION_ENABLED_FALSE", (char *)"false" },
	{ MN_EXPIRATION_ENABLED_TRUE, (char *)"MN_EXPIRATION_ENABLED_TRUE", (char *)"true" },
	{ 0, NULL, NULL }
};

GType
mn_expiration_enabled_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNExpirationEnabled", _mn_expiration_enabled_values);
	return type;
}

static const GEnumValue _mn_popup_position_values[] = {
	{ MN_POPUP_POSITION_ATTACHED, (char *)"MN_POPUP_POSITION_ATTACHED", (char *)"attached" },
	{ MN_POPUP_POSITION_FREE, (char *)"MN_POPUP_POSITION_FREE", (char *)"free" },
	{ 0, NULL, NULL }
};

GType
mn_popup_position_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPopupPosition", _mn_popup_position_values);
	return type;
}

