#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <glib.h>
#include <maitretarot.h>

xmlDocPtr xmlconfig_doc = NULL;
xmlXPathContextPtr xmlconfig_context = NULL;
gboolean xml_xpath_is_initialized = FALSE;

gboolean
libmt_xmlconfig_init_from_doc (void)
{
  if (!xmlconfig_doc)
    return (FALSE);
  if (!xml_xpath_is_initialized)
    xmlXPathInit ();
  xml_xpath_is_initialized = TRUE;
  xmlconfig_context = xmlXPathNewContext (xmlconfig_doc);
  return (TRUE);
}

gboolean
libmt_xmlconfig_init_from_string (gchar * xml_config_string)
{
  if (xmlconfig_doc)
    return (TRUE);
  xmlconfig_doc =
    xmlParseMemory (xml_config_string, strlen (xml_config_string));
  return (libmt_xmlconfig_init_from_doc ());
}

gboolean
libmt_xmlconfig_init_from_file (const gchar * config_file_name)
{
  if (xmlconfig_doc)
    return (TRUE);
  if (!g_file_test (config_file_name, G_FILE_TEST_EXISTS))
    return (FALSE);
  xmlconfig_doc = xmlParseFile (config_file_name);
  return (libmt_xmlconfig_init_from_doc ());
}

void
libmt_xmlconfig_free (void)
{
  xmlXPathFreeContext (xmlconfig_context);
  xmlFreeDoc (xmlconfig_doc);
  xmlconfig_doc = NULL;
  xmlconfig_context = NULL;
}

const gchar *
libmt_xmlconfig_get_value (gchar * path)
{
  xmlXPathObjectPtr object;
  gchar *value = NULL;

  if (!xmlconfig_doc)
    return (NULL);

  object = xmlXPathEval (path, xmlconfig_context);
  if (object->type == XPATH_NODESET)
    {
      if (object->nodesetval->nodeNr)
	{
	  xmlNodePtr node;
	  node = object->nodesetval->nodeTab[0];
	  if (node->type == XML_TEXT_NODE)
	    {
	      value = node->content;
	    }
	  else if (node->type == XML_CDATA_SECTION_NODE)
	    {
	      value = node->content;
	    }
	}
    }
  xmlXPathFreeObject (object);
  return (value);
}

gboolean
libmt_xmlconfig_set_value (gchar * path, gchar * content)
{
  xmlXPathObjectPtr object;
  gboolean r = FALSE;

  if (!xmlconfig_doc)
    return (FALSE);

  object = xmlXPathEval (path, xmlconfig_context);
  if (object->type == XPATH_NODESET)
    {
      if (object->nodesetval->nodeNr)
	{
	  xmlNodePtr node;
	  node = object->nodesetval->nodeTab[0];
	  if (node->type == XML_TEXT_NODE)
	    {
	      xmlNodeSetContent (node, content);
	      r = TRUE;
	    }
	}
    }
  xmlXPathFreeObject (object);
  return (r);
}

gboolean
libmt_xmlconfig_write_file (gchar * filename, gboolean keep_bakup_file)
{
  gchar *filename_bak;
  filename_bak = g_strconcat (filename, ".bak", NULL);
  if (g_file_test (filename_bak, G_FILE_TEST_EXISTS))
    unlink (filename_bak);
  if (g_file_test (filename, G_FILE_TEST_EXISTS))
    rename (filename, filename_bak);
  if (xmlSaveFormatFile (filename, xmlconfig_doc, 1) == -1)
    {
      rename (filename_bak, filename);
      return (FALSE);
    }
  else if (!keep_bakup_file)
    {
      unlink (filename_bak);
    }
  g_free (filename_bak);
  return (TRUE);
}

xmlXPathContextPtr
libmt_xmlconfig_get_context (void)
{
  return (xmlconfig_context);
}

xmlDocPtr
libmt_xmlconfig_get_doc (void)
{
  return (xmlconfig_doc);
}
