/*
 * MaitreTarot. (C) 2002 Guillaume Weexsteen <gui.mail@wanadoo.fr> Modified
 * by Yves Mettier <ymettier@libertysurf.fr>
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <glib.h>

#include <maitretarot.h>
#include "defs.h"
#include "config_utils.h"
#include "game.h"

void
deconnexion_handle (void)
{
  g_message (_("A client disconnected\n"));
  exit (EXIT_SUCCESS);
}



int
main (int argc, char **argv)
{
  game_t *game;
  gboolean continue_playing;
  config_t *config;

  config = config_read (argc, argv);
  if (!config)
    exit (EXIT_FAILURE);

  g_thread_init (NULL);

  g_print ("maitretarot listen on port %d\n", config->port);

  game = game_new (config->port);
  if (!game)
    deconnexion_handle ();

  /* boucle de jeu */
  continue_playing = TRUE;
  while (continue_playing)
    {
      int r;
      init_hand (game);

      if (dill_cards (game) == -1)
	deconnexion_handle ();
      r = bills (game);
      if (r == 1)
	{
	  if (manage_chien (game) == -1)
	    deconnexion_handle ();
	  g_print ("game start!\n");
	  if (play_game (game) == -1)
	    deconnexion_handle ();
	  compute_scores (game);
	}
      else if (r == -1)
	{
	  deconnexion_handle ();
	}
      else
	{
	  compute_scores_when_no_game_was_played (game);
	}
      if (send_scores (game) == -1)
	deconnexion_handle ();
      if (send_chien (game, FALSE))
	deconnexion_handle ();

      continue_playing = ask_players_if_the_want_to_play_again (game);
      if (continue_playing == -1)
	deconnexion_handle ();
    }

  return (0);
}
