/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <libmt_client.h>
#include "defs.h"
#include "config_utils.h"


extern config_t *config;


gint
player_client_init (libmt_client_player_t * player)
{
  player->nick[0] = g_string_new (config->player_name->str);

  g_printerr (player->nick[0]->str);

  return (0);
}


gint
player_client_game_init (libmt_client_player_t * player)
{
  return (0);
}




gint
player_client_make_bid (libmt_client_player_t * player)
{
  /* make a petit */
/*   player->bid[player->place] = LIBMT_BID_PRISE; */
  player->bid[player->place] = LIBMT_BID_PASSE;
  g_printerr ("Bid is : %d\n", player->bid[player->place]);

  return (0);
}


static
void swap (gint *a, gint*b)
{
  gint c;

  c = *a;
  *a = *b;
  *b = c;
}

static gboolean
is_valide_for_chien (gint card)
{
  if (card == CLUB + 13 || card == SPADE + 13
      || card == HEART + 13 || card == DIAMOND + 13
      || card >= TRUMP)
    return FALSE;

  return TRUE;
}

gint
player_client_make_chien (libmt_client_player_t * player)
{
  gint i, j;

  g_printerr ("before changes, chien is :");
  for (i = 0; i < player->nb_chien_card; i++)
    {
      g_printerr ("%d  ", player->chien[i]);
    }
  g_printerr ("\n");

  for (i = 0; i < player->nb_chien_card; i++)
    {
      if (! is_valide_for_chien (player->chien [i]))
	{
	  for (j = 0; j < player->nb_hand_card; j++)
	    {
	      if (is_valide_for_chien (player->card[j]))
		{
		  swap (&player->chien[i], &player->card[j]);
		}
	    }
	}
    }

  g_printerr ("after changes, chien is :");
  for (i = 0; i < player->nb_chien_card; i++)
    {
      g_printerr ("%d  ", player->chien[i]);
    }
  g_printerr ("\n");

  return (0);
}


gint
player_client_not_make_chien (libmt_client_player_t * player)
{
  g_printerr ("in player_client_not_make_chien\n");

  return (0);
}



gint
player_client_choose_card (libmt_client_player_t * player)
{
  /* choose a random card, and don't cheat */
  do
    {
      player->card_play =
	player->
	card[(int) (1.0 * player->nb_hand_card * rand () / (RAND_MAX))];
    }
  while (player->card_play == -1);

  g_printerr ("IA play card : %d\n", player->card_play);

  return (0);
}


gint
player_client_remove_card (libmt_client_player_t * player)
{
  gint i;

  for (i = 0; i < player->nb_hand_card; i++)
    if (player->card_play == player->card[i])
      player->card[i] = -1;

  return (0);
}


gint
player_client_draw (libmt_client_player_t * player)
{
  gint gi;

  switch (player->draw_state)
    {
    case LIBMT_CLIENT_DRAW_OTHER_BID:
      g_printerr (_("An other player makes its bid\n"));
      break;

    case LIBMT_CLIENT_DRAW_GET_BID:
      g_printerr (_("An other player makes its bid\n"));
      break;

    case LIBMT_CLIENT_DRAW_MAKE_CHIEN:
      g_printerr (_("Ready to make chien\n"));
      break;

    case LIBMT_CLIENT_DRAW_GET_CHIEN:
      g_printerr ("Chien is : ");
      for (gi = 0; gi < player->nb_chien_card; gi++)
	g_printerr ("%d  ", player->chien[gi]);
      g_printerr ("\n");
      break;

    case LIBMT_CLIENT_DRAW_START_PLAYING:
      g_printerr (_("Start to play!\n"));
      break;

    case LIBMT_CLIENT_DRAW_OTHER_PLAY:
      g_printerr (_("An other player plays his card\n"));
      break;

    case LIBMT_CLIENT_DRAW_PAUSE_END_TURN:
      g_printerr (_("End of turn\n"));
      break;

    case LIBMT_CLIENT_DRAW_PAUSE_END_GAME:
      g_printerr (_("End of game\n"));
      g_print ("Contract : %d\n", player->contract);
      g_print ("Taker is the winner : %s\n",
	       (player->taker_is_winner ? "Yes" : "No"));
      g_print ("Taker score : %d\n", player->taker_score);
      g_print ("Number of oudler : %d\n", player->nb_oudler);

      g_print ("Scores :\n");
      for (gi = 0; gi < player->nb_player; gi++)
	{
	  g_print ("  %s : %d\n", player->nick[gi]->str, player->score[gi]);
	}
      break;

    case LIBMT_CLIENT_DRAW_NONE_TAKE:
      g_printerr (_("Nobody takes. Press space to continue\n"));
      break;
    }

  return (0);
}


gint
player_client_ack_replay (libmt_client_player_t * player)
{
  g_printerr (_("IA want to replay :)\n"));
  player->replay = TRUE;

  return 0;
}



gint
player_client_lost_connection (libmt_client_player_t * player)
{
  g_printerr (_("Someone have quit the game : lost connection\n"));

  return 0;
}


gint
player_client_normal_close (libmt_client_player_t * player)
{
  g_printerr (_("Normal end of game\n"));

  return 0;
}
