/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MT_GTK_CLIENT_GUI_H
#define MT_GTK_CLIENT_GUI_H

#include <gtk/gtk.h>
#include <libmt_client.h>
#include "config_utils.h"

#define X_HIDE (-1000)
#define Y_HIDE (-1000)

#define GUI_CARD_IN_CHIEN    (1000)
#define LAYOUT_BG_COLOR      "ForestGreen"


typedef void (*gui_redraw_func_t) (GtkWidget * win, GdkEventConfigure * evt,
				   gpointer data);

extern void gui_set_redraw_func (gui_redraw_func_t func, gpointer data);
extern void gui_do_redraw (void);

extern gint gui_init (int argc, char **argv);
extern void gui_clear_layout (void);
extern void gui_layout_get_size (GdkEventConfigure * evt, gint * width,
				 gint * height);

extern void gui_start_game (void);

extern gint gui_load_images (void);

extern void gui_init_card_sort (void);
extern void gui_sort_card (gint * card, gint nb_card);


extern gint gui_card_sort[NUMBER_OF_CARD + 1];



/* GUI variable */
extern GtkWidget *gui_mainwin;
extern GtkWidget *gui_layout;
extern GtkWidget *gui_statusbar;
extern GtkWidget *gui_menubar;
extern GtkItemFactory *gui_item_factory;
extern GtkAccelGroup *gui_accel_group;

extern GtkWidget *gui_card_img[NUMBER_OF_CARD + 1];
extern gint gui_card_width, gui_card_height;


#endif /* MT_GTK_CLIENT_GUI_H */
