/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <libintl.h>
#define _(a) gettext (a)
#include <gtk/gtk.h>
#include <stdlib.h>
#include <maitretarot.h>
#include "defs.h"
#include "gui.h"
#include "player.h"
#include "gui_sort_card.h"
#include "gui_config.h"
#include "config_utils.h"
#include "main.h"


config_t *config;

int
main (int argc, char **argv)
{
#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();

  config = config_read (argc, argv);
  if (!config)
    {
      g_error (_("Could not initialize the config"));
    }
/*   else { */
/*     printf ("Dump of the xml file into /tmp/config.xml\n\n"); */
/*     libmt_xmlconfig_write_file ("/tmp/config.xml", FALSE); */
/*     config_print (config); */
/*     exit (0); */
/*   } */

  g_thread_init (NULL);
  gdk_threads_init ();

  gui_init (argc, argv);

  gdk_threads_enter ();
  gtk_main ();
/*   while (1) */
/*     { */
/*       gtk_main_iteration_do (FALSE); */
/*     } */
  gdk_threads_leave ();

  return (0);
}


void
show_usage (gchar * prog_name)
{
  g_printerr (_
	      ("%s [-h | --help] [-v | --version] [-g | --geometry geometry] [-p | --port port] [-s | --server server] [-n | --name name]\n"),
	      prog_name);
  g_printerr (_
	      ("    -h, --help                  Gives this help display.\n"));
  g_printerr (_
	      ("    -v, --version               Display program version.\n"));
  g_printerr (_
	      ("    -g, --geometry=geometry     Set the window geometry to geometry\n"));
  g_printerr (_
	      ("                                (i.e: 'width'x'height'+/-'x'+/-'y')\n"));
  g_printerr (_("                                (ex: 640x480+10+10)\n"));
  g_printerr (_("    -p, --port=port             Set the port.\n"));
  g_printerr (_("    -s, --server=server         Set the server name.\n"));
  g_printerr (_("    -n, --player-name=name      Set the player name.\n"));
  g_printerr (_
	      ("    -c, --config-file-name=filename    Use an alternate configuration file.\n"));
  g_printerr (_
	      ("        --no-start-screen       Start a game without interaction with player\n"));
  g_printerr (_
	      ("        --cardpics-dir=<path>   Path of the Cardpics images\n"));
  
  exit(EXIT_SUCCESS);	      
}
