/*
 * Make7Libre, free (as in freedom) implementation of the
 * unfamous game 'Make 7 Hexa Puzzle'
 * Copyright 2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 * 
 * This file is part of Make7Libre.
 * 
 * Make7Libre is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Make7Libre is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with Make7Libre.  If not, see <http://www.gnu.org/licenses/>.
 */
/***********
 * game.h  *
 * ~~~~~~~ *
 ***********/

#ifndef MAKE7LIBRE_GAME_H__
#define MAKE7LIBRE_GAME_H__

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */

#include <iostream>
#include <gtkmm.h>
#include "gettext.h"

class Game
{
public:
  Game ();
  void connect_every_button ();
  void display (Glib::RefPtr<Gtk::Application> app);
  void end_game ();
  void import_every_widget ();
  void launch_game ();

private:
  void display_error (int i);
  virtual void game_button_selected (int ref);
  Glib::ustring get_main_hexa ();
  int get_neighbour (int rel, int ref);
  int get_pos2 ();
  void get_random_hexas ();
  Glib::ustring get_second_hexa ();
  void on_cancel_action_activate ();
  void on_close_help_activate ();
  void on_close_scores_activate ();
  void on_display_credits_activate ();
  void on_display_help_activate ();
  void on_display_scores_activate ();
  void on_erase_hexa_activate ();
  void on_new_game_activate ();
  void on_next_hexa_activate ();
  void on_quit_game_activate ();
  void on_rotate_hexas_activate ();
  void next_turn (int a, int b);
  void refresh_board ();
  void refresh_score ();
  void refresh_selection_area ();
  void reset_board ();
  void reset_selection_area ();
  void scan_neighbours (int ref, std::list<int> &oldRefs);
  void set_main_hexa (std::string Snum);
  void set_pos2 (int givenPos2);
  void set_second_hexa (std::string Snum);
  
  /* External variables */
  
  // Windows
  Gtk::Window *make7window, *make7scores;
  Gtk::MessageDialog *make7message, *make7error_board;
  Gtk::AboutDialog *make7credits;

  // Buttons pointers
  Gtk::Button
  //  Interface
    *button_cancel, *button_close_scores, *button_credits,
    *button_erase, *button_help, *button_new, *button_next,
    *button_quit, *button_rotate, *button_scores,
  //  Game Board
    *nnw, *nn, *nne, *nww, *nw, *ne, *nee, *ww, *w, *m, *e, *ee, *sww,
    *sw, *se, *see, *ssw, *ss, *sse,
  //  Game Selection Area
    *mainNw, *mainNe, *mainW, *mainM, *mainE, *mainSw, *mainSe;
  // Game score
  Gtk::Label *current_score;

  std::map<int,Gtk::Button*> Board, SelectionArea;
  std::list<int> BoardKeys, SelectionAreaKeys;
  int pos2, valHexa1, valHexa2, score, nMatch;
};

#endif // MAKE7LIBRE_GAME_H__
