###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

package myFunctionUtils;

use strict;
use warnings;
use Param qw(:config);

# It resturn a current time in numerical format 'aaaammgghhmmss'
sub timeNow {
    return (localtime)[0] + (localtime)[1] * 100 + (localtime)[2] * 100**2 +
      (localtime)[3] * 100**3 + ( (localtime)[4] + 1 ) * 100**4 +
      ( (localtime)[5] + 1900 ) * 100**5;
}

sub traceLog {
    my ( $msg, $verbose ) = @_;
    print $msg , "\n" if $verbose <= $verboseThreshold;
}

# Am I already running?
sub alreadyRunning {

    # Write on screen 'Am I already running?'
    myFunctionUtils::traceLog( "Am I already running?", 3 );

    # Get my PID
    my $myPID = $$;

    # Get (if exist) other processID
    my $scriptName     = $0;
    my $gettingProcess =
`/bin/ps afxv | /bin/grep '$scriptName' | grep -v grep | grep -v "$myPID"`;
    chomp $gettingProcess;

    # Write output
    $gettingProcess =~ s/^\s*//;
    myFunctionUtils::traceLog( "\tGetting: '$gettingProcess'", 5 );

    my @pezzi = split( '\s+', $gettingProcess );
    my $msg = "splitted values: " . join( "|", @pezzi );
    myFunctionUtils::traceLog( $msg, 5 );
    my $pid = $pezzi[0];
    if ( ( defined $pid ) and ( $pid =~ /\d+/ ) ) {
        $msg = "I'm already running with pid [$pid]... so I'm exit now.";
        myFunctionUtils::traceLog( $msg, 1 );
        exit;
    }
}

# Transform datetime from format aaaammgghhmmss in _TIME_ human-redable hh.mm.ss
sub getTimeFromNowDateTime {

    #    my ($datetime) = @_;
    my $dateNow =
        sprintf( "%02d", (localtime)[2] ) . '.'
      . sprintf( "%02d", (localtime)[1] ) . '.'
      . sprintf( "%02d", (localtime)[0] );
    return $dateNow;
}

# Transform datetime from format aaaammgghhmmss in _DATE_ human-redable gg.mm.aaaa
sub getDateFromNowDateTime {

    #    my ($datetime) = @_;
    my $dateNow =
        sprintf( "%02d", (localtime)[3] ) . '.'
      . sprintf( "%02d", ( (localtime)[4] + 1 ) ) . '.'
      . ( 1900 + (localtime)[5] );
    return $dateNow;
}

# Transform datetime from aaaa-mm-gg
sub transformDatetimeInHumanDate {
    my ($datetime) = @_;
    my $HumanDate =
        substr( $datetime, 8, 2 ) . '.'
      . substr( $datetime, 5, 2 ) . '.'
      . substr( $datetime, 0, 4 );
    return $HumanDate;
}

# Transform datetime from aaaa-mm-gg hh:mm:ss
sub transformDatetimeInHumanDatetime {
    my ($datetime) = @_;
    my $HumanDate =
        substr( $datetime, 8, 2 ) . '.'
      . substr( $datetime, 5, 2 ) . '.'
      . substr( $datetime, 0, 4 );
    $HumanDate .= ' '
      . substr( $datetime, 11, 2 ) . '.'
      . substr( $datetime, 14, 2 ) . '.'
      . substr( $datetime, 17, 4 );
    return $HumanDate;
}

# check mac address
sub checkMAC {
    my ($mac) = @_;
    if ( $mac =~ /^[0-9a-fA-F]{2}((-|:| |)?[0-9a-fA-F]{2}){1,5}$/ ) {
        return 1;
    }
    else { return 0; }
}

# check IP address
sub checkIP {
    my ($ip) = @_;
    if ( $ip =~ /^(\d{1,3}\.){3}\d{1,3}$/ ) {
        return 1;
    }
    else { return 0; }
}

# check switch's port
sub checkPort {
    my ($Port) = @_;
    if ( $Port =~ /^\d{1,4}$/ ) {
        return 1;
    }
    else { return 0; }
}

# check id switch
sub checkIDswitch {
    my ($IDswitch) = @_;
    if ( $IDswitch =~ /^\d{1,3}$/ ) {
        return 1;
    }
    else { return 0; }
}

# cleaned up MAC (trasform mac in lower case, erase ':' and/or '-' and/or ' ' )
sub cleanedUpMAC {
    my ($cleanedUpMAC) = @_;
    $cleanedUpMAC =~ s/\:|\-| //g;
    $cleanedUpMAC =~ s/^0x//;
    return lc($cleanedUpMAC);
}

# it returns text SNMP version from number SNMP version
sub textSNMPversion {
    my ($numberSNMPversion) = @_;
    my $textSNMPversion = '';
    if ( $numberSNMPversion == 2 ) {
        $textSNMPversion = 'snmpv2c';
    }
    else { $textSNMPversion = 'snmpv1'; }
    return ($textSNMPversion);
}

1;
