/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 0.1.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2005,2006 COLLARD Christophe
 * copyright  2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    Eshelby-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type Eshelby test
#endif

#if !defined(__ESHELBY_TEST_H)
#define __ESHELBY_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__PRECISION_H)
#include "../../MOL++/precision.h"
#endif

#if !defined(__MATRIX_H)
#include"../../MOL++/matrix.h"
#endif

#if !defined(__TENSORS2_H)
#include"../../MOL++/tensors2.h"
#endif

#if !defined(__TENSORS3_H)
#include"../../MOL++/tensors3.h"
#endif

#if !defined(__ISOTROPIC_TENSORS_H)
#include"../../MateriOL++/isotropic tensors.h"
#endif

#if !defined(__TII_H)
#include"../../MateriOL++/TII.h"
#endif

#if !defined(__ESHELBY_H)
#include"../../MateriOL++/Eshelby.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//===========================
int test_Eshelby (int detail)
//===========================
{
  int result=1;
  bool test = true;

  long double R = 5;
  long double V = 4/3. * pi() * power(R,3);
  long double nu = 0.3;
  long double mu = 80000.;
  long double lambda = 120000;

  long double c = 2.5E-1; // length of the oblate radius rotation axis

  isotropic_tensor<long double> C;
  C.Lame(lambda);
  C.Poisson(nu);
  //  C.Shear(mu);

  tensor4<long double> T_analytique(3), Tiso_analytique(3);
  long double coef = V / (30 * mu * (1-nu));
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  T_analytique(i,j,k,l) = ( (9. - 10*nu) * (i==k) * (j==l) - ( (i==j)*(k==l) + (i==l)*(j==k)) ) * coef;

  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      Tiso_analytique[i][j] = (long double) .5 * (T_analytique[i][j] + T_analytique[j][i]);

  tensor4<long double> Siso_analytique;
  Siso_analytique = (Tiso_analytique || C) * (long double) (1/V);

  Eshelby SII;
  test = (Siso_analytique == SII.sphere(C));
  if (detail) affiche ("sphere", test);
  else result *= (test);

  vector<long double> geometry (3,true,R);
  test = (Siso_analytique == SII.Sii(C,geometry,13,17));
  if (detail) affiche ("Sii (sphere)", test);
  else result *= (test);

  geometry[3] = 5.e-2;
  tensor4<long double> Ti_pennyshape =& SII.penny_shape(C,geometry);
  tensor4<long double> Ti =& SII.Sii(C,geometry,500,10);
  test = true;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  test *= abs(Ti(i,j,k,l) - Ti_pennyshape(i,j,k,l)) < 5.e-4;
  geometry[3] = 5.e-5;
  Ti_pennyshape =& SII.penny_shape(C,geometry);
  Ti =& SII.Sii(C,geometry,10,10);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  test *= abs(Ti(i,j,k,l) - Ti_pennyshape(i,j,k,l)) < 2.e-5;
  if (detail) affiche ("penny shape / Sii", test);
  else result *= (test);

  test = abs(Ti (2,3,2,3) - SII.oblate_spheroid_2332(C,geometry)) < 1.e-5;
  test *= abs(Ti_pennyshape (2,3,2,3) - SII.oblate_spheroid_2332(C,geometry)) < 2.e-10;
  if (detail) affiche ("oblate / penny shape (coord 2332)", test);
  else result *= (test);

  geometry[3] = R-5.e-4;
  test = abs(SII.Sii(C,geometry,13,17)(2,3,3,2) -  SII.oblate_spheroid_2332(C,geometry)) < 2.e-6;
  test *= abs(Siso_analytique(2,3,3,2) -  SII.oblate_spheroid_2332(C,geometry)) < 6.e-6;
  if (detail) affiche ("oblate / sphere (coord 2332)", test);
  else result *= (test);

  geometry[3] = 2;
  test = abs(SII.Sii(C,geometry,60,17)(2,3,3,2) -  SII.oblate_spheroid_2332(C,geometry)) < epsilon;
  if (detail) affiche ("oblate / Sii (coord 2332)", test);
  else result *= (test);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                     Eshelby test passed \n";
  else cout << "                     Eshelby test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
