/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 0.1.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2005,2006 COLLARD Christophe
 * copyright  2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    TII-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type TII test
#endif

#if !defined(__TII_TEST_H)
#define __TII_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__PRECISION_H)
#include "../../MOL++/precision.h"
#endif

#if !defined(__MATRIX_H)
#include"../../MOL++/matrix.h"
#endif

#if !defined(__TENSORS4_H)
#include"../../MOL++/tensors4.h"
#endif

#if !defined(__ISOTROPIC_TENSORS_H)
#include"../../MateriOL++/isotropic tensors.h"
#endif

#if !defined(__TII_H)
#include"../../MateriOL++/TII.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//=======================
int test_TII (int detail)
//=======================
{
  int result=1;
  bool test = true;

  long double R = 5;
  long double V = 4/3. * pi() * power(R,3);
  long double lambda = 120000, mu = 80000, nu = 0.3;

  isotropic_tensor<long double> C ("elasticity tensor");
  C.Lame(lambda);
  C.Poisson(nu);

  tensor4<long double> T_analytique(3), Tiso_analytique(3);
  long double coef = V / (30 * mu * (1-nu));
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  T_analytique(i,j,k,l) = ( (9. - 10*nu) * (i==k) * (j==l) - ( (i==j)*(k==l) + (i==l)*(j==k)) ) * coef;

  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      Tiso_analytique[i][j] = (long double) .5 * (T_analytique[i][j] + T_analytique[j][i]);

  vector<long double> geometry(3,true,R); // a = b = c = R
  TII<long double> tii(15,30);
  test = (Tiso_analytique == tii.sphere(C,geometry));
  if (detail) affiche ("sphere (analytique)", test);
  else result *= (test);

  test = (tii.Tii(C,geometry) == tii.sphere(C,geometry));
  if (detail) affiche ("Tii (sphere)", test);
  else result *= (test);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                       TII test passed \n";
  else cout << "                       TII test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
