/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 0.1.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2005,2006 COLLARD Christophe
 * copyright  2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    MatOoLbox-test belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type MatOoLbox test
#endif

#if !defined(__MATERIALS_TOOLBOX_TEST_H)
#define __MATERIALS_TOOLBOX_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__PARAMETERS_H)
#include "../../parameters.h"
#endif

#if !defined(__TENSORS2_H)
#include"../../MOL++/tensors2.h"
#endif

#if !defined(__TENSORS4_H)
#include"../../MOL++/tensors4.h"
#endif

#if !defined(__MATERIALS_TOOLBOX_H)
#include"../../MateriOL++/MatOoLbox.h"
#endif

#if !defined(__ISOTROPIC_ELASTICITY_TENSORS_H)
#include "../../MateriOL++/isotropic elasticity tensors.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//=============================
int test_MatOoLbox (int detail)
//=============================
{
  int result=1;
  tensor2<long double> Id =& kronecker<long double>(3);
  tensor2<long double> stress(3,3);
  long double sc = 1;
  sc /= 3;
  stress(1,1) = 125.4567;
  stress(2,2) = 23.56;
  stress(3,3) = 32.341;
  stress(1,2) = stress(2,1) = -15.234;
  stress(1,3) = 24.567;
  stress(3,1) = -23.67;
  stress(2,3) = -27.1234;
  stress(3,2) = 61.345;

  if (detail) affiche ("Von Mises equivalent stress", abs(sqrt((long double) 1.5*(stress-sc*tr(stress)*Id)|(stress-sc*tr(stress)*Id)) - Von_Mises_stress(stress)) < epsilon);
  else result *= ( abs (sqrt((long double) 1.5*(stress-tr(stress)*Id)|(stress-tr(stress)*Id)) == Von_Mises_stress(stress)) < epsilon);

  tensor2<long double> strain = stress;
  if (detail) affiche ("Von Mises equivalent strain", abs(sqrt((long double) 2*sc*(strain|strain)) - Von_Mises_strain(strain)) < epsilon);
  else result *= (abs(sqrt((long double) 2*sc*(strain|strain)) - Von_Mises_strain(strain)) < epsilon);

  isotropic_elasticity_tensor<long double> C;
  C.Lame(120000);
  C.Shear(80000);
  tensor2<long double> M(3,3);
  M(1,1) = 4; M(1,2) = -1; M(1,3) = 8;
  M(2,1) = -2; M(2,3) = 7;
  M(3,1) = M(3,2) = 0.5; M(3,3) = 9;
  long double To = 27.85*0;

  isotropic_elasticity_tensor<long double> S = C.inv();
  stress(1,3) = stress(3,1);
  stress(3,2) = stress(2,3);
  strain = constitutive_equation(S, S||M, stress, To, 1);
  if (detail) affiche ("constitutive equation", strain == ((S||stress) + (S||M)*To) && stress == constitutive_equation(C,M,strain,To,-1));
  else result *= (strain == ((S||stress) + (S||M)*To) && stress == constitutive_equation(C,M,strain,To,-1));

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                    MatOoLbox test passed \n";
  else cout<< "                    MatOoLbox test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
