/***************************************************************
 *                   Material Object Library                   *
 *  Class loading : declaration for different loading dstrain  *
 *                      simula+@ensam.eu                       *
 *                   GNU/linux version 2.2.1                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2008 COLLARD Christophe
 * copyright © 2008 NICAISE Nicolas
 * copyright © 2008 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 ***************************************************************/

/*! \namespace materiol
    \brief Materials Object Libraries
*/

/*! \class materiol::loading
    \brief Numerical computation of strain increment for different kind of loadings

    \htmlonly 
    <FONT color="#838383">

    loading belongs to Material Object Libraries (MateriOL++) </br>
    MateriOL++ is part of Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly

METTRE UN RESUME, CE QUI EST IMPLEMENTE DANS LA CLASSE



    \author copyright \htmlonly &#169; \endhtmlonly 2008 Christophe COLLARD \n
            copyright \htmlonly &#169; \endhtmlonly 2008 Nicolas NICAISE \n
            copyright \htmlonly &#169; 2008 Laboratoire de Physique et M&#233;canique des Mat&#233;riaux (LPMM - CNRS) \endhtmlonly
    \version 2.2.1
    \date 2008
    \bug none
    \warning none
*/

#ifndef __cplusplus
#error Must use C++ for the type tensor3
#endif

#if !defined(__LOADING_H)
#define _LOADING_H


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "MOL++/matrix.h"
#endif

#if !defined(__TENSORS2_H)
#include "MOL++/tensors2.h"
#endif

#if !defined(__CONVERSION_TOOLS_H)
#include "MOL++/conversion tools.h"
#endif

using namespace std;
using namespace mol;

namespace materiol
{


//==================================================================
template <class T, template <class> class tensor_type> class loading
//==================================================================
{
  private:
//  tensor2 <T> dstrain_macro;
//  tensor2 <T> dstress_macro;
    int stock_macro, stock_micro;
    double increment, end_loading;
    string end_criterium;

  public:
    loading() {}
    loading(ifstream&);
    ~loading() {}
    tensor2<T> UT (const tensor_type <T>&, T, int);
    tensor2<T> PS (const tensor_type <T>&, T, int);
};


//----------------------------------------------------
template <class T, template <class> class tensor_type>
loading<T, tensor_type>::loading(ifstream& file3)
//----------------------------------------------------
{ 
  string text, keyword, loading_type, end_crit;
}


/*!
  \brief Uniaxial tensile strain


  \param L elasticity tensor
  \param dE strain increment
  \param axis direction for tensile stress (possible values are 11 or 22 or 33)
  \return \f$ d\EuScript{E} \f$
*/

//-------------------------------------------------------------------------------
template <class T, template <class> class tensor_type>
tensor2<T> loading<T, tensor_type>::UT (const tensor_type <T>& L, T dE, int axis)
//-------------------------------------------------------------------------------
{ 
  assert (axis == 11 || axis == 22 || axis ==33);

  axis /= 11;
  matrix<T> Linv = gauss(symtensor2matrix(L));
  T dSigma = dE / Linv(axis,axis);
  vector<T> dotE(6);
  for (int i=1; i<=6; i++)
    dotE[i] = Linv(i, axis) * dSigma;

  return vector2symtensor(dotE);
}


/*!
  \brief Uniaxial tensile strain


  \param L elasticity tensor
  \param dE strain increment
  \param axis direction for tensile stress (possible values are 11 or 22 or 33)
  \return \f$ d\EuScript{E} \f$
*/

//-------------------------------------------------------------------------------
template <class T, template <class> class tensor_type>
tensor2<T> loading<T, tensor_type>::PS (const tensor_type <T>& L, T dE, int axis)
//-------------------------------------------------------------------------------
{ assert (axis == 12 || axis == 13 || axis == 23);

  if(axis == 12){ axis= 4;}
  if(axis == 13){ axis= 5;}
  if(axis == 23){ axis= 6;}
  matrix<T> Linv = gauss(symtensor2matrix(L));
  T dSigma = dE / Linv(axis,axis);
  vector<T> dotE(6);
  for (int i=1; i<=6; i++)
    dotE[i] = sqrt(2) * Linv(i, axis) * dSigma;

  return vector2symtensor(dotE);
}

}


#endif
