/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 2.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006,2007,2008,2009 COLLARD Christophe
 * copyright © 2005,2006 BERBENNI Stephane
 * copyright © 2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 ***************************************************************/

/*
    tests-materials belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type interface.
#endif

#if !defined(__IOMANIP_H)
#include <iomanip>
#endif

#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__TIME_H)
#include <time.h>
#endif

#if !defined(___COLORS_H)
#include "colors.h"
#endif

#if !defined(__ISOTROPIC_TENSORS_TEST_H)
#include "isotropic tensors-test.h"
#endif

#if !defined(__ISOTROPIC_ELASTICITY_TENSORS_TEST_H)
#include "isotropic elasticity tensors-test.h"
#endif

#if !defined(__CUBIC_TENSORS_TEST_H)
#include "cubic tensors-test.h"
#endif

#if !defined(__CUBIC_ELASTICITY_TENSORS_TEST_H)
#include "cubic elasticity tensors-test.h"
#endif

#if !defined(__ORTHOTROPIC_TENSORS_TEST_H)
#include "orthotropic tensors-test.h"
#endif

#if !defined(__TRANSVERSELY_ISOTROPIC_TENSORS_TEST_H)
#include "transversely isotropic tensors-test.h"
#endif

#if !defined(__TRANSVERSELY_ISOTROPIC_ELASTIC_TENSORS_TEST_H)
#include "transversely isotropic elastic tensors-test.h"
#endif

#if !defined(__TII_TEST_H)
#include "TII-test.h"
#endif

#if !defined(__PII_TEST_H)
#include "PII-test.h"
#endif

//#if !defined(__TIJ_TEST_H)
//#include"materials/TIJ-test.h"
//#endif

#if !defined(__ESHELBY_TEST_H)
#include "Eshelby-test.h"
#endif

#if !defined(__SCHMID_TENSOR_TEST_H)
#include "Schmid tensor-test.h"
#endif

#if !defined(__SYSTEMS_TEST_H)
#include "systems-test.h"
#endif

#if !defined(__LOADING_TEST_H)
#include "loading-test.h"
#endif

#if !defined(__MATERIALS_TOOLBOX_TEST_H)
#include "MatOoLbox-test.h"
#endif

#if !defined(__WALPOLE_TEST_H)
#include "walpole-test.h"
#endif

using namespace std;


main()
{
  int detail; // parameter to write/hide test procedure
  bool result = true;
  clock_t start, end;
  clock_t start_main, end_main;

  detail = 0;
  start_main = start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------------isotropic tensor---------------------- \n";
    //=======================================================================
  result *= test_isotropic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------isotropic elasticity tensor----------------- \n";
    //=======================================================================
  result *= test_isotropic_elasticity_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "------------------------cubic tensor------------------------- \n";
    //=======================================================================
  result *= test_cubic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-------------------cubic elasticity tensor------------------- \n";
    //=======================================================================
  result *= test_cubic_elasticity_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "----------------------orthotropic tensor----------------------\n";
    //=======================================================================
  result *= test_orthotropic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "----------------transversely isotropic tensor---------------- \n";
    //=======================================================================
  result *= test_transversely_isotropic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "------------transversely isotropic elastic tensor------------ \n";
    //=======================================================================
  result *= test_transversely_isotropic_elastic_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------------------TII----------------------------- \n";
    //=======================================================================
  result *= test_TII(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "-----------------------------PII----------------------------- \n";
    //=======================================================================
  result *= test_PII(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  /*
  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------------------TIJ----------------------------- \n";
    //=======================================================================
  result *= test_TIJ(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;
  */

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------Eshelby--------------------------- \n";
    //=======================================================================
  result *= test_Eshelby(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "------------------------Schmid tensor------------------------ \n";
    //=======================================================================
  result *= test_Schmid_tensor(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------systems--------------------------- \n";
    //=======================================================================
  result *= test_systems(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------loading--------------------------- \n";
    //=======================================================================
  result *= test_loading(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "--------------------------MatOolbox-------------------------- \n";
    //=======================================================================
  result *= test_MatOoLbox(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail>0)
    //=======================================================================
    cout<< "---------------------------walpole--------------------------- \n";
    //=======================================================================
  result *= test_walpole(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  end_main = clock();

  cout << "============================================================== \n";
  if (result) cout << green << "-------OK-----------end of MateriOL++ tests-----------OK------" << reset;
  else cout << red << "-----FAILED---------end of MateriOL++ tests---------FAILED----" << reset;
  cout << "============================================================== \n";

  cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
}
