/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006,2007,2008,2009 COLLARD Christophe
 * copyright © 2005,2006,2007,2008,2009 Centre National de la Recherche Scientifique
 * copyright © 2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 ***************************************************************/

/*
    loading-tests belongs to Material Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type loading test
#endif

#if !defined(__LOADING_TEST_H)
#define __LOADING_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(___COLORS_H)
#include "colors.h"
#endif

#if !defined(__PARAMETERS_H)
#include "parameters.h"
#endif

#if !defined(__MATRIX_H)
#include "MOL++/matrix.h"
#endif

#if !defined(__TENSORS4_H)
#include "MOL++/tensors4.h"
#endif

#if !defined(__ISOTROPIC_TENSORS_H)
#include "MateriOL++/isotropic tensors.h"
#endif

#if !defined(__LOADING_H)
#include "MateriOL++/loading.h"
#endif

#if !defined(__AFFICHE_h)
#include "tests/affiche.h"
#endif

using namespace std;
using namespace mol;
using namespace materiol;


//===========================
int test_loading (int detail)
//===========================
{
  int result=1;
  bool test = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                     loading test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  isotropic_tensor<long double> C;
  C.lambda(120000);
  C.mu(80000);

  long double dE = 0.2;
  tensor2<long double> dStress(3);
  dStress (1,1) = dE / C.inv()(1,1,1,1);
  loading<long double, tensor4> chargement;
  tensor2<long double> dotE = chargement.UT (C, dE, 11);
  test *= (dStress == (C||dotE));
  dStress (1,1) = 0;
  dotE = chargement.UT (C, dE, 22);
  dStress (2,2) = dE / C.inv()(2,2,2,2);
  test *= (dStress == (C||dotE));
  dStress (2,2) = 0;
  dotE = chargement.UT (C, dE, 33);
  dStress (3,3) = dE / C.inv()(3,3,3,3);
  test *= (dStress == (C||dotE));

  if (detail) affiche ("UT loading", test);
  else result *= test;

  dStress (3,3) = 0;
  dStress (1,2) = dStress (2,1) = 0.5 * dE / C.inv()(1,2,1,2);
  loading<long double, tensor4> chargement2;
  tensor2<long double> dotE2 = chargement2.PS (C, dE, 12);
  test *= (dStress == (C||dotE2));
  dStress (1,2) = dStress (2,1) = 0;
  dotE2 = chargement2.PS (C, dE, 13);
  dStress (1,3) = dStress (3,1) = 0.5 * dE / C.inv()(1,3,1,3);
  test *= (dStress == (C||dotE2));
  dStress (1,3) = dStress (3,1) = 0;
  dotE2 = chargement2.PS (C, dE, 23);
  dStress (2,3) = dStress (3,2) = 0.5 * dE / C.inv()(2,3,2,3);
  test *= (dStress == (C||dotE2));

  if (detail) affiche ("PS loading", test);
  else result *= test;

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                     loading test passed" << reset;
  else cout << red << "                     loading test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
