/***************************************************************
 *                      simula+@ensam.eu                       *
 *                   GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2008,2009 COLLARD Christophe
 * copyright © 2008,2009 Centre National de la Recherche Scientifique
 * copyright © 2008,2009 Arts et Métiers ParisTech
 * copyright © 2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 ***************************************************************/

/*
    systems-test belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type martensite test
#endif

#if !defined(__SYSTEMS_TEST_H)
#define __SYSTEMS_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(___COLORS_H)
#include "colors.h"
#endif

#if !defined(__PARAMETERS_H)
#include "parameters.h"
#endif

#if !defined(__ISOTROPIC_TENSORS_H)
#include "MateriOL++/isotropic tensors.h"
#endif

#if !defined(__SYSTEMS_H)
#include "MateriOL++/systems.h"
#endif

#if !defined(__AFFICHE_h)
#include "tests/affiche.h"
#endif

using namespace materiol;

//============================
bool test_systems (int detail)
//============================
{
  bool result = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                     systems test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  string material_type = "CuZnAl";
  systems<long double> CuZnAl("data/CuZnAl.dat"), CuZnAl2(material_type, 24);
  material_type = "CuAlBe";
  systems<long double> CuAlBe("data/CuAlBe.dat"), CuAlBe2(material_type, 24);
  material_type = "FCC";
  systems<long double> FCC("data/FCC.dat"), FCC2(material_type, 12);

  bool test = true;
  for (int i=1; i<=24; i++)
    { test *= (CuZnAl.R(i) == CuZnAl2.R(i));
      test *= (CuAlBe.R(i) == CuAlBe2.R(i));
    }
  for (int i=1; i<=12; i++)
    test *= (FCC.R(i) == FCC2.R(i));
  if (detail) affiche ("constructors", test);
  else result *= test;

  if (detail) affiche ("operator ==", CuAlBe==CuAlBe2 && !(CuZnAl==CuAlBe));
  else result *= (CuAlBe==CuAlBe2 && !(CuZnAl==CuAlBe));

  if (detail) affiche ("operator !=", !(CuAlBe!=CuAlBe2) && CuZnAl!=CuAlBe);
  else result *= (!(CuAlBe!=CuAlBe2) && CuZnAl!=CuAlBe);

  systems<long double> mat("data/CuAlBe.dat"), mat1("data/FCC.dat");
  mat = mat1 = CuZnAl;
  if (detail) affiche ("operator =", mat==CuZnAl && mat1==CuZnAl);
  else result *= (mat==CuZnAl && mat1==CuZnAl); 

  if (detail) affiche ("number of systems", CuZnAl.nb_systems()==24);
  else result *= CuZnAl.nb_systems()==24;

  vector<long double> n(3), m(3);
  n[1] = -1.820000E-01;
  n[2] = 6.690000E-01;
  n[3] = 7.210000E-01;
  m[1] = -1.650000E-01;
  m[2] = -7.370000E-01;
  m[3] = 6.550000E-01;
  Schmid_tensor<long double> vr2(n,m);

  vector<long double> n1(3), m1(3);
  n1[1] = -1.820000E-01;
  n1[2] = 7.210000E-01;
  n1[3] = 6.690000E-01;
  m1[1] = -1.650000E-01;
  m1[2] = 6.550000E-01;
  m1[3] = -7.370000E-01;

  n /= n.norm();
  m /= m.norm();
  n1 /= n1.norm();
  m1 /= m1.norm();

  test = true;

  if (detail) affiche ("normal unit vector to slip plane", CuZnAl.n(1)==n && CuZnAl.n(2)==n1);
  else result *= (CuZnAl.n(1)==n && CuZnAl.n(2)==n1);

  if (detail) affiche ("normal unit vector in the slip direction", CuZnAl.m(1)==m && CuZnAl.m(2)==m1);
  else result *= (CuZnAl.m(1)==m && CuZnAl.m(2)==m1);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                     systems test passed" << reset;
  else cout << red << "                     systems test failed" << reset;
  cout << "============================================================== \n";
  return result;
}


#endif
