/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    TII-tests belongs to Material Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type TII test
#endif

#ifndef __TII_test_hpp
#define __TII_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __isotropic_elasticity_tensors_hpp
#include "MateriOL++/isotropic elasticity tensors.hpp"
#endif

#ifndef __TII_hpp
#include "MateriOL++/TII.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace materiol;


//=======================
int test_TII (int detail)
//=======================
{
  int result=1;
  bool test = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                       TII test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  long double R = 5;
  long double V = 4/3. * pi() * power(R,3);
  long double lambda = 120000, mu = 80000, nu = 0.3;

  isotropic_elasticity_tensor<long double> C ("elasticity tensor");
  C.Lame(lambda);
  C.Poisson(nu);

  tensor4<long double> T_analytique(3), Tiso_analytique(3);
  long double coef = 1 / (30 * mu * (1-nu));
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  T_analytique(i,j,k,l) = ( (9. - 10*nu) * (i==k) * (j==l) - ( (i==j)*(k==l) + (i==l)*(j==k)) ) * coef;

  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      Tiso_analytique[i][j] = (long double) .5 * (T_analytique[i][j] + T_analytique[j][i]);

  vector<long double> geometry(3,true,R); // a = b = c = R
  TII<long double> tii(15,30);
  test = (Tiso_analytique == tii.sphere(C));
  if (detail) affiche ("sphere (analytique)", test);
  else result *= (test);

  test = (tii.ellipsoid(C,geometry) == tii.sphere(C));
  if (detail) affiche ("ellipsoid (sphere)", test);
  else result *= (test);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                       TII test passed" << reset;
  else cout << red << "                       TII test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
