/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    loading-tests belongs to Material Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type loading test
#endif

#ifndef __loading_test_hpp
#define __loading_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __isotropic_tensors_hpp
#include "MateriOL++/isotropic tensors.hpp"
#endif

#ifndef __loading_hpp
#include "MateriOL++/loading.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace mol;
using namespace materiol;


//===========================
int test_loading (int detail)
//===========================
{
  int result=1;
  bool test = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                     loading test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  isotropic_tensor<long double> C;
  C.lambda(120000);
  C.mu(80000);

  long double dE = 0.2;
  tensor2<long double> dStress(3);
  dStress (1,1) = dE / C.inv()(1,1,1,1);
  loading<long double, tensor4> chargement;
  tensor2<long double> dotE = chargement.UT (C, dE, 11);
  test *= (dStress == (C||dotE));
  dStress (1,1) = 0;
  dotE = chargement.UT (C, dE, 22);
  dStress (2,2) = dE / C.inv()(2,2,2,2);
  test *= (dStress == (C||dotE));
  dStress (2,2) = 0;
  dotE = chargement.UT (C, dE, 33);
  dStress (3,3) = dE / C.inv()(3,3,3,3);
  test *= (dStress == (C||dotE));

  if (detail) affiche ("UT loading", test);
  else result *= test;

  dStress (3,3) = 0;
  dStress (1,2) = dStress (2,1) = 0.5 * dE / C.inv()(1,2,1,2);
  loading<long double, tensor4> chargement2;
  tensor2<long double> dotE2 = chargement2.PS (C, dE, 12);
  test *= (dStress == (C||dotE2));
  dStress (1,2) = dStress (2,1) = 0;
  dotE2 = chargement2.PS (C, dE, 13);
  dStress (1,3) = dStress (3,1) = 0.5 * dE / C.inv()(1,3,1,3);
  test *= (dStress == (C||dotE2));
  dStress (1,3) = dStress (3,1) = 0;
  dotE2 = chargement2.PS (C, dE, 23);
  dStress (2,3) = dStress (3,2) = 0.5 * dE / C.inv()(2,3,2,3);
  test *= (dStress == (C||dotE2));

  if (detail) affiche ("PS loading", test);
  else result *= test;

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                     loading test passed" << reset;
  else cout << red << "                     loading test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
